uniform float time;	//passed as frame counter from game

varying vec3 lightDir;
//varying float dist;
varying vec3 snormal;

void main()
{
	//Color calculations
	vec3 ecpos3 = vec3(gl_ModelViewMatrix * gl_Vertex);
	lightDir = gl_LightSource[0].position.xyz - ecpos3;
//	dist = length(gl_LightSource[0].position.xyz-ecpos4.xyz);
	
	//normal
	//Not using the provided normals, as they are crappy
	snormal = gl_NormalMatrix * gl_Normal;
	
	//textures
	vec4 tex = gl_MultiTexCoord0;
//	tex.y = tex.y + 0.15*cos(2.5*tex.x+time*0.3);
	gl_TexCoord[0] = tex;

	//Pumping
	vec4 v = gl_ModelViewMatrix*gl_Vertex;
	
	vec4 normal = gl_ModelViewMatrix*vec4(0,-0.4,0.7,1);
	float pumpdist = distance(v,normal);
	float factor = -atan( pumpdist/12.0 - 0.5 ) + 1.58;
	normal = normalize(v - normal);

	v = v + 5*factor*normal*abs(sin(time*1.4));
	
	gl_Position = gl_ProjectionMatrix * v;	//default transformation
}
