varying vec3 snormal;
varying vec3 lightDir;
//varying float dist;

uniform float fire;
uniform float time;
uniform sampler2D _handle;

void main()
{
	vec4 color = vec4(0.0,0.0,0.0,0.0);
	vec4 specular = vec4(0.4,1.6,1.6,0);
	vec4 diffuse = vec4(0.8,0.0,0,0);

	
	vec3 spotDir = normalize(-gl_LightSource[0].spotDirection.xyz);
	float dist = length(lightDir);
	vec3 lightdir = lightDir/dist;
	vec3 n = normalize(snormal);

	
	float spotEffect = dot( spotDir, normalize(snormal+0.036*lightdir) );
	//spotEffect *= spotEffect;
	
	float att = spotEffect / (gl_LightSource[0].constantAttenuation +
			gl_LightSource[0].linearAttenuation * dist +
			gl_LightSource[0].quadraticAttenuation * dist * dist);

	color += att * specular * pow(dot(lightdir,spotDir),125);
	color += att * diffuse * dot(spotDir,normalize(lightdir));

	if(fire > 0)
		color = color + vec4(0.2,-0.3,-0.1,0);
	
        vec4 intensity = texture2D(_handle,gl_TexCoord[0].st);
	
	vec3 yellowish = vec3(0.0,0.4,0.0);
	vec3 reddish   = vec3(0.2,0.0,0.0);

//	if(intensity.r > 0.5 )
//		intensity.r = 1;
//	intensity.r = clamp(intensity.r-.25,0.0,1.0);
//	intensity.r *= intensity.r*intensity.r;
//	vec3 mixcolor = mix(reddish,yellowish,intensity.r );
	
//	vec4 heartColor = vec4( mixcolor, 1.0);
//	gl_FragColor = color + 0.8*heartColor;
	color.a = 1;
	vec4 mixcol;
//	if(intensity.r < 0.2)
//	{
//		color += vec4(0.1,0.5,0.5,0);
//		mixcol = vec4(1.0,0.1,0.1,1);
//		color *= mixcol;
//	}
	
	if(intensity.r > 0.8)
	{
//		color += vec4(0,0.5,0.5,0);
//		mixcol = vec4(1,0.1,0.1,1);
//		color *= mixcol;

		color += vec4(0.05,0.2,0.2,0);
		mixcol = vec4(0.7,0.05,0.05,1);
		color *= mixcol;
		
		//color.r *= 1.0;
		//color.g += 0.1;
		//color.b += 0.1;
	}
	else
	{
		color += vec4(0,0.5,0.5,0);
		
		if(intensity.r>0.3)
		mixcol = mix(vec4(0.9,0.2,0,1), vec4(0.7,0.05,0.05,1),2*(intensity.r-0.3));
		else
		mixcol = mix(vec4(0.9,0.2,0,1), vec4(0.7,0,0,1),3.3*(0.3-intensity.r));
		color *= mixcol;

		
//		color.r *= 0.9;
//		color.g += 0.25;
//		color.b += 0.0;
	}
	
	gl_FragColor = color;
//	gl_FragColor = heartColor + color;

//	gl_FragColor = intensity;
}
