/***************************************************************************
                          twidgetrender.h  -  description
                             -------------------
    begin                : Mon Jul 28 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/
#include "tinfrastructure.h"

#ifndef TWIDGETRENDER_H
#define TWIDGETRENDER_H

const int CLASSIC_STYLE = 0;

/**
  *@author Chong Jiayi
  */

class TWidgetRender {
protected:
	TextureInfo *curTex;
	TInfrastructure *curInfrastructure;
public: 
	TWidgetRender(TInfrastructure *theInfrastructure) { curInfrastructure = theInfrastructure; }
	~TWidgetRender();

	void loadTexture(char *filename) { curTex = curInfrastructure->LoadWidgetTexture(filename); }
	void renderRect(int style, int x, int y, int width, int height, 
			GLfloat r1, GLfloat g1, GLfloat b1, GLfloat r2, GLfloat g2, GLfloat b2, GLfloat alpha);
	void selectTexture();
};

#endif
