/***************************************************************************
                          twidgetrender.cpp  -  description
                             -------------------
    begin                : Mon Jul 28 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "twidgetrender.h"


TWidgetRender::~TWidgetRender(){
}

void TWidgetRender::selectTexture() {
	
	glBindTexture(GL_TEXTURE_2D, curTex->decIndex);
}


void TWidgetRender::renderRect(int style, int x, int y, int width, int height, 
			GLfloat r1, GLfloat g1, GLfloat b1, GLfloat r2, GLfloat g2, GLfloat b2, GLfloat alpha) {
	
	glMatrixMode(GL_MODELVIEW);
	
	switch(style) {
		case CLASSIC_STYLE:
			glBegin(GL_QUADS);
				glColor4f(r1, g1, b1, alpha);
				glTexCoord2f(0.0, 0.0);
				glVertex2i(x, y);
				
				glColor4f(r1, g1, b1, alpha);
				glTexCoord2f(1.0, 0.0);
				glVertex2i(x + width, y);
			
				glColor4f(r2, g2, b2, alpha);
				glTexCoord2f(1.0, 1.0);
				glVertex2i(x + width, y + height);
			
				glColor4f(r2, g2, b2, alpha);
				glTexCoord2f(0.0, 1.0);
				glVertex2i(x, y + height);
			glEnd();
			
		break;
		
		default:
		break;
	}
}
