/***************************************************************************
                          twidget.cpp  -  description
                             -------------------
    begin                : Mon Jul 28 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "twidget.h"

void TWidget::Initialize(TInfrastructure *theInfrastructure) {
	curInfrastructure = theInfrastructure;
	mouseDownFuncPtr = NULL;
	mouseUpFuncPtr = NULL;
	renderAlpha = 1.0;
	WidgetCallObject = NULL;
}

void TWidget::setDimensions(int curX, int curY, int curWidth, int curHeight) {
	x = curX;
	y = curY;
	width = curWidth;
	height = curHeight;
	visible = true;
}

void TWidget::setColor(GLfloat red1, GLfloat green1, GLfloat blue1, GLfloat red2, GLfloat green2, 
				GLfloat blue2, GLfloat curAlpha) {
	r1 = red1;
	g1 = green1;
	b1 = blue1;

	r2 = red2;
	g2 = green2;
	b2 = blue2;
	
	alpha = curAlpha;
	renderAlpha = alpha;
}

void TWidget::callMouseDown(int clickX, int clickY) {
	if(mouseDownFuncPtr != NULL) mouseDownFuncPtr(WidgetCallObject, clickX, clickY);
}

void TWidget::callMouseUp(int clickX, int clickY) {
	if(mouseUpFuncPtr != NULL) mouseUpFuncPtr(WidgetCallObject, clickX, clickY);
}

bool TWidget::withinBoundary(int curX, int curY, int x1, int y1, int x2, int y2) {
	if(curX >= x1 && curX <= x2 && curY >= y1 && curY <= y2) return true;
	
	return false;
}


