/***************************************************************************
                          trts.h  -  description
                             -------------------
    begin                : Wed Jul 23 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TRTS_H
#define TRTS_H

#include "tfps.h"
#include "toolbar.h"

#include <queue>
#include <algorithm>

const int BORDER_WIDTH = 10;
const int PICK_BUFFER_SIZE = 400;
const float TOLERANCE_LEVEL = 2.0f;
const float ROTATE_TOLERANCE_LEVEL = 0.5;
const float TRANSLATE_TOLERANCE_LEVEL = 2.0;

const int ANIMATE_SMOOTHNESS = 3;

const int IDLE_ANIMATE = 0;
const int MOVE_ANIMATE = 1;
const int ATTACK_ANIMATE = 2;
const int DEATH_ANIMATE = 3;

const int DEATH_ANIMATE_MAX_FRAMES = 40;

const int IDLE_ACTION = 0;
const int MOVE_ACTION = 1;
const int ROTATE_ACTION = 2;
const int ATTACK_MELEE_ACTION = 3;
const int ATTACK_RANGE_ACTION = 4;
const int DEATH_ACTION = 5;
const int ATTACK_RAT_RANGE_ACTION = 6;
const int ATTACK_SUICIDE_ACTION = 7;

const int MIN_RECT_DIST = 20;

const int NORMAL_MODE = 0;
const int SERVER_RTS_MODE = 1;
const int SERVER_FPS_MODE = 2;
const int CLIENT_RTS_MODE = 3;
const int CLIENT_FPS_MODE = 4;

const int MOVING_STATE = 0;
const int INCREMENT_WAYPOINT_STATE = 1;
const int FOUND_GOAL_STATE = 2;
const int NEED_PATH_STATE = 3;

const int RESOURCE_CAP = 300;
const int END_GAME_FRAME_CAP = 3500;

/**
  *@author Chong Jiayi
  */

  
  
struct pickPatch {
	Vector v[4];
	Vector midpnt;
};

struct TPortalPose : public Vector {
	int portalNum;
	float f, g, h;
	int curIndex, prevIndex;
	
	bool operator >  (const TPortalPose &pose) const { return (f > pose.f); }
	bool operator == (const TPortalPose &pose) const { return (x == pose.x && y == pose.y && z == pose.z); }
};

struct TMovePose : public Vector {
	bool isGoal;
	float f, g, h;
	int curIndex, prevIndex;
	
	bool operator >  (const TMovePose &pose) const { return (f > pose.f); }
	bool operator == (const TMovePose &pose) const { return (x == pose.x && y == pose.y && z == pose.z); }
};

/*
struct TPose {
	Vector pos;
	int curIndex, prevIndex;
	float f, g, h;
	bool isGoal;
	
	bool operator > (const TPose &pose) const
	{
		return (f > pose.f);
	}
	
	bool operator == (const TPose &pose) const
	{
		return (pos.x == pose.pos.x && pos.y == pose.pos.y && pos.z == pose.pos.z);
	}
};
*/

class TNetworkSyncData {
	protected:
		bool needUpdate;
		NLmutex dataMutex;
		TNetworkObjectListPacket objectList;
		TNetworkObjectListPacket currentObjList;
		vector<TNetworkObjectPacket> objPackets;
		vector<TNetworkObjectPacket> currentObjPackets;
	public:
		TNetworkSyncData() {
			needUpdate = false;
			objectList.frame = 0;
			currentObjList.frame = 0;
			nlMutexInit(&dataMutex);
		}
		
		~TNetworkSyncData() {
			nlMutexDestroy(&dataMutex);
		}
		
		void mutexInit() {
		}
		
	
		bool dataChanged() { 
			nlMutexLock(&dataMutex);
			nlMutexUnlock(&dataMutex);
			bool curState = needUpdate;
			needUpdate = false;
			return curState;
		}
		
		void updateLock() {
			nlMutexLock(&dataMutex);
		}
		
		void updateUnLock() {
			nlMutexUnlock(&dataMutex);
		}
		
		TNetworkObjectListPacket getNetworkList() {  nlMutexLock(&dataMutex); nlMutexUnlock(&dataMutex); return currentObjList; }
		vector<TNetworkObjectPacket> getNetworkObjs() { nlMutexLock(&dataMutex); nlMutexUnlock(&dataMutex); return currentObjPackets; }	
	
		void addObjectList(TNetworkObjectListPacket *curList) {
			if(curList->frame <= objectList.frame) return;
			objectList = *curList;
			if(!objPackets.empty()) objPackets.clear();
		}
		
		void addObject(TNetworkObjectPacket *curPacket) {
			if(objPackets.size() == objectList.num) return; //already synchronized
			
			
			if(curPacket->frame <= objectList.frame) { //see if it's a valid object
				objPackets.push_back(*curPacket);
			}
			
			//now try to synchronize
			if(objPackets.size() == objectList.num) {
				nlMutexLock(&dataMutex);	
				nlMutexUnlock(&dataMutex);
				nlMutexLock(&dataMutex);	
					if(!currentObjPackets.empty()) currentObjPackets.clear();
					for(int i = 0; i < objPackets.size(); i++) {
						currentObjPackets.push_back(objPackets[i]);
					}
					currentObjList = objectList;
					needUpdate = true;
				nlMutexUnlock(&dataMutex);
			}
		}
		
};

class TRTS : public TFPS  {
protected:
	bool firstMove;
	bool mouseDown, rightMouseDown, drawSelectionRect;
	int mouseStartX, mouseStartY; /* For drawing selection rect */
	int elevate_num;
	int frame;
	int multiPlayerMode;
	int rectSelectX, rectSelectY, rectSelectWidth, rectSelectHeight;
	int reviveTime;
	int itemSpawnTime;
	Vector playerRotateOffset;
	Uint16 rotLeftBind;
	Uint16 rotRightBind;
	float addViewerRot;
	GLuint pickBuffer[PICK_BUFFER_SIZE];
	Vector MinBnd;
	Vector MaxBnd;
	float selectAlpha;
	bool selectAlphaFlag;
	toolBar *RTStoolBar;
	vector<GameType> gameBuildList;
	vector<TPicButton *> buildPics;
	TNetworkSyncData syncData;
	TNetworkPlayerInputPacket multiPlayerClient_Input;
	TNetworkPlayerInputPacket playerProcessInput;
	
	vector<int> selectList;
	
	/* Pathfinding Data Structures */
	
	priority_queue< TPortalPose, vector<TPortalPose>, greater<TPortalPose> > portalOpen;
	vector<TPortalPose> portalClosed;
	vector<TPortalPose> portalList;
	
	vector<Vector *> scaledVertexList;
	
	priority_queue< TMovePose, vector<TMovePose>, greater<TMovePose> > open;
	vector<TMovePose> closed;
	vector<TMovePose> vertexList;
	
	/*
	vector<Vector *> scaledVertexList;
	priority_queue< TPose, vector<TPose>, greater<TPose> > open;
	vector<TPose> closed;
	vector<TPose> vertexList;
	*/
	
	/* End Pathfinding Data Structures */

	int getObjectIndex(TObject *obj);
	void renderPickObjects();
	void renderObjectOBB(TObject *curObject);
	void prepareSinglePicking(int X, int Y);
	void prepareMultiplePicking(int X, int Y, int Width, int Height);
	int endPicking();
	pickPatch selectPatch(pickPatch *curPatch);
	void renderSinglePickPatch(pickPatch *curPatch, GLuint name);
	void renderSelectionRect(int x, int y, int width, int height);
	
	void addAction(int index, int type, Vector *vec, bool front);
	void addRotateAction(int index, Vector dst, bool front, bool viewTransform);
	void addRotateAction2(int index, Vector src, Vector dst, bool front, bool viewTransform);
	void addAttackAction(int index, int targetID);
	
	void simulateMove(int objNum);
	int getObjectListIndex(TObject *obj);
	bool isValidMove(int objNum, Vector moveDiff);
	
	void addBuildUnit(int type);
	void simulateBuildObjects();
	void findAndsimulateDeadObjects();
	void simulateReviveHuman();
	
	/* Movement code */
	
	bool attackActionHits(int objNum, int targetIndex);
	void simulateAttack(int objNum, int targetIndex);
	int calculateIntersections(int objNum, Vector move, int goalIndex);
	
	void simulateMeleeAttack(int id, list<GamerAction>::iterator iter);
	void simulateRangeAttack(int id, list<GamerAction>::iterator iter);
	
	/* Pathfinding Headers */
	
	int findPortal(Vector pt);
	bool portalObjContains(Vector pt, int i);
	bool inPortalClosedList(TPortalPose p);
	void generatePortalSuccessors(TPortalPose p, Vector goal, int goalPortal);
	
	vector<Vector *> calculateScaledVertices(int objNum, int portalNum, int targetNum);
	bool inClosedList(TMovePose p);
	void generateNodeSuccessors(TMovePose p, int objNum, Vector goal, int sectorNum);
	bool pathIntersects(Vector start, Vector goal, int objNum);
	float findTheta(Vector dir);
	void addNewNode(TMovePose p, Vector newLoc, Vector goal);
	
	// random
	
	float getGoalDirTheta(float curTheta, Vector goalDiff);
	
	/*
	float getObjectWidth(int objNum);
	vector<Vector *> calculateScaledVertices(int objNum);
	bool inClosedList(TPose pose);
	list<Vector> addNodesToMoveList(TPose curPose, int objNum);
	bool isGoalPt(TPose pose);
	void generateSuccessorNodes(TPose curPose, int objNum, Vector goal, int goalNum);
	void addNewNode(TPose curPose, Vector pos, Vector goal);
	vector<int> findIntersectionList(TPose curPose, int objNum, Vector goal, bool findAllIntersections);
	float getBoundingRectTheta(TPose curPose, Vector goal);
	float getGoalDirTheta(float curTheta, Vector goalDiff);
	*/
	
	/* End Pathfinding Headers */

	
private:
	void RTSserverProcessRTSinput(TNetworkPlayerInputPacket inputPacket);
	void RTSserverProcessFPSinput(TNetworkPlayerInputPacket inputPacket);
	
	void FPSserverProcessRTSinput(TNetworkPlayerInputPacket inputPacket);
	void FPSserverProcessFPSinput(TNetworkPlayerInputPacket inputPacket);
	
	void RTSclientProcess(void *data);
	void FPSclientProcess(void *data);
	
	void playUnitSound(int unitType);
	void simulatePillarObjects();
	
	bool mainRatAlive();
	
	Vector mainRatSpawn;
	int endGameFrameCnt;
	ScoreReport gameScore;
	
public: 
	TRTS(TInfrastructure *theInfrastructure);
	~TRTS();
	void extractBounds();
	void setKeyBindRTS(Uint16 left, Uint16 right);
	void userRTSinput(Uint16 key);
	void userRTSinputStop();
	void mouseRTSInput(float xDelta, float yDelta, int mouseX, int mouseY, int width, int height, int leftPress, int rightPress); 
	
	void clientFPSkeyDown(Uint16 key);
	void clientFPSkeyUp(Uint16 key);
	void clientFPSmouseInput(float xDelta, float yDelta, int mouseX, int mouseY, int leftPress, int rightPress); 
	void sendClientFPSinput();
	
	void ApplyRTSUserInput();
	void TryMoveRTSViewerPhysics();
	void setElevateLevel(float level) {elevate_num = level; }
	void presetObjectSelection();
	void renderSelection();
	void addGameObjectType(int type, int health, float rotVel, float transVel);
	void loadRTStoolBar(char *filename, TWidgetManager *wigetManager);
	void renderRTStoolBar() { if(RTStoolBar != NULL) RTStoolBar->render(); }
	void renderStatusBars();
	void renderRTSmap();
	void addMainRat();
	void renderEndGameSequence();
	
	int singleClickSelect(int x, int y);
	int processClickMap(int x, int y);
	int getResource() { return FPSGamePacket.resource; }
	vector<int> multipleClickSelect(int x, int y, int width, int height);
	bool getPoint3DSelect(int x, int y, Vector *retVec);
	void simulateGameObjects();
	void simulateItemPickUp();
	
	/* Pathfinding Headers */
	
	list<Vector> findRoomPath(Vector start, Vector goal);
	list<Vector> findRoomPath(Vector start, Vector goal, int objNum);
	
	list<Vector> findPath(int objNum, Vector goal, int portalNum);
	list<Vector> findPath(int objNum, Vector goal, int portalNum, int targetIndex);
	
	/*
	list<Vector> findPath(int objNum, Vector goal);
	list<Vector> findPath(int objNum, Vector goal, int goalNum);
	*/
	
	/* End Pathfinding Headers */
	
	void setMultiPlayerMode(int mode) { multiPlayerMode = mode; }
	int getMultiPlayerMode() { return multiPlayerMode; }
	void setMultiPlayerFrame(int num) { frame = num; }
	void prepareMultiplayerMode();
	void endMultiplayerMode();
	void runMultiplayerMode(void *data, int size);
	void incrementFrame() { if(frame != -1) frame++; }
	int getFrame() { return frame; }
	int getGameEnd();
	bool canStart() { if(multiPlayerMode == SERVER_RTS_MODE || multiPlayerMode == SERVER_FPS_MODE) { if(frame == -1){return false;} } return true; }
	void syncToNetwork();

	void sendServerRTSinfo();
	void RTSserverProcessFPSinputFrame();
	
	
};

#endif
