/***************************************************************************
                          trts.cpp  -  description
                             -------------------
    begin                : Wed Jul 23 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "trts.h"

#define PATHFIND_DEBUG 0

const int MAX_BUILD = 8;
const int BUILD_BTN_SIZE = 40;
const float USER_ROT_ANGLE = 2.0f;

static void multiPlayerCallBack(void *obj, void *data, int size);

TRTS::TRTS(TInfrastructure *theInfrastructure) :TFPS(theInfrastructure) {
	viewAngleX = -40.0;
	viewAngleY = 0.0;
	viewAngleZ = 0.0;
	
	viewXDisp = 0.0;
	viewYDisp = 0.0;
	viewZDisp = 0.0;
	elevate_num = 70.0;
	
	mouseDown = false;
	rightMouseDown = false;
	drawSelectionRect = false;
	
	StopViewerPhysics((viewXDisp == 0.0), (viewYDisp == 0.0), (viewZDisp == 0.0) );
	
	firstMove = true;
	selectAlpha = 1.0f;
	selectAlphaFlag = true;
	frame = -1;
	
	addGameObjectType(0, 100, 5.0, 1.0);
	FPSGamePacket.resource = 100;
	
	SetPortalScissor(false);
	
	RTStoolBar = NULL;	
	
	addViewerRot = 0.0;
	multiPlayerMode = NORMAL_MODE;

	memset(&multiPlayerClient_Input, 0, sizeof(TNetworkPlayerInputPacket));
	memset(&playerProcessInput, 0, sizeof(TNetworkPlayerInputPacket));
	
	playerRotateOffset.x = 0.0;
	playerRotateOffset.y = 122.4;
	playerRotateOffset.z = 0.0;
	
	endGameFrameCnt = 0;
	
	Vset(&mainRatSpawn, 0.0, 0.0, 2.0);
	
	gameScore.side1_score = 0;	
	gameScore.side2_score = 0;

	rectSelectX =  rectSelectY =  rectSelectWidth =  rectSelectHeight = -100.0;
	itemSpawnTime = SDL_GetTicks();
}

TRTS::~TRTS(){
	if(RTStoolBar != NULL) { delete RTStoolBar; cout << "Freeing Toolbar" << endl; }
	RTStoolBar = NULL;

	for(int i = 0 ; i < buildPics.size(); i++) {
		delete buildPics[i];
	}
	
}

/* Extracts the bounding box for the entire world*/
void TRTS::extractBounds() {
	MinBnd.x = MinBnd.y = MinBnd.z = 99999.0;
	MaxBnd.x = MaxBnd.y = MaxBnd.z = -99999.0;
	
	for(int i = 0; i < ObjectList.size(); i++) {
		TObject *curObject = ObjectList[i].curObject;
		
		if(curObject->GetType() == PLANE_TYPE) {
			Vector curMinBnd = curObject->GetMinBounds();
			Vector curMaxBnd = curObject->GetMaxBounds();
		
			if(MinBnd.x > curMinBnd.x) MinBnd.x = curMinBnd.x;
			if(MinBnd.y > curMinBnd.y) MinBnd.y = curMinBnd.y;
			if(MinBnd.z > curMinBnd.z) MinBnd.z = curMinBnd.z;
		
			if(MaxBnd.x < curMaxBnd.x) MaxBnd.x = curMaxBnd.x;
			if(MaxBnd.y < curMaxBnd.y) MaxBnd.y = curMaxBnd.y;
			if(MaxBnd.z < curMaxBnd.z) MaxBnd.z = curMaxBnd.z;

		}
	}
}

void TRTS::setKeyBindRTS(Uint16 left, Uint16 right) {
	rotLeftBind = left;
	rotRightBind = right;
}

void TRTS::userRTSinput(Uint16 key) {
	if(key == SDLK_q) {
		addViewerRot = USER_ROT_ANGLE;
	}
	else if(key == SDLK_e) {
		addViewerRot = -USER_ROT_ANGLE;
	}
	else if(key == SDLK_a) {
		viewXDisp = -horzDisp;
	}
	else if(key == SDLK_d) {
		viewXDisp = horzDisp;
	}
	else if(key == SDLK_w) {
		viewZDisp = -vertDisp;
	}
	else if(key == SDLK_s) {
		viewZDisp = vertDisp;
	}
	else if(key == SDLK_SPACE) {
		for(int i = 0; i < ObjectList.size(); i++) {
			if(ObjectList[i].gamePacket.type == MAIN_RAT_TYPE) {
				viewerLoc = ObjectList[i].translate;
				viewerLoc.z = viewerLoc.z + 30.0;
				viewerLoc.y = elevate_num;
				viewerPhysics.vel.x = viewerPhysics.vel.y = viewerPhysics.vel.z = 0.0;
				break;
			}
		}
	}
	else addViewerRot = 0.0;
}

void TRTS::userRTSinputStop() {
	addViewerRot = 0.0;
	viewXDisp = 0.0;
	viewZDisp = 0.0;
}

void TRTS::mouseRTSInput(float xDelta, float yDelta, int mouseX, int mouseY, int width, int height, 
					int leftPress, int rightPress) {
  viewXDisp = 0.0f;
  viewZDisp = 0.0f;
	
  if(mouseX - 0 < BORDER_WIDTH) viewXDisp = -horzDisp; //-xDelta;
  else if (width - mouseX < BORDER_WIDTH) viewXDisp = horzDisp; //xDelta;

  if(mouseY - 0 < BORDER_WIDTH) viewZDisp = -vertDisp; //-yDelta;
  else if (height - mouseY < BORDER_WIDTH) viewZDisp = vertDisp; //yDelta;
	
  StopViewerPhysics((viewXDisp == 0.0), (viewYDisp == 0.0), (viewZDisp == 0.0) );

  
  if(leftPress) {
    btnReturnInfo buildRetVal = RTStoolBar->getButtonClicked();
    int mapClick = processClickMap(mouseX, mouseY);
    if(mapClick) return;

    if(buildRetVal.index != -1) {
      addBuildUnit(buildRetVal.type);
    } else {
      if(!mouseDown) { // first frame in which the button is down
	mouseDown = true;
	mouseStartX = mouseX;
	mouseStartY = mouseY;
      }

      if(!drawSelectionRect && abs(mouseX - mouseStartX) + abs(mouseY - mouseStartY) > MIN_RECT_DIST)
	drawSelectionRect = true;

	// draw selection rect;
	int xp = min(mouseX, mouseStartX);
	int yp = min(mouseY, mouseStartY);
	int widthp = abs(mouseX - mouseStartX);
	int heightp = abs(mouseY - mouseStartY);
	rectSelectX = xp; rectSelectY = yp; rectSelectWidth = widthp; rectSelectHeight = heightp;
	
    }
  } else {
    if(mouseDown) {
      if(drawSelectionRect) {
	int x = min(mouseX, mouseStartX);
	int y = min(mouseY, mouseStartY);
	int width = abs(mouseX - mouseStartX);
	int height = abs(mouseY - mouseStartY);
	selectList = multipleClickSelect(x, y, width, height);
	drawSelectionRect = false;
      } else {
	selectList.clear();
	int choose = singleClickSelect(mouseX, mouseY);
	playUnitSound(ObjectList[choose].gamePacket.type);
	cout << choose << endl;
	if(choose > -1)
	  selectList.push_back(choose); 
      }
      rectSelectHeight = -1; rectSelectWidth = -1;
      mouseDown = false;
    }
  }

  if (rightPress == true) {
    if(!rightMouseDown) {
      rightMouseDown = true;
      
      Vector retVec, groupCtr, goalDiff;
      if(getPoint3DSelect(mouseX, mouseY, &retVec)) {
	printVector(&retVec, "Click Point: ");
	
	int size = selectList.size();
	if(size == 0) return;
	
	int target = singleClickSelect(mouseX, mouseY);
	printf("Target is %d\n", target);
	
	RestoreSceneObjectsTransform();
	ApplyMd2PhysicsTransform();
	
	int i, index;
	for(i = 0; i < size; i++) {
		index = selectList[i];
		
		if(ObjectList[index].curObject->GetType() != MD2_TYPE) continue;
		
		ObjectList[index].gamePacket.actionList.clear();
		
		if(target == -1)
			ObjectList[index].gamePacket.goal.type = MOVE_ACTION;
		else
			ObjectList[index].gamePacket.goal.type = ATTACK_MELEE_ACTION;
		ObjectList[index].gamePacket.goal.dst = retVec;
		if(target == -1)
			ObjectList[index].gamePacket.goal.target = NULL;
		else
			ObjectList[index].gamePacket.goal.target = ObjectList[target].curObject;
		ObjectList[index].gamePacket.waypointList = findRoomPath(ObjectList[index].translate, retVec);
	}
      }
    }
  } else {
    rightMouseDown = false;
  }
}

void TRTS::playUnitSound(int unitType) {
			/* begin ugly code */
	switch(unitType) {
		case 1:
			curInfrastructure->PlaySound(MICE_SQUEAK_SOUND);
		break;
		
		case 2:
			curInfrastructure->PlaySound(MICE_SOUND);
		break;
		case 3:
		break;
		
		case 4:
			curInfrastructure->PlaySound(SHOTGUN_SOUND);
		break;
		case 5:
			curInfrastructure->PlaySound(UFO_SOUND);
		break;
		case 6:
			curInfrastructure->PlaySound(ROBOT_ARM_SOUND);
		break;
		case 12:
			curInfrastructure->PlaySound(PIGEON_SOUND);
		break;
	}
			/* end ugle code */

}

void TRTS::ApplyRTSUserInput() {
	if(!firstMove) {
		if(viewerLoc.x <= MinBnd.x && viewXDisp < 0) viewXDisp = 0.0;
		if(viewerLoc.y <= MinBnd.y && viewYDisp < 0) viewYDisp = 0.0;
		if(viewerLoc.z <= MinBnd.z && viewZDisp < 0) viewZDisp = 0.0;
	
		if(viewerLoc.x >= MaxBnd.x && viewXDisp > 0) viewXDisp = 0.0;
		if(viewerLoc.y >= MaxBnd.y && viewYDisp > 0) viewYDisp = 0.0;
		if(viewerLoc.z >= MaxBnd.z && viewZDisp > 0) viewZDisp = 0.0;
		
	}
	
	viewAngleY = viewAngleY + addViewerRot;
	ApplyViewerAccel(viewXDisp, viewYDisp, viewZDisp, viewAngleX, viewAngleY, viewAngleZ);
	StopViewerPhysics((viewXDisp == 0.0), (viewYDisp == 0.0), (viewZDisp == 0.0) );
}

void TRTS::TryMoveRTSViewerPhysics() {
	if(!firstMove) {
		MoveFPSViewerDelta(viewerPhysics.vel.x, viewerPhysics.vel.y, viewerPhysics.vel.z, 
				viewerPhysics.angle.x, viewerPhysics.angle.y, viewerPhysics.angle.z);
	}
	else {
		extractBounds();
		ApplyViewerAccel(viewXDisp, viewYDisp, viewZDisp, viewAngleX, viewAngleY, viewAngleZ);
		MoveFPSViewerDelta(viewerPhysics.vel.x, elevate_num, viewerPhysics.vel.z, 
				viewerPhysics.angle.x, viewerPhysics.angle.y, viewerPhysics.angle.z);
				
		firstMove = false;
	}
	
}

void TRTS::presetObjectSelection() {
	for(int i = 0; i < ObjectList.size(); i++) {
		TObject *curObject = ObjectList[i].curObject;
		
		if(curObject->GetType() == MD2_TYPE && ObjectList[i].gamePacket.type != -1) {
			ObjectList[i].gamePacket.selectLevel = SELECT_ONLY;
			if(ObjectList[i].gamePacket.team == FPSGamePacket.team) ObjectList[i].gamePacket.selectLevel = SELECT_MOVE;
		}
		else ObjectList[i].gamePacket.selectLevel = SELECT_NO;
	}
}

void TRTS::renderObjectOBB(TObject *curObject) {
	Vector *Bnd1, *Bnd2, *Bnd3, *Bnd4, *Bnd5, *Bnd6, *Bnd7, *Bnd8;
	
	Bnd1 = curObject->GetDstBounds1();
	Bnd2 = curObject->GetDstBounds2();
	Bnd3 = curObject->GetDstBounds3();
	Bnd4 = curObject->GetDstBounds4();
	Bnd5 = curObject->GetDstBounds5();
	Bnd6 = curObject->GetDstBounds6();
	Bnd7 = curObject->GetDstBounds7();
	Bnd8 = curObject->GetDstBounds8();
	glBegin(GL_QUADS);
		glVertex3f(Bnd1->x, Bnd1->y, Bnd1->z);
		glVertex3f(Bnd3->x, Bnd3->y, Bnd3->z);
		glVertex3f(Bnd6->x, Bnd6->y, Bnd6->z);
		glVertex3f(Bnd8->x, Bnd8->y, Bnd8->z);
	
		glVertex3f(Bnd4->x, Bnd4->y, Bnd4->z);
		glVertex3f(Bnd2->x, Bnd2->y, Bnd2->z);
		glVertex3f(Bnd7->x, Bnd7->y, Bnd7->z);
		glVertex3f(Bnd5->x, Bnd5->y, Bnd5->z);
	
		glVertex3f(Bnd1->x, Bnd1->y, Bnd1->z);
		glVertex3f(Bnd5->x, Bnd5->y, Bnd5->z);
		glVertex3f(Bnd7->x, Bnd7->y, Bnd7->z);
		glVertex3f(Bnd8->x, Bnd8->y, Bnd8->z);
	
		glVertex3f(Bnd3->x, Bnd3->y, Bnd3->z);
		glVertex3f(Bnd4->x, Bnd4->y, Bnd4->z);
		glVertex3f(Bnd2->x, Bnd2->y, Bnd2->z);
		glVertex3f(Bnd6->x, Bnd6->y, Bnd6->z);
	
		glVertex3f(Bnd8->x, Bnd8->y, Bnd8->z);
		glVertex3f(Bnd6->x, Bnd6->y, Bnd6->z);
		glVertex3f(Bnd2->x, Bnd2->y, Bnd2->z);
		glVertex3f(Bnd7->x, Bnd7->y, Bnd7->z);
	
		glVertex3f(Bnd1->x, Bnd1->y, Bnd1->z);
		glVertex3f(Bnd3->x, Bnd3->y, Bnd3->z);
		glVertex3f(Bnd4->x, Bnd4->y, Bnd4->z);
		glVertex3f(Bnd5->x, Bnd5->y, Bnd5->z);
	glEnd();
}

void TRTS::prepareSinglePicking(int X, int Y) {
	GLint viewport[4];

	glSelectBuffer(PICK_BUFFER_SIZE, pickBuffer);
	glRenderMode(GL_SELECT);

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();

	glGetIntegerv(GL_VIEWPORT,viewport);
	gluPickMatrix(X,viewport[3]-Y, 5,5,viewport);
	curInfrastructure->iniProjectionMatrix();
	
	glMatrixMode(GL_MODELVIEW);
	
	glInitNames();
}

void TRTS::prepareMultiplePicking(int X, int Y, int Width, int Height) {
	GLint viewport[4];
	GLfloat newX = (GLfloat)X + (GLfloat)Width * 0.5;
	GLfloat newY = (GLfloat)Y + (GLfloat)Height * 0.5;

	glSelectBuffer(PICK_BUFFER_SIZE, pickBuffer);
	glRenderMode(GL_SELECT);

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();

	glGetIntegerv(GL_VIEWPORT,viewport);
	gluPickMatrix(newX,viewport[3]-newY, Width, Height,viewport);
	curInfrastructure->iniProjectionMatrix();
	
	glMatrixMode(GL_MODELVIEW);
	
	glInitNames();
}


int TRTS::endPicking() {
	// restoring the original projection matrix
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glFlush();
	
	return glRenderMode(GL_RENDER);
}

void TRTS::renderPickObjects() {
	for(int i = 0; i < ObjectList.size(); i++) {
		if(ObjectList[i].gamePacket.selectLevel > 0 
			&& (ObjectList[i].gamePacket.type < 50 || ObjectList[i].gamePacket.type == PLAYER_TYPE || ObjectList[i].gamePacket.type == GAME_PILLAR_TYPE) 
			&& ObjectList[i].gamePacket.health > 0) {
			glPushName(i);
			renderObjectOBB(ObjectList[i].curObject);
			glPopName();
		}
	}
}

int TRTS::singleClickSelect(int x, int y) {
	prepareSinglePicking(x, y);
	renderPickObjects();
	
	int hits = endPicking();
	GLuint choose = pickBuffer[3]; //make selection first object
	GLuint depth = pickBuffer[1];

	if(hits > 0) {
		for(int j = 0; j < hits; j++) {
			if(pickBuffer[j * 4 + 1] < depth) {
				choose = pickBuffer[j * 4 + 3];
				depth = pickBuffer[j * 4 + 1];
			}
		}
		cout << "Chosen: " << choose << endl;
		return choose;
	}
	
	
	return -1;
}

vector<int> TRTS::multipleClickSelect(int x, int y, int width, int height) {
	vector<int> returnList;
	prepareMultiplePicking(x, y, width, height);
	renderPickObjects();
	
	int hits = endPicking();
//	GLuint choose = pickBuffer[3]; //make selection first object
//	GLuint depth = pickBuffer[1];
	
	if(hits > 0) {
		for(int j = 0; j < hits; j++) {
			returnList.push_back(pickBuffer[j * 4 + 3]);
		}
	}
	
	return returnList;
}

void TRTS::renderSelectionRect(int x, int y, int width, int height) {
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	glLineWidth (2.0);
	glHint (GL_LINE_SMOOTH_HINT, GL_NICEST);        // Use The Good Calculations
	glEnable (GL_LINE_SMOOTH);                      // Enable Anti-Aliasing
	
	x = x;
	y = curInfrastructure->GetWinHeight() - y;
	if(height == -1 || width == -1) return;
	
	glMatrixMode( GL_PROJECTION );
		glPushMatrix();
		glLoadIdentity();
		glOrtho(0, curInfrastructure->GetWinWidth(), 0, curInfrastructure->GetWinHeight(), -1, 1);
		
	glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();
		glTranslated(0, 0, 0);
	
	glColor4f(0.0, 1.0, 0.0, 1.0);
	
	glBegin(GL_LINES);
		glVertex2f(x, y);
		glVertex2f(x + width, y);
		
		glVertex2f(x + width, y);
		glVertex2f(x + width, y - height);
		
		glVertex2f(x + width, y - height);
		glVertex2f(x, y - height);
	
		glVertex2f(x, y - height);
		glVertex2f(x, y);
	glEnd();
		
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();

	glDisable (GL_LINE_SMOOTH);                      // Enable Anti-Aliasing
	glDisable(GL_BLEND);

	glEnable(GL_DEPTH_TEST);
}

void TRTS::renderSelection() {
	int i;
	Vector *Bnd1, *Bnd2, *Bnd3, *Bnd4, *Bnd5, *Bnd6, *Bnd7, *Bnd8;
	
	glActiveTextureARB( GL_TEXTURE1_ARB );
	glDisable( GL_TEXTURE_CUBE_MAP_ARB );
	glDisable( GL_TEXTURE_2D );

	glActiveTextureARB( GL_TEXTURE0_ARB );
	glDisable( GL_TEXTURE_CUBE_MAP_ARB );

	glDisable(GL_REGISTER_COMBINERS_NV);
	glDisable(GL_TEXTURE_2D);
	glDepthFunc(GL_LEQUAL);

	glDisable(GL_LIGHTING);
	
	glDisable(GL_STENCIL_TEST);
	glDepthMask(GL_FALSE);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_COLOR);
	glDisable(GL_CULL_FACE );
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE,GL_ONE);
	glLineWidth (2.0);
	glHint (GL_LINE_SMOOTH_HINT, GL_NICEST);        // Use The Good Calculations
	glEnable (GL_LINE_SMOOTH);                      // Enable Anti-Aliasing
		
	for(i = 0; i < selectList.size(); i++) {
		TObject *curObject = ObjectList[selectList[i]].curObject;
		if(curObject == NULL) continue;
		Bnd1 = curObject->GetDstBounds1();
		Bnd2 = curObject->GetDstBounds2();
		Bnd3 = curObject->GetDstBounds3();
		Bnd4 = curObject->GetDstBounds4();
		Bnd5 = curObject->GetDstBounds5();
		Bnd6 = curObject->GetDstBounds6();
		Bnd7 = curObject->GetDstBounds7();
		Bnd8 = curObject->GetDstBounds8();		
		
		glColor4f(0.0, 1.0, 0.0, 1.0); //selectAlpha);
		glBegin(GL_LINES);
			glVertex3f(Bnd1->x, Bnd1->y, Bnd1->z);
			glVertex3f(Bnd3->x, Bnd3->y, Bnd3->z);
			
			glVertex3f(Bnd4->x, Bnd4->y, Bnd4->z);
			glVertex3f(Bnd5->x, Bnd5->y, Bnd5->z);
		
			glVertex3f(Bnd1->x, Bnd1->y, Bnd1->z);
			glVertex3f(Bnd5->x, Bnd5->y, Bnd5->z);
			
			glVertex3f(Bnd3->x, Bnd3->y, Bnd3->z);
			glVertex3f(Bnd4->x, Bnd4->y, Bnd4->z);
		glEnd();
		
	}
	
	
	// for debugging
	if(PATHFIND_DEBUG) {
		glDisable (GL_DEPTH_TEST);
		Vector *curScaledVertices, tmpScaledVertices[4];
		Vector curVector;
		for(i = 0; i < scaledVertexList.size(); i++) {
			curScaledVertices = scaledVertexList[i];
			if(curScaledVertices == NULL)
				continue;
			
			for(int j = 0; j < 4; j++) {
				curScaledVertices[j].y = -37.0;
				transformVector(&curVector, &curScaledVertices[j], this->inverseViewerMatrix);
				tmpScaledVertices[j] = curVector;
			}
			glBegin(GL_LINES);
				glVertex3f(tmpScaledVertices[0].x, tmpScaledVertices[0].y, tmpScaledVertices[0].z);
				glVertex3f(tmpScaledVertices[1].x, tmpScaledVertices[1].y, tmpScaledVertices[1].z);
				
				glVertex3f(tmpScaledVertices[2].x, tmpScaledVertices[2].y, tmpScaledVertices[2].z);
				glVertex3f(tmpScaledVertices[3].x, tmpScaledVertices[3].y, tmpScaledVertices[3].z);
				
				glVertex3f(tmpScaledVertices[0].x, tmpScaledVertices[0].y, tmpScaledVertices[0].z);
				glVertex3f(tmpScaledVertices[3].x, tmpScaledVertices[3].y, tmpScaledVertices[3].z);
				
				glVertex3f(tmpScaledVertices[1].x, tmpScaledVertices[1].y, tmpScaledVertices[1].z);
				glVertex3f(tmpScaledVertices[2].x, tmpScaledVertices[2].y, tmpScaledVertices[2].z);
			glEnd();
		}
		glEnable (GL_DEPTH_TEST);
	}
	
	glDisable (GL_LINE_SMOOTH);                      // Enable Anti-Aliasing
	
	if(selectAlphaFlag) {
		selectAlpha = selectAlpha - 0.025;
		if(selectAlpha < 0.0) {
			selectAlpha = 0.0;
			selectAlphaFlag = false;
		}
	}
	else {
		selectAlpha = selectAlpha + 0.025;
		if(selectAlpha > 1.0) {
			selectAlpha = 1.0;
			selectAlphaFlag = true;
		}
	}

	glDisable(GL_BLEND);
	glDisable(GL_BLEND);
	glDepthMask(GL_TRUE);
	glEnable(GL_CULL_FACE );

	renderSelectionRect(rectSelectX, rectSelectY, rectSelectWidth, rectSelectHeight);
}

//recursive function that attempts to determine where the player clicked on a planar surface
pickPatch TRTS::selectPatch(pickPatch *curPatch) {
	//first see if the patch is within our tolerance level
	float length = 0.0;
	Vector diffVec;
	Vsub(&curPatch->v[2], &curPatch->v[0], &diffVec);
	length = Vlength(&diffVec);
	
	if(length <= TOLERANCE_LEVEL) return *curPatch;
	
	glRenderMode(GL_SELECT);
	glInitNames();
	//begin drawing the patches into the selection buffer first
	pickPatch workPatch[4];
	Vector curMidPnt1, curMidPnt2;

	//build the patches	
	workPatch[0].v[0] = curPatch->v[0];
	Vadd(&curPatch->v[0], &curPatch->v[1], &curMidPnt1);
	Vscale(&curMidPnt1, 0.5);
	Vadd(&curPatch->v[0], &curPatch->v[3], &curMidPnt2);
	Vscale(&curMidPnt2, 0.5);
	workPatch[0].v[1] = curMidPnt1;
	workPatch[0].v[2] = curPatch->midpnt;
	workPatch[0].v[3] = curMidPnt2;
	
	workPatch[1].v[0] = curMidPnt1;
	Vadd(&curPatch->v[1], &curPatch->v[2], &curMidPnt2);
	Vscale(&curMidPnt2, 0.5);
	workPatch[1].v[1] = curPatch->v[1];
	workPatch[1].v[2] = curMidPnt2;
	workPatch[1].v[3] = curPatch->midpnt;
	
	workPatch[2].v[0] = curPatch->midpnt;
	Vadd(&curPatch->v[2], &curPatch->v[3], &curMidPnt1);
	Vscale(&curMidPnt1, 0.5);
	workPatch[2].v[1] = curMidPnt2;
	workPatch[2].v[2] = curPatch->v[2];
	workPatch[2].v[3] = curMidPnt1;
	
	workPatch[3].v[0] = curPatch->midpnt;
	Vadd(&curPatch->v[0], &curPatch->v[3], &curMidPnt2);
	Vscale(&curMidPnt2, 0.5);
	workPatch[3].v[1] = curMidPnt1;
	workPatch[3].v[2] = curPatch->v[3];
	workPatch[3].v[3] = curMidPnt2;
	
	for(int i = 0; i < 4; i++) {
		renderSinglePickPatch(&workPatch[i], i);
	}
	
	int hit = glRenderMode(GL_RENDER);
	GLuint choose = pickBuffer[3];
	if(hit > 0) {
		Vadd(&workPatch[choose].v[0], &workPatch[choose].v[2], &workPatch[choose].midpnt);
		Vscale(&workPatch[choose].midpnt, 0.5);
		return selectPatch(&workPatch[choose]);
	}
	
	return *curPatch;
}

void TRTS::renderSinglePickPatch(pickPatch *curPatch, GLuint name) {
	glPushName(name);
		glBegin(GL_QUADS);
			glVertex3f(curPatch->v[0].x, curPatch->v[0].y, curPatch->v[0].z);
			glVertex3f(curPatch->v[1].x, curPatch->v[1].y, curPatch->v[1].z);
			glVertex3f(curPatch->v[2].x, curPatch->v[2].y, curPatch->v[2].z);
			glVertex3f(curPatch->v[3].x, curPatch->v[3].y, curPatch->v[3].z);
		glEnd();
	glPopName();
}

bool TRTS::getPoint3DSelect(int x, int y, Vector *retVec) {
	GLint viewport[4];

	glSelectBuffer(PICK_BUFFER_SIZE, pickBuffer);
	glRenderMode(GL_SELECT);

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();

	glGetIntegerv(GL_VIEWPORT,viewport);
	gluPickMatrix(x,viewport[3]-y, 5,5,viewport);
	curInfrastructure->iniProjectionMatrix();
	
	glMatrixMode(GL_MODELVIEW);
	glRenderMode(GL_SELECT);
	
	for(int i = 0; i < ObjectList.size(); i++) {
		TObject *curObject = ObjectList[i].curObject;
		if(curObject->GetType() == PLANE_TYPE) {
			glPushName(i);
			renderObjectOBB(curObject);
			glPopName();
		}
	}
	
	glFlush();
	int hits = glRenderMode(GL_RENDER);
	GLuint choose = pickBuffer[3]; //make selection first object
	GLuint depth = pickBuffer[1];
	
	if(hits > 0) {
		for(int j = 0; j < hits; j++) {
			if(pickBuffer[j * 4 + 1] < depth) {
				choose = pickBuffer[j * 4 + 3];
				depth = pickBuffer[j * 4 + 1];
			}
		}
		
		//construct patch
		pickPatch curPatch;
		TObject *curObject = ObjectList[choose].curObject;
		Vector *Bnd1, *Bnd2, *Bnd3, *Bnd4, *Bnd5, *Bnd6, *Bnd7, *Bnd8;
		Bnd1 = curObject->GetDstBounds1();
		Bnd2 = curObject->GetDstBounds2();
		Bnd3 = curObject->GetDstBounds3();
		Bnd4 = curObject->GetDstBounds4();
		Bnd5 = curObject->GetDstBounds5();
		Bnd6 = curObject->GetDstBounds6();
		Bnd7 = curObject->GetDstBounds7();
		Bnd8 = curObject->GetDstBounds8();
		
		curPatch.v[0] = *Bnd1;
		curPatch.v[1] = *Bnd3;
		curPatch.v[2] = *Bnd4;
		curPatch.v[3] = *Bnd5;
		Vadd(&curPatch.v[0], &curPatch.v[2], &curPatch.midpnt);
		Vscale(&curPatch.midpnt, 0.5);
		
		pickPatch retPatch = selectPatch(&curPatch);
		//now transform back into world space
		Vector newVec;
		transformVector(&newVec, &retPatch.midpnt, this->viewerMatrix);
		*retVec = newVec;
		
		// restoring the original projection matrix
		glMatrixMode(GL_PROJECTION);
		glPopMatrix();
		glMatrixMode(GL_MODELVIEW);
		return true;
	}	
	
	// restoring the original projection matrix
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	return false;
}

void TRTS::addGameObjectType(int type, int health, float rotVel, float transVel) {
	GameType newGameType;
	
	newGameType.type = type;
	newGameType.health = health;
	newGameType.rotVel = rotVel;
	newGameType.transVel = transVel;
	
	gameObjectTypeList.push_back(newGameType);
}

void TRTS::addAction(int index, int type, Vector *vec, bool front) {
	GamerAction newAction;
	
	newAction.type = type;
	newAction.dst = *vec;

	newAction.frame = 0;
	
	if(front) {
		ObjectList[index].gamePacket.actionList.push_front(newAction);
	}
	else ObjectList[index].gamePacket.actionList.push_back(newAction);
}

void TRTS::addRotateAction(int index, Vector dst, bool front, bool viewTransform = true) {
	TObject *curObject = ObjectList[index].curObject;
	float orgAngle = ObjectList[index].rotate.y;
	
	Vector orgVec, maxPnt, minPnt, midPnt;
	
	orgVec.x = 0.0;
	orgVec.y = 0.0;
	orgVec.z = 1.0;
	
	Vsub(&dst, &ObjectList[index].translate, &dst);
	dst.y = 0.0;
	Vnormal(&dst);
	
	float angle = acos(Vdot(&dst, &orgVec) ) / MATH_PI * 180.0;
	if(dst.x < 0) { 
		angle = angle - ObjectList[index].rotOffset.y;
		angle = -angle;
	}
	else {
		angle = angle + ObjectList[index].rotOffset.y;
	}
	
	cout << "Angle1: " << angle << " orgAngle1: " << orgAngle << endl;
	
	if( (angle < 0.0 && orgAngle > 0.0) || (angle > 0.0 && orgAngle < 0.0) ) {
		if( fabs(angle - orgAngle) >= 180.0) {
			if(angle < 0.0) {
				angle = 180.0 + (180.0 + angle);
			}
			else {
				angle = -180.0 - (180.0 - angle);
			}
		}
	}
	else {
		if( fabs(angle - orgAngle) >= 180.0) {
			float newAngle = 0.0;
			if(angle < 0.0) {
				newAngle = (360.0 + angle);
				if( fabs(angle - orgAngle) > fabs(newAngle - orgAngle)) angle = newAngle;
			}
			else {
				newAngle = -(360.0 - angle);
				if( fabs(angle - orgAngle) > fabs(orgAngle - newAngle)) angle = newAngle;
			}
		}
	}
	
	cout << "Angle: " << angle << " orgAngle: " << orgAngle << endl;
	
	if( fabs(angle - ObjectList[index].rotate.y) > ROTATE_TOLERANCE_LEVEL) { //add a rotate action
		Vector rotVec = ObjectList[index].rotate;
		rotVec.y = (float)((int)angle % 360);
		addAction(index, ROTATE_ACTION, &rotVec, front);
	}
}

void TRTS::addAttackAction(int index, int targetID) {
	TObject *targetObject = ObjectList[targetID].curObject;
	Vector tMaxVec = targetObject->GetMaxBounds();
	Vector tMinVec = targetObject->GetMinBounds();
	Vector diffVec, dstVec;
	
	Vsub(&tMaxVec, &tMinVec, &diffVec);
	Vscale(&diffVec, 0.7);
	diffVec.y = 0.0;
	Vsub(&ObjectList[targetID].translate, &diffVec, &dstVec);
	
	int index2 = getGameTypeIndex(ObjectList[index].gamePacket.type);
	ObjectList[index].gamePacket.goal.type = gameObjectTypeList[index2].attackType;
	ObjectList[index].gamePacket.goal.target = targetID;
}



void TRTS::addRotateAction2(int index, Vector src, Vector dst, bool front, bool viewTransform = true) {
	TObject *curObject = ObjectList[index].curObject;
	float orgAngle = ObjectList[index].rotate.y;
	
	Vector orgVec, maxPnt, minPnt, midPnt;
	
	orgVec.x = 0.0;
	orgVec.y = 0.0;
	orgVec.z = 1.0;
	
	Vsub(&dst, &src, &dst);
	dst.y = 0.0;
	Vnormal(&dst);
	
	float angle = acos(Vdot(&dst, &orgVec) ) / MATH_PI * 180.0;
	if(dst.x < 0) { 
		angle = angle - ObjectList[index].rotOffset.y;
		angle = -angle;
	}
	else {
		angle = angle + ObjectList[index].rotOffset.y;
	}
	
	cout << "Angle1: " << angle << " orgAngle1: " << orgAngle << endl;
	
	if( (angle < 0.0 && orgAngle > 0.0) || (angle > 0.0 && orgAngle < 0.0) ) {
		if( fabs(angle - orgAngle) >= 180.0) {
			if(angle < 0.0) {
				angle = 180.0 + (180.0 + angle);
			}
			else {
				angle = -180.0 - (180.0 - angle);
			}
		}
	}
	else {
		if( fabs(angle - orgAngle) >= 180.0) {
			float newAngle = 0.0;
			if(angle < 0.0) {
				newAngle = (360.0 + angle);
				if( fabs(angle - orgAngle) > fabs(newAngle - orgAngle)) angle = newAngle;
			}
			else {
				newAngle = -(360.0 - angle);
				if( fabs(angle - orgAngle) > fabs(newAngle - orgAngle)) angle = newAngle;
			}
		}
	}
	
	cout << "Angle: " << angle << " orgAngle: " << orgAngle << endl;
	
	if( fabs(angle - ObjectList[index].rotate.y) > ROTATE_TOLERANCE_LEVEL) { //add a rotate action
		Vector rotVec = ObjectList[index].rotate;
		rotVec.y = (float)((int)angle % 360);
		addAction(index, ROTATE_ACTION, &rotVec, front);
	}
}

void TRTS::simulateGameObjects()
{
	int actionType;
	int targetIndex;
	list<GamerAction>::iterator gaIter;
	
	if (FPSGamePacket.resource < RESOURCE_CAP && mainRatAlive())
		FPSGamePacket.resource = FPSGamePacket.resource + ((frameCnt % 10) == 1);
	
	int i, olSize = ObjectList.size();
	for(i = 0; i < olSize; i++) {
		if (ObjectList[i].curObject->GetType() != MD2_TYPE)
			continue;
		if (ObjectList[i].gamePacket.type == -1)
			continue;
		if (ObjectList[i].gamePacket.health <= 0)
			continue;
		
		if (ObjectList[i].gamePacket.type == PLAYER_TYPE && ObjectList[i].gamePacket.health > 100) {
			ObjectList[i].gamePacket.health--;
			ObjectList[i].shadow = CHROM_REFRACT_TRUE;
		}
		else if (ObjectList[i].gamePacket.type == PLAYER_TYPE && ObjectList[i].gamePacket.health <= 100)
			ObjectList[i].shadow = true;
		
		actionType = ObjectList[i].gamePacket.goal.type;
		
		if (actionType == MOVE_ACTION) {
			// simulate move
			simulateMove(i);
		}
		else if (actionType == ATTACK_MELEE_ACTION || actionType == ATTACK_RANGE_ACTION ||
				actionType == ATTACK_RAT_RANGE_ACTION) {
			// simulate attack
			int targetIndex = getObjectListIndex((TObject *)ObjectList[i].gamePacket.goal.target);
			
			if(targetIndex == -1 || ObjectList[targetIndex].gamePacket.health <= 0) {
				ObjectList[i].gamePacket.goal.type = IDLE_ACTION;
				TMd2 *curMd2 = (TMd2 *)ObjectList[i].curObject;
				curMd2->SetCurrentAnimation(IDLE_ANIMATE, ANIMATE_SMOOTHNESS);
				return;
			}
			
			if(attackActionHits(i, targetIndex)) {
				simulateAttack(i, targetIndex);
			} else {
				simulateMove(i);
			}
			
			if(ObjectList[i].gamePacket.goal.type == IDLE_ACTION) {
				cout << "Idle action detected!" << endl;
				ObjectList[i].gamePacket.goal.type = actionType;
				ObjectList[i].gamePacket.waypointList =
					findRoomPath(ObjectList[i].translate, ObjectList[targetIndex].translate);
			}
		}
	}

	simulatePillarObjects();
	simulateBuildObjects();
	findAndsimulateDeadObjects();
	simulateReviveHuman();
	
	if( (SDL_GetTicks() - itemSpawnTime) > 300000) {
		itemSpawnTime = SDL_GetTicks();
		for(int p = 0; p < 20; p++) ReSpawnItems();
	}
}

bool TRTS::attackActionHits(int objNum, int targetIndex)
{
	Vector bounds[8];
	
	bounds[0] = *(ObjectList[objNum].curObject->GetDstBounds1());
	bounds[1] = *(ObjectList[objNum].curObject->GetDstBounds2());
	bounds[2] = *(ObjectList[objNum].curObject->GetDstBounds3());
	bounds[3] = *(ObjectList[objNum].curObject->GetDstBounds4());
	bounds[4] = *(ObjectList[objNum].curObject->GetDstBounds5());
	bounds[5] = *(ObjectList[objNum].curObject->GetDstBounds6());
	bounds[6] = *(ObjectList[objNum].curObject->GetDstBounds7());
	bounds[7] = *(ObjectList[objNum].curObject->GetDstBounds8());
	
	Vector goalDiff;
	goalDiff.x = sin(ObjectList[objNum].rotate.y * MATH_PI / 180.0);
	goalDiff.y = 0.0;
	goalDiff.z = cos(ObjectList[objNum].rotate.y * MATH_PI / 180.0);
	
	int gtIndex = getGameTypeIndex(ObjectList[objNum].gamePacket.type);
	Vscale(&goalDiff, gameObjectTypeList[gtIndex].range);
	
	Vadd(&bounds[1], &goalDiff, &bounds[1]);
	Vadd(&bounds[3], &goalDiff, &bounds[3]);
	Vadd(&bounds[4], &goalDiff, &bounds[4]);
	Vadd(&bounds[6], &goalDiff, &bounds[6]);
	
	dummyObj->SetDstBounds1(bounds[0].x, bounds[0].y, bounds[0].z);
	dummyObj->SetDstBounds2(bounds[1].x, bounds[1].y, bounds[1].z);
	dummyObj->SetDstBounds3(bounds[2].x, bounds[2].y, bounds[2].z);
	dummyObj->SetDstBounds4(bounds[3].x, bounds[3].y, bounds[3].z);
	dummyObj->SetDstBounds5(bounds[4].x, bounds[4].y, bounds[4].z);
	dummyObj->SetDstBounds6(bounds[5].x, bounds[5].y, bounds[5].z);
	dummyObj->SetDstBounds7(bounds[6].x, bounds[6].y, bounds[6].z);
	dummyObj->SetDstBounds8(bounds[7].x, bounds[7].y, bounds[7].z);
	
	if(OBBIntersect(dummyObj, ObjectList[targetIndex].curObject)) {
		printf("Attack hit!\n");
		return true;
	}
	
	return false;
}

void TRTS::simulateAttack(int objNum, int targetIndex)
{
	int gtIndex = getGameTypeIndex(ObjectList[objNum].gamePacket.type);
	
	Vector shootVec, workVec, startVec, ammoRotLoc;
	float targetDist, shootVel;
	
	switch(gameObjectTypeList[gtIndex].attackType) {
	case ATTACK_MELEE_ACTION:
		
		ObjectList[targetIndex].gamePacket.health -= gameObjectTypeList[gtIndex].damage;
		break;
		
	case ATTACK_RANGE_ACTION:
		
		Vsub(&ObjectList[targetIndex].translate, &ObjectList[objNum].translate, &shootVec);
//		if(shootVec.y < 0.0) shootVec.y = 2.0;
		
		Vnormal(&shootVec);
		workVec = shootVec;
		Vscale(&shootVec, 7.0);
		Vscale(&workVec, 5.0);
		
		startVec = ObjectList[objNum].translate;
		Vadd(&ObjectList[objNum].translate, &workVec, &startVec);
		
		ammoRotLoc = ObjectList[objNum].rotate;
		ObjectList[objNum].gamePacket.weaponSwitchFrame++;
		
		if((ObjectList[objNum].gamePacket.weaponSwitchFrame % 5) == 0) {
			//within range, we can hit target
			cout << "Shooting" << endl;
			shootAmmo(objNum, CANNON_SHOT_TYPE,
				shootVec, startVec, &ammoRotLoc,  -1);
			TNetwork *curNetwork = curInfrastructure->getNetwork();
			curNetwork->sendParticlePacket((char)CANNON_SHOT_TYPE, objNum, startVec, shootVec);
		}
		break;
		
	case ATTACK_RAT_RANGE_ACTION:
		
		startVec = ObjectList[objNum].translate;
		startVec.y += 10.0;
		
		Vsub(&ObjectList[targetIndex].translate, &startVec, &shootVec);
		shootVec.y = 0.0;
		
		targetDist = Vlength(&shootVec);
		shootVel = fast_sqrt((0.8 * targetDist * targetDist)/(10 + targetDist));
		
		Vnormal(&shootVec);
		workVec = shootVec;
		Vscale(&shootVec, shootVel / M_SQRT2);
		shootVec.y = shootVel / M_SQRT2;
		
		ammoRotLoc = ObjectList[objNum].rotate;
		ObjectList[objNum].gamePacket.weaponSwitchFrame++;
		
		if((ObjectList[objNum].gamePacket.weaponSwitchFrame % 15) == 0) {
			// within range, we can hit target
			shootAmmo(objNum, MOUSE_SHOT_TYPE, 
				shootVec, startVec, &ammoRotLoc,  -1);
			TNetwork *curNetwork = curInfrastructure->getNetwork();
			curNetwork->sendParticlePacket((char)MOUSE_SHOT_TYPE, objNum, startVec, shootVec);
		}
		break;
		
	case ATTACK_SUICIDE_ACTION:
		curInfrastructure->PlaySound(EXPLODE_SOUND);
		ObjectList[targetIndex].gamePacket.health -= gameObjectTypeList[gtIndex].damage;
		ObjectList[objNum].gamePacket.health = -1;
		shootAmmo(objNum, EXPLOSION1, startVec, startVec, NULL, -1);
		TNetwork *curNetwork = curInfrastructure->getNetwork();
		curNetwork->sendParticlePacket((char)ATTACK_SUICIDE_ACTION, objNum, ObjectList[objNum].translate, ObjectList[objNum].translate);
		break;
		
	}

	if(ObjectList[targetIndex].gamePacket.type == PLAYER_TYPE) {
		curInfrastructure->PlaySound(OW_SOUND);
	}
}

static int INTERSECTS_NOTHING = 0;
static int INTERSECTS_ONLY_GOAL_OBJ = 1;
static int INTERSECTS_OTHER_OBJ = 2;

void TRTS::simulateMove(int objNum)
{
	list<Vector>::iterator vIter;
	
	int goalIndex = getObjectListIndex((TObject *)ObjectList[objNum].gamePacket.goal.target);
	
	if(ObjectList[objNum].gamePacket.actionList.empty()) {
		// need to update waypoint
		if(ObjectList[objNum].gamePacket.waypointList.empty()) {
			// we've reached our goal
			ObjectList[objNum].gamePacket.goal.type = IDLE_ACTION;
			TMd2 *curMd2 = (TMd2 *)ObjectList[objNum].curObject;
			curMd2->SetCurrentAnimation(IDLE_ANIMATE, ANIMATE_SMOOTHNESS);
			return;
		} else {
			Vector nextWaypoint = *(ObjectList[objNum].gamePacket.waypointList.begin());
			ObjectList[objNum].gamePacket.waypointList.pop_front();
			
			int portalIndex;
			
			if(ObjectList[objNum].gamePacket.waypointList.empty()) {
				portalIndex = findPortal(nextWaypoint);
			} else {
				Vector futureWaypoint = *(ObjectList[objNum].gamePacket.waypointList.begin());
				Vector ctrPt;
				int sectors[4];
				bool foundSector[2] = { false, false };
				int i, pwlSize = PortalWindowList.size();
				for(i = 0; i < pwlSize; i++) {
					Vset(&ctrPt, 0.0, 0.0, 0.0);
					Vadd(&ctrPt, &PortalWindowList[i].Bounds1, &ctrPt);
					Vadd(&ctrPt, &PortalWindowList[i].Bounds2, &ctrPt);
					ctrPt.x /= 2.0; ctrPt.y /= 2.0; ctrPt.z /= 2.0;
					if(Vequal(&nextWaypoint, &ctrPt)) {
						sectors[0] = PortalWindowList[i].index1;
						sectors[1] = PortalWindowList[i].index2;
						foundSector[0] = true;
						if(foundSector[1]) break;
					}
					if(Vequal(&futureWaypoint, &ctrPt)) {
						sectors[2] = PortalWindowList[i].index1;
						sectors[3] = PortalWindowList[i].index2;
						foundSector[1] = true;
						if(foundSector[0]) break;
					}
				}
				
				if(foundSector[0] && foundSector[1]) {
					if(sectors[0] == sectors[2] || sectors[0] == sectors[3])
						portalIndex = sectors[1];
					if(sectors[1] == sectors[2] || sectors[1] == sectors[3])
						portalIndex = sectors[0];
				} else {
					int goalPortal = findPortal(futureWaypoint);
					if(sectors[0] == goalPortal)
						portalIndex = sectors[1];
					if(sectors[1] == goalPortal)
						portalIndex = sectors[0];
				}
			}
			
			if(ObjectList[objNum].gamePacket.goal.target != NULL) {
				int prevSectorIndex = ObjectList[objNum].sectorIndex;
				ObjectList[objNum].sectorIndex = portalIndex;
				ObjectList[objNum].gamePacket.waypointList =
					findRoomPath(ObjectList[objNum].translate, ObjectList[goalIndex].translate, objNum);
				ObjectList[objNum].gamePacket.waypointList.pop_front();
				ObjectList[objNum].sectorIndex = prevSectorIndex;
			}
			
			list<Vector> moveSteps = findPath(objNum, nextWaypoint, portalIndex, goalIndex);
			
			Vector newLoc;
			for(vIter = moveSteps.begin(); vIter != moveSteps.end(); ++vIter) {
				newLoc = *vIter;
				addAction(objNum, MOVE_ACTION, &newLoc, false);
			}
		}
	}
	
	if(ObjectList[objNum].gamePacket.goal.target != NULL) {
		int portalIndex = ObjectList[objNum].sectorIndex;
		int goalPortalIndex = ObjectList[goalIndex].sectorIndex;
		
		if(portalIndex == goalPortalIndex) {
			ObjectList[objNum].gamePacket.actionList.clear();
			list<Vector> newPath = findPath(objNum, ObjectList[goalIndex].translate, portalIndex, goalIndex);
			Vector newLoc;
			list<Vector>::iterator vIter;
			for(vIter = newPath.begin(); vIter != newPath.end(); ++vIter) {
				newLoc = *vIter;
				addAction(objNum, MOVE_ACTION, &newLoc, false);
			}
		}
	}
	
	if(ObjectList[objNum].gamePacket.actionList.empty())
		return;
	list<GamerAction>::iterator gaIter = ObjectList[objNum].gamePacket.actionList.begin();
	
	if((*gaIter).frame == 0) {
		TMd2 *curMd2 = (TMd2 *)ObjectList[objNum].curObject;
		curMd2->SetCurrentAnimation(MOVE_ANIMATE, ANIMATE_SMOOTHNESS);
		(*gaIter).frame++;
	}
	
	int gtIndex = getGameTypeIndex(ObjectList[objNum].gamePacket.type);
	
	Vector goalDir;
	Vsub(&((*gaIter).dst), &ObjectList[objNum].translate, &goalDir);
	goalDir.y = 0.0;
	
	float thetaDiff = getGoalDirTheta(ObjectList[objNum].rotate.y, goalDir);
	
	Vector origRotate = ObjectList[objNum].rotate;
	
	if(fabs(thetaDiff) > gameObjectTypeList[gtIndex].rotVel) {
		// we need to do some turrrrrrrning...
		if(thetaDiff > 0.0) {
			ObjectList[objNum].rotate.y += gameObjectTypeList[gtIndex].rotVel;
		}
		else if(thetaDiff < 0.0) {
			ObjectList[objNum].rotate.y -= gameObjectTypeList[gtIndex].rotVel;
		}
		return;
	} else {
		// just point ourselves in the right direction; we can do it!
		ObjectList[objNum].rotate.y += thetaDiff;
		if(ObjectList[objNum].rotate.y > 180.0)
			ObjectList[objNum].rotate.y -= 360.0;
		else if (ObjectList[objNum].rotate.y < -180.0)
			ObjectList[objNum].rotate.y += 360.0;
	}
	
	// now move
	
	Vector origTranslate = ObjectList[objNum].translate;
	
	Vnormal(&goalDir);
	Vscale(&goalDir, gameObjectTypeList[gtIndex].transVel);
	
	Vadd(&ObjectList[objNum].translate, &goalDir, &ObjectList[objNum].translate);
	
	Vector newGoalDir;
	Vsub(&(*gaIter).dst, &ObjectList[objNum].translate, &newGoalDir);
	newGoalDir.y = 0.0;
	
	bool actionDone = false;
		
	Vnormal(&goalDir);
	Vnormal(&newGoalDir);
	
	float dp = Vdot(&goalDir, &newGoalDir);
	if(dp < 0.0) {
		ObjectList[objNum].translate.x = (*gaIter).dst.x;
		ObjectList[objNum].translate.z = (*gaIter).dst.z;
		actionDone = true;
	}
	
	Vector moveVect;
	Vsub(&ObjectList[objNum].translate, &origTranslate, &moveVect);
	float moveLength = Vlength(&moveVect);
	
	int intersectionStatus = calculateIntersections(objNum, moveVect, goalIndex);
	
	if(intersectionStatus == INTERSECTS_ONLY_GOAL_OBJ) {
		// move backwards along moveVect until we find a good spot
		Vector deltaVect = moveVect;
		Vscale(&deltaVect, -0.2);
		int i;
		for(i = 0; i < 5; i++) {
			Vadd(&moveVect, &deltaVect, &moveVect);
			if(calculateIntersections(objNum, moveVect, goalIndex) == INTERSECTS_NOTHING) {
				Vadd(&origTranslate, &moveVect, &origTranslate);
				ObjectList[objNum].translate = origTranslate;
				ObjectList[objNum].gamePacket.waypointList.clear();
				actionDone = true;
				break;
			}
		}
	}
	else if(intersectionStatus == INTERSECTS_OTHER_OBJ) {
		cout << "Intersection detected!" << endl;
		actionDone = false;
		ObjectList[objNum].rotate = origRotate;
		ObjectList[objNum].translate = origTranslate;
		ObjectList[objNum].gamePacket.actionList.clear();
		Vector tmp;
		if(ObjectList[objNum].gamePacket.waypointList.empty()) {
			cout << "Waypoint list empty!" << endl;
			if(ObjectList[objNum].gamePacket.goal.target == NULL) {
				tmp = ObjectList[objNum].gamePacket.goal.dst;
			} else {
				TObject *obj = (TObject *)ObjectList[objNum].gamePacket.goal.target;
				int tIndex = getObjectListIndex(obj);
				if(tIndex == -1) {
					cout << "Object not found!" << endl;
					return;
				} else {
					tmp = ObjectList[tIndex].translate;
				}
			}
		} else {
			tmp = *(ObjectList[objNum].gamePacket.waypointList.begin());
		}
		ObjectList[objNum].gamePacket.waypointList.push_front(tmp);
	}
	
	if(actionDone) {
		ObjectList[objNum].gamePacket.actionList.pop_front();
		TMd2 *curMd2 = (TMd2 *)ObjectList[objNum].curObject;
		curMd2->SetCurrentAnimation(IDLE_ANIMATE, ANIMATE_SMOOTHNESS);
	}
}

int TRTS::calculateIntersections(int objNum, Vector move, int goalIndex)
{
	bool intersectedGoalObj = false;
	int sectorIndex = ObjectList[objNum].sectorIndex;
	
	Vector bounds[8];
	
	bounds[0] = *(ObjectList[objNum].curObject->GetDstBounds1());
	bounds[1] = *(ObjectList[objNum].curObject->GetDstBounds2());
	bounds[2] = *(ObjectList[objNum].curObject->GetDstBounds3());
	bounds[3] = *(ObjectList[objNum].curObject->GetDstBounds4());
	bounds[4] = *(ObjectList[objNum].curObject->GetDstBounds5());
	bounds[5] = *(ObjectList[objNum].curObject->GetDstBounds6());
	bounds[6] = *(ObjectList[objNum].curObject->GetDstBounds7());
	bounds[7] = *(ObjectList[objNum].curObject->GetDstBounds8());
	
	int i;
	for(i = 0; i < 8; i++)
		Vadd(&bounds[i], &move, &bounds[i]);
	
	dummyObj->SetDstBounds1(bounds[0].x, bounds[0].y, bounds[0].z);
	dummyObj->SetDstBounds2(bounds[1].x, bounds[1].y, bounds[1].z);
	dummyObj->SetDstBounds3(bounds[2].x, bounds[2].y, bounds[2].z);
	dummyObj->SetDstBounds4(bounds[3].x, bounds[3].y, bounds[3].z);
	dummyObj->SetDstBounds5(bounds[4].x, bounds[4].y, bounds[4].z);
	dummyObj->SetDstBounds6(bounds[5].x, bounds[5].y, bounds[5].z);
	dummyObj->SetDstBounds7(bounds[6].x, bounds[6].y, bounds[6].z);
	dummyObj->SetDstBounds8(bounds[7].x, bounds[7].y, bounds[7].z);
	
	int olSize = ObjectList.size();
	for(i = 0; i < olSize; i++) {
		if(i == objNum)
			continue;
		if(ObjectList[i].sectorIndex != sectorIndex)
			continue;
		if(ObjectList[i].gamePacket.type >= 50 && ObjectList[i].gamePacket.type != PLAYER_TYPE
			&& ObjectList[i].gamePacket.type != GAME_PILLAR_TYPE)
			continue;
		if(ObjectList[i].curObject->GetType() == PLANE_TYPE) {
			TPlane *curPlane = (TPlane *)ObjectList[i].curObject;
			Vector planeNormal = curPlane->GetNormal();
			if(fabs(planeNormal.y) >= .99)
				continue;
		}
		
		if(OBBIntersect(dummyObj, ObjectList[i].curObject)) {
			if(i == goalIndex)
				intersectedGoalObj = true;
			else return INTERSECTS_OTHER_OBJ;
		}
	}
	
	return (intersectedGoalObj ? INTERSECTS_ONLY_GOAL_OBJ : INTERSECTS_NOTHING);
}

float TRTS::getGoalDirTheta(float curTheta, Vector goalDiff)
{
	Vector heading1, heading2, ref;
	float theta1, theta2, thetaDiff;
	
	if(Vlength(&goalDiff) == 0.0)
		return 0.0;
	
	ref.x = 0.0;
	ref.y = 0.0;
	ref.z = 1.0;
	
	heading1.x = sin(curTheta * MATH_PI / 180.0);
	heading1.y = 0.0;
	heading1.z = cos(curTheta * MATH_PI / 180.0);
	
	heading2 = goalDiff;
	Vnormal(&heading2);
	
	theta1 = acos(Vdot(&heading1, &ref)) * 180.0 / MATH_PI;
	theta2 = acos(Vdot(&heading2, &ref)) * 180.0 / MATH_PI;
	
	if(heading1.x < 0.0)
		theta1 = -theta1;
	if(heading2.x < 0.0)
		theta2 = -theta2;
	
	thetaDiff = theta2 - theta1;

	if(thetaDiff < -180.0)
		thetaDiff += 360.0;
	else if(thetaDiff > 180.0)
		thetaDiff -= 360.0;
	
	return thetaDiff;
}

int TRTS::getObjectListIndex(TObject *obj)
{
	int i, olSize = ObjectList.size();
	for(i = 0; i < olSize; i++) {
		if(ObjectList[i].curObject == obj)
			return i;
	}
	return -1;
}

void TRTS::simulateMeleeAttack(int id, list<GamerAction>::iterator iter) {
	TObject *curObject = ObjectList[id].curObject;
	Vector Bnd1, Bnd2, Bnd3, Bnd4, Bnd5, Bnd6, Bnd7, Bnd8;
	
	Bnd1 = *(curObject->GetDstBounds1());
	Bnd2 = *(curObject->GetDstBounds2());
	Bnd3 = *(curObject->GetDstBounds3());
	Bnd4 = *(curObject->GetDstBounds4());
	Bnd5 = *(curObject->GetDstBounds5());
	Bnd6 = *(curObject->GetDstBounds6());
	Bnd7 = *(curObject->GetDstBounds7());
	Bnd8 = *(curObject->GetDstBounds8());
	
	Vector moveVec, distVec, orgDistVec;
	Vsub( &(*iter).dst, &ObjectList[id].translate, &orgDistVec);
	moveVec = orgDistVec;
	moveVec.y = 0.0;
	Vnormal(&moveVec);
	Vscale(&moveVec, MELEE_REACH);
	
	Vadd(&Bnd1, &moveVec, &Bnd1);
	Vadd(&Bnd2, &moveVec, &Bnd2);
	Vadd(&Bnd3, &moveVec, &Bnd3);
	Vadd(&Bnd4, &moveVec, &Bnd4);
	Vadd(&Bnd5, &moveVec, &Bnd5);
	Vadd(&Bnd6, &moveVec, &Bnd6);
	Vadd(&Bnd7, &moveVec, &Bnd7);
	Vadd(&Bnd8, &moveVec, &Bnd8);
	
	dummyObj->SetDstBounds1(Bnd1.x, Bnd1.y, Bnd1.z);
	dummyObj->SetDstBounds2(Bnd2.x, Bnd2.y, Bnd2.z);
	dummyObj->SetDstBounds3(Bnd3.x, Bnd3.y, Bnd3.z);
	dummyObj->SetDstBounds4(Bnd4.x, Bnd4.y, Bnd4.z);
	dummyObj->SetDstBounds5(Bnd5.x, Bnd5.y, Bnd5.z);
	dummyObj->SetDstBounds6(Bnd6.x, Bnd6.y, Bnd6.z);
	dummyObj->SetDstBounds7(Bnd7.x, Bnd7.y, Bnd7.z);
	dummyObj->SetDstBounds8(Bnd8.x, Bnd8.y, Bnd8.z);
	
	for(int i = 0; i < ObjectList.size(); i++) {
		if(i != id) {
			if(ObjectList[i].gamePacket.team !=0 && ObjectList[i].gamePacket.team != ObjectList[id].gamePacket.team) {
				if(OBBIntersect(dummyObj, ObjectList[i].curObject)) { //hits something
					int hit_Index = getGameTypeIndex(ObjectList[id].gamePacket.type);
					ObjectList[i].gamePacket.health = ObjectList[i].gamePacket.health -
						gameObjectTypeList[hit_Index].damage;
				}
			}
		}
	}
	
	if( (*iter).frame == 0) {
		TMd2 *curMd2 = (TMd2 *)curObject;
		curMd2->SetCurrentAnimation(ATTACK_ANIMATE, ANIMATE_SMOOTHNESS);
		(*iter).frame++;
	}
}

void TRTS::simulateRangeAttack(int id, list<GamerAction>::iterator iter) {
	
}

void TRTS::findAndsimulateDeadObjects() {
	for(int i = 0; i < ObjectList.size(); i++) {
			if(ObjectList[i].gamePacket.health == 0) ObjectList[i].gamePacket.health = -1;
			if(ObjectList[i].gamePacket.health <= 0) {
//			if(ObjectList[i].gamePacket.type == PLAYER_TYPE) ObjectList[i].gamePacket.health = 100;
			bool addDeathFlag = false;
			if(ObjectList[i].gamePacket.actionList.empty() ) addDeathFlag = true;
			else {
				list<GamerAction>::iterator start_Iter = ObjectList[i].gamePacket.actionList.begin();
				if( (*start_Iter).type != DEATH_ACTION) {
					addDeathFlag = true;
				}
			}
			
			if(addDeathFlag) {
				Vector dummyVec;
				if(!ObjectList[i].gamePacket.actionList.empty() ) ObjectList[i].gamePacket.actionList.clear();
				addAction(i, DEATH_ACTION, &dummyVec, true);
				TMd2 *curMd2 = (TMd2 *)ObjectList[i].curObject;
				
				if(ObjectList[i].gamePacket.type == PLAYER_TYPE || ObjectList[i].gamePacket.type == MAIN_RAT_TYPE) {
					if(ObjectList[i].gamePacket.type == PLAYER_TYPE) {
						statusTextSet("You have just killed the human player!");
						curInfrastructure->PlaySound(HALLELUJAH_SOUND);
						curInfrastructure->PlaySound(LAUGH_CARTOON_SOUND);
						gameScore.side1_score++;
					}
					else {
						curInfrastructure->PlaySound(CARTOON_CHARGE_SOUND);
						statusTextSet("Your Voodoo Rat has been slain!");
						ObjectList[i].gamePacket.goal.type = IDLE_ACTION;
						if(!ObjectList[i].gamePacket.waypointList.empty())
							ObjectList[i].gamePacket.waypointList.clear();
						gameScore.side2_score++;
					}
					
					if(ObjectList[i].gamePacket.type == PLAYER_TYPE)
						curMd2->SetCurrentAnimation(curMd2->GetDeathAnimationIndex(), ANIMATE_SMOOTHNESS);
					else curMd2->SetCurrentAnimation(DEATH_ANIMATE, ANIMATE_SMOOTHNESS);
					ObjectList[i].gamePacket.deadFrameCnt = 0;
					reviveTime = SDL_GetTicks();
				}
				else curMd2->SetCurrentAnimation(DEATH_ANIMATE, ANIMATE_SMOOTHNESS);
				curMd2->SetAnimationCycle(false);
				ObjectList[i].gamePacket.selectLevel = -1;
			}
		}
	}
	
	bool deleteFlag = false;
	for(int j = 0; j < ObjectList.size(); j++) {
		if(ObjectList[j].gamePacket.health <= 0 && ObjectList[j].gamePacket.type != PLAYER_TYPE && ObjectList[j].gamePacket.type != MAIN_RAT_TYPE) {
			list<GamerAction>::iterator iter = ObjectList[j].gamePacket.actionList.begin();
			if( (*iter).type == DEATH_ACTION) {
				(*iter).frame++;
				if( (*iter).frame > DEATH_ANIMATE_MAX_FRAMES && ObjectList[j].gamePacket.type != PLAYER_TYPE && ObjectList[j].gamePacket.type != GAME_PILLAR_TYPE) deleteFlag = true;
				
				if ((*iter).frame > DEATH_ANIMATE_MAX_FRAMES && ObjectList[j].gamePacket.type == GAME_PILLAR_TYPE) {
					gameScore.side2_score++;
				}
			}
		}
	}
	
	//now delete away the objects from the objectlist
	if(!deleteFlag) return;
	selectList.clear();
	vector<SceneObjInfo> newObjList;
	for(int k = 0; k < ObjectList.size(); k++) {
		bool copyFlag = true;
		if(ObjectList[k].gamePacket.health <= 0) {
			if(ObjectList[k].gamePacket.type != PLAYER_TYPE && ObjectList[k].gamePacket.type != MAIN_RAT_TYPE) {
				list<GamerAction>::iterator iter2 = ObjectList[k].gamePacket.actionList.begin();
				if( (*iter2).type == DEATH_ACTION) {
					if( (*iter2).frame > DEATH_ANIMATE_MAX_FRAMES) {
						copyFlag = false;
						TMd2 *curMd2 = (TMd2 *)LoadedTObjects[ObjectList[k].loadedTObjIndex];
						cout << "Clearing Dead Object" << endl;
						if(curMd2 == NULL)
							cout << "Trying to delete NULL" << endl;
						
						delete curMd2;
						LoadedTObjects[ObjectList[k].loadedTObjIndex] = NULL;
					}
				}
			}
			else { //it's a player, see if we can respawn
				ObjectList[k].gamePacket.health = 100;
			}
			
		}
		if(copyFlag) newObjList.push_back(ObjectList[k]);
	}
	
	ObjectList = newObjList;
	
}

int TRTS::getGameEnd() {
	if(gameScore.side1_score >= 6) return 1;
	if(gameScore.side2_score > 0) return 2;
	
	return 0;
	
}


void TRTS::loadRTStoolBar(char *filename, TWidgetManager *widgetManager) {
	RTStoolBar = new toolBar(curInfrastructure);
	RTStoolBar->setWidgetManager(widgetManager);
//	RTStoolBar->setDimensions(0, curInfrastructure->GetWinHeight() - 640, 150, 750);
	RTStoolBar->setDimensions(0, curInfrastructure->GetWinHeight() - 900, 100, 1200);
	RTStoolBar->setStyle(VERTICAL_STYLE); 
	RTStoolBar->setBtnSize(40, 40);
	RTStoolBar->setOffset(20, 30);
	RTStoolBar->setBtnOffset(15, 200);
	RTStoolBar->LoadButtonList(filename);
	
	//initialize building pictures
	for(int i = 0 ; i < MAX_BUILD; i++) {
		TPicButton *newPic = new TPicButton(curInfrastructure);
		newPic->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0);
		newPic->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0);
		widgetManager->AttachWidget(newPic);
		
		buildPics.push_back(newPic);
	}
	
}

bool TRTS::mainRatAlive() {
	for(int i = 0; i < ObjectList.size(); i++) {
		if(ObjectList[i].gamePacket.type == MAIN_RAT_TYPE && ObjectList[i].gamePacket.health <= 0) { 
			return false;
		}
	}
		
	return true;
}

void TRTS::renderEndGameSequence() {
	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
	Vector showLight, showEye;
//	Vset(&showLight, 0.0, 60.0, -4.0); Vset(&showEye, -30.0, 0.0, 600.0);
//	SetLighting(showLight, showEye, 600.0, 1.0, 1.0, 1.0);
	
	
	endGameFrameCnt++;
	
	int curFrame = (endGameFrameCnt % END_GAME_FRAME_CAP);
	float startZ = -500.0, zVec = 0.4;
	float offSetX = 32.0, offSetZ = 64.0;
	Vector srcCenter;
	Vset(&srcCenter, 0.0, -30.0, startZ + zVec * (float)curFrame);

	int mouseIndex = getGameTypeIndex(1);
	int playerIndex = getGameTypeIndex(100);
	GameType mouseType = GetUnitInfo(1);
	GameType playerType = GetUnitInfo(100);
		
	for(int i = -1; i <= 1; i++) {
		for(int j = -1; j <= 1; j++) {
			Vector newMove;
			Vset(&newMove, i * offSetX + srcCenter.x, srcCenter.y, j * offSetZ + srcCenter.z);
			TMd2 *curMd2 = LoadedMd2( (char *)(mouseType.md2_Filename.c_str()) );
			
			if(endGameFrameCnt == 1) curMd2->SetCurrentAnimation(MOVE_ANIMATE, ANIMATE_SMOOTHNESS * 10);
			
			curMd2->RestoreMatrix();
			curMd2->PrepareTransform();
				glLoadIdentity();
				glTranslatef(newMove.x, newMove.y, newMove.z);
				glRotatef(0.0, 0.0, 0.0, 1.0f);
				glRotatef(0.0, 0.0, 1.0f, 0.0);
				glRotatef(0.0, 1.0f, 0.0, 0.0);
				glScalef(1.0, 1.0, 1.0);
			curMd2->EndTransform();
				
				
			curMd2->EnablePlainDecal();
			curMd2->SelectSingleDecalTexture();
			curMd2->SetupVertexArraysForRendering(DECAL_MODE);
			curMd2->PlayAnimation();
			curMd2->Render();
		
			curMd2->EnableDiffusePass(0.2f, 0.2f, 0.2f, 0.0f, 0.5, 0.5, 0.5, 0.0f);
			curMd2->SelectCubeAndBumpTexture();
			curMd2->SetupVertexArraysForRendering(DIFFUSE_BUMP_MODE);
			curMd2->Render();
		
		}
	}
	
	
	Vector newMove2;
	if(gameScore.side1_score < gameScore.side2_score) {
		Vset(&newMove2, srcCenter.x, srcCenter.y + 30, srcCenter.z - offSetZ * 6);
	}
	else {
		Vset(&newMove2, srcCenter.x, srcCenter.y + 30, srcCenter.z + offSetZ * 2);
	}
	TMd2 *playerMd2 = LoadedMd2( (char *)(playerType.md2_Filename.c_str()) );
			
	if(endGameFrameCnt == 1) playerMd2->SetCurrentAnimation(MOVE_ANIMATE, ANIMATE_SMOOTHNESS * 4);
	
	playerMd2->RestoreMatrix();
	playerMd2->PrepareTransform();
		glLoadIdentity();
		glTranslatef(newMove2.x, newMove2.y, newMove2.z);
		glRotatef(0.0, 0.0, 0.0, 1.0f);
		glRotatef(-90.0, 0.0, 1.0f, 0.0);
		glRotatef(0.0, 1.0f, 0.0, 0.0);
		glScalef(5.0, 5.0, 5.0);
	playerMd2->EndTransform();
	
	playerMd2->EnablePlainDecal();
	playerMd2->SelectSingleDecalTexture();
	playerMd2->SetupVertexArraysForRendering(DECAL_MODE);
	playerMd2->PlayAnimation();
	playerMd2->Render();
	
	
	playerMd2->EnableDiffusePass(0.2f, 0.2f, 0.2f, 0.0f, 0.5, 0.5, 0.5, 0.0f);
	playerMd2->SelectCubeAndBumpTexture();
	playerMd2->SetupVertexArraysForRendering(DIFFUSE_BUMP_MODE);
	playerMd2->Render();
}



void TRTS::addBuildUnit(int type) {
	if(gameBuildList.size() < MAX_BUILD) {
		GameType newType;
		newType = GetUnitInfo(type);
		if( (FPSGamePacket.resource - newType.cost < 0)) {
			statusTextSet("Not enough energy to spawn new unit!");
			return;
		}
		
		if(!mainRatAlive()) { 
			statusTextSet("Cannot build units when your Voodoo Rat is dead!");
			return;
		}
		
		FPSGamePacket.resource = FPSGamePacket.resource - newType.cost;
		newType.miscBuildTime = newType.buildtime;
		gameBuildList.push_back(newType);
		cout << "Resources Left: " << FPSGamePacket.resource << endl;
	}
}

void TRTS::simulateBuildObjects() {
	for(int i = 0; i < gameBuildList.size(); i++) {
		gameBuildList[i].buildtime = gameBuildList[i].buildtime - 1;
		buildPics[i]->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0);
		buildPics[i]->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0);
	}
	
	/* unit finished building, remove it from build list and add it into the game*/
	vector<GameType> newBuildList;
	int cnt = 0;
	for(i = 0; i < gameBuildList.size(); i++) {
		if(gameBuildList[i].buildtime <= 0) { //add the unit into the game at the current spawn point
			Vector rotVec, scaleVec, objSpawnPt;
			GameType addType = GetUnitInfo(gameBuildList[i].type);
			Vset(&rotVec, 0.0, 0.0, 0.0); Vset(&scaleVec, addType.size, addType.size, addType.size);
			
			TMd2 *addMd2 = new TMd2(curInfrastructure);
			addMd2->Copy(*(LoadedMd2( (char *)(addType.md2_Filename.c_str() ) )));
			
			addMd2->PrepareTransform();
				glTranslatef(objSpawnPt.x, objSpawnPt.y, objSpawnPt.z);
				glRotatef(0.0, 0.0, 0.0, 1.0f);
				glRotatef(0.0, 0.0, 1.0f, 0.0);
				glRotatef(0.0, 1.0f, 0.0, 0.0);
				glScalef(addType.size, addType.size, addType.size);
			addMd2->EndTransform();
			addMd2->SaveMatrix(); 
			addMd2->PlayAnimation();
			addMd2->CalcBounds();
			printVector(&(addMd2->GetMaxBounds()), "Max: " );
			printVector(&(addMd2->GetMinBounds()), "Max: " );
			
			LoadedTObjects.push_back(addMd2);
			
			Vector tryVec;
			for(int k = 0; k < ObjectList.size(); k++) { 
				if(ObjectList[k].gamePacket.type == MAIN_RAT_TYPE) { tryVec = ObjectList[k].translate; break; }
			}
			
			if(gameBuildList[i].type <= 10 && gameBuildList[i].type != 3) {
				tryVec.y = getObjectSpawnY( (TObject *)addMd2, 0.2, addType.size);
			}
			else if(gameBuildList[i].type == 3) {
				tryVec.y = getObjectSpawnY( (TObject *)addMd2, 1.0, addType.size);
			}
			else {
				tryVec.y = getObjectSpawnY( (TObject *)addMd2, 40.0, addType.size);
			}
			objSpawnPt = tryToSpawn(tryVec, (TObject *)addMd2, addType.size, -1);
			AttachObject(addMd2, objSpawnPt, scaleVec, rotVec, true, true, true, false, -1, false, 0.0f, gameBuildList[i].type, NULL, FPSGamePacket.team);
			printVector(&objSpawnPt, "Object Spawn Point: " );
			ObjectList[ObjectList.size() - 1].gamePacket.health = addType.health;
			presetObjectSelection();
			string buildText = "You create a " + addType.name + "!";
			statusTextSet((char *)buildText.c_str());
			
			/* begin ugly code */
			switch(gameBuildList[i].type) {
				case 1:
					curInfrastructure->PlaySound(MICE_SQUEAK_SOUND);
				break;
				
				case 2:
					curInfrastructure->PlaySound(MICE_SOUND);
				break;
				case 3:
				break;
				case 4:
					curInfrastructure->PlaySound(SHOTGUN_SOUND);
				break;
				case 5:
					curInfrastructure->PlaySound(UFO_SOUND);
				break;
				case 6:
					curInfrastructure->PlaySound(ROBOT_ARM_SOUND);
				break;
				case 12:
					curInfrastructure->PlaySound(PIGEON_SOUND);
				break;
			}
			/* end ugle code */
		}
		else {
			newBuildList.push_back(gameBuildList[i]);
			buildPics[cnt]->setTexture((char *)(RTStoolBar->getPicFilename(gameBuildList[i].type).c_str()) );
			buildPics[cnt]->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, (float)gameBuildList[i].buildtime / (float)gameBuildList[i].miscBuildTime);
			buildPics[cnt]->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, (float)gameBuildList[i].buildtime / (float)gameBuildList[i].miscBuildTime);
			buildPics[cnt]->setDimensions((i * BUILD_BTN_SIZE * 2) + BUILD_BTN_SIZE * 4, BUILD_BTN_SIZE, BUILD_BTN_SIZE, BUILD_BTN_SIZE);
			cnt++;
			
		}
	}
	
	gameBuildList.clear();
	gameBuildList = newBuildList;
}

list<Vector> TRTS::findRoomPath(Vector start, Vector goal)
{
	return findRoomPath(start, goal, -1);
}

list<Vector> TRTS::findRoomPath(Vector start, Vector goal, int objNum)
{
	list<Vector> retList;
	int curPortal, goalPortal;
	int index;
	
	if(objNum == -1)
		curPortal = findPortal(start);
	else {
		curPortal = ObjectList[objNum].sectorIndex;
		if(!portalObjContains(start, curPortal)) {
			printf("HOLY SHIT~\n");
			curPortal = findPortal(start);
		}
	}
	goalPortal = findPortal(goal);
	
	if(curPortal == goalPortal) {
		retList.push_front(goal);
		return retList;
	}
	
	TPortalPose tmp;
	Vector tmpVect;
	
	Vset(&tmp, start.x, start.y, start.z);
	tmp.portalNum = curPortal;
	tmp.f = tmp.g = tmp.h = 0.0;
	tmp.curIndex = 0; tmp.prevIndex = -1;
	
	portalOpen.push(tmp);
	portalList.push_back(tmp);
	
	while(!portalOpen.empty()) {
		tmp = portalOpen.top();
		portalOpen.pop();
		
		if(inPortalClosedList(tmp)) continue;
		
		portalClosed.push_back(tmp);
		
		Vsub(&goal, &tmp, &tmpVect);
		if(Vlength(&tmpVect) < 0.01) {
			// we found a path...
			index = tmp.curIndex;
			while(index > 0) {
				tmp = portalList[index];
				retList.push_front((Vector)tmp);
				index = tmp.prevIndex;
			}
			break;
		}
		
		generatePortalSuccessors(tmp, goal, goalPortal);
	}
	
	while(!portalOpen.empty())
		portalOpen.pop();
	portalClosed.clear();
	portalList.clear();
	
	return retList;
}

int TRTS::findPortal(Vector pt)
{
	int i, plSize = PortalList.size();
	for(i = 0; i < plSize; i++) {
		if(portalObjContains(pt, i))
			return i;
	}
	return -1;
}

bool TRTS::portalObjContains(Vector pt, int i)
{
	return (pt.x >= PortalList[i].Bound1.x && pt.x <= PortalList[i].Bound2.x &&
		pt.z >= PortalList[i].Bound1.z && pt.z <= PortalList[i].Bound2.z);
}

bool TRTS::inPortalClosedList(TPortalPose p)
{
	int i, pclSize = portalClosed.size();
	for (i = 0; i < pclSize; i++) {
		if(p == portalClosed[i])
			return true;
	}
	return false;
}

void TRTS::generatePortalSuccessors(TPortalPose p, Vector goal, int goalPortal)
{
	TPortalPose newPose;
	Vector tmp;
	Vector newLoc; float length;
	newPose.prevIndex = p.curIndex;
	
	if(p.portalNum == goalPortal) {
		// we've found the right room, now add goal as a node
		Vset(&newPose, goal.x, goal.y, goal.z);
		
		newPose.portalNum = p.portalNum;
		
		Vsub(&newPose, &p, &tmp);
		newPose.f = newPose.g = p.g + Vlength(&tmp);
		newPose.h = 0.0;
		
		newPose.curIndex = portalList.size();
		
		portalOpen.push(newPose);
		portalList.push_back(newPose);
		
		return;
	}
	
	int i, pwlSize = PortalWindowList.size();
	for(i = 0; i < pwlSize; i++) {
		if (PortalWindowList[i].index1 == p.portalNum)
			newPose.portalNum = PortalWindowList[i].index2;
		else if (PortalWindowList[i].index2 == p.portalNum)
			newPose.portalNum = PortalWindowList[i].index1;
		else continue;
		
		Vset(&newLoc, 0.0, 0.0, 0.0);
		Vadd(&newLoc, &PortalWindowList[i].Bounds1, &newLoc);
		Vadd(&newLoc, &PortalWindowList[i].Bounds2, &newLoc);
		newLoc.x /= 2.0; newLoc.y /= 2.0; newLoc.z /= 2.0;
		
		Vset(&newPose, newLoc.x, newLoc.y, newLoc.z);
		
		Vsub(&newPose, &p, &tmp);
		newPose.g = p.g + Vlength(&tmp);
		Vsub(&goal, &newPose, &tmp);
		newPose.h = Vlength(&tmp);
		newPose.f = newPose.g + newPose.h;
		
		newPose.curIndex = portalList.size();
		
		portalOpen.push(newPose);
		portalList.push_back(newPose);
	}
}

/* End Portal Pathfinding Code */

/* Begin Real Pathfinding Code */

list<Vector> TRTS::findPath(int objNum, Vector goal, int portalNum)
{
	return findPath(objNum, goal, portalNum, -1);
}

list<Vector> TRTS::findPath(int objNum, Vector goal, int portalNum, int targetIndex)
{
	list<Vector> retList;
	TMovePose tmp;
	int index;
	
	scaledVertexList = calculateScaledVertices(objNum, portalNum, targetIndex);
	
	// verify that we can move to our goal pt in the first place!
	
	Vset(&tmp, ObjectList[objNum].translate.x, ObjectList[objNum].translate.y, ObjectList[objNum].translate.z);
	tmp.curIndex = 0; tmp.prevIndex = -1;
	tmp.f = tmp.g = tmp.h = 0.0;
	tmp.isGoal = false;
	
	open.push(tmp);
	vertexList.push_back(tmp);
	
	while(!open.empty()) {
		tmp = open.top();
		open.pop();
		
		if(inClosedList(tmp)) continue;
		
		closed.push_back(tmp);
		
		if(tmp.isGoal) {
			index = tmp.curIndex;
			while(index > 0) {
				tmp = vertexList[index];
				retList.push_front((Vector)tmp);
				index = tmp.prevIndex;
			}
			break;
		}
		
		generateNodeSuccessors(tmp, objNum, goal, portalNum);
	}
	
	// do cleanup...
	while(!open.empty())
		open.pop();
	closed.clear();
	vertexList.clear();
	
	if(!(PATHFIND_DEBUG)) {
		int i, svlSize = scaledVertexList.size();
		for(i = 0; i < svlSize; i++) {
			if(scaledVertexList[i] != NULL)
				delete[] scaledVertexList[i];
		}
		scaledVertexList.clear();
	}
	
	return retList;
}

vector<Vector *> TRTS::calculateScaledVertices(int objNum, int portalNum, int targetNum)
{
	vector<Vector *> retVec;
	
	int gtIndex;
	float scaleFactor;
	float matrix[16];
	
	Vector scaleVector;
	Vset(&scaleVector, 1.0, 1.0, 1.0);
		
	if(ObjectList[objNum].curObject->GetType() == MD2_TYPE) {
		if (ObjectList[objNum].gamePacket.type == -1) {
			scaleVector = ObjectList[objNum].scale;
		} else {
			gtIndex = getGameTypeIndex(ObjectList[objNum].gamePacket.type);
			scaleFactor = gameObjectTypeList[gtIndex].size;
			Vset(&scaleVector, scaleFactor, scaleFactor, scaleFactor);
		}
	}
	
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
		glLoadIdentity();
		glScalef(scaleVector.x, scaleVector.y, scaleVector.z);
		glGetFloatv(GL_MODELVIEW_MATRIX, matrix);
	glPopMatrix();
	
	Vector min, max;
	Vector tmp;
	float objectWidth;
	
	max = ObjectList[objNum].curObject->GetMaxOrgBounds();
	min = ObjectList[objNum].curObject->GetMinOrgBounds();
	
	transformVector(&tmp, &max, matrix);
	max = tmp;
	transformVector(&tmp, &min, matrix);
	min = tmp;
	
	objectWidth = max.x - min.x + 1.0;
	
	Vector *scaledVertices;
	TPlane *tmpPlane;
	
	int i, olSize = ObjectList.size();
	for(i = 0; i < olSize; i++) {
		if(i == objNum) {
			retVec.push_back(NULL);
			continue;
		}
		if(i == targetNum) {
			retVec.push_back(NULL);
			continue;
		}
		if(ObjectList[i].sectorIndex != portalNum) {
			retVec.push_back(NULL);
			continue;
		}
		
		if(ObjectList[i].gamePacket.type >= 50 && ObjectList[i].gamePacket.type != PLAYER_TYPE
			&& ObjectList[i].gamePacket.type != GAME_PILLAR_TYPE) {
			retVec.push_back(NULL);
			continue;
		}
		if(ObjectList[i].curObject->GetType() == PLANE_TYPE) {
			tmpPlane = (TPlane *)(ObjectList[i].curObject);
			tmp = tmpPlane->GetNormal();
			if(fabs(tmp.y) >= 0.999) {
				retVec.push_back(NULL);
				continue;
			}
		}
		
		// actually create scaled vertices
		
		Vset(&scaleVector, 1.0, 1.0, 1.0);
		
		if(ObjectList[i].curObject->GetType() == MD2_TYPE) {
			if(ObjectList[i].gamePacket.type == -1) {
				scaleVector = ObjectList[i].scale;
			} else {
				gtIndex = getGameTypeIndex(ObjectList[i].gamePacket.type);
				scaleFactor = gameObjectTypeList[gtIndex].size;
				Vset(&scaleVector, scaleFactor, scaleFactor, scaleFactor);
			}
		}
		
		scaledVertices = new Vector[4];
		
		scaledVertices[0] = *(ObjectList[i].curObject->GetBounds1());
		scaledVertices[1] = *(ObjectList[i].curObject->GetBounds3());
		scaledVertices[2] = *(ObjectList[i].curObject->GetBounds4());
		scaledVertices[3] = *(ObjectList[i].curObject->GetBounds5());
		
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
			glLoadIdentity();
			glScalef(scaleVector.x, scaleVector.y, scaleVector.z);
			glGetFloatv(GL_MODELVIEW_MATRIX, matrix);
		glPopMatrix();
		
		int j;
		for(j = 0; j < 4; j++) {
			transformVector(&tmp, &scaledVertices[j], matrix);
			scaledVertices[j] = tmp;
		}
		
		scaledVertices[0].x -= objectWidth;
		scaledVertices[0].z -= objectWidth;
		
		scaledVertices[1].x += objectWidth;
		scaledVertices[1].z -= objectWidth;
		
		scaledVertices[2].x += objectWidth;
		scaledVertices[2].z += objectWidth;
		
		scaledVertices[3].x -= objectWidth;
		scaledVertices[3].z += objectWidth;
		
		if(ObjectList[i].curObject->GetType() == MD2_TYPE) {
			glMatrixMode(GL_MODELVIEW);
			glPushMatrix();
				glLoadIdentity();
				glRotatef(ObjectList[i].rotate.x, 1.0, 0.0, 0.0);
				glRotatef(ObjectList[i].rotate.y, 0.0, 1.0, 0.0);
				glRotatef(ObjectList[i].rotate.z, 0.0, 0.0, 1.0);
				glGetFloatv(GL_MODELVIEW_MATRIX, matrix);
			glPopMatrix();
			
			for(j = 0; j < 4; j++) {
				transformVector(&tmp, &scaledVertices[j], matrix);
				scaledVertices[j] = tmp;
				Vadd(&scaledVertices[j], &ObjectList[i].translate, &scaledVertices[j]);
				scaledVertices[j].y = ObjectList[objNum].translate.y;
			}
		}
		
		retVec.push_back(scaledVertices);
	}
	
	return retVec;
}

bool TRTS::inClosedList(TMovePose p)
{
	int i, clSize = closed.size();
	for(i = 0; i < clSize; i++) {
		if(p == closed[i])
			return true;
	}
	return false;
}

void TRTS::generateNodeSuccessors(TMovePose p, int objNum, Vector goal, int portalNum)
{
	if(!pathIntersects(p, goal, objNum)) {
		addNewNode(p, goal, goal);
	}
	
	int i, j, olSize = ObjectList.size();
	for(i = 0; i < olSize; i++) {
		if(scaledVertexList[i] == NULL)
			continue;
		
		for(j = 0; j < 4; j++) {
			if(!portalObjContains(scaledVertexList[i][j], portalNum))
				continue;
			
			if(!pathIntersects(p, scaledVertexList[i][j], objNum)) {
				addNewNode(p, scaledVertexList[i][j], goal);
			}
		}
	}
}

bool TRTS::pathIntersects(Vector start, Vector goal, int objNum)
{
	int gtIndex;
	float scaleFactor;
	float matrix[16];
	
	Vector scaleVector;
	Vset(&scaleVector, 1.0, 1.0, 1.0);
		
	if(ObjectList[objNum].curObject->GetType() == MD2_TYPE) {
		if (ObjectList[objNum].gamePacket.type == -1) {
			scaleVector = ObjectList[objNum].scale;
		} else {
			gtIndex = getGameTypeIndex(ObjectList[objNum].gamePacket.type);
			scaleFactor = gameObjectTypeList[gtIndex].size;
			Vset(&scaleVector, scaleFactor, scaleFactor, scaleFactor);
		}
	}
	
	Vector goalDir;
	Vsub(&goal, &start, &goalDir);
	goalDir.y = 0;
	float theta = findTheta(goalDir);
	
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
		glLoadIdentity();
		glTranslatef(start.x, start.y, start.z);
		glRotatef(theta, 0.0, 1.0f, 0.0);
		glScalef(scaleVector.x, scaleVector.y, scaleVector.z);
		glGetFloatv(GL_MODELVIEW_MATRIX, matrix);
	glPopMatrix();
	
	Vector bounds[8];
	
	bounds[0] = *(ObjectList[objNum].curObject->GetBounds1());
	bounds[1] = *(ObjectList[objNum].curObject->GetBounds2());
	bounds[2] = *(ObjectList[objNum].curObject->GetBounds3());
	bounds[3] = *(ObjectList[objNum].curObject->GetBounds4());
	bounds[4] = *(ObjectList[objNum].curObject->GetBounds5());
	bounds[5] = *(ObjectList[objNum].curObject->GetBounds6());
	bounds[6] = *(ObjectList[objNum].curObject->GetBounds7());
	bounds[7] = *(ObjectList[objNum].curObject->GetBounds8());
	
	int i;
	Vector tmp;
	for(i = 0; i < 8; i++) {
		transformVector(&tmp, &bounds[i], matrix);
		bounds[i] = tmp;
	}
	
	Vadd(&bounds[1], &goalDir, &bounds[1]);
	Vadd(&bounds[3], &goalDir, &bounds[3]);
	Vadd(&bounds[4], &goalDir, &bounds[4]);
	Vadd(&bounds[6], &goalDir, &bounds[6]);
	
	dummyObj->SetDstBounds1(bounds[0].x, bounds[0].y, bounds[0].z);
	dummyObj->SetDstBounds2(bounds[1].x, bounds[1].y, bounds[1].z);
	dummyObj->SetDstBounds3(bounds[2].x, bounds[2].y, bounds[2].z);
	dummyObj->SetDstBounds4(bounds[3].x, bounds[3].y, bounds[3].z);
	dummyObj->SetDstBounds5(bounds[4].x, bounds[4].y, bounds[4].z);
	dummyObj->SetDstBounds6(bounds[5].x, bounds[5].y, bounds[5].z);
	dummyObj->SetDstBounds7(bounds[6].x, bounds[6].y, bounds[6].z);
	dummyObj->SetDstBounds8(bounds[7].x, bounds[7].y, bounds[7].z);
	
	int olSize = ObjectList.size();
	for(i = 0; i < olSize; i++) {
		if(scaledVertexList[i] == NULL)
			continue;
		
		if(OBBIntersect(dummyObj, ObjectList[i].curObject))
			return true;
	}
	
	return false;
}

float TRTS::findTheta(Vector dir)
{
	Vector init;
	float theta;
	
	init.x = 0.0;
	init.y = 0.0;
	init.z = 1.0;
	
	dir.y = 0.0;
	Vnormal(&dir);
	
	theta = acos(Vdot(&init, &dir))  * 180.0 / MATH_PI;
	
	if(dir.x < 0.0)
		theta = -theta;
	
	return theta;
}

void TRTS::addNewNode(TMovePose p, Vector newLoc, Vector goal)
{
	TMovePose newPose;
	Vset(&newPose, newLoc.x, newLoc.y, newLoc.z);
	
	Vector tmp;
	Vsub(&newLoc, &goal, &tmp);
	newPose.isGoal = (Vlength(&tmp) < .01);
	
	Vsub(&newLoc, &p, &tmp);
	newPose.g = p.g + Vlength(&tmp);
	
	Vsub(&goal, &newLoc, &tmp);
	newPose.h = Vlength(&tmp);
	
	newPose.f = newPose.g + newPose.h;
	
	newPose.prevIndex = p.curIndex;
	newPose.curIndex = vertexList.size();
	
	if(inClosedList(newPose))
		return;
	
	open.push(newPose);
	vertexList.push_back(newPose);
}

void TRTS::prepareMultiplayerMode() {
	TNetwork *curNetwork = curInfrastructure->getNetwork();

	if(multiPlayerMode == SERVER_RTS_MODE) { //add in the 3D model of the FPS player
		FPSGamePacket.team = 1;
		Vector rotVec, scaleVec;
		GameType addType = GetUnitInfo(PLAYER_TYPE);
		Vset(&rotVec, 0.0, 0.0, 0.0); Vset(&scaleVec, addType.size, addType.size, addType.size);
		TMd2 *addMd2 = new TMd2(curInfrastructure);
		addMd2->Copy(*(LoadedMd2( (char *)(addType.md2_Filename.c_str() ) )));
		addMd2->PrepareTransform();
			glTranslatef(0.0, 0.0, 0.0);
			glRotatef(0.0, 0.0, 0.0, 1.0f);
			glRotatef(0.0, 0.0, 1.0f, 0.0);
			glRotatef(0.0, 1.0f, 0.0, 0.0);
			glScalef(addType.size, addType.size, addType.size);
		addMd2->EndTransform();
		addMd2->SaveMatrix(); 
		addMd2->PlayAnimation();
		addMd2->CalcBounds();
			
		LoadedTObjects.push_back(addMd2);
		setSpawnPt(0.0, 0.0, 0.0);
		AttachObject(addMd2, spawnPt, scaleVec, rotVec, true, true, true, false, -1, false, 0.0f, PLAYER_TYPE, NULL, FPSGamePacket.team);
		ObjectList[ObjectList.size() - 1].gamePacket.health = 100;
//		viewXDisp = spawnPt.x; viewYDisp = spawnPt.y; viewZDisp = spawnPt.z;
		presetObjectSelection();
		addMainRat();
	}
	spawnPt.y = getMinSpawnY();

	cout << "Server Done initialzing objects for multiplayer mode!" << endl;
	curNetwork->setNetworkParam(&multiPlayerCallBack, (void *)this);
}

void TRTS::endMultiplayerMode() {
	TNetwork *curNetwork = curInfrastructure->getNetwork();
	curNetwork->setNetworkParam(NULL, NULL);
}


void TRTS::sendServerRTSinfo() {
	if( (curInfrastructure->timerDelay2(70)) == false || frame == -1) return;
	TNetwork *curNetwork = curInfrastructure->getNetwork();
	//count number of sendable objects
	int sendCnt = 0;
	for(int i = 0; i < ObjectList.size(); i++) {
		if(ObjectList[i].gamePacket.team > 0) { //we should send these objects
			sendCnt++;
		}
	}
	
	//send list
	if(getGameEnd() != 0) {
		if(getGameEnd() == 1) {
			curNetwork->sendObjectList(sendCnt, frame, HUMAN_WINS, 0);
		}
		else if(getGameEnd() == 2) {
			curNetwork->sendObjectList(sendCnt, frame, MOUSE_WINS, 0);
		}
	}
	else curNetwork->sendObjectList(sendCnt, frame, curSituation, 0);
	if(curSituation != 0 && frame % 10 == 0) curSituation = 0;
	
	//send the bloody objects
	for(i = 0; i < ObjectList.size(); i++) {
		if(ObjectList[i].gamePacket.team > 0) { //we should send these objects
			TMd2 *curMd2 = (TMd2 *)ObjectList[i].curObject;
			GamerPacket curInfo = ObjectList[i].gamePacket;
			int curSelected = 0;
			int curAction = 0;
			for(int k = 0; k < selectList.size(); k++) { if(selectList[k] == i) curSelected = 1; break; }
			
			curNetwork->sendObjectPacket(curInfo.type, curInfo.team, curSelected, curInfo.health, FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type,
						FPSGamePacket.weapons[FPSGamePacket.weaponSelect].ammo, curMd2->GetAnimationIndex(),
						frame, ObjectList[i].translate, ObjectList[i].rotate, i);
		}
	}
	
	if(multiPlayerMode == SERVER_FPS_MODE) { //we have to send FPS player info over as well ! {
		curNetwork->sendObjectPacket(PLAYER_TYPE, FPSGamePacket.team, 0, FPSGamePacket.health, FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type,
					FPSGamePacket.weapons[FPSGamePacket.weaponSelect].ammo, MOVE_ANIMATE,
					frame, ObjectList[i].translate, ObjectList[i].rotate, -1);
	}
	
}

void TRTS::RTSserverProcessRTSinput(TNetworkPlayerInputPacket inputPacket) {
	
}

void TRTS::RTSserverProcessFPSinput(TNetworkPlayerInputPacket inputPacket) {
	GLfloat curMat[16];
	playerProcessInput = inputPacket;
}

void TRTS::RTSserverProcessFPSinputFrame() {
	if(LightList[weaponLightID].brightness > 0.0) LightList[weaponLightID].brightness = LightList[weaponLightID].brightness - 5.0;
	if(LightList[weaponLightID].brightness < 0.0) LightList[weaponLightID].brightness = 0.0;
		
	for(int i = 0; i < ObjectList.size(); i++) {
		if(ObjectList[i].gamePacket.type == PLAYER_TYPE) {
			Vector curMoveVec;
			curMoveVec = playerProcessInput.playerLoc;
			if( (playerProcessInput.press_a || playerProcessInput.press_d || playerProcessInput.press_w || 
				playerProcessInput.press_s || playerProcessInput.press_space) && ObjectList[i].gamePacket.health > 0) {
				TMd2 *curMd2 = (TMd2 *)ObjectList[i].curObject;
				if(curMd2->GetAnimationIndex() != MOVE_ANIMATE) {
					curMd2->SetCurrentAnimation(MOVE_ANIMATE, ANIMATE_SMOOTHNESS);
					curMd2->SetAnimationCycle(true);
				}
			}
			
			if(playerProcessInput.press_1) {
				FPSGamePacket.weaponSelect = MELEE_SELECT;
			}
			else if(playerProcessInput.press_2) {
				FPSGamePacket.weaponSelect = SECONDARY_SELECT;
			}
			else if(playerProcessInput.press_3) {
				FPSGamePacket.weaponSelect = PRIMARY_SELECT;
			}
			
			if((!playerProcessInput.press_a && !playerProcessInput.press_d && !playerProcessInput.press_w && 
				!playerProcessInput.press_s && !playerProcessInput.press_space)  && ObjectList[i].gamePacket.health > 0) {
				TMd2 *curMd2 = (TMd2 *)ObjectList[i].curObject;
				if(curMd2->GetAnimationIndex() != IDLE_ANIMATE) {
					curMd2->SetCurrentAnimation(IDLE_ANIMATE, ANIMATE_SMOOTHNESS);
					curMd2->SetAnimationCycle(true);
				}
				
			}
			
			if(playerProcessInput.mouseLeftPress == true  && ObjectList[i].gamePacket.health > 0) { //try to shoot something
				playerProcessInput.mouseLeftPress = false;
				if(weaponLightID == -1) {
					Vector emptyLight;
					Vset(&emptyLight, 0.0, 0.0, 0.0);
					weaponLightID = AddLight(emptyLight, emptyLight, 0.0, 0.0, 0.0, 0.0, 0);
					weaponLightBrightness = 150.0;
					weaponLightR = 1.0;
					weaponLightG = 0.0;
					weaponLightB = 0.5;
				}
				if(FPSGamePacket.weaponSelect == SECONDARY_SELECT || FPSGamePacket.weaponSelect == PRIMARY_SELECT ||FPSGamePacket.weaponSelect == MELEE_SELECT) {
					if(FPSGamePacket.weapons[FPSGamePacket.weaponSelect].ammo > 0 || FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type == MELEE_TYPE) {
						Vector startVec = curMoveVec, workVec;
						Vector shootVec = GetViewerMoveDelta(0.0, 0.0, -1.0f, 
									180.0 -playerProcessInput.playerRotateX, 180.0 -playerProcessInput.playerRotateY, 0.0f);
						shootVec.x = -shootVec.x;
						Vnormal(&shootVec);
						workVec = shootVec;
						Vscale(&shootVec, 7.0);
						Vscale(&workVec, 27.0);
						
						Vadd(&curMoveVec, &workVec, &startVec);
						Vector ammoRotLoc;
						Vset(&ammoRotLoc, playerProcessInput.playerRotateX, playerProcessInput.playerRotateY, 0.0);
						
						
						if(FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type == MELEE_TYPE ||  FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type == FLAME_TYPE) {
							timeShot = -1;
						}
						else if(FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type == EXPLOSIVE_TYPE) {
							if(timeShot == -1) {
								timeShot = SDL_GetTicks();
							}
							int curTime = SDL_GetTicks();
							int diff = curTime - timeShot;
		
							if(diff > 100) timeShot = -1;
						}
						
						if(timeShot == -1) {
							shootAmmo(FPS_PLAYER, FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type, 
								shootVec, startVec, &ammoRotLoc,  ObjectList[i].sectorIndex);
							FPSGamePacket.weapons[FPSGamePacket.weaponSelect].ammo--;
						}
						
					}
				} 
			}
			
			ObjectList[i].translate = curMoveVec;			
			ObjectList[i].rotate.y = playerProcessInput.playerRotateY + playerRotateOffset.y;
			
			break;
		}
	}
}

void TRTS::FPSserverProcessRTSinput(TNetworkPlayerInputPacket inputPacket) {
	
}

void TRTS::FPSserverProcessFPSinput(TNetworkPlayerInputPacket inputPacket) {
	
}

void TRTS::RTSclientProcess(void *data) {
}

void TRTS::FPSclientProcess(void *data) {
	TNetwork *curNetwork = curInfrastructure->getNetwork();
	int packetType = curNetwork->getPacketType(data);
	if(packetType == OBJECT_LIST_PACKET) {
		TNetworkObjectListPacket recvListPacket;
		curNetwork->getObjectListPacket(data, &recvListPacket);
		syncData.addObjectList(&recvListPacket);
		
	}
	else if(packetType == OBJECT_PACKET) {
		TNetworkObjectPacket recvPacket;
		curNetwork->getObjectPacket(data, &recvPacket);
		syncData.addObject(&recvPacket);
	}
	else if(packetType == PARTICLE_PACKET) {
		TNeworkParticlePacket recvPacket;
		curNetwork->getParticlePacket(data, &recvPacket);
		Vector shootVec, startVec, rotVec;
		Vset(&shootVec, recvPacket.velX, recvPacket.velY, recvPacket.velZ); 
		Vset(&startVec, recvPacket.x, recvPacket.y, recvPacket.z); 
		Vset(&rotVec, 0.0, 0.0, 0.0);
		shootAmmo(recvPacket.index - 1, recvPacket.type, shootVec, startVec, &rotVec,  -1);
	}
	
	
}

//synchronizes network data with client data
void TRTS::syncToNetwork() {
	int playerIndex = 0;
	vector<TNetworkObjectPacket> curObjs = syncData.getNetworkObjs();
	if(syncData.dataChanged() ) {
		syncData.updateLock();
		
		TNetworkObjectListPacket curObjList = syncData.getNetworkList();
		if(curObjList.situation == FLAME_PICK_SIT) { statusTextSet("You pick up a FlameThrower!"); cout << "Pick up FlameThrower" << endl;}
		else if(curObjList.situation == CROSSBOW_PICK_SIT) { statusTextSet("You pick up a Crossbow!"); cout << "Pick up CrossBow" << endl;}
		else if(curObjList.situation == SHIELD_HEALTH_PICK_SIT) { statusTextSet("You pick up a Health Shield!"); cout << "Pick up Health Shield" << endl;}
		else if(curObjList.situation == SHIELD_QUAD_DAMAGE_PICK_SIT) { statusTextSet("You pick up a Mega Health Enhancer!"); cout << "Pick up Mega Health Enhancer" << endl;}
		else if(curObjList.situation == MOUSE_WINS) gameScore.side2_score = 100;
		else if(curObjList.situation == HUMAN_WINS) gameScore.side1_score = 100;
		
		//first check for any difference in units
		int unitCnt = 0, unitCnt2 = 0;
		bool changed = false;
		for(int i = 0; i < curObjs.size(); i++) {
			int obIndex = 0;
			if(multiPlayerMode == CLIENT_RTS_MODE) {
				obIndex = curObjs[i].index;
			}
			else {
				if(curObjs[i].type < 50) {
					obIndex = curObjs[i].index - 1;
				}
				else  { obIndex = curObjs[i].index; continue; }
			}
			
			if(obIndex == -1) continue;
			if(curObjs[i].type != PLAYER_TYPE) {
				unitCnt++;
				if(obIndex <= (ObjectList.size() - 1)) {
					if(ObjectList[obIndex].gamePacket.team != curObjs[i].team) { changed = true; break; }
					if(ObjectList[obIndex].gamePacket.type != curObjs[i].type) { changed = true; break; }
				}
			}
		}
		
		cout << "Matched? " << changed << endl;
		
		for(i = 0; i < ObjectList.size(); i++) { if(ObjectList[i].gamePacket.team != -1 && ObjectList[i].gamePacket.type != PLAYER_TYPE 
							&& ObjectList[i].gamePacket.type < 50) unitCnt2++; }
		if(unitCnt2 != unitCnt) changed = true;
		cout << "Matched? " << changed << endl;
		cout << "Trying to sync" << endl;
		
		vector<SceneObjInfo> newList;
		if(changed) { // we need to update ObjectList
			for(i = 0; i < ObjectList.size(); i++) {
				if(ObjectList[i].gamePacket.team <= 0 || ObjectList[i].gamePacket.type >= 50) newList.push_back(ObjectList[i]);
				else { //free memory for md2
					TMd2 *curMd2 = (TMd2 *)LoadedTObjects[ObjectList[i].loadedTObjIndex];
					delete curMd2;
					LoadedTObjects[ObjectList[i].loadedTObjIndex] = NULL;
				} 
			} 
			
			ObjectList.clear();
			ObjectList = newList;
			
			//now push back into the array the new objects
			for(i = 0; i < curObjs.size(); i++) {
				Vector rotVec, scaleVec;
				if(curObjs[i].type == PLAYER_TYPE && (multiPlayerMode == SERVER_RTS_MODE || multiPlayerMode == CLIENT_RTS_MODE) ) {
				}
				else if( (curObjs[i].type == PLAYER_TYPE || curObjs[i].type >= 50)
					&& (multiPlayerMode == SERVER_FPS_MODE || multiPlayerMode == CLIENT_FPS_MODE) ) {
					continue;
				}
				
				GameType addType = GetUnitInfo(curObjs[i].type);
				Vset(&rotVec, 0.0, curObjs[i].rotateY, 0.0); Vset(&scaleVec, addType.size, addType.size, addType.size);
				TMd2 *addMd2 = new TMd2(curInfrastructure);
				addMd2->Copy(*(LoadedMd2( (char *)(addType.md2_Filename.c_str() ) )));
					addMd2->PrepareTransform();
					glTranslatef(curObjs[i].translate.x, curObjs[i].translate.y, curObjs[i].translate.z);
					glRotatef(0.0, 0.0, 0.0, 1.0f);
					glRotatef(0.0, 0.0, 1.0f, 0.0);
					glRotatef(0.0, 1.0f, 0.0, 0.0);
					glScalef(addType.size, addType.size, addType.size);
				addMd2->EndTransform();
				addMd2->SaveMatrix(); 
				addMd2->SetCurrentAnimation(IDLE_ANIMATE, ANIMATE_SMOOTHNESS);
				addMd2->PlayAnimation();
				addMd2->CalcBounds();
			
				LoadedTObjects.push_back(addMd2);
				int shadowType = true;
				if(curObjs[i].type == MAIN_RAT_TYPE) shadowType = GLOW_TRUE;
				AttachObject(addMd2, curObjs[i].translate, scaleVec, rotVec, shadowType, true, true, false, -1, false, 0.0f, 
							curObjs[i].type, NULL, curObjs[i].team);
				
			} 
		syncData.updateUnLock();
			
		}
		else { //just update coordinates and other properties
			int cIndex = 0;
			for(i = 0; i < curObjs.size(); i++) {
				if(curObjs[i].type < 50) {
					cIndex = curObjs[i].index - 1;
				}
				else {
					cIndex = curObjs[i].index;
				}
				
				if(cIndex == -1) continue;
				
				if(curObjs[i].type == PLAYER_TYPE) {
					if(multiPlayerMode == CLIENT_FPS_MODE || multiPlayerMode == SERVER_FPS_MODE) {
						FPSGamePacket.weapons[FPSGamePacket.weaponSelect].ammo = curObjs[i].ammo;
						if(curObjs[i].health < 0) {
							FPSGamePacket.health = 0;
							statusTextSet("You have just been killed!");
							SetViewerBounds(0.2, 0.2, 0.2);
							UpdateViewerBounds();
						}
						else {
							SetBlurSwitch(false);
							if(FPSGamePacket.health <= 0) {
								statusTextSet("You have just been respawned!");
								curInfrastructure->PlaySound(DRUMS_SOUND);
								SetViewerBounds(VIEWER_WIDTH_X, VIEWER_WIDTH_Y, VIEWER_WIDTH_Z);
								Vector tryVec = mustSpawnRandom((TObject *)ObjectList[cIndex].curObject, 1.0, cIndex);
								tryVec.y = 0.0;
								viewerLoc = tryVec;
								viewerPhysics.loc = viewerLoc;
								viewerPhysics.vel.x = viewerPhysics.vel.y = viewerPhysics.vel.z = 0.0;
								MoveFPSViewerDelta(viewerPhysics.vel.x, 35.0, viewerPhysics.vel.z, 
									viewerPhysics.angle.x, viewerPhysics.angle.y, viewerPhysics.angle.z);
								UpdateViewerBounds();
								cout << "Setting viewer bounds" << endl;
							}
							else if(FPSGamePacket.health > 0 && FPSGamePacket.health <= 20) {
								SetBlurSwitch(true);
							}
							FPSGamePacket.health = curObjs[i].health;
						}
					}
				}
				else {
					ObjectList[cIndex].translate = curObjs[i].translate;
					if(curObjs[i].type < 50) ObjectList[cIndex].rotate.y = curObjs[i].rotateY;
					TMd2 *curMd2 = (TMd2 *)ObjectList[cIndex].curObject;
					if(curMd2->GetAnimationIndex() != curObjs[i].action && curObjs[i].action < 4 && curObjs[i].type < 50) {
						curMd2->SetCurrentAnimation(curObjs[i].action, ANIMATE_SMOOTHNESS);
						if(curObjs[i].health <= 0) curMd2->SetAnimationCycle(false);
						else curMd2->SetAnimationCycle(true);
					}
					
				}
			}
			
		}
		
		frame = syncData.getNetworkList().frame;
	}
	cout << "Exiting syncData stuff" << endl;
}



void TRTS::runMultiplayerMode(void *data, int size) {
	TNetwork *curNetwork = curInfrastructure->getNetwork();
	int packetType = 0;
	if(multiPlayerMode == SERVER_RTS_MODE || multiPlayerMode == SERVER_FPS_MODE) {
		if(frame == -1) { //wait for first player input packets
			cout << "Still waiting for other player to join!" << endl;
			if(size > 0) {
				packetType = curNetwork->getPacketType(data);
				if(packetType == PLAYER_INPUT_PACKET) { //we can now officially start the game!
					frame = 1;
					cout << "Game Started!" << endl;
				}
			}
		}
		else { //game started, do processing
			if(multiPlayerMode == SERVER_RTS_MODE) {
				if(size > 0) {
					packetType = curNetwork->getPacketType(data);
					if(packetType == PLAYER_INPUT_PACKET) {
						TNetworkPlayerInputPacket inputPacket;
						curNetwork->getPlayerInputPacket(data, &inputPacket);
						if(inputPacket.mode == (char)CLIENT_RTS_MODE) {
						}
						else if(inputPacket.mode == (char)CLIENT_FPS_MODE) {
							RTSserverProcessFPSinput(inputPacket);
						}
					}
				}
			}
			else if(multiPlayerMode == SERVER_FPS_MODE) {
			}
			
//			if( (curInfrastructure->timerDelay2(80)) == true) sendServerRTSinfo();
		}
	}
	
	else if(multiPlayerMode == CLIENT_RTS_MODE || multiPlayerMode == CLIENT_FPS_MODE) {
		if(multiPlayerMode == CLIENT_FPS_MODE) {
			if(size > 0) FPSclientProcess(data);
		}
		else if(multiPlayerMode == CLIENT_RTS_MODE) {
		}
	}
}

void TRTS::clientFPSkeyDown(Uint16 key) {
	if(key == leftBind) {
		multiPlayerClient_Input.press_a = 1;
	}
	else if(key == rightBind) {
		multiPlayerClient_Input.press_d = 1;
	}
	else if(key == forwardBind) {
		multiPlayerClient_Input.press_w = 1;
	}
	else if(key == backwardsBind) {
		multiPlayerClient_Input.press_s = 1;
	}
	else if(key == jumpBind) {
		multiPlayerClient_Input.press_space = 1;
	}
	else if(key == SDLK_1) {
		multiPlayerClient_Input.press_1 = 1;
		multiPlayerClient_Input.press_2 = false;
		multiPlayerClient_Input.press_3 = false;
	}
	else if(key == SDLK_2) {
		multiPlayerClient_Input.press_1 = false;
		multiPlayerClient_Input.press_2 = 1;
		multiPlayerClient_Input.press_3 = false;
	}
	else if(key == SDLK_3) {
		multiPlayerClient_Input.press_1 = false;
		multiPlayerClient_Input.press_2 = false;
		multiPlayerClient_Input.press_3 = 1;
	}
	
}

void TRTS::clientFPSkeyUp(Uint16 key) {
	if(key == leftBind) {
		multiPlayerClient_Input.press_a = false;
	}
	else if(key == rightBind) {
		multiPlayerClient_Input.press_d = false;
	}
	else if(key == forwardBind) {
		multiPlayerClient_Input.press_w = false;
	}
	else if(key == backwardsBind) {
		multiPlayerClient_Input.press_s = false;
	}
	else if(key == jumpBind) {
		multiPlayerClient_Input.press_space = false;
	}
	
}

void TRTS::clientFPSmouseInput(float xDelta, float yDelta, int mouseX, int mouseY, int leftPress, int rightPress) {
	multiPlayerClient_Input.mouseX = xDelta;
	multiPlayerClient_Input.mouseY = yDelta;
	multiPlayerClient_Input.mouseLeftPress = leftPress;
	multiPlayerClient_Input.mouseRightPress = rightPress;
}

void TRTS::sendClientFPSinput() {
	if(FPSGamePacket.health <= 0) return;
	if( (curInfrastructure->timerDelay2(20)) == false) return;
	Vector playerLoc, playerRotate;
	Vset(&playerLoc, viewerLoc.x, viewerLoc.y, viewerLoc.z);
	Vset(&playerRotate, viewAngleX, viewAngleY, 0.0);
	TNetwork *curNetwork = curInfrastructure->getNetwork();
	curNetwork->sendPlayerInputPacket(multiPlayerClient_Input.press_1, multiPlayerClient_Input.press_2, multiPlayerClient_Input.press_3,
				multiPlayerClient_Input.press_w, multiPlayerClient_Input.press_s, multiPlayerClient_Input.press_a,
				multiPlayerClient_Input.press_d, multiPlayerClient_Input.press_space, multiPlayerClient_Input.mouseX,
				multiPlayerClient_Input.mouseY, multiPlayerClient_Input.mouseLeftPress, multiPlayerClient_Input.mouseRightPress,
				multiPlayerMode, playerLoc, playerRotate);
	
	if(multiPlayerClient_Input.mouseX != 0) multiPlayerClient_Input.mouseX = 0;
	if(multiPlayerClient_Input.mouseY != 0) multiPlayerClient_Input.mouseY = 0;
}


void TRTS::simulateItemPickUp(){
	//first see if there is a human player in this mode
	bool playerYes = false;
	int playerIndex = -1;
	
	for(int i = 0; i < ObjectList.size(); i++) {
		if(ObjectList[i].gamePacket.type == PLAYER_TYPE){ playerYes = true; playerIndex = i; break; }
	}
	
	if(playerYes) {
		for(i = 0; i < ObjectList.size(); i++) {
			if(ObjectList[i].gamePacket.type >= 50 && i != playerIndex && ObjectList[i].gamePacket.type != GAME_PILLAR_TYPE) {
				if(OBBIntersect(ObjectList[playerIndex].curObject, ObjectList[i].curObject)) {
					cout << "Picking up Item!" << endl;
					
					switch(ObjectList[i].gamePacket.type) {
						case MELEE_TYPE:
						break;
						
						case EXPLOSIVE_TYPE:
							FPSGamePacket.weapons[1].ammo = 30;
							curSituation = CROSSBOW_PICK_SIT;
							
						break;
						
						case FLAME_TYPE:
							FPSGamePacket.weapons[2].ammo = 100;
							curSituation = FLAME_PICK_SIT;
						break;
					
						case SHIELD_HEALTH_TYPE:
							curSituation = SHIELD_HEALTH_PICK_SIT;
							ObjectList[playerIndex].gamePacket.health = ObjectList[playerIndex].gamePacket.health + 10;
						break;
					
						case SHIELD_QUAD_DAMAGE_TYPE:
							curSituation = SHIELD_QUAD_DAMAGE_PICK_SIT;
							ObjectList[playerIndex].gamePacket.health = ObjectList[playerIndex].gamePacket.health + 100;
						break;
					}
					
					Vset(&ObjectList[i].translate, OUT_OF_RANGE, OUT_OF_RANGE, OUT_OF_RANGE);
					break;
				}
			}
		}
	}
	else {
		
	}
}


void TRTS::renderStatusBars() {
	GLint viewport[4];
	GLdouble modelMatrix[16];
	GLdouble projMatrix[16];
	
	glGetIntegerv(GL_VIEWPORT, viewport);
	glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();
		glGetDoublev(GL_MODELVIEW_MATRIX, modelMatrix);
		glGetDoublev(GL_PROJECTION_MATRIX, projMatrix);
	glPopMatrix();
	
	glMatrixMode( GL_PROJECTION );
		glPushMatrix();
		glLoadIdentity();
		glOrtho(0, curInfrastructure->GetWinWidth(), 0, curInfrastructure->GetWinHeight(), -1, 1);
	
	glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();
		glTranslated(0, 0, 0);

	glActiveTextureARB( GL_TEXTURE1_ARB );
	glDisable( GL_TEXTURE_CUBE_MAP_ARB );
	glDisable( GL_TEXTURE_2D );

	glActiveTextureARB( GL_TEXTURE0_ARB );
	glDisable( GL_TEXTURE_CUBE_MAP_ARB );

	glDisable(GL_REGISTER_COMBINERS_NV);
	glDisable(GL_TEXTURE_2D);
	glDepthFunc(GL_LEQUAL);

	glDisable(GL_LIGHTING);
	
	glDisable(GL_STENCIL_TEST);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(GL_FALSE);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_COLOR);
	glDisable(GL_CULL_FACE );
	
	GLdouble pixelOffsetY = 50.0;
	GLdouble rectFullWidth = 60.0;
	GLdouble rectFullHeight = 5.0;
	GLdouble borderWidth = 2.0;
	
	for(int i = 0; i < selectList.size(); i++) {
		int index = selectList[i];
		if(index < 0 ) continue;
		if(ObjectList[index].gamePacket.type >= 50) continue;
		//draw health bar rectangle
		GLdouble coordX, coordY, coordZ;
		Vector curMidPnt = ObjectList[index].curObject->GetBndMidPnt();
		gluProject((GLdouble)curMidPnt.x, (GLdouble)curMidPnt.y, (GLdouble)
		curMidPnt.z, modelMatrix, projMatrix, viewport, &coordX, &coordY, &coordZ);
		
		coordY = coordY + pixelOffsetY;
		GameType addType = GetUnitInfo(ObjectList[index].gamePacket.type);
		
		glColor4f(0.2, 0.2, 0.2, 1.0);
		glRectf(coordX - rectFullWidth * 0.5 - borderWidth, coordY - rectFullHeight * 0.5 - borderWidth, coordX 
			+ rectFullWidth  * 0.5 + borderWidth, 
			coordY + rectFullHeight * 0.5 + borderWidth);
		
		glColor4f(0.0, 1.0, 0.0, 1.0);
		float value = ObjectList[index].gamePacket.health;
		if(value < 0.0) value = 0.0;
		glRectf(coordX - rectFullWidth * 0.5, coordY - rectFullHeight * 0.5, coordX 
			+ rectFullWidth * ((float)value / (float)addType.health) - rectFullWidth * 0.5, 
			coordY + rectFullHeight * 0.5);
	
	}
	

	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
	glDisable(GL_BLEND);
	glDepthMask(GL_TRUE);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_CULL_FACE );
}


void TRTS::renderRTSmap() {
	GLint viewport[4];
	glGetIntegerv(GL_VIEWPORT,viewport);
	glViewport(curInfrastructure->GetWinWidth() * 0.8, curInfrastructure->GetWinHeight() * 0.8, curInfrastructure->GetWinWidth() * 0.2, curInfrastructure->GetWinHeight() * 0.2);

	Vector maxCoord, minCoord;
	Vset(&maxCoord, -9999.0, -99999.0, -99999.0);
	Vset(&minCoord, 99999.0, 99999.0, 99999.0);
	
	for(int i = 0; i < PortalList.size(); i++) {
		if(PortalList[i].Bound1.x > maxCoord.x) maxCoord.x = PortalList[i].Bound1.x;
		if(PortalList[i].Bound1.y > maxCoord.y) maxCoord.y = PortalList[i].Bound1.y;
		if(PortalList[i].Bound1.z > maxCoord.z) maxCoord.z = PortalList[i].Bound1.z;
	
		if(PortalList[i].Bound2.x > maxCoord.x) maxCoord.x = PortalList[i].Bound2.x;
		if(PortalList[i].Bound2.y > maxCoord.y) maxCoord.y = PortalList[i].Bound2.y;
		if(PortalList[i].Bound2.z > maxCoord.z) maxCoord.z = PortalList[i].Bound2.z;
	
		if(PortalList[i].Bound3.x > maxCoord.x) maxCoord.x = PortalList[i].Bound3.x;
		if(PortalList[i].Bound3.y > maxCoord.y) maxCoord.y = PortalList[i].Bound3.y;
		if(PortalList[i].Bound3.z > maxCoord.z) maxCoord.z = PortalList[i].Bound3.z;
	
		if(PortalList[i].Bound4.x > maxCoord.x) maxCoord.x = PortalList[i].Bound4.x;
		if(PortalList[i].Bound4.y > maxCoord.y) maxCoord.y = PortalList[i].Bound4.y;
		if(PortalList[i].Bound4.z > maxCoord.z) maxCoord.z = PortalList[i].Bound4.z;
	
	
		if(PortalList[i].Bound1.x < minCoord.x) minCoord.x = PortalList[i].Bound1.x;
		if(PortalList[i].Bound1.y < minCoord.y) minCoord.y = PortalList[i].Bound1.y;
		if(PortalList[i].Bound1.z < minCoord.z) minCoord.z = PortalList[i].Bound1.z;
	
		if(PortalList[i].Bound2.x < minCoord.x) minCoord.x = PortalList[i].Bound2.x;
		if(PortalList[i].Bound2.y < minCoord.y) minCoord.y = PortalList[i].Bound2.y;
		if(PortalList[i].Bound2.z < minCoord.z) minCoord.z = PortalList[i].Bound2.z;
	
		if(PortalList[i].Bound3.x < minCoord.x) minCoord.x = PortalList[i].Bound3.x;
		if(PortalList[i].Bound3.y < minCoord.y) minCoord.y = PortalList[i].Bound3.y;
		if(PortalList[i].Bound3.z < minCoord.z) minCoord.z = PortalList[i].Bound3.z;
	
		if(PortalList[i].Bound4.x < minCoord.x) minCoord.x = PortalList[i].Bound4.x;
		if(PortalList[i].Bound4.y < minCoord.y) minCoord.y = PortalList[i].Bound4.y;
		if(PortalList[i].Bound4.z < minCoord.z) minCoord.z = PortalList[i].Bound4.z;
	}
	
	
	glMatrixMode( GL_PROJECTION );
		glPushMatrix();
		glLoadIdentity();
		glOrtho(minCoord.x, maxCoord.x, maxCoord.z, minCoord.z, -1, 1);
	
	glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();
		glTranslated(0, 0, 0);

	glActiveTextureARB( GL_TEXTURE1_ARB );
	glDisable( GL_TEXTURE_CUBE_MAP_ARB );
	glDisable( GL_TEXTURE_2D );

	glActiveTextureARB( GL_TEXTURE0_ARB );
	glDisable( GL_TEXTURE_CUBE_MAP_ARB );

	glDisable(GL_REGISTER_COMBINERS_NV);
	glDisable(GL_TEXTURE_2D);
	glDepthFunc(GL_LEQUAL);

	glDisable(GL_LIGHTING);
	
	glDisable(GL_STENCIL_TEST);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(GL_FALSE);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_COLOR);
	glDisable(GL_CULL_FACE );
	
	glColor4f(0.5, 0.5, 0.5, 1.0);
	for(i = 0; i < PortalList.size(); i++) {
		glColor4f(0.5 + (float)(i % 4) / 8.0, 0.5 + (float)(i % 4) / 4.0, 0.5 + (float)(i % 4) / 8.0, 1.0);
		glBegin(GL_QUADS);
			glVertex2f(PortalList[i].Bound1.x, PortalList[i].Bound1.z); 
			glVertex2f(PortalList[i].Bound3.x, PortalList[i].Bound3.z); 
			glVertex2f(PortalList[i].Bound2.x, PortalList[i].Bound2.z); 
			glVertex2f(PortalList[i].Bound4.x, PortalList[i].Bound4.z); 
		glEnd();
		
	}

	float area = (maxCoord.x - minCoord.x) * (maxCoord.z - minCoord.z);	
	float desigLength = 0.00012 * area;
	float desigLength2 = 0.00002 * area;
	
	glDisable(GL_BLEND);
	glColor4f(1.0, 1.0, 0.0, 0.6);
	glBegin(GL_LINES);
		glVertex2f(viewerLoc.x - desigLength, viewerLoc.z - desigLength);
		glVertex2f(viewerLoc.x + desigLength, viewerLoc.z - desigLength);
	
		glVertex2f(viewerLoc.x + desigLength, viewerLoc.z - desigLength);
		glVertex2f(viewerLoc.x + desigLength, viewerLoc.z + desigLength);
	
		glVertex2f(viewerLoc.x + desigLength, viewerLoc.z + desigLength);
		glVertex2f(viewerLoc.x - desigLength, viewerLoc.z + desigLength);
	
		glVertex2f(viewerLoc.x - desigLength, viewerLoc.z + desigLength);
		glVertex2f(viewerLoc.x - desigLength, viewerLoc.z - desigLength);
	glEnd();
	
	for(i = 0; i < ObjectList.size(); i++) {
		if( (ObjectList[i].gamePacket.selectLevel > 0) || ObjectList[i].gamePacket.type >= 50) {
			glBegin(GL_LINES);
				glColor4f(0.0, 0.0, 1.0, 1.0);
				if(ObjectList[i].gamePacket.type >= 50) glColor4f(0.0, 1.0, 0.0, 1.0);
				if(ObjectList[i].gamePacket.type == PLAYER_TYPE) glColor4f(1.0, 0.0, 0.0, 1.0);
				glVertex2f(ObjectList[i].translate.x - desigLength2, ObjectList[i].translate.z);
				glVertex2f(ObjectList[i].translate.x + desigLength2, ObjectList[i].translate.z);
				glVertex2f(ObjectList[i].translate.x, ObjectList[i].translate.z - desigLength2);
				glVertex2f(ObjectList[i].translate.x, ObjectList[i].translate.z + desigLength2);
			glEnd();
		}
	}
	
	
	glColor4f(1.0, 1.0, 1.0, 1.0);

	//restore scene properties
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
	glDepthMask(GL_TRUE);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_CULL_FACE );
		
	//restore viewport;
	glViewport(viewport[0], viewport[1], viewport[2], viewport[3]);
	
}

int TRTS::processClickMap(int x, int y) {
	Vector maxCoord, minCoord;
	Vset(&maxCoord, -9999.0, -99999.0, -99999.0);
	Vset(&minCoord, 99999.0, 99999.0, 99999.0);
	
	//see if the click is on the map
	y = curInfrastructure->GetWinHeight() - y;
	if((float)x < (float)curInfrastructure->GetWinWidth() * 0.8 || (float)y < (float)curInfrastructure->GetWinHeight() * 0.8) return false;
	float xRatio = ( (float)x - (float)curInfrastructure->GetWinWidth() * 0.8) / ((float)curInfrastructure->GetWinWidth() * 0.2);
	float zRatio = 1.0 - ( (float)y - (float)curInfrastructure->GetWinHeight() * 0.8) / ((float)curInfrastructure->GetWinHeight() * 0.2);
	
	//find max/min boundaries
	for(int i = 0; i < PortalList.size(); i++) {
		if(PortalList[i].Bound1.x > maxCoord.x) maxCoord.x = PortalList[i].Bound1.x;
		if(PortalList[i].Bound1.y > maxCoord.y) maxCoord.y = PortalList[i].Bound1.y;
		if(PortalList[i].Bound1.z > maxCoord.z) maxCoord.z = PortalList[i].Bound1.z;
	
		if(PortalList[i].Bound2.x > maxCoord.x) maxCoord.x = PortalList[i].Bound2.x;
		if(PortalList[i].Bound2.y > maxCoord.y) maxCoord.y = PortalList[i].Bound2.y;
		if(PortalList[i].Bound2.z > maxCoord.z) maxCoord.z = PortalList[i].Bound2.z;
	
		if(PortalList[i].Bound3.x > maxCoord.x) maxCoord.x = PortalList[i].Bound3.x;
		if(PortalList[i].Bound3.y > maxCoord.y) maxCoord.y = PortalList[i].Bound3.y;
		if(PortalList[i].Bound3.z > maxCoord.z) maxCoord.z = PortalList[i].Bound3.z;
	
		if(PortalList[i].Bound4.x > maxCoord.x) maxCoord.x = PortalList[i].Bound4.x;
		if(PortalList[i].Bound4.y > maxCoord.y) maxCoord.y = PortalList[i].Bound4.y;
		if(PortalList[i].Bound4.z > maxCoord.z) maxCoord.z = PortalList[i].Bound4.z;
	
	
		if(PortalList[i].Bound1.x < minCoord.x) minCoord.x = PortalList[i].Bound1.x;
		if(PortalList[i].Bound1.y < minCoord.y) minCoord.y = PortalList[i].Bound1.y;
		if(PortalList[i].Bound1.z < minCoord.z) minCoord.z = PortalList[i].Bound1.z;
	
		if(PortalList[i].Bound2.x < minCoord.x) minCoord.x = PortalList[i].Bound2.x;
		if(PortalList[i].Bound2.y < minCoord.y) minCoord.y = PortalList[i].Bound2.y;
		if(PortalList[i].Bound2.z < minCoord.z) minCoord.z = PortalList[i].Bound2.z;
	
		if(PortalList[i].Bound3.x < minCoord.x) minCoord.x = PortalList[i].Bound3.x;
		if(PortalList[i].Bound3.y < minCoord.y) minCoord.y = PortalList[i].Bound3.y;
		if(PortalList[i].Bound3.z < minCoord.z) minCoord.z = PortalList[i].Bound3.z;
	
		if(PortalList[i].Bound4.x < minCoord.x) minCoord.x = PortalList[i].Bound4.x;
		if(PortalList[i].Bound4.y < minCoord.y) minCoord.y = PortalList[i].Bound4.y;
		if(PortalList[i].Bound4.z < minCoord.z) minCoord.z = PortalList[i].Bound4.z;
	}
	
	float transX = xRatio * (maxCoord.x - minCoord.x) + minCoord.x;
	float transZ = zRatio * (maxCoord.z - minCoord.z) + minCoord.z;

	viewXDisp = 0.0;
	viewZDisp = 0.0;
	viewerLoc.x = transX;
	viewerLoc.z = transZ;
		
	return true;
}

void TRTS::simulateReviveHuman() {
	for(int i = 0; i < ObjectList.size(); i++) {
		if(ObjectList[i].gamePacket.type == PLAYER_TYPE) {
			if(ObjectList[i].gamePacket.health < 0) { //see if we can revive the human player
				if( (SDL_GetTicks() - reviveTime) >= 15000) {
					ObjectList[i].gamePacket.health = 100;
					ObjectList[i].gamePacket.selectLevel = SELECT_ONLY;
					ObjectList[i].gamePacket.actionList.clear();
					Vector tryVec = mustSpawnRandom((TObject *)ObjectList[i].curObject, 4.0, i);
					ObjectList[i].translate = tryVec;
					TMd2 *curMd2 = (TMd2 *)ObjectList[i].curObject;
					curMd2->SetCurrentAnimation(IDLE_ANIMATE, ANIMATE_SMOOTHNESS);
					curMd2->SetAnimationCycle(true);
				}
			}
		}
		else if(ObjectList[i].gamePacket.type == MAIN_RAT_TYPE) {
			if(ObjectList[i].gamePacket.health < 0) { //see if we can revive the rat player
				if( (SDL_GetTicks() - reviveTime) >= 15000) {
					ObjectList[i].gamePacket.health = 500;
					ObjectList[i].gamePacket.selectLevel = SELECT_MOVE;
					ObjectList[i].gamePacket.actionList.clear();
					Vector tryVec = mainRatSpawn, objSpawnPt;
					GameType addType = GetUnitInfo(MAIN_RAT_TYPE);
					tryVec = mustSpawnRandom((TObject *)ObjectList[i].curObject, addType.size, i);
					tryVec.y = getObjectSpawnY( (TObject *)ObjectList[i].curObject, 1.0, addType.size);
					objSpawnPt = tryVec;
					ObjectList[i].translate = objSpawnPt;
					
					TMd2 *curMd2 = (TMd2 *)ObjectList[i].curObject;
					curMd2->SetCurrentAnimation(IDLE_ANIMATE, ANIMATE_SMOOTHNESS);
					curMd2->PlayAnimation();
					curMd2->SetAnimationCycle(true);
					statusTextSet("Voodoo Rat Revived!");
				
					viewerLoc = objSpawnPt;
					viewerLoc.z = viewerLoc.z + 30.0;
					viewerLoc.y = elevate_num;
					viewerPhysics.loc = viewerLoc;
					viewerPhysics.vel.x = viewerPhysics.vel.y = viewerPhysics.vel.z = 0.0;
					
				}
			}
		}
	}
}


void TRTS::addMainRat() {
	//adds the main rat character for the RTS player
	Vector rotVec, scaleVec, objSpawnPt;
	GameType addType = GetUnitInfo(MAIN_RAT_TYPE);
	Vset(&rotVec, 0.0, 0.0, 0.0); Vset(&scaleVec, addType.size, addType.size, addType.size);
			
	TMd2 *addMd2 = new TMd2(curInfrastructure);
	addMd2->Copy(*(LoadedMd2( (char *)(addType.md2_Filename.c_str() ) )));
			
	addMd2->PrepareTransform();
		glTranslatef(objSpawnPt.x, objSpawnPt.y, objSpawnPt.z);
		glRotatef(0.0, 0.0, 0.0, 1.0f);
		glRotatef(0.0, 0.0, 1.0f, 0.0);
		glRotatef(0.0, 1.0f, 0.0, 0.0);
		glScalef(addType.size, addType.size, addType.size);
	addMd2->EndTransform();
	addMd2->SaveMatrix(); 
	addMd2->PlayAnimation();
	addMd2->CalcBounds();
	printVector(&(addMd2->GetMaxBounds()), "Max: " );
	printVector(&(addMd2->GetMinBounds()), "Max: " );
		
	LoadedTObjects.push_back(addMd2);
	Vector tryVec = mainRatSpawn;
	tryVec.y = getObjectSpawnY( (TObject *)addMd2, 1.0, addType.size);
	objSpawnPt = tryToSpawn(tryVec, (TObject *)addMd2, addType.size, -1);
	AttachObject(addMd2, objSpawnPt, scaleVec, rotVec, GLOW_TRUE, true, true, false, -1, false, 0.0f, MAIN_RAT_TYPE, NULL, FPSGamePacket.team);
	printVector(&objSpawnPt, "Main Rat Spawn Point: " );
	ObjectList[ObjectList.size() - 1].gamePacket.health = addType.health;
	presetObjectSelection();

	tryVec = mustSpawnRandom((TObject *)ObjectList[ObjectList.size() - 1].curObject, addType.size, ObjectList.size() - 1);
	tryVec.y = getObjectSpawnY( (TObject *)ObjectList[ObjectList.size() - 1].curObject, 1.0, addType.size);
	objSpawnPt = tryVec;
	ObjectList[ObjectList.size() - 1].translate = objSpawnPt;
	
	viewerLoc = objSpawnPt;
	viewerLoc.z = viewerLoc.z + 30.0;
	viewerLoc.y = elevate_num;
	viewerPhysics.loc = viewerLoc;
	viewerPhysics.vel.x = viewerPhysics.vel.y = viewerPhysics.vel.z = 0.0; 

	ApplyRTSUserInput();
	TryMoveRTSViewerPhysics();
}

void TRTS::simulatePillarObjects() {
	bool flag = false;
	bool pillarYes = false;
	for(int i = 0; i < ObjectList.size(); i++) {
		if(ObjectList[i].gamePacket.type == GAME_PILLAR_TYPE) {
			pillarYes = true;
			
			if(ObjectList[i].translate.x < OUT_OF_RANGE) flag = true;
		}
		if(ObjectList[i].gamePacket.type == GAME_PILLAR_TYPE && ObjectList[i].gamePacket.health <= 0) {
			ObjectList[i].gamePacket.health = 200;
			Vset(&ObjectList[i].translate, OUT_OF_RANGE,  OUT_OF_RANGE,  OUT_OF_RANGE);
			statusTextSet("You have destroyed a pillar!");
			pillarCnt--;
		}
	}
	
	if(pillarCnt <= 0) {
		gameScore.side1_score = 6;
		gameScore.side2_score = 0;
	}
}




static void multiPlayerCallBack(void *obj, void *data, int size) {
	TRTS *curRTS = (TRTS *)obj;
	curRTS->runMultiplayerMode(data, size);
}


