/***************************************************************************
                          tparticle.h  -  description
                             -------------------
    begin                : Wed Jul 16 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TPARTICLE_H
#define TPARTICLE_H

const int MAX_PARTICLES = 150;

using namespace std;


/**
  *@author Chong Jiayi
  */

class TParticle {

protected:
	vector <GLuint> rasterImages;
	GLuint particleBuffer;
	GLuint particleColorBuffer;
	GLuint particleTextureBuffer;
	GLuint particleIndiceBuffer;
public: 
	TParticle();
	~TParticle();
	
	GLuint createGlowBall(int r1, int g1, int b1, int r2, int g2, int b2);
	void prepareParticlePlainRender();
	void renderParticlePlain(GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height, GLfloat angleX,
						GLfloat angleY, GLfloat angleZ, GLfloat *mat);
	void renderParticleList(slist<GamerAmmo>::iterator begin, slist<GamerAmmo>::iterator end, 
					Vector gravity, float alphaDelta, 
					GLfloat r1, GLfloat g1, GLfloat b1, GLfloat r2, GLfloat g2, GLfloat b2,
					GLfloat r3, GLfloat g3, GLfloat b3, int maxFrame,
					GLfloat width, GLfloat height,
					GLfloat angleX, GLfloat angleY, GLfloat angleZ, GLfloat *mat);
	void renderParticleListVBO(slist<GamerAmmo>::iterator begin, slist<GamerAmmo>::iterator end, 
					Vector gravity, float alphaDelta, 
					GLfloat r1, GLfloat g1, GLfloat b1, GLfloat r2, GLfloat g2, GLfloat b2,
					GLfloat r3, GLfloat g3, GLfloat b3, int maxFrame,
					GLfloat width, GLfloat height,
					GLfloat angleX, GLfloat angleY, GLfloat angleZ, GLfloat *mat);
	void renderParticleList2(slist<GamerAmmo>::iterator begin, slist<GamerAmmo>::iterator end, 
					Vector gravity, float alphaDelta, 
					GLfloat r1, GLfloat g1, GLfloat b1, GLfloat r2, GLfloat g2, GLfloat b2,
					GLfloat r3, GLfloat g3, GLfloat b3, int maxFrame,
					GLfloat width, GLfloat height,
					GLfloat angleX, GLfloat angleY, GLfloat angleZ, GLfloat *mat);
	void renderParticleList2VBO(slist<GamerAmmo>::iterator begin, slist<GamerAmmo>::iterator end, 
					Vector gravity, float alphaDelta, 
					GLfloat r1, GLfloat g1, GLfloat b1, GLfloat r2, GLfloat g2, GLfloat b2,
					GLfloat r3, GLfloat g3, GLfloat b3, int maxFrame,
					GLfloat width, GLfloat height,
					GLfloat angleX, GLfloat angleY, GLfloat angleZ, GLfloat *mat);
	
	void endParticleRender();
	
};

#endif
