/***************************************************************************
                          tnetwork.cpp  -  description
                             -------------------
    begin                : Tue Nov 11 2003
    copyright            : (C) 2003 by jychong
    email                : jychong@dromaesaur.stanford.edu
 ***************************************************************************/


#include "tnetwork.h"


static void connect_Thread(void *data);
static void tryTo_connect_Thread(void *data);
static void network_MainThread(void *data);

TNetwork::TNetwork() {
	if(!nlInit()) {
		cerr << "Unable to Initialize HawkNL library!" << endl;
		exit(1);
	}

	localPort = 6116;

	if(!nlSelectNetwork(NL_IP)) {
		cerr << "Unable to Initialize HawkNL library! (type error)" << endl;
		exit(1);
	}

	socktype =  NL_UNRELIABLE;

	mode = IDLE_MODE;
	connectCallBack = NULL;
	connectCallBack2 = NULL;
	callBackData = NULL;
	cout << "HawkNL Network Library initialized" << endl;

}

TNetwork::~TNetwork() {
	nlShutdown();
}

void TNetwork::allowConnect(SDL_CallBackFunc callFn, void *data) {
	cout << "Server is now accepting connections..." << endl;
	callBackData = data;
	connectCallBack = callFn;
	/* create the server socket */
	localSock = nlOpen(localPort, socktype);
	connectGroup = nlGroupCreate();
	mode = ALLOW_MODE;
	if(!nlListen(localSock)) {
		cerr << "Cannot listen on socket!" << endl;
		NLenum curError = nlGetError();
		cerr << nlGetErrorStr(curError) << endl;
		nlClose(localSock);
		exit(1);
	}

	NLaddress localAddress;
	nlGetLocalAddr(serverSock, &localAddress);
	nlSetAddrPort(&localAddress, localPort);

	sendTarget = CLIENT_TARGET;
	(void)nlThreadCreate(&connect_Thread, (void *)this, NL_FALSE);

}

int TNetwork::joinServer(char *name, SDL_CallBackFunc callFn, void *data) {

	if( (nlGetAddrFromName(name, &joinAddress) == NL_FALSE)) return 0;
	connectCallBack = callFn;
	callBackData = data;
	localSock = nlOpen(0, socktype);
	(void)nlThreadCreate(&tryTo_connect_Thread, (void *)this, NL_FALSE);
}


void TNetwork::endConnect() {
	mode = IDLE_MODE;
	cout << "Server has stopped accepting connections..." << endl;
}

void TNetwork::disConnect() {
	cout << "Attempting to disconnect" << endl;
	if(clients.empty()) return;
	nlGroupDestroy(connectGroup);
	mode = IDLE_MODE;
	nlClose(localSock);
//	nlClose(serverSock);
	
	for(int i = 0; i < clients.size(); i++) {
		nlClose(clients[i]);
	}
	
	clients.clear();
	
	
	nlShutdown();
	
	if(!nlInit()) {
		cerr << "Unable to Initialize HawkNL library!" << endl;
		exit(1);
	}

	localPort = 6116;

	if(!nlSelectNetwork(NL_IP)) {
		cerr << "Unable to Initialize HawkNL library! (type error)" << endl;
		exit(1);
	}

	socktype =  NL_UNRELIABLE;

	mode = IDLE_MODE;
	connectCallBack = NULL;
	connectCallBack2 = NULL;
	callBackData = NULL;
	cout << "HawkNL Network Library initialized!" << endl;
}

void TNetwork::processLogin() {
	NLsocket newSock, newSock2;
	NLbyte nl_string[NL_MAX_STRING_LENGTH];

	newSock =  nlAcceptConnection(localSock);

	if(newSock != NL_INVALID) {
		NLaddress addr;
		nlGetRemoteAddr(newSock, &addr);
		clients.push_back(newSock);
		/* add socket to the group */
		nlGroupAddSocket(connectGroup, newSock);
		printf("SERVER:Client %d connected from %s on socket %d\n", clients.size(),
			nlAddrToString(&addr, nl_string), newSock);

		if(connectCallBack != NULL) connectCallBack(callBackData);
	}
}

void TNetwork::processConnect() {
	NLbyte str[256];
	int retval = 0;
	nlSetAddrPort(&joinAddress, localPort);
	if(nlConnect(localSock, &joinAddress) == NL_TRUE) {
		printf("CLIENT connect to %s\n", nlAddrToString(&joinAddress, str));
		memset(str, '\0', 256);
		bool connectFlag = false;
		for(int i = 0; i < 50; i++) {
			retval = nlWrite(localSock, str, 256);
			if(retval == NL_INVALID) {
				NLenum curError = nlGetError();
				cout << nlGetErrorStr(curError) << endl;
			}
			else {connectFlag = true; break;}
			SDL_Delay(100);
		}
		
		if(connectFlag == false) {
			if(nlGetError() == NL_CON_PENDING) {
				printf("CLIENT: nlConnect error\n");
				return;
			}
		}
		sendTarget = SERVER_TARGET;
		connectCallBack(callBackData);
	}
	else {
		printf("CLIENT: nlConnect error\n");
		return;
	}
}

void TNetwork::startNetwork(SDL_CallBackFunc2 callFn, void *data) {
	connectCallBack2 = callFn; callBackData = data; int oldMode = mode;
	mode = RUNNING_MODE;
	SDL_Delay(100);
	if(oldMode != RUNNING_MODE) (void)nlThreadCreate(&network_MainThread, (void *)this, NL_FALSE);

}

void TNetwork::processMessages() {
	NLint retval = 0;
	for(int i = 0; i < clients.size(); i++) {
		while( (retval = nlRead(clients[i], readBuffer, READ_BUFFER_SIZE)) > 0) {
			if(retval != NL_INVALID) {
				if(connectCallBack2 != NULL) connectCallBack2(callBackData, (void *)readBuffer, retval);
			}
		}
	}

/*	retval = nlRead(serverSock, readBuffer, READ_BUFFER_SIZE);
	if(retval != NL_INVALID) {
		if(connectCallBack2 != NULL) connectCallBack2(callBackData, (void *)readBuffer, retval);
	} */
	
	int cnt = 0;

	while( (retval = nlRead(localSock, readBuffer, READ_BUFFER_SIZE)) > 0) {
		cnt++;
		if(retval != NL_INVALID) {
			if(connectCallBack2 != NULL) connectCallBack2(callBackData, (void *)readBuffer, retval);
			if(cnt > 50) { nlThreadYield(); cnt = 0; }
		}
	}
}


void TNetwork::sendTextMessageFromServer(char *message) {
	uint8_t sendPacket[1100];
	uint16_t length = (uint16_t)strlen(message) + 1;
	if(length > 1000) {
		length = 1000;
	}

	//construct the send packet
	memcpy(sendPacket, &TEXT_MESSAGE_PACKET, sizeof(uint8_t));
	memcpy(sendPacket + sizeof(uint8_t), message, sizeof(uint8_t) * length);
	
	//send it
//	if(sendTarget = CLIENT_TARGET) {
		int sentBytes = nlWrite(connectGroup, (NLvoid *)sendPacket, sizeof(uint8_t) + sizeof(uint8_t) * length);
		cout << "Bytes sent to Clients:" << sentBytes << endl;
//	}
//	else if(sendTarget = LOCAL_TARGET) {
//		sentBytes = nlWrite(serverSock, (NLvoid *)sendPacket, sizeof(uint8_t) + sizeof(uint8_t) * length);
//		cout << "Bytes sent to Server:" << sentBytes << endl;
//	}
}

void TNetwork::sendTextMessageFromClient(char *message) {
	uint8_t sendPacket[1100];
	uint16_t length = (uint16_t)strlen(message) + 1;
	if(length > 1000) {
		length = 1000;
		message[999] = '\0';
	}

	//construct the send packet
	memcpy(sendPacket, &TEXT_MESSAGE_PACKET, sizeof(uint8_t));
	memcpy(sendPacket + sizeof(uint8_t), message, sizeof(uint8_t) * length);
	
	//send it
	if(sendTarget == SERVER_TARGET) {
		int sentBytes = nlWrite(localSock, (NLvoid *)sendPacket, sizeof(uint8_t) + sizeof(uint8_t) * length);
		cout << "Bytes sent to Server:" << sentBytes << endl;
	}
}

void TNetwork::sendObjectPacket(int objType, int team, int selected, int health, int weapon, int ammo,
			int action, unsigned int frame, Vector translate, Vector rotate, int index) {
	uint8_t *sendPacket = new uint8_t[1 + 28];
	//construct the send packet
	memcpy(sendPacket, &OBJECT_PACKET, sizeof(uint8_t));
	
	uint8_t object_Type = (uint8_t)objType;
	memcpy(sendPacket + sizeof(uint8_t), &object_Type, sizeof(uint8_t));
	
	uint8_t object_Team = (uint8_t)team;
	memcpy(sendPacket + sizeof(uint8_t) * 2, &object_Team, sizeof(uint8_t));
	
	uint8_t object_Selected = (uint8_t)selected;
	memcpy(sendPacket + sizeof(uint8_t) * 3, &object_Selected, sizeof(uint8_t));
	
	int16_t object_Health = (int16_t)health;
	memcpy(sendPacket + sizeof(uint8_t) * 4, &object_Health, sizeof(int16_t));
	
	uint8_t object_Weapon = (uint8_t)weapon;
	memcpy(sendPacket + sizeof(uint8_t) * 4 + sizeof(uint16_t), &object_Weapon, sizeof(uint8_t));
	
	uint8_t object_Ammo = (uint8_t)ammo;
	memcpy(sendPacket + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t), &object_Ammo, sizeof(uint8_t));
	
	int8_t object_Action = (int8_t)action;
	memcpy(sendPacket + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 2, &object_Action, sizeof(int8_t));
	
	uint32_t object_Frame = (uint32_t)frame;
	memcpy(sendPacket + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 3, &object_Frame, sizeof(uint32_t));
	
	NLfloat object_X = (NLfloat)translate.x;
	memcpy(sendPacket + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 3
		+ sizeof(uint32_t), &object_X, sizeof(NLfloat));
	
	NLfloat object_Y = (NLfloat)translate.y;
	memcpy(sendPacket + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 3
		+ sizeof(uint32_t) + sizeof(NLfloat), &object_Y, sizeof(NLfloat));
	
	NLfloat object_Z = (NLfloat)translate.z;
	memcpy(sendPacket + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 3
		+ sizeof(uint32_t) + sizeof(NLfloat) * 2, &object_Z, sizeof(NLfloat));
	
	int16_t object_rotateY = (int16_t)rotate.y;
	memcpy(sendPacket + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 3
		+ sizeof(uint32_t) + sizeof(NLfloat) * 3, &object_rotateY, sizeof(int16_t));
	
	uint16_t object_index = (uint16_t)index;
	memcpy(sendPacket + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 3
		+ sizeof(uint32_t) + sizeof(NLfloat) * 3 + sizeof(int16_t), &object_index, sizeof(uint16_t));
	
	//send it
	int sentBytes = 0;
	if(sendTarget == SERVER_TARGET) {
		sentBytes = nlWrite(localSock, (NLvoid *)sendPacket, 1 + 28);
	}
	else {
		for(int i = 0; i < clients.size(); i++) 
			sentBytes = nlWrite(clients[i], (NLvoid *)sendPacket, 1 + 28);
	}
	
	
}

void TNetwork::sendObjectList(int objNum, unsigned int frame, char situation, int resources) {
	uint8_t *sendPacket = new uint8_t[1 + 9];
	//construct the send packet
	memcpy(sendPacket, &OBJECT_LIST_PACKET, sizeof(uint8_t));
	
	uint16_t object_Num = (uint16_t)objNum;
	memcpy(sendPacket + sizeof(uint8_t), &object_Num, sizeof(uint16_t));
	
	uint32_t object_Frame = (uint32_t)frame;
	memcpy(sendPacket + sizeof(uint8_t) + sizeof(uint16_t), &object_Frame, sizeof(uint32_t));
	
	uint8_t object_Situation = (uint8_t)situation;
	memcpy(sendPacket + sizeof(uint8_t) + sizeof(uint16_t) + sizeof(uint32_t), &object_Situation, sizeof(uint8_t));
	
	uint16_t object_Resources = (uint16_t)resources;
	memcpy(sendPacket + sizeof(uint8_t) + sizeof(uint16_t) + sizeof(uint32_t) + sizeof(uint8_t), &object_Resources, sizeof(uint16_t));
	
	
	//send it
	int sentBytes = 0;
	if(sendTarget == SERVER_TARGET) {
		sentBytes = nlWrite(localSock, (NLvoid *)sendPacket, 1 + 9);
	}
	else {
		for(int i = 0; i < clients.size(); i++) 
			sentBytes = nlWrite(clients[i], (NLvoid *)sendPacket, 1 + 9);
	}
}

void TNetwork::sendPlayerInputPacket(char press_1, char press_2, char press_3, char press_w, char press_s,
			char press_a, char press_d, char press_space, int mouseX, int mouseY,
			char mouseLeft, char mouseRight, char mode, Vector playerLoc, Vector playerRotate) {
	uint8_t *sendPacket = new uint8_t[1 + 35];
	//construct the send packet
	memcpy(sendPacket, &PLAYER_INPUT_PACKET, sizeof(uint8_t));
	
	uint8_t playerPress1 = (uint8_t)press_1;
	memcpy(sendPacket + sizeof(uint8_t), &playerPress1, sizeof(uint8_t));
	
	uint8_t playerPress2 = (uint8_t)press_2;
	memcpy(sendPacket + sizeof(uint8_t) * 2, &playerPress2, sizeof(uint8_t));
	
	uint8_t playerPress3 = (uint8_t)press_3;
	memcpy(sendPacket + sizeof(uint8_t) * 3, &playerPress3, sizeof(uint8_t));
	
	uint8_t playerPressw = (uint8_t)press_w;
	memcpy(sendPacket + sizeof(uint8_t) * 4, &playerPressw, sizeof(uint8_t));
	
	uint8_t playerPresss = (uint8_t)press_s;
	memcpy(sendPacket + sizeof(uint8_t) * 5, &playerPresss, sizeof(uint8_t));
	
	uint8_t playerPressa = (uint8_t)press_a;
	memcpy(sendPacket + sizeof(uint8_t) * 6, &playerPressa, sizeof(uint8_t));
	
	uint8_t playerPressd = (uint8_t)press_d;
	memcpy(sendPacket + sizeof(uint8_t) * 7, &playerPressd, sizeof(uint8_t));
	
	uint8_t playerPressspace = (uint8_t)press_space;
	memcpy(sendPacket + sizeof(uint8_t) * 8, &playerPressspace, sizeof(uint8_t));
	
	int16_t playerMouseX = (int16_t)mouseX;
	memcpy(sendPacket + sizeof(uint8_t) * 9, &playerMouseX, sizeof(int16_t));
	
	int16_t playerMouseY = (int16_t)mouseY;
	memcpy(sendPacket + sizeof(uint8_t) * 9 + sizeof(int16_t), &playerMouseY, sizeof(int16_t));
	
	uint8_t playerMouseLeft = (uint8_t)mouseLeft;
	memcpy(sendPacket + sizeof(uint8_t) * 9 + sizeof(int16_t) * 2, &playerMouseLeft, sizeof(uint8_t));
	
	uint8_t playerMouseRight = (uint8_t)mouseRight;
	memcpy(sendPacket + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t), &playerMouseRight, sizeof(uint8_t));
	
	uint8_t playerMode = (uint8_t)mode;
	memcpy(sendPacket + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t) * 2, &playerMode, sizeof(uint8_t));
	
	NLfloat playerLocX = (NLfloat)playerLoc.x;
	memcpy(sendPacket + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t) * 3, &playerLocX, sizeof(NLfloat));
	
	NLfloat playerLocY = (NLfloat)playerLoc.y;
	memcpy(sendPacket + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t) * 3
			+ sizeof(NLfloat), &playerLocY, sizeof(NLfloat));
	
	NLfloat playerLocZ = (NLfloat)playerLoc.z;
	memcpy(sendPacket + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t) * 3
			+ sizeof(NLfloat) * 2, &playerLocZ, sizeof(NLfloat));
	
	NLfloat playerRotY = (NLfloat)playerRotate.y;
	memcpy(sendPacket + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t) * 3
			+ sizeof(NLfloat) * 3, &playerRotY, sizeof(NLfloat));
	
	NLfloat playerRotX = (NLfloat)playerRotate.x;
	memcpy(sendPacket + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t) * 3
			+ sizeof(NLfloat) * 4, &playerRotX, sizeof(NLfloat));
	
	//send it
	int sentBytes = 0;
	if(sendTarget == SERVER_TARGET) {
		sentBytes = nlWrite(localSock, (NLvoid *)sendPacket, 1 + 35);
	}
	else {
		for(int i = 0; i < clients.size(); i++) 
			sentBytes = nlWrite(clients[i], (NLvoid *)sendPacket, 1 + 35);
	}
	
}

void TNetwork::sendParticlePacket(char type, int index, Vector loc, Vector vel) {
	uint8_t *sendPacket = new uint8_t[1 + 27];
	//construct the send packet
	memcpy(sendPacket, &PARTICLE_PACKET, sizeof(uint8_t));
	
	uint8_t particle_Type = (uint8_t)type;
	memcpy(sendPacket + sizeof(uint8_t), &particle_Type, sizeof(uint8_t));
	
	NLfloat locX = (NLfloat)loc.x;
	memcpy(sendPacket + sizeof(uint8_t) * 2, &locX, sizeof(NLfloat));
	
	NLfloat locY = (NLfloat)loc.y;
	memcpy(sendPacket + sizeof(uint8_t) * 2 + sizeof(NLfloat), &locY, sizeof(NLfloat));
	
	NLfloat locZ = (NLfloat)loc.z;
	memcpy(sendPacket + sizeof(uint8_t) * 2 + sizeof(NLfloat) * 2, &locZ, sizeof(NLfloat));
	
	NLfloat velX = (NLfloat)vel.x;
	memcpy(sendPacket + sizeof(uint8_t) * 2 + sizeof(NLfloat) * 3, &velX, sizeof(NLfloat));
	
	NLfloat velY = (NLfloat)vel.y;
	memcpy(sendPacket + sizeof(uint8_t) * 2 + sizeof(NLfloat) * 4, &velY, sizeof(NLfloat));
	
	NLfloat velZ = (NLfloat)vel.z;
	memcpy(sendPacket + sizeof(uint8_t) * 2 + sizeof(NLfloat) * 5, &velZ, sizeof(NLfloat));

	int16_t curIndex = (int16_t)index;
	memcpy(sendPacket + sizeof(uint8_t) * 2 + sizeof(NLfloat) * 6, &curIndex, sizeof(int16_t));
	
	//send it
	int sentBytes = 0;
	if(sendTarget == SERVER_TARGET) {
		sentBytes = nlWrite(localSock, (NLvoid *)sendPacket, 1 + 27);
	}
	else {
		for(int i = 0; i < clients.size(); i++) 
			sentBytes = nlWrite(clients[i], (NLvoid *)sendPacket, 1 + 27);
	}
	
}


void TNetwork::sendStartPacket() {
	int sentBytes = 0;
	sentBytes = nlWrite(connectGroup, (NLvoid *)&START_GAME_PACKET,sizeof(uint8_t));
	cout << "Sent Bytes: " << sentBytes << endl;
	
}




void TNetwork::getString(void *data, int size, char *output){
	uint8_t *workPtr = (uint8_t *)data;
	uint8_t dataType = *((uint8_t *)data);
	*output = '\0';
	
	if(dataType == TEXT_MESSAGE_PACKET) {
		memcpy(output, workPtr + 1, size);
	}
	
}

void TNetwork::getObjectPacket(void *data, TNetworkObjectPacket *curPacket) {
	uint8_t *workData = (uint8_t *)data;
	
	uint8_t objType_org = 0;
	memcpy(&objType_org, workData + sizeof(uint8_t), sizeof(uint8_t));
	curPacket->type = (int)objType_org;

	uint8_t objTeam_org = 0;
	memcpy(&objTeam_org, workData + sizeof(uint8_t) * 2, sizeof(uint8_t));
	curPacket->team = (int)objTeam_org;
	
	uint8_t objSelected_org = 0;
	memcpy(&objSelected_org, workData + sizeof(uint8_t) * 3, sizeof(uint8_t));
	curPacket->selected = (int)objSelected_org;

	int16_t objHealth_org = 0;
	memcpy(&objHealth_org, workData + sizeof(uint8_t) * 4, sizeof(int16_t));
	curPacket->health = (int)objHealth_org;

	uint8_t objWeapon_org = 0;
	memcpy(&objWeapon_org, workData + sizeof(uint8_t) * 4 + sizeof(uint16_t), sizeof(uint8_t));
	curPacket->weapon = (int)objWeapon_org;

	uint8_t objAmmo_org = 0;
	memcpy(&objAmmo_org, workData + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t), sizeof(uint8_t));
	curPacket->ammo = (int)objAmmo_org;

	int8_t objAction_org = 0;
	memcpy(&objAction_org, workData + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 2, sizeof(int8_t));
	curPacket->action = (int)objAction_org;

	uint32_t objFrame_org = 0;
	memcpy(&objFrame_org, workData + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 3, sizeof(uint32_t));
	curPacket->frame = (int)objFrame_org;

	NLfloat objX_org = 0.0;
	memcpy(&objX_org, workData + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 3
		+sizeof(uint32_t), sizeof(NLfloat));
	curPacket->translate.x = (float)objX_org;

	NLfloat objY_org = 0.0;
	memcpy(&objY_org, workData + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 3
		+sizeof(uint32_t) + sizeof(NLfloat), sizeof(NLfloat));
	curPacket->translate.y = (float)objY_org;

	NLfloat objZ_org = 0.0;
	memcpy(&objZ_org, workData + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 3
		+sizeof(uint32_t) + sizeof(NLfloat) * 2, sizeof(NLfloat));
	curPacket->translate.z = (float)objZ_org;

	int16_t objRotateY_org = 0;
	memcpy(&objRotateY_org, workData + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 3
		+sizeof(uint32_t) + sizeof(NLfloat) * 3, sizeof(int16_t));
	curPacket->rotateY = (float)objRotateY_org;
		
	uint16_t objIndex_org = 0;
	memcpy(&objIndex_org, workData + sizeof(uint8_t) * 4 + sizeof(uint16_t) + sizeof(uint8_t) * 3
		+sizeof(uint32_t) + sizeof(NLfloat) * 3 + sizeof(uint16_t), sizeof(uint16_t));
	curPacket->index = (float)objIndex_org;
	
}

void TNetwork::getObjectListPacket(void *data, TNetworkObjectListPacket *curPacket) {
	uint8_t *workData = (uint8_t *)data;
	
	uint16_t listNum_org = 0;
	memcpy(&listNum_org, workData + sizeof(uint8_t), sizeof(uint16_t));
	curPacket->num = (int)listNum_org;

	uint32_t listFrame_org = 0;
	memcpy(&listFrame_org, workData + sizeof(uint8_t) + sizeof(uint16_t), sizeof(uint32_t));
	curPacket->frame = (int)listFrame_org;
	
	uint8_t listSituation_org = 0;
	memcpy(&listSituation_org, workData + sizeof(uint8_t) + sizeof(uint16_t) + sizeof(uint32_t), sizeof(uint8_t));
	curPacket->situation = (int)listSituation_org;

	uint16_t listResources_org = 0;
	memcpy(&listResources_org, workData + sizeof(uint8_t) + sizeof(uint16_t) + sizeof(uint32_t) + sizeof(uint8_t), sizeof(uint16_t));
	curPacket->resources = (int)listResources_org;
}

void TNetwork::getPlayerInputPacket(void *data, TNetworkPlayerInputPacket *curPacket) {
	uint8_t *workData = (uint8_t *)data;
	
	uint8_t input_1_org = 0;
	memcpy(&input_1_org, workData + sizeof(uint8_t), sizeof(uint8_t));
	curPacket->press_1 = (int)input_1_org;
	
	uint8_t input_2_org = 0;
	memcpy(&input_2_org, workData + sizeof(uint8_t) * 2, sizeof(uint8_t));
	curPacket->press_2 = (int)input_2_org;

	uint8_t input_3_org = 0;
	memcpy(&input_3_org, workData + sizeof(uint8_t) * 3, sizeof(uint8_t));
	curPacket->press_3 = (int)input_3_org;

	uint8_t input_w_org = 0;
	memcpy(&input_w_org, workData + sizeof(uint8_t) * 4, sizeof(uint8_t));
	curPacket->press_w = (int)input_w_org;

	uint8_t input_s_org = 0;
	memcpy(&input_s_org, workData + sizeof(uint8_t) * 5, sizeof(uint8_t));
	curPacket->press_s = (int)input_s_org;

	uint8_t input_a_org = 0;
	memcpy(&input_a_org, workData + sizeof(uint8_t) * 6, sizeof(uint8_t));
	curPacket->press_a = (int)input_a_org;

	uint8_t input_d_org = 0;
	memcpy(&input_d_org, workData + sizeof(uint8_t) * 7, sizeof(uint8_t));
	curPacket->press_d = (int)input_d_org;

	uint8_t input_space_org = 0;
	memcpy(&input_space_org, workData + sizeof(uint8_t) * 8, sizeof(uint8_t));
	curPacket->press_space = (int)input_space_org;

	int16_t input_mouseX_org = 0;
	memcpy(&input_mouseX_org, workData + sizeof(uint8_t) * 9, sizeof(int16_t));
	curPacket->mouseX = (int)input_mouseX_org;

	int16_t input_mouseY_org = 0;
	memcpy(&input_mouseY_org, workData + sizeof(uint8_t) * 9 + sizeof(int16_t), sizeof(int16_t));
	curPacket->mouseY = (int)input_mouseY_org;

	uint8_t input_mouseLeft_org = 0;
	memcpy(&input_mouseLeft_org, workData + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2, sizeof(uint8_t));
	curPacket->mouseLeftPress = (int)input_mouseLeft_org;

	uint8_t input_mouseRight_org = 0;
	memcpy(&input_mouseRight_org, workData + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t), sizeof(uint8_t));
	curPacket->mouseRightPress = (int)input_mouseRight_org;

	uint8_t input_mode_org = 0;
	memcpy(&input_mode_org, workData + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t) * 2, sizeof(uint8_t));
	curPacket->mode = (int)input_mode_org;

	NLfloat input_locX_org = 0.0;
	memcpy(&input_locX_org, workData + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t) * 3, sizeof(NLfloat));
	curPacket->playerLoc.x = input_locX_org;

	NLfloat input_locY_org = 0.0;
	memcpy(&input_locY_org, workData + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t) * 3 + sizeof(NLfloat), sizeof(NLfloat));
	curPacket->playerLoc.y = input_locY_org;

	NLfloat input_locZ_org = 0.0;
	memcpy(&input_locZ_org, workData + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t) * 3 + sizeof(NLfloat) * 2, sizeof(NLfloat));
	curPacket->playerLoc.z = input_locZ_org;

	NLfloat input_rotY_org = 0.0;
	memcpy(&input_rotY_org, workData + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t) * 3 + sizeof(NLfloat) * 3, sizeof(NLfloat));
	curPacket->playerRotateY = input_rotY_org;

	NLfloat input_rotX_org = 0.0;
	memcpy(&input_rotX_org, workData + sizeof(uint8_t) * 9 + sizeof(uint16_t) * 2 + sizeof(uint8_t) * 3 + sizeof(NLfloat) * 4, sizeof(NLfloat));
	curPacket->playerRotateX = input_rotX_org;
}

void TNetwork::getParticlePacket(void *data, TNeworkParticlePacket *curPacket) {
	uint8_t *workData = (uint8_t *)data;
	
	uint8_t type = 0;
	memcpy(&type, workData + sizeof(uint8_t), sizeof(uint8_t));
	curPacket->type = (char)type;

	float locX = 0;
	memcpy(&locX, workData + sizeof(uint8_t) * 2, sizeof(NLfloat));
	curPacket->x = (float)locX;
	
	float locY = 0;
	memcpy(&locY, workData + sizeof(uint8_t) * 2 + sizeof(NLfloat), sizeof(NLfloat));
	curPacket->y = (float)locY;

	float locZ = 0;
	memcpy(&locZ, workData + sizeof(uint8_t) * 2 + sizeof(NLfloat) * 2, sizeof(NLfloat));
	curPacket->z = (float)locZ;

	float velX = 0;
	memcpy(&velX, workData + sizeof(uint8_t) * 2 + sizeof(NLfloat) * 3, sizeof(NLfloat));
	curPacket->velX = (float)velX;

	float velY = 0;
	memcpy(&velY, workData + sizeof(uint8_t) * 2 + sizeof(NLfloat) * 4, sizeof(NLfloat));
	curPacket->velY = (float)velY;

	float velZ = 0;
	memcpy(&velZ, workData + sizeof(uint8_t) * 2 + sizeof(NLfloat) * 5, sizeof(NLfloat));
	curPacket->velZ = (float)velZ;

	int index = 0;
	memcpy(&index, workData + sizeof(uint8_t) * 2 + sizeof(NLfloat) * 6, sizeof(int16_t));
	curPacket->index = (float)index;
}


int TNetwork::getPacketType(void *data) {
	int packetType = 0;
	uint8_t orgType = 0;
	memcpy(&orgType, data, sizeof(uint8_t));
	packetType = (int)orgType;
	
	return packetType;
}





static void connect_Thread(void *data) {
	TNetwork *curNetwork = (TNetwork *)data;
	cout << "Starting Connect Thread...." << endl;

	while(curNetwork->getMode() == ALLOW_MODE) {
		curNetwork->processLogin();
		SDL_Delay(10);
		curNetwork->processMessages();
		SDL_Delay(10);
		nlThreadYield();
	}

	cout << "Ending Connect Thread...." << endl;
}

static void tryTo_connect_Thread(void *data) {
	TNetwork *curNetwork = (TNetwork *)data;
	curNetwork->processConnect();

}

static void network_MainThread(void *data) {
	TNetwork *curNetwork = (TNetwork *)data;
	cout << "Starting Network Thread...." << endl;
	while(curNetwork->getMode() == RUNNING_MODE) {
		curNetwork->processMessages();
		SDL_Delay(10);
		nlThreadYield();
	}
	cout << "Ending Network Thread...." << endl;
}



