/***************************************************************************
                          tlevelgen.cpp  -  description
                             -------------------
    begin                : Tue Jul 8 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "tlevelgen.h"

static int is_Space(int c)
{
	if (c == ' ' || c == '\t' || c == '\n' || c == '\r') return true;
	else return false;
}

static char * is_fgets(char *buf, int n, FILE *fp)
{
	char *wbuf;
	int c, bcnt = 0;

	if (n <= 0) return (NULL);

	wbuf = buf; n = n - 1;                   

	c = '\t';
	while(is_Space(c)) { c = getc(fp); }

	while (n != 0) {
		if (c == '\n' || c == '\r') break;
		if (c == EOF) 
			if (bcnt == 0) return NULL; else break;
		buf[bcnt] = c; bcnt++;
		n = n - 1;
		c = getc(fp);
	}

	buf[bcnt] = '\0';
	return buf;
}


TLevelGen::TLevelGen(TScene *theScene){
	curScene = theScene;
}
TLevelGen::~TLevelGen(){
}

int TLevelGen::AddRoom(float x1, float y1, float z1, float x2, float y2, float z2, int type, string groundTexture, string wallTexture, 
				string ceilingTexture, float alphaVal, float brightness, float lightR, float lightG, float lightB) {
	BasicRoom newRoom;
	newRoom.bound1.x = x1;
	newRoom.bound1.y = y1;
	newRoom.bound1.z = z1;
	newRoom.bound2.x = x2;
	newRoom.bound2.y = y2;
	newRoom.bound2.z = z2;
	newRoom.type = type;
	newRoom.alphaVal = alphaVal;
	newRoom.groundTexture = groundTexture;
	newRoom.wallTexture = wallTexture;
	newRoom.ceilingTexture = ceilingTexture;
	
	newRoom.lightR = lightR;
	newRoom.lightG = lightG;
	newRoom.lightB = lightB;
	newRoom.brightness  = brightness;
	Vector midPnt;
	Vadd(&newRoom.bound1, &newRoom.bound2, &midPnt);
	Vscale(&midPnt, 0.5);
	newRoom.lightPos = midPnt;
	newRoom.lightPos.y = 0.0;
	newRoom.eyePos = midPnt;
	
	BasicRooms.push_back(newRoom);
	
	return BasicRooms.size() - 1;
}

void TLevelGen::LinkRooms(int index1, int index2, float width, float height, int side, float offsetRatio) {
	LinkRoom newLink;
	
	newLink.width = width;
	newLink.height = height;
	newLink.index1 = index1;
	newLink.index2= index2;
	newLink.side = side;
	newLink.offsetRatio = offsetRatio;
	
	LinkList.push_back(newLink);
}

//generates the level and writes it to a scene file
int TLevelGen::GenerateLevel(char *filename) {
	FILE *file;
	file = fopen(filename, "w");
	
	if (file == NULL) {
		cout << "Could not save " << filename << "." << endl;
		return SAVE_ERROR;
  	}
	
	//write out the sectors
	fprintf(file, "#Define the Sectors\n");
	for(int i = 0; i < BasicRooms.size(); i++) {
		fprintf(file, "SECTOR %f, %f, %f %f, %f, %f\n", BasicRooms[i].bound1.x, BasicRooms[i].bound1.y, BasicRooms[i].bound1.z,
					 BasicRooms[i].bound2.x,  BasicRooms[i].bound2.y,  BasicRooms[i].bound2.z);
	}
	
	fprintf(file, "\n#Define the Windows\n");
	//write out the windows
	for(i = 0; i < LinkList.size(); i++) {
		//decide which part of room is linked to the other
		Vector winBnd1, winBnd2;
		int index1, index2;
		index1 = LinkList[i].index1;
		index2 = LinkList[i].index2;
		
		switch(LinkList[i].side) {
			case LEFT_SIDE:
				winBnd1.x = BasicRooms[index1].bound1.x;
				winBnd1.y = BasicRooms[index1].bound1.y;
				winBnd1.z = (BasicRooms[index1].bound2.z - BasicRooms[index1].bound1.z) * LinkList[i].offsetRatio + BasicRooms[index1].bound1.z;
				
				winBnd2.x = BasicRooms[index1].bound1.x;
				winBnd2.y = BasicRooms[index1].bound1.y + LinkList[i].height;
				winBnd2.z = winBnd1.z + LinkList[i].width;
			break;
			
			case RIGHT_SIDE:
				winBnd1.x = BasicRooms[index1].bound2.x;
				winBnd1.y = BasicRooms[index1].bound1.y;
				winBnd1.z = (BasicRooms[index1].bound2.z - BasicRooms[index1].bound1.z) * LinkList[i].offsetRatio + BasicRooms[index1].bound1.z;
				
				winBnd2.x = BasicRooms[index1].bound2.x;
				winBnd2.y = BasicRooms[index1].bound1.y + LinkList[i].height;
				winBnd2.z = winBnd1.z + LinkList[i].width;
			break;
			
			case FRONT_SIDE:
				winBnd1.x = (BasicRooms[index1].bound2.x - BasicRooms[index1].bound1.x) * LinkList[i].offsetRatio + BasicRooms[index1].bound1.x;
				winBnd1.y = BasicRooms[index1].bound1.y;
				winBnd1.z = BasicRooms[index1].bound2.z;
				
				winBnd2.x = winBnd1.x + LinkList[i].width;
				winBnd2.y = BasicRooms[index1].bound1.y + LinkList[i].height;
				winBnd2.z = BasicRooms[index1].bound2.z;
			break;
			
			case BACK_SIDE:
				winBnd1.x = (BasicRooms[index1].bound2.x - BasicRooms[index1].bound1.x) * LinkList[i].offsetRatio + BasicRooms[index1].bound1.x;
				winBnd1.y = BasicRooms[index1].bound1.y;
				winBnd1.z = BasicRooms[index1].bound1.z;
				
				winBnd2.x = winBnd1.x + LinkList[i].width;
				winBnd2.y = BasicRooms[index1].bound1.y + LinkList[i].height;
				winBnd2.z = BasicRooms[index1].bound1.z;
			break;
		}
		
		fprintf(file, "WINDOW %f, %f, %f %f, %f, %f\n", winBnd1.x, winBnd1.y, winBnd1.z,
				 winBnd2.x,  winBnd2.y,  winBnd2.z);
		LinkList[i].bnd1 = winBnd1;
		LinkList[i].bnd2 = winBnd2;
	}
	
	fprintf(file, "\n#Define the Links\n");
	//write out the links
	for(i = 0; i < LinkList.size(); i++) {
		fprintf(file, "LINK %d %d %d\n", LinkList[i].index1, LinkList[i].index2, i);
	}
	
	//write out lights
	fprintf(file, "\n#Define the lights\n");
	for(i = 0; i < BasicRooms.size(); i++) {
		if(BasicRooms[i].brightness > 0.0) {
			fprintf(file, "light %f, %f, %f %f, %f, %f %f %f, %f, %f %d\n",BasicRooms[i].lightPos.x, BasicRooms[i].lightPos.y, BasicRooms[i].lightPos.z, BasicRooms[i].eyePos.x, BasicRooms[i].eyePos.y, BasicRooms[i].eyePos.z,
						BasicRooms[i].brightness, BasicRooms[i].lightR, BasicRooms[i].lightG, BasicRooms[i].lightB, i);
		}
	}
	
	fprintf(file, "\n#Define the Rooms\n");
	//now create the actual rooms... formed by a series of TPlane objects
	for(i = 0; i < BasicRooms.size(); i++) {
		texturePacket groundTex = GetTexPacket(BasicRooms[i].groundTexture);
		texturePacket wallTex = GetTexPacket(BasicRooms[i].wallTexture);
		texturePacket ceilingTex = GetTexPacket(BasicRooms[i].ceilingTexture);
		Vector roomMidPnt;
		Vadd(&BasicRooms[i].bound1, &BasicRooms[i].bound2, &roomMidPnt);
		Vscale(&roomMidPnt, 0.5);
		float scaleX = fabs(BasicRooms[i].bound2.x - BasicRooms[i].bound1.x);
		float scaleY = fabs(BasicRooms[i].bound2.y - BasicRooms[i].bound1.y);
		float scaleZ = fabs(BasicRooms[i].bound2.z - BasicRooms[i].bound1.z) ;
		Vector MaxBnd = BasicRooms[i].bound2;
		Vector MinBnd = BasicRooms[i].bound1;
		fprintf(file, "\n#Room: %i  Min Bound: (%f, %f, %f)  Max Bound: (%f, %f, %f)\n\n", i,
			MinBnd.x, MinBnd.y, MinBnd.z, MaxBnd.x, MaxBnd.y, MaxBnd.z);
		
		//do the basic floor / ceiling first
		if(BasicRooms[i].type != NO_CEILING_REFLECT && BasicRooms[i].type != WITH_CEILING_REFLECT) {
			fprintf(file, "PLANE %f, %f, %f %f, %f, %f %f, %f, %f %s %s %d %d %d %d %f %f %d\n", 
				roomMidPnt.x, MinBnd.y, roomMidPnt.z, scaleX * 0.5, scaleZ * 0.5, 1.0, -90.0, 0.0, 0.0,
				groundTex.decalTexture.c_str(), groundTex.bumpTexture.c_str(), groundTex.shadow, groundTex.diffuse, groundTex.specular, groundTex.attenuate, groundTex.bumpScale,
				groundTex.tileFactor, i);
		}
		else {
			fprintf(file, "REFLECTOR %f, %f, %f %f, %f, %f %f, %f, %f %s %s %f %d %d %d %f %f %d\n", 
				roomMidPnt.x, MinBnd.y, roomMidPnt.z, scaleX * 0.5, scaleZ * 0.5, 1.0, -90.0, 0.0, 0.0,
				groundTex.decalTexture.c_str(), groundTex.bumpTexture.c_str(), BasicRooms[i].alphaVal, groundTex.diffuse, groundTex.specular, groundTex.attenuate, groundTex.bumpScale,
				groundTex.tileFactor, i);
		}
		
		//see if we need to do the ceiling
		if(BasicRooms[i].type == WITH_CEILING || BasicRooms[i].type == WITH_CEILING_REFLECT) {
			fprintf(file, "PLANE %f, %f, %f %f, %f, %f %f, %f, %f %s %s %d %d %d %d %f %f %d\n", 
				roomMidPnt.x, MaxBnd.y, roomMidPnt.z, scaleX * 0.5, scaleZ * 0.5, 1.0, -90.0, 0.0, 0.0,
				ceilingTex.decalTexture.c_str(), ceilingTex.bumpTexture.c_str(), ceilingTex.shadow, ceilingTex.diffuse, ceilingTex.specular, ceilingTex.attenuate, ceilingTex.bumpScale,
				ceilingTex.tileFactor, i);
		}
		
		
		vector<int> leftList = GetNumLinkedLeft(i);
		vector<int> rightList = GetNumLinkedRight(i);
		vector<int> frontList = GetNumLinkedFront(i);
		vector<int> backList = GetNumLinkedBack(i);
		float startX, startY, startZ;
		float endX, endY, endZ;
		
		//do the left wall
		SectionPacket initial;
		initial.Bnd1 = MinBnd;
		initial.Bnd2 = MinBnd;
		initial.Bnd2.z = MaxBnd.z;
		if(leftList.size() > 0) cout << "LeftList: " << leftList[0] << endl;
		vector <SectionPacket> WallsListLeft = GetSectionPacketLeft(leftList, initial);

		for(int k = 0; k < WallsListLeft.size(); k++) {
			Vector curMidPnt; curMidPnt.x = 0; curMidPnt.y = 0; curMidPnt.z = 0;
			Vadd(&WallsListLeft[k].Bnd1, &WallsListLeft[k].Bnd2, &curMidPnt);
			Vscale(&curMidPnt, 0.5f);
			float WallScaleX = fabs(WallsListLeft[k].Bnd2.z - WallsListLeft[k].Bnd1.z);
			
			if(WallsListLeft[k].active)
			fprintf(file, "PLANE %f, %f, %f %f, %f, %f %f, %f, %f %s %s %d %d %d %d %f %f %d\n", 
				MinBnd.x + 1.0, roomMidPnt.y, curMidPnt.z, WallScaleX * 0.5, scaleY * 0.5, 1.0, 0.0, -90.0, 0.0,
				wallTex.decalTexture.c_str(), wallTex.bumpTexture.c_str(), wallTex.shadow, wallTex.diffuse, wallTex.specular, wallTex.attenuate, wallTex.bumpScale,
				wallTex.tileFactor, i);
		}

		//do the right wall
		initial.Bnd1 = MinBnd;
		initial.Bnd2 = MinBnd;
		initial.Bnd1.x = MaxBnd.x;
		initial.Bnd2.x = MaxBnd.x;
		initial.Bnd2.z = MaxBnd.z;
		if(rightList.size() > 0) cout << "RightList: " << rightList[0] << endl;
		vector <SectionPacket> WallsListRight = GetSectionPacketLeft(rightList, initial);
		
		for(k = 0; k < WallsListRight.size(); k++) {
			Vector curMidPnt;
			Vadd(&WallsListRight[k].Bnd1, &WallsListRight[k].Bnd2, &curMidPnt);
			Vscale(&curMidPnt, 0.5f);
			float WallScaleX = fabs(WallsListRight[k].Bnd2.z - WallsListRight[k].Bnd1.z);
			
			if(WallsListRight[k].active)
			fprintf(file, "PLANE %f, %f, %f %f, %f, %f %f, %f, %f %s %s %d %d %d %d %f %f %d\n", 
				MaxBnd.x - 1.0, roomMidPnt.y, curMidPnt.z, WallScaleX * 0.5, scaleY * 0.5, 1.0, 0.0, -90.0, 0.0,
				wallTex.decalTexture.c_str(), wallTex.bumpTexture.c_str(), wallTex.shadow, wallTex.diffuse, wallTex.specular, wallTex.attenuate, wallTex.bumpScale,
				wallTex.tileFactor, i);
		}
		//do the front wall
		initial.Bnd1 = MinBnd;
		initial.Bnd2 = MinBnd;
		initial.Bnd2.x = MaxBnd.x;
		if(frontList.size() > 0) cout << "FrontList: " << frontList[0] << endl;
		vector <SectionPacket> WallsListFront = GetSectionPacketFront(frontList, initial);
		
		for(k = 0; k < WallsListFront.size(); k++) {
			Vector curMidPnt;
			Vadd(&WallsListFront[k].Bnd1, &WallsListFront[k].Bnd2, &curMidPnt);
			Vscale(&curMidPnt, 0.5f);
			float WallScaleX = fabs(WallsListFront[k].Bnd2.x - WallsListFront[k].Bnd1.x);
			
			if(WallsListFront[k].active)
			fprintf(file, "PLANE %f, %f, %f %f, %f, %f %f, %f, %f %s %s %d %d %d %d %f %f %d\n", 
				curMidPnt.x, roomMidPnt.y, MaxBnd.z - 1.0, WallScaleX * 0.5, scaleY * 0.5, 1.0, 0.0, 0.0, 0.0,
				wallTex.decalTexture.c_str(), wallTex.bumpTexture.c_str(), wallTex.shadow, wallTex.diffuse, wallTex.specular, wallTex.attenuate, wallTex.bumpScale,
				wallTex.tileFactor, i);
		}

		//do the back wall
		initial.Bnd1 = MinBnd;
		initial.Bnd2 = MinBnd;
		initial.Bnd2.x = MaxBnd.x;
		initial.Bnd1.z = MaxBnd.z;
		initial.Bnd2.z = MaxBnd.z;
		if(backList.size() > 0) cout << "BackList: " << backList[0] << endl;
		vector <SectionPacket> WallsListBack = GetSectionPacketBack(backList, initial);
		
		cout << "Walls Back Size: " << WallsListBack.size() << endl;
		for(k = 0; k < WallsListBack.size(); k++) {
			Vector curMidPnt;
			Vadd(&WallsListBack[k].Bnd1, &WallsListBack[k].Bnd2, &curMidPnt);
			Vscale(&curMidPnt, 0.5f);
			float WallScaleX = fabs(WallsListBack[k].Bnd2.x - WallsListBack[k].Bnd1.x);
			
			if(WallsListBack[k].active)
			fprintf(file, "PLANE %f, %f, %f %f, %f, %f %f, %f, %f %s %s %d %d %d %d %f %f %d\n", 
				curMidPnt.x, roomMidPnt.y, MinBnd.z + 1.0, WallScaleX * 0.5, scaleY * 0.5, 1.0, 0.0, 0.0, 0.0,
				wallTex.decalTexture.c_str(), wallTex.bumpTexture.c_str(), wallTex.shadow, wallTex.diffuse, wallTex.specular, wallTex.attenuate, wallTex.bumpScale,
				wallTex.tileFactor, i);
		}
										
	}

	//now write out the Md2 objects
	for(i = 0; i < md2StringArray.size(); i++) {
		fprintf(file, "%s\n", md2StringArray[i].c_str());
	}
	
	//write out additionally defined light objects
	for(i = 0; i < lightStringArray.size(); i++) {
		fprintf(file, "%s\n", lightStringArray[i].c_str());
	}

	fclose(file);
	
	return true;	
}

void TLevelGen::AddTexturePacket(string name, string decalTexture, string bumpTexture, bool shadow, bool diffuse, bool specular, bool attenuate,
					float bumpScale, float tileFactor) {
	texturePacket newTexturePacket;
	
	newTexturePacket.name = name;
	newTexturePacket.decalTexture = decalTexture;
	newTexturePacket.bumpTexture = bumpTexture;
	newTexturePacket.shadow = shadow;
	newTexturePacket.diffuse = diffuse;
	newTexturePacket.specular = specular;
	newTexturePacket.attenuate = attenuate;
	newTexturePacket.bumpScale = bumpScale;
	newTexturePacket.tileFactor = tileFactor;

	texPackList.push_back(newTexturePacket);
}

texturePacket TLevelGen::GetTexPacket(string name) {
	texturePacket empty;
	empty.name = "";
	
	for(int i = 0; i < texPackList.size(); i++) {
		if(texPackList[i].name == name) return texPackList[i];
	}
	
	return empty;
}

vector<int> TLevelGen::GetNumLinkedLeft(int index) {
	vector<int> retList;
	
	for(int i = 0; i < LinkList.size(); i++) {
		if(LinkList[i].index1 == index) {
			if(LinkList[i].side == LEFT_SIDE) {retList.push_back(i);}
		}
		else if(LinkList[i].index2 == index) {
			if(LinkList[i].side == RIGHT_SIDE) {retList.push_back(i);}
		}
	}
	
	return retList;
}

vector<int> TLevelGen::GetNumLinkedRight(int index) {
	vector<int> retList;
	
	for(int i = 0; i < LinkList.size(); i++) {
		if(LinkList[i].index1 == index) {
			if(LinkList[i].side == RIGHT_SIDE) retList.push_back(i);
		}
		else if(LinkList[i].index2 == index) {
			if(LinkList[i].side == LEFT_SIDE) retList.push_back(i);
		}
	}
	
	return retList;
}

vector<int> TLevelGen::GetNumLinkedFront(int index) {
	vector<int> retList;
	
	for(int i = 0; i < LinkList.size(); i++) {
		if(LinkList[i].index1 == index) {
			if(LinkList[i].side == FRONT_SIDE) retList.push_back(i);
		}
		else if(LinkList[i].index2 == index) {
			if(LinkList[i].side == BACK_SIDE) retList.push_back(i);
		}
	}
	
	return retList;
}

vector<int> TLevelGen::GetNumLinkedBack(int index) {
	vector<int> retList;
	
	for(int i = 0; i < LinkList.size(); i++) {
		if(LinkList[i].index1 == index) {
			if(LinkList[i].side == BACK_SIDE) retList.push_back(i);
		}
		else if(LinkList[i].index2 == index) {
			if(LinkList[i].side == FRONT_SIDE) retList.push_back(i);
		}
	}
	
	return retList;
}

vector<SectionPacket> TLevelGen::GetSectionPacketLeft(vector<int> sectionList, SectionPacket initial) {
	vector<SectionPacket> retList;
	initial.active = true;
	retList.push_back(initial);
	
	for(int i = 0; i < sectionList.size(); i++) {
		int curIndex = sectionList[i];
		for(int j = 0; j < retList.size(); j++) {
			if(LinkList[curIndex].bnd1.z <= retList[j].Bnd1.z &&  LinkList[curIndex].bnd2.z > retList[j].Bnd1.z && retList[j].active) {
				if(LinkList[curIndex].bnd2.z < retList[j].Bnd2.z) {
					retList[j].active = false;
					SectionPacket newSection;
					newSection.Bnd1 = retList[j].Bnd1;
					newSection.Bnd1.z = LinkList[curIndex].bnd2.z;
					newSection.Bnd2 = retList[j].Bnd2;
					newSection.active = true;
					retList.push_back(newSection);
				}
				else {
					retList[j].active = false;
				}
			}
		
			else if(LinkList[curIndex].bnd1.z > retList[j].Bnd1.z &&  LinkList[curIndex].bnd2.z > retList[j].Bnd1.z 
				&& LinkList[curIndex].bnd1.z < retList[j].Bnd2.z && retList[j].active) {
				if(LinkList[curIndex].bnd2.z < retList[j].Bnd2.z) {
					retList[j].active = false;
					SectionPacket newSection;
					newSection.Bnd1 = retList[j].Bnd1;
					newSection.Bnd2 = retList[j].Bnd2;
					newSection.Bnd2.z = LinkList[curIndex].bnd1.z;
					newSection.active = true;
					retList.push_back(newSection);
					
					SectionPacket newSection2;
					newSection2.Bnd1 = retList[j].Bnd1;
					newSection2.Bnd2 = retList[j].Bnd2;
					newSection2.Bnd1.z = LinkList[curIndex].bnd2.z;
					newSection2.active = true;
					retList.push_back(newSection2);
				}
				else {
					retList[j].active = false;
					SectionPacket newSection;
					newSection.Bnd1 = retList[j].Bnd1;
					newSection.Bnd2 = retList[j].Bnd2;
					newSection.Bnd2.z = LinkList[curIndex].bnd1.z;
					newSection.active = true;
					retList.push_back(newSection);
				}
			}
		}
	}
	
	return retList;
}

vector<SectionPacket> TLevelGen::GetSectionPacketRight(vector<int> sectionList, SectionPacket initial) {
	vector<SectionPacket> retList;
	initial.active = true;
	retList.push_back(initial);
	
	for(int i = 0; i < sectionList.size(); i++) {
		int curIndex = sectionList[i];
		for(int j = 0; j < retList.size(); j++) {
			if(LinkList[curIndex].bnd1.z <= retList[j].Bnd1.z &&  LinkList[curIndex].bnd2.z > retList[j].Bnd1.z && retList[j].active) {
				if(LinkList[curIndex].bnd2.z < retList[j].Bnd2.z) {
					retList[j].active = false;
					SectionPacket newSection;
					newSection.Bnd1 = retList[j].Bnd1;
					newSection.Bnd1.z = LinkList[curIndex].bnd2.z;
					newSection.Bnd2 = retList[j].Bnd2;
					newSection.active = true;
					retList.push_back(newSection);
				}
				else {
					retList[j].active = false;
				}
			}
		
			else if(LinkList[curIndex].bnd1.z > retList[j].Bnd1.z &&  LinkList[curIndex].bnd2.z > retList[j].Bnd1.z 
				&& LinkList[curIndex].bnd1.z < retList[j].Bnd2.z && retList[j].active) {
				if(LinkList[curIndex].bnd2.z < retList[j].Bnd2.z) {
					retList[j].active = false;
					SectionPacket newSection;
					newSection.Bnd1 = retList[j].Bnd1;
					newSection.Bnd2 = retList[j].Bnd2;
					newSection.Bnd2.z = LinkList[curIndex].bnd1.z;
					newSection.active = true;
					retList.push_back(newSection);
					
					SectionPacket newSection2;
					newSection2.Bnd1 = retList[j].Bnd1;
					newSection2.Bnd2 = retList[j].Bnd2;
					newSection2.Bnd1.z = LinkList[curIndex].bnd2.z;
					newSection2.active = true;
					retList.push_back(newSection2);
				}
				else {
					retList[j].active = false;
					SectionPacket newSection;
					newSection.Bnd1 = retList[j].Bnd1;
					newSection.Bnd2 = retList[j].Bnd2;
					newSection.Bnd2.z = LinkList[curIndex].bnd1.z;
					newSection.active = true;
					retList.push_back(newSection);
				}
			}
		}
	}
	
	return retList;
}

vector<SectionPacket> TLevelGen::GetSectionPacketFront(vector<int> sectionList, SectionPacket initial) {
	vector<SectionPacket> retList;
	initial.active = true;
	retList.push_back(initial);
	
	for(int i = 0; i < sectionList.size(); i++) {
		int curIndex = sectionList[i];
		for(int j = 0; j < retList.size(); j++) {
			if(LinkList[curIndex].bnd1.x <= retList[j].Bnd1.x &&  LinkList[curIndex].bnd2.x > retList[j].Bnd1.x && retList[j].active) {
				if(LinkList[curIndex].bnd2.x < retList[j].Bnd2.x) {
					retList[j].active = false;
					SectionPacket newSection;
					newSection.Bnd1 = retList[j].Bnd1;
					newSection.Bnd1.x = LinkList[curIndex].bnd2.x;
					newSection.Bnd2 = retList[j].Bnd2;
					newSection.active = true;
					retList.push_back(newSection);
				}
				else {
					retList[j].active = false;
				}
			}
		
			else if(LinkList[curIndex].bnd1.x > retList[j].Bnd1.x &&  LinkList[curIndex].bnd2.x > retList[j].Bnd1.x 
				&& LinkList[curIndex].bnd1.x < retList[j].Bnd2.x && retList[j].active) {
				if(LinkList[curIndex].bnd2.x < retList[j].Bnd2.x) {
					retList[j].active = false;
					SectionPacket newSection;
					newSection.Bnd1 = retList[j].Bnd1;
					newSection.Bnd2 = retList[j].Bnd2;
					newSection.Bnd2.x = LinkList[curIndex].bnd1.x;
					newSection.active = true;
					retList.push_back(newSection);
					
					SectionPacket newSection2;
					newSection2.Bnd1 = retList[j].Bnd1;
					newSection2.Bnd2 = retList[j].Bnd2;
					newSection2.Bnd1.x = LinkList[curIndex].bnd2.x;
					newSection2.active = true;
					retList.push_back(newSection2);
				}
				else {
					retList[j].active = false;
					SectionPacket newSection;
					newSection.Bnd1 = retList[j].Bnd1;
					newSection.Bnd2 = retList[j].Bnd2;
					newSection.Bnd2.x = LinkList[curIndex].bnd1.x;
					newSection.active = true;
					retList.push_back(newSection);
				}
			}
		}
	}
	
	return retList;
}

vector<SectionPacket> TLevelGen::GetSectionPacketBack(vector<int> sectionList, SectionPacket initial) {
	vector<SectionPacket> retList;
	initial.active = true;
	retList.push_back(initial);
	
	for(int i = 0; i < sectionList.size(); i++) {
		int curIndex = sectionList[i];
		for(int j = 0; j < retList.size(); j++) {
			if(LinkList[curIndex].bnd1.x <= retList[j].Bnd1.x &&  LinkList[curIndex].bnd2.x > retList[j].Bnd1.x && retList[j].active) {
				if(LinkList[curIndex].bnd2.x < retList[j].Bnd2.x) {
					retList[j].active = false;
					SectionPacket newSection;
					newSection.Bnd1 = retList[j].Bnd1;
					newSection.Bnd1.x = LinkList[curIndex].bnd2.x;
					newSection.Bnd2 = retList[j].Bnd2;
					newSection.active = true;
					retList.push_back(newSection);
				}
				else {
					retList[j].active = false;
				}
			}
		
			else if(LinkList[curIndex].bnd1.x > retList[j].Bnd1.x &&  LinkList[curIndex].bnd2.x > retList[j].Bnd1.x 
				&& LinkList[curIndex].bnd1.x < retList[j].Bnd2.x && retList[j].active) {
				if(LinkList[curIndex].bnd2.x < retList[j].Bnd2.x) {
					retList[j].active = false;
					SectionPacket newSection;
					newSection.Bnd1 = retList[j].Bnd1;
					newSection.Bnd2 = retList[j].Bnd2;
					newSection.Bnd2.x = LinkList[curIndex].bnd1.x;
					newSection.active = true;
					retList.push_back(newSection);
					
					SectionPacket newSection2;
					newSection2.Bnd1 = retList[j].Bnd1;
					newSection2.Bnd2 = retList[j].Bnd2;
					newSection2.Bnd1.x = LinkList[curIndex].bnd2.x;
					newSection2.active = true;
					retList.push_back(newSection2);
				}
				else {
					retList[j].active = false;
					SectionPacket newSection;
					newSection.Bnd1 = retList[j].Bnd1;
					newSection.Bnd2 = retList[j].Bnd2;
					newSection.Bnd2.x = LinkList[curIndex].bnd1.x;
					newSection.active = true;
					retList.push_back(newSection);
				}
			}
		}
	}
	
	return retList;
}

void TLevelGen::GenerateDefaultTextures() {
	AddTexturePacket("stone1", "camo2.tga", "camo.tga", false, true, false, false, 2.0f, 4.0f);
	AddTexturePacket("stone2", "camo2.tga", "camo.tga", false, false, false, true, 2.0f, 4.0f);
}

int TLevelGen::LoadTextureList(char *filename) {
	FILE *file;
	char buf[256], *gotbuf;
	char name[256], texName[256], bumpName[256], decalName[256];
	int matches, specTrue, diffuseTrue, shadowTrue, attenuateTrue, animation, smoothness, windowIndex, sectorIndex, flipnormal;
	float x, y, z, scale, rotate, bscale, tileFactor, brightness, red, green, blue, alphaval;
	Vector vec1, vec2, vec3, vec4;
	
	file = fopen(filename, "r");
	if (file == NULL) {
		cout << "Could not load " << filename << "." << endl;
		return -1;
 	 }
	 
	 	while (!feof(file)) {
			gotbuf = is_fgets(buf, sizeof(buf), file);
			if (gotbuf) {
				switch(buf[0]) {
					case '#':
					break;

					case 'T':
						matches = sscanf(buf, "TEXTURE %s %s %s %d %d %d %d %f %f\n",
									texName, decalName, bumpName, &shadowTrue, &diffuseTrue, &specTrue,
									&attenuateTrue, &bscale, &tileFactor);
						if (matches == 9) {
							AddTexturePacket(texName, decalName, bumpName, shadowTrue, diffuseTrue, specTrue,
										attenuateTrue, bscale, tileFactor);
						} else {fclose(file); cout << "Bad Parse for TEXTURE!" << endl; return -1;}
					break;
				}
			}
		}
		
		return true;

}


int TLevelGen::LoadRoomGen(char *filename) {
	FILE *file;
	char buf[256], *gotbuf;
	char name[256], texName[256], bumpName[256], decalName[256], groundTex[256], wallTex[256], ceilingTex[256];
	int matches, specTrue, diffuseTrue, shadowTrue, attenuateTrue, animation, smoothness, windowIndex, sectorIndex, flipnormal;
	int index1, index2, roomcnt, linkcnt;
	int roomType, sideType;
	float x, y, z, scale, rotate, bscale, tileFactor, brightness, red, green, blue, alphaval, offsetRatio;
	Vector vec1, vec2, vec3, vec4;

	md2StringArray.clear();
	
	file = fopen(filename, "r");
	if (file == NULL) {
		cout << "Could not load " << filename << "." << endl;
		return -1;
	}
	
	roomcnt = 0;
	linkcnt = 0;
	 
 	while (!feof(file)) {
		gotbuf = is_fgets(buf, sizeof(buf), file);
		if (gotbuf) {
			switch(buf[0]) {
				case '#':
				break;
				case 'A':
					//ADD x1, y1, z1, x2, y2, z2 type groundTexture wallTexture ceilingTexture alphaVal brightness r, g, b
					matches = sscanf(buf, "ADD %f, %f, %f %f, %f, %f %d %s %s %s %f %f %f, %f, %f\n",
								&vec1.x, &vec1.y, &vec1.z, &vec2.x, &vec2.y, &vec2.z, &roomType,
								groundTex, wallTex, ceilingTex, &alphaval, &brightness, &red, &green, &blue);
								
								
					if (matches == 15) {
						AddRoom(vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, roomType, groundTex, wallTex,
								ceilingTex, alphaval, brightness, red, green, blue);
						roomcnt++;
						
					} else {fclose(file); cout << "Bad Parse for ADD(add room)!" << endl; return -1;}
				break;			
				
				case 'L':
					//LINK index1 index2 width height side offsetRatio
					matches = sscanf(buf, "LINK %d %d %f %f %d %f\n",
								&index1, &index2, &vec1.x, &vec1.y, &sideType, &offsetRatio);
								
					if (matches == 6) {
						LinkRooms(index1, index2, vec1.x, vec1.y, sideType, offsetRatio);
						linkcnt++;
						
					} else {fclose(file); cout << "Bad Parse for ADD(add room)!" << endl; return -1;}
					
				break;
				
				case 'M':
					matches = sscanf(buf, "MD2 %s %f, %f, %f %f, %f, %f %f, %f, %f %s %s %d %d %d %d %f %d %d %d", name,
										&vec1.x, &vec1.y, &vec1.z, &vec2.x, &vec2.y, &vec2.z, &vec3.x, &vec3.y, &vec3.z,
										decalName, bumpName, &shadowTrue, &diffuseTrue, &specTrue, &attenuateTrue, &bscale, &animation, &smoothness, &flipnormal);
					if(matches == 20) {
						string newString = buf;
						md2StringArray.push_back(newString);
					} else {fclose(file); cout << "Bad Parse for ADD(add room)!" << endl; return -1;}
				break;
				
				case 'l':
					matches = sscanf(buf, "light %f, %f, %f %f, %f, %f %f %f, %f, %f %d\n",&vec1.x, &vec1.y, &vec1.z, &vec2.x, &vec2.y, &vec2.z,
										&brightness, &red, &green, &blue, &sectorIndex);
					if (matches == 11) {
						string newString = buf;
						lightStringArray.push_back(newString);
					} else {fclose(file); cout << "Bad Parse for light!" << endl; return BAD_PARSE;}
				break;
			}
		}
	}
	
	cout << "Loaded file: " << filename << " has " << roomcnt << " rooms and " << linkcnt << " linkages." << endl;
	return true;
}



