/***************************************************************************
                          tlabel.cpp  -  description
                             -------------------
    begin                : Mon Jul 28 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "tlabel.h"

TLabel::TLabel(TInfrastructure *theInfrastructure){
	Initialize(theInfrastructure);
	x = 0;
	y = 0;
}

TLabel::~TLabel(){
}

void TLabel::render(int X, int Y) {
	if(!visible) {
		if(renderAlpha > 0.0) {
			renderAlpha = renderAlpha - 0.1;
		}
	}
	else {
		if(renderAlpha < alpha) {
			renderAlpha = renderAlpha + 0.1;
		}
	}
	
	if(renderAlpha <= 0.0) return;
	glColor4f(r1, g1, b1, renderAlpha);
	curInfrastructure->screenPrint(X + this->x, Y + this->y, (char *)showTitle.c_str(), (int)curFont, 1.0, 1.0);
	glDisable( GL_DEPTH_TEST );
	glDisable(GL_CULL_FACE );
}

void TLabel::setFont(int fontset, char *title) {
	showTitle = title;
	curFont = fontset;
}

void TLabel::inputMouseDown(int x, int y) {
	callMouseDown(x, y);
}

void TLabel::inputMouseUp(int x, int y) {
	callMouseUp(x, y);

}

void TLabel::show(bool flag) { 
	visible = flag;
}


