/***************************************************************************
                          tfps.h  -  description
                             -------------------
    begin                : Mon Jul 14 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TFPS_H
#define TFPS_H

#include "tscene.h"

const int MELEE_TYPE = 50;
const int PISTOL_TYPE = 51;
const int EXPLOSIVE_TYPE = 52;
const int FLAME_TYPE = 53;
const int EXPLOSION1 = 100;
const int SHIELD_HEALTH_TYPE = 54;
const int SHIELD_QUAD_DAMAGE_TYPE = 55;
const int CANNON_SHOT_TYPE = 4;
const int MOUSE_SHOT_TYPE = 11;

const int NO_SELECT = -1;
const int MELEE_SELECT = 0;
const int SECONDARY_SELECT = 1;
const int PRIMARY_SELECT = 2;



const int FLAME_PICK_SIT = 200;
const int CROSSBOW_PICK_SIT = 201;
const int SHIELD_HEALTH_PICK_SIT = 202;
const int SHIELD_QUAD_DAMAGE_PICK_SIT = 203;
const int MOUSE_WINS = 205;
const int HUMAN_WINS = 206;

/**
  *@author Chong Jiayi
  */
  
  struct DisplayWeapon {
	TMd2 *curObject;
	Vector offset;
	Vector scaleOffset;
	Vector rotOffset;
	int type;
  };
  
  struct DisplayAmmo {
	int type;
	vector<GLuint> rasterImage;
	float radius;
  };
  
  /* How does the whole weapon/ammo thing fit into the big picture?
   We define the GamerWeapon types first(what kind of damage, type etc. it is) for the player.
   We then load the DisplayWeapon and DisplayAmmo types from a file. DisplayWeapon/Ammo types have a 
   parameter called type that links that particular weapon or ammo to the one defined in GamerWeapon. In other words,
   it is just the display model of the weapon/ammo. The actual properties of the weapon/ammo are defined in the GamerWeapon/
   GamerAmmo data structures.
  */
  
  struct DeleteParticle {
  	int type;
	int owner;
  };
  
  

const int JUMP_LIMIT = 10;

class TFPS :public TScene  {
 
 protected:
 	string statusText;
	int statusFrameLimit;
	int statusCurFrame;
	bool triggerRelease;
	bool shotFired;
	bool loadedOnce;
	Uint16 leftBind;
	Uint16 rightBind;
	Uint16 forwardBind;
	Uint16 backwardsBind;
	Uint16 jumpBind;
	int IDgen;
	int weaponLightID;
	int timeShot;
	float rotHorizDelta;
	float rotVertDelta;
	float meleeRotDelta;
	float meleeRotSwitch;
	float horzDisp;
	float vertDisp;
	float jumpDisp;
	int jumpCnt;
	float viewXDisp, viewYDisp, viewZDisp, viewAngleX, viewAngleY, viewAngleZ;
	float gravity;
	float weaponLightBrightness;
	float weaponLightR, weaponLightG, weaponLightB;
	GamerPacket FPSGamePacket;
	vector <DisplayWeapon> WeaponList;
	vector <DisplayAmmo> AmmoList;
	void AddMd2Weapon(TMd2 *curObject, Vector offset, Vector scaleOffset, Vector rotOffset, int type);
	void AddAmmo(int r1, int g1, int b1, int r2, int g2, int b2, int type);
	int GetWeaponIndex(int type);
	GLuint GetAmmoIndex(int type);
	int curSituation;
	
	
	slist<slist<GamerAmmo> > AmmoParticles;
	void shootAmmo(int owner, int type, Vector vel, Vector startLoc, Vector *rotVec, int sectorIndex);
	void deleteAmmo(int ID);
	void ParticlesIntersect();
	
	void statusTextSet(char *text) { statusText = text; statusCurFrame = 0;}

	int getGameTypeIndex(int type);
	
	
public: 
	TFPS(TInfrastructure *theInfrastructure);
	~TFPS();
	void userInput(Uint16 key); 
	void userKeyUp(Uint16 key); 
	void mouseInput(int mouseXrel, int mouseYrel, bool leftPress, bool rightPress); 
	void setMovement(float xDisp, float yDisp, float jDisp, float xRot, float yRot);
	void setKeyBind(int left, int right, int forward, int backwards, int jump);
	void MoveFPSViewerDelta(GLfloat dispX, GLfloat dispY, GLfloat dispZ, GLfloat rotX, GLfloat rotY, GLfloat rotZ);
	void MoveFPSViewerDelta2(GLfloat dispX, GLfloat dispY, GLfloat dispZ, GLfloat rotX, GLfloat rotY, GLfloat rotZ);
	void PlaceFPSViewer(Vector loc);
	Vector GetFPSViewerMoveDelta(GLfloat dispX, GLfloat dispY, GLfloat dispZ, GLfloat rotX, GLfloat rotY, GLfloat rotZ);
	void TryMoveFPSViewerPhysics();
	void TryToShootFPSAmmo();
	void ApplyUserInput();
	int LoadWeaponsFromFile(char *filename);
	void RenderMd2(TMd2 * curObject);
	void RenderFPSWeapon();
	void RenderFPSPlayerStatus();
	void RenderFPSLensFlare();
	void simulateAmmo();
	void renderAmmo();
	void renderStatusText();
	
	int GetGamerHealth() const  { return FPSGamePacket.health; }
	int GetGamerAmmo() const  { return FPSGamePacket.weapons[FPSGamePacket.weaponSelect].ammo; }
	void setSpawnPt(float x, float y, float z) { Vset(&spawnPt, x, y, z); }
	void SetViewerPosition(GLfloat x, GLfloat y, GLfloat z) { viewerPhysics.loc.x = x; viewerPhysics.loc.x = y; viewerPhysics.loc.x = z;}
};

#endif
