/***************************************************************************
                          tfps.cpp  -  description
                             -------------------
    begin                : Mon Jul 14 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "tfps.h"

const int PARTICLE_COLLIDE_ACCURACY = 4;

static int is_Space(int c)
{
	if (c == ' ' || c == '\t' || c == '\n' || c == '\r') return true;
	else return false;
}

static char * is_fgets(char *buf, int n, FILE *fp)
{
	char *wbuf;
	int c, bcnt = 0;

	if (n <= 0) return (NULL);

	wbuf = buf; n = n - 1;                   

	c = '\t';
	while(is_Space(c)) { c = getc(fp); }

	while (n != 0) {
		if (c == '\n' || c == '\r') break;
		if (c == EOF) 
			if (bcnt == 0) return NULL; else break;
		buf[bcnt] = c; bcnt++;
		n = n - 1;
		c = getc(fp);
	}

	buf[bcnt] = '\0';
	return buf;
}


TFPS::TFPS(TInfrastructure *theInfrastructure) : TScene(theInfrastructure) {
	rotHorizDelta = 0.7f;
	rotVertDelta = 0.7f;
	gravity = .5f;
	viewXDisp = viewYDisp = viewZDisp = viewAngleX = viewAngleY = viewAngleZ = 0.0f;
	FPSGamePacket.weaponSelect = 0; 
	FPSGamePacket.oldweaponSelect = NO_SELECT;
	
	FPSGamePacket.health = 100;
	
	//generate default weapon types
	FPSGamePacket.weapons[0].type = MELEE_TYPE;
	FPSGamePacket.weapons[0].ammo = 0;
	FPSGamePacket.weapons[0].damage = 30;
	
	FPSGamePacket.weapons[1].type = EXPLOSIVE_TYPE;
	FPSGamePacket.weapons[1].ammo = 30;
	FPSGamePacket.weapons[1].damage = 40;
	
	FPSGamePacket.weapons[2].type = FLAME_TYPE;
	FPSGamePacket.weapons[2].ammo = 30;
	FPSGamePacket.weapons[2].damage = 30;
	
	dummyObj = new TMd2(theInfrastructure);
	IDgen = 0;
	loadedOnce = false;
	weaponLightID = -1;
	shotFired = false;
	meleeRotDelta = 0.0;
	meleeRotSwitch = false;
	
	SetPortalScissor(false);
	Vset(&spawnPt, 0, 0, 0);
	curSituation = 0;
	statusFrameLimit = 200;
	statusCurFrame = 0;
	timeShot = -1;
	jumpCnt = 0;

}

TFPS::~TFPS(){
	if(WeaponList.size() > 0) {
		for(int i = 0; i < WeaponList.size(); i++) {
			delete WeaponList[i].curObject;
		}
	}
	
	delete dummyObj;
}

void TFPS::setMovement(float xDisp, float yDisp, float jDisp, float xRot, float yRot) {
	horzDisp = xDisp;
	vertDisp = yDisp;
	jumpDisp = jDisp;
	rotHorizDelta = yRot;
	rotVertDelta = xRot;
}

void TFPS::setKeyBind(int left, int right, int forward, int backwards, int jump) {
	leftBind = left;
	rightBind = right;
	forwardBind = forward;
	backwardsBind = backwards;
	jumpBind = jump;
}

void TFPS::MoveFPSViewerDelta(GLfloat dispX, GLfloat dispY, GLfloat dispZ, GLfloat rotX, GLfloat rotY, GLfloat rotZ) {
	PrepareViewerTransform();
		glLoadIdentity();
		glRotatef(rotY, 0.0f, 1.0f, 0.0f);
	EndViewerTransform();

	Vector defaultVec, defaultVec2;
	defaultVec.x = dispX;
	defaultVec.y = dispY;
	defaultVec.z = dispZ;
	transformVector(&defaultVec2, &defaultVec, this->viewerMatrix);

	Vadd(&viewerLoc, &defaultVec2, &viewerLoc);

	PrepareViewerTransform();
		glLoadIdentity();
		glTranslatef(viewerLoc.x, viewerLoc.y, viewerLoc.z);
		glRotatef(rotY, 0.0f, 1.0f, 0.0f);
		glRotatef(rotX, 1.0f, 0.0f, 0.0f);
//		glRotatef(rotZ, 0.0f, 0.0f, 1.0f);
	EndViewerTransform();
}

void TFPS::PlaceFPSViewer(Vector loc) {
	viewerLoc = loc;
	PrepareViewerTransform();
		glLoadIdentity();
		glTranslatef(viewerLoc.x, viewerLoc.y, viewerLoc.z);
		glRotatef(viewAngleY, 0.0f, 1.0f, 0.0f);
		glRotatef(viewAngleX, 1.0f, 0.0f, 0.0f);
	EndViewerTransform();
	
}



Vector TFPS::GetFPSViewerMoveDelta(GLfloat dispX, GLfloat dispY, GLfloat dispZ, GLfloat rotX, GLfloat rotY, GLfloat rotZ) {
	GLfloat curMatrix[16][16];
	
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
		glLoadIdentity();
		glRotatef(rotY, 0.0f, 1.0f, 0.0f);
		glGetFloatv(GL_MODELVIEW_MATRIX, &curMatrix[0][0]);
	glPopMatrix();
	
	Vector defaultVec, defaultVec2;
	defaultVec.x = dispX;
	defaultVec.y = dispY;
	defaultVec.z = dispZ;
	transformVector(&defaultVec2, &defaultVec, &curMatrix[0][0]);
	
	return defaultVec2;
}

void TFPS::MoveFPSViewerDelta2(GLfloat dispX, GLfloat dispY, GLfloat dispZ, GLfloat rotX, GLfloat rotY, GLfloat rotZ) {
	Vector defaultVec2;
	defaultVec2.x = dispX;
	defaultVec2.y = dispY;
	defaultVec2.z = dispZ;

	Vadd(&viewerLoc, &defaultVec2, &viewerLoc);

	PrepareViewerTransform();
		glLoadIdentity();
		glTranslatef(viewerLoc.x, viewerLoc.y, viewerLoc.z);
		glRotatef(rotY, 0.0f, 1.0f, 0.0f);
		glRotatef(rotX, 1.0f, 0.0f, 0.0f);
//		glRotatef(rotZ, 0.0f, 0.0f, 1.0f);
	EndViewerTransform();
}

void TFPS::TryMoveFPSViewerPhysics() {
	Vector orgLoc = viewerLoc, zeroVec;
	Vset(&zeroVec, 0.0, 0.0, 0.0);
	GLfloat orgViewerMatrix[16];
	memcpy(orgViewerMatrix, viewerMatrix, 16 * sizeof(GLfloat));
	
	MoveFPSViewerDelta(viewerPhysics.vel.x, viewerPhysics.vel.y, viewerPhysics.vel.z, 
				viewerPhysics.angle.x, viewerPhysics.angle.y, viewerPhysics.angle.z);
	 
	viewerPhysics.resultVel = GetFPSViewerMoveDelta(viewerPhysics.vel.x, viewerPhysics.vel.y, viewerPhysics.vel.z, 
				viewerPhysics.angle.x, viewerPhysics.angle.y, viewerPhysics.angle.z);
	
	//loop through every object in the scene and test for intersection 
	bool flag = false;
	for(int i = 0; i < ObjectList.size(); i++) {
		if(ObjectList[i].curObject->GetType() == MD2_TYPE && ObjectList[i].sectorIndex == curSectorIndex 
			&& (ObjectList[i].gamePacket.type < 50 || ObjectList[i].gamePacket.type == GAME_PILLAR_TYPE) ) {
			if(OBBIntersect(NULL, ObjectList[i].curObject)) {
				
				flag = true;
				Vector pNormal;
				Vsub(&GetViewerMidPnt(), &ObjectList[i].curObject->GetBndMidPnt(), &pNormal);
				Vnormal(&pNormal);
				
//				float dotProj = Vdot(&viewerPhysics.resultVel, &pNormal);
				float backMag = Vlength(&viewerPhysics.resultVel);
//				Vscale(&pNormal, -dotProj);
				Vscale(&pNormal, backMag);
				Vector resultVec;
				Vadd(&viewerPhysics.resultVel, &pNormal, &resultVec);
				viewerPhysics.resultVel = resultVec;
			}
		}
	}
	
	for(i = 0; i < ObjectList.size(); i++) {
		if(ObjectList[i].curObject->GetType() == PLANE_TYPE  && fabs(((TPlane *)ObjectList[i].curObject)->GetNormal().y) < 0.9f) {
			if(OBBIntersect(NULL, ObjectList[i].curObject)) {
				flag = true; 
				TPlane *curPlane = (TPlane *)ObjectList[i].curObject;
				Vector pNormal = curPlane->GetNormal();
				
				float dotProj = (Vdot(&viewerPhysics.resultVel, &pNormal));
				Vscale(&pNormal, -(dotProj));
				Vector resultVec;
				Vadd(&viewerPhysics.resultVel, &pNormal, &resultVec);
				viewerPhysics.resultVel = resultVec;
			}
		}
	}
	
	for(i = 0; i < ObjectList.size(); i++) {
		if(ObjectList[i].curObject->GetType() == PLANE_TYPE  && fabs(((TPlane *)ObjectList[i].curObject)->GetNormal().y) > 0.9f) {
			if(OBBIntersect(NULL, ObjectList[i].curObject)) {
				flag = true; 
				TPlane *curPlane = (TPlane *)ObjectList[i].curObject;
				Vector pNormal = curPlane->GetNormal();
				
				float dotProj = (Vdot(&viewerPhysics.resultVel, &pNormal));
				Vscale(&pNormal, -(dotProj)); 
				Vector resultVec;
				Vadd(&viewerPhysics.resultVel, &pNormal, &resultVec);
				resultVec.y = 0.0f;
				
				viewerPhysics.resultVel = resultVec;
			}
		}
	}
	
	
	if(flag) {
		viewerLoc = orgLoc;
		PrepareViewerTransform();
		glLoadMatrixf(orgViewerMatrix);
		EndViewerTransform();
		MoveFPSViewerDelta2(viewerPhysics.resultVel.x, viewerPhysics.resultVel.y, viewerPhysics.resultVel.z, 
				viewerPhysics.angle.x, viewerPhysics.angle.y, viewerPhysics.angle.z);
	}
	
}

void TFPS::userInput(Uint16 key) {
	if(key == leftBind) {
		viewXDisp = -horzDisp;
	}
	else if(key == rightBind) {
		viewXDisp = horzDisp;
	}
	else if(key == forwardBind) {
		viewZDisp = -vertDisp;
	}
	else if(key == backwardsBind) {
		viewZDisp = vertDisp;
	}
	else if(key == jumpBind) {
		if(viewYDisp == 0.0 && viewerLoc.y < 50.0) viewYDisp = jumpDisp;
	}
	
}

void TFPS::userKeyUp(Uint16 key) {
	if(key == leftBind) {
		viewXDisp = 0.0f;
	}
	else if(key == rightBind) {
		viewXDisp = 0.0f;
	}
	else if(key == forwardBind) {
		viewZDisp = 0.0f;
	}
	else if(key == backwardsBind) {
		viewZDisp = 0.0f;
	}
	else if(key == jumpBind) {
		viewYDisp = 0.0f;
		jumpCnt = 0;
	}
	else if(key == SDLK_1) { //melee weapon
		FPSGamePacket.oldweaponSelect = FPSGamePacket.weaponSelect;
		FPSGamePacket.weaponSelect = MELEE_SELECT;
		FPSGamePacket.weaponSwitchFrame = 0;
	}
	else if(key == SDLK_2) { //secondary weapon
		FPSGamePacket.oldweaponSelect = FPSGamePacket.weaponSelect;
		FPSGamePacket.weaponSelect = SECONDARY_SELECT;
		FPSGamePacket.weaponSwitchFrame = 0;
	}
	else if(key == SDLK_3) { //primary weapon
		FPSGamePacket.oldweaponSelect = FPSGamePacket.weaponSelect;
		FPSGamePacket.weaponSelect = PRIMARY_SELECT;
		FPSGamePacket.weaponSwitchFrame = 0;
	}
	
	StopViewerPhysics((viewXDisp == 0), (viewYDisp == 0), (viewZDisp == 0) );
}

void TFPS::mouseInput(int mouseXrel, int mouseYrel, bool leftPress, bool rightPress) {
	if(mouseXrel > 0) viewAngleY = viewAngleY - rotHorizDelta;
	else if (mouseXrel < 0) viewAngleY = viewAngleY + rotHorizDelta;

	if(mouseYrel > 0) viewAngleX = viewAngleX - rotVertDelta;
	else if (mouseYrel < 0) viewAngleX = viewAngleX + rotVertDelta;
	
	if(leftPress) {
		triggerRelease = true;
	}
	else if(!leftPress) {
		triggerRelease = false;
	}

}

void TFPS::ApplyUserInput() {
	if(FPSGamePacket.health <= 0) return;
	
	if(weaponLightID == -1) {
		Vector emptyLight;
		Vset(&emptyLight, 0.0, 0.0, 0.0);
		weaponLightID = AddLight(emptyLight, emptyLight, 0.0, 0.0, 0.0, 0.0, 0);
		weaponLightBrightness = 150.0;
		weaponLightR = 1.0;
		weaponLightG = 0.0;
		weaponLightB = 0.5;
	}
	
	ApplyViewerAccel(viewXDisp, viewYDisp - gravity, viewZDisp, viewAngleX, viewAngleY, viewAngleZ);
	viewYDisp = 0.9 * viewYDisp;
	if(viewYDisp < 0.0) viewYDisp = 0.0;

	
	SetLight(viewerLoc, viewerLoc, 0.0, 0.0, 0.0, 0.0, curSectorIndex, weaponLightID);
	shotFired = false;
	
	if(triggerRelease  && FPSGamePacket.weaponSelect != NO_SELECT) {
		shotFired = true;
	}
}

void TFPS::TryToShootFPSAmmo() {
	if(FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type == MELEE_TYPE ||  FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type == FLAME_TYPE) {
		timeShot = -1;
	}
	else if(FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type == EXPLOSIVE_TYPE) {
		if(timeShot == -1) {
			timeShot = SDL_GetTicks();
		}
		int curTime = SDL_GetTicks();
		int diff = curTime - timeShot;
		
		if(diff > 100) timeShot = -1;
	}
	
	if(shotFired == true && (FPSGamePacket.weapons[FPSGamePacket.weaponSelect].ammo > 0 || FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type == MELEE_TYPE)
			 && timeShot == -1) {
		int wIndex = GetWeaponIndex(FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type);
		Vector shootVec = GetViewerMoveDelta(0.0, 0.0, -1.0f, 
				180.0 -viewAngleX, 180.0 -viewAngleY, 0.0f);
		shootVec.x = -shootVec.x;
		Vector startVec, offsetVec;
		Vnormal(&shootVec);
		offsetVec = shootVec;
		Vscale(&shootVec, 7.0);
		Vscale(&offsetVec, 17.0);
		Vadd(&offsetVec, &viewerLoc, &startVec);
		
		Vector ammoRotLoc;
		Vset(&ammoRotLoc, viewAngleX, viewAngleY, 0.0);
		
		shootAmmo(FPS_PLAYER, FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type, 
			shootVec, startVec, &ammoRotLoc, curSectorIndex);
			
		FPSGamePacket.weapons[FPSGamePacket.weaponSelect].ammo--;
		if(FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type == MELEE_TYPE) FPSGamePacket.weapons[FPSGamePacket.weaponSelect].ammo = 0;
	}
}


int TFPS::LoadWeaponsFromFile(char *filename) {
	FILE *file;
	char buf[256], *gotbuf;
	char name[256], modelName[256], bumpName[256], decalName[256];
	int matches, specTrue, diffuseTrue, shadowTrue, attenuateTrue, animation, smoothness, windowIndex, sectorIndex, flipnormal;
	int wtype;
	float x, y, z, scale, rotate, bscale, tileFactor, brightness, red, green, blue, alphaval;
	Vector vec1, vec2, vec3, vec4;
	
	if(!loadedOnce) {
		AddAmmo(255, 255, 255, 128, 128, 128, EXPLOSION1);
		loadedOnce = true;
	}

	file = fopen(filename, "r");
	if (file == NULL) {
		cout << "Could not load " << filename << "." << endl;
		return LOAD_ERROR;
  }

	while (!feof(file)) {
		gotbuf = is_fgets(buf, sizeof(buf), file);
		if (gotbuf) {
			switch(buf[0]) {
				case '#':
				break;
				
				case 'A': //AMMO r1, g1, b1 r2, g2, b2 type 
					int r1, g1, b1, r2, g2, b2, type;
					matches = sscanf(buf, "AMMO %d, %d, %d %d, %d, %d %d", 
									&r1, &g1, &b1, &r2, &g2, &b2, &type);
					if(matches == 7) {
						AddAmmo(r1, g1, b1, r2, g2, b2, type);
					}
					else {fclose(file); ; cout << "Bad Parse for AMMO! Number of matches: " << matches << endl; return BAD_PARSE;}					
				break;

				case 'M': //wtype is the weapon type
					matches = sscanf(buf, "MD2 %s %f, %f, %f %f, %f, %f %f, %f, %f %s %s %d %d %d %d %f %d %d %d", name,
										&vec1.x, &vec1.y, &vec1.z, &vec2.x, &vec2.y, &vec2.z, &vec3.x, &vec3.y, &vec3.z,
										decalName, bumpName, &wtype, &diffuseTrue, &specTrue, &attenuateTrue, &bscale, &animation, &smoothness, &flipnormal);
					if(matches == 20) {
						TMd2 *newMd2 = new TMd2(curInfrastructure);
						newMd2->SetLoadFlippedNormals(flipnormal);

						if(LoadedMd2(name) != NULL) newMd2->Copy(*LoadedMd2(name)); 
						else newMd2->LoadGeom(name);
						newMd2->LoadTexture(decalName, bumpName, true, bscale);
						newMd2->PrepareTransform();
							glLoadIdentity();
						newMd2->EndTransform();
						newMd2->SetCurrentAnimation(animation, smoothness);
						newMd2->PlayAnimation();
						newMd2->SaveMatrix();
						
						AddMd2Weapon(newMd2, vec1, vec2, vec3, wtype);
						
					}	else {fclose(file); ; cout << "Bad Parse for MD2! Number of matches: " << matches << endl; return BAD_PARSE;}
				break;
			}
		}
	}
	
	return true;

	
}

void TFPS::AddMd2Weapon(TMd2 *curObject, Vector offset, Vector scaleOffset, Vector rotOffset, int type) {
	DisplayWeapon newWeapon;
	
	newWeapon.curObject = curObject;
	newWeapon.rotOffset = rotOffset;
	newWeapon.offset = offset;
	newWeapon.scaleOffset = scaleOffset;
	newWeapon.type = type;
	
	WeaponList.push_back(newWeapon);
}

void TFPS::RenderFPSWeapon() {
	if(FPSGamePacket.weaponSelect != NO_SELECT && FPSGamePacket.health > 0) {
		//see if we need to render the weapon switching frames
		if(FPSGamePacket.weaponSwitchFrame <= (MAX_SWITCH_FRAME / 2)) {
			if(FPSGamePacket.oldweaponSelect != NO_SELECT) {
				int wIndex = GetWeaponIndex(FPSGamePacket.weapons[FPSGamePacket.oldweaponSelect].type);
				if(wIndex != -1) {
					TMd2 *curMd2 = WeaponList[wIndex].curObject;
			
					curMd2->PrepareTransform();
						glTranslatef(WeaponList[wIndex].offset.x, WeaponList[wIndex].offset.y, 
							WeaponList[wIndex].offset.z - WeaponList[wIndex].offset.z / (MAX_SWITCH_FRAME / 2 - FPSGamePacket.weaponSwitchFrame) * 
							FPSGamePacket.weaponSwitchFrame);
						glRotatef(WeaponList[wIndex].rotOffset.z, 0.0, 0.0, 1.0);
						glRotatef(WeaponList[wIndex].rotOffset.y, 0.0, 1.0, 0.0);
						glRotatef(WeaponList[wIndex].rotOffset.x, 1.0, 0.0, 0.0);
						glScalef(WeaponList[wIndex].scaleOffset.x, WeaponList[wIndex].scaleOffset.y, 
							WeaponList[wIndex].scaleOffset.z);
					curMd2->EndTransform();
					RenderMd2(curMd2);
				}
			}
			FPSGamePacket.weaponSwitchFrame++;
		}
		else if(FPSGamePacket.weaponSwitchFrame > (MAX_SWITCH_FRAME / 2) &&
			FPSGamePacket.weaponSwitchFrame <= MAX_SWITCH_FRAME) {
				int wIndex = GetWeaponIndex(FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type);
				if(wIndex != -1) {
					TMd2 *curMd2 = WeaponList[wIndex].curObject;
			
					curMd2->PrepareTransform();
						glTranslatef(WeaponList[wIndex].offset.x, WeaponList[wIndex].offset.y, 
							WeaponList[wIndex].offset.z - WeaponList[wIndex].offset.z / (MAX_SWITCH_FRAME / 2) * 
							(MAX_SWITCH_FRAME  - FPSGamePacket.weaponSwitchFrame));
						glRotatef(WeaponList[wIndex].rotOffset.z, 0.0, 0.0, 1.0);
						glRotatef(WeaponList[wIndex].rotOffset.y, 0.0, 1.0, 0.0);
						glRotatef(WeaponList[wIndex].rotOffset.x, 1.0, 0.0, 0.0);
						glScalef(WeaponList[wIndex].scaleOffset.x, WeaponList[wIndex].scaleOffset.y, 
							WeaponList[wIndex].scaleOffset.z);
					curMd2->EndTransform();
					RenderMd2(curMd2);
				}
			
			FPSGamePacket.weaponSwitchFrame++;
		}
		else { //render weapon
			int wIndex = GetWeaponIndex(FPSGamePacket.weapons[FPSGamePacket.weaponSelect].type);
			if(wIndex != -1) {
				TMd2 *curMd2 = WeaponList[wIndex].curObject;
			
				curMd2->PrepareTransform();
					glTranslatef(WeaponList[wIndex].offset.x, WeaponList[wIndex].offset.y, WeaponList[wIndex].offset.z);
					glRotatef(WeaponList[wIndex].rotOffset.z, 0.0, 0.0, 1.0);
					glRotatef(WeaponList[wIndex].rotOffset.y + meleeRotDelta, 0.0, 1.0, 0.0);
					glRotatef(WeaponList[wIndex].rotOffset.x, 1.0, 0.0, 0.0);
					glScalef(WeaponList[wIndex].scaleOffset.x, WeaponList[wIndex].scaleOffset.y, 
						WeaponList[wIndex].scaleOffset.z);
				curMd2->EndTransform();
				RenderMd2(curMd2);
				
				if(meleeRotSwitch) {
					meleeRotDelta = meleeRotDelta + 10.0;
					if(meleeRotDelta > 60.0) meleeRotSwitch = false;
				}
				else {
					if(meleeRotDelta > 0.0) meleeRotDelta = meleeRotDelta - 10.0;
				}
				
			}
		}
	}
	
}

void RenderFPSPlayerStatus() {
	glActiveTextureARB(GL_TEXTURE0_ARB );
	glDisable(GL_TEXTURE_CUBE_MAP_ARB );
	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE1_ARB );
	glDisable(GL_TEXTURE_CUBE_MAP_ARB );
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_CULL_FACE );
	glDisable(GL_REGISTER_COMBINERS_NV);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		
	glDisable(GL_BLEND);
}

void TFPS::RenderFPSLensFlare() {
	GLint viewport[4];
	GLdouble modelMatrix[16];
	GLdouble projMatrix[16];
	GLdouble screenX, screenY, screenZ;
	GLdouble midpntX = (GLdouble)curInfrastructure->GetWinWidth() * 0.5, midpntY = (GLdouble)curInfrastructure->GetWinHeight() * 0.5;
	
	glGetIntegerv(GL_VIEWPORT, viewport);
	glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();
		glGetDoublev(GL_MODELVIEW_MATRIX, modelMatrix);
		glGetDoublev(GL_PROJECTION_MATRIX, projMatrix);
	glPopMatrix();

	glActiveTextureARB(GL_TEXTURE1_ARB );
	glDisable(GL_TEXTURE_CUBE_MAP_ARB );
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_REGISTER_COMBINERS_NV);
	
	glActiveTextureARB(GL_TEXTURE0_ARB );
	glDisable(GL_TEXTURE_CUBE_MAP_ARB );
	glDisable(GL_CULL_FACE );
	glDepthMask(GL_FALSE);
	glDisable(GL_STENCIL_TEST);
	
	glEnable(GL_TEXTURE_2D);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);

	glMatrixMode(GL_PROJECTION);
		glPushMatrix( );
		glLoadIdentity( );
		glOrtho(0, curInfrastructure->GetWinWidth(), 0, curInfrastructure->GetWinHeight() , -1, 1);
	
	glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
			
	for(int i = 0; i < LightList.size(); i++) {
		if(LightList[i].sectorIndex == curSectorIndex) {
			if(LightList[i].dstLightVec.z > -1.0) break;
			gluProject((GLdouble)LightList[i].dstLightVec.x, (GLdouble)LightList[i].dstLightVec.y, 
				(GLdouble)LightList[i].dstLightVec.z, modelMatrix, projMatrix, 
				viewport, &screenX, &screenY, &screenZ); 
			if(screenX < 0 || screenX > curInfrastructure->GetWinWidth() || screenY < 0 || screenY > curInfrastructure->GetWinHeight() ) break;
			Vector midpnt, lightpnt, delta, result, lightDist;
			float length = 0.0, scale = 1.0, size = 64.0, curalpha = 0.0, lightLength;
			Vsub(&LightList[i].dstLightVec, &viewerLoc, &lightDist);
			lightLength = Vlength(&lightDist);
			
			curalpha = lightLength / LightList[i].brightness;
			if(curalpha > 1.0) curalpha = 1.0;
			
			Vset(&midpnt, midpntX, midpntY, 0.0);
			Vset(&lightpnt, screenX, screenY, 0.0);
			Vsub(&lightpnt, &midpnt, &delta);
			length = Vlength(&delta);
			Vnormal(&delta);
			glLoadIdentity();
			glTranslatef(0.0, 0.0, 0.0);
			
			//flare 1
			glBindTexture(GL_TEXTURE_2D, curInfrastructure->GetLensFlareTexture(0));
			result = delta;
			Vscale(&result, length);
			Vadd(&result, &midpnt, &result);
			
			glBegin(GL_QUADS);
				glColor4f(1.0, 1.0, 1.0, curalpha);
				glTexCoord2f(0.0, 0.0);
				glVertex3f(result.x - size * scale , result.y - size * scale, LightList[i].dstLightVec.z);
				glTexCoord2f(1.0, 0.0);
				glVertex3f(result.x + size * scale , result.y - size * scale, LightList[i].dstLightVec.z);
				glTexCoord2f(1.0, 1.0);
				glVertex3f(result.x + size * scale , result.y + size * scale, LightList[i].dstLightVec.z);
				glTexCoord2f(0.0, 1.0);
				glVertex3f(result.x - size * scale , result.y + size * scale, LightList[i].dstLightVec.z);
			glEnd(); 
			
			//flare 2
			glBindTexture(GL_TEXTURE_2D, curInfrastructure->GetLensFlareTexture(1));
			result = delta;
			Vscale(&result, length * 0.5);
			Vadd(&result, &midpnt, &result);
			scale = 0.5;
			
			glBegin(GL_QUADS);
				glColor4f(1.0, 1.0, 1.0, curalpha);
				glTexCoord2f(0.0, 0.0);
				glVertex2f(result.x - size * scale , result.y - size * scale);
				glTexCoord2f(1.0, 0.0);
				glVertex2f(result.x + size * scale , result.y - size * scale);
				glTexCoord2f(1.0, 1.0);
				glVertex2f(result.x + size * scale , result.y + size * scale);
				glTexCoord2f(0.0, 1.0);
				glVertex2f(result.x - size * scale , result.y + size * scale);
			glEnd(); 
			
			//flare 3
			glBindTexture(GL_TEXTURE_2D, curInfrastructure->GetLensFlareTexture(3));
			result = delta;
			Vscale(&result, length * 0.25);
			Vadd(&result, &midpnt, &result);
			scale = 0.25;
			
			glBegin(GL_QUADS);
				glColor4f(1.0, 1.0, 1.0, curalpha);
				glTexCoord2f(0.0, 0.0);
				glVertex2f(result.x - size * scale , result.y - size * scale);
				glTexCoord2f(1.0, 0.0);
				glVertex2f(result.x + size * scale , result.y - size * scale);
				glTexCoord2f(1.0, 1.0);
				glVertex2f(result.x + size * scale , result.y + size * scale);
				glTexCoord2f(0.0, 1.0);
				glVertex2f(result.x - size * scale , result.y + size * scale);
			glEnd(); 

			//flare 4
			glBindTexture(GL_TEXTURE_2D, curInfrastructure->GetLensFlareTexture(3));
			result = delta;
			Vscale(&result, length * 0.125);
			Vadd(&result, &midpnt, &result);
			scale = 1.0;
			
			glBegin(GL_QUADS);
				glColor4f(1.0, 1.0, 1.0, curalpha);
				glTexCoord2f(0.0, 0.0);
				glVertex2f(result.x - size * scale , result.y - size * scale);
				glTexCoord2f(1.0, 0.0);
				glVertex2f(result.x + size * scale , result.y - size * scale);
				glTexCoord2f(1.0, 1.0);
				glVertex2f(result.x + size * scale , result.y + size * scale);
				glTexCoord2f(0.0, 1.0);
				glVertex2f(result.x - size * scale , result.y + size * scale);
			glEnd(); 
						
			//flare 5
			glBindTexture(GL_TEXTURE_2D, curInfrastructure->GetLensFlareTexture(0));
			result = delta;
			Vscale(&result, length * -0.5);
			Vadd(&result, &midpnt, &result);
			scale = -0.5;
			
			glBegin(GL_QUADS);
				glColor4f(1.0, 1.0, 1.0, curalpha);
				glTexCoord2f(0.0, 0.0);
				glVertex2f(result.x - size * scale , result.y - size * scale);
				glTexCoord2f(1.0, 0.0);
				glVertex2f(result.x + size * scale , result.y - size * scale);
				glTexCoord2f(1.0, 1.0);
				glVertex2f(result.x + size * scale , result.y + size * scale);
				glTexCoord2f(0.0, 1.0);
				glVertex2f(result.x - size * scale , result.y + size * scale);
			glEnd(); 
			
			//flare 6
			glBindTexture(GL_TEXTURE_2D, curInfrastructure->GetLensFlareTexture(1));
			result = delta;
			Vscale(&result, length * -0.25);
			Vadd(&result, &midpnt, &result);
			scale = -0.25;
			
			glBegin(GL_QUADS);
				glColor4f(1.0, 1.0, 1.0, curalpha);
				glTexCoord2f(0.0, 0.0);
				glVertex2f(result.x - size * scale , result.y - size * scale);
				glTexCoord2f(1.0, 0.0);
				glVertex2f(result.x + size * scale , result.y - size * scale);
				glTexCoord2f(1.0, 1.0);
				glVertex2f(result.x + size * scale , result.y + size * scale);
				glTexCoord2f(0.0, 1.0);
				glVertex2f(result.x - size * scale , result.y + size * scale);
			glEnd(); 
			
			//flare 7
			glBindTexture(GL_TEXTURE_2D, curInfrastructure->GetLensFlareTexture(2));
			result = delta;
			Vscale(&result, length * -0.5);
			Vadd(&result, &midpnt, &result);
			scale = -0.5;
			
			glBegin(GL_QUADS);
				glColor4f(1.0, 1.0, 1.0, curalpha);
				glTexCoord2f(0.0, 0.0);
				glVertex2f(result.x - size * scale , result.y - size * scale);
				glTexCoord2f(1.0, 0.0);
				glVertex2f(result.x + size * scale , result.y - size * scale);
				glTexCoord2f(1.0, 1.0);
				glVertex2f(result.x + size * scale , result.y + size * scale);
				glTexCoord2f(0.0, 1.0);
				glVertex2f(result.x - size * scale , result.y + size * scale);
			glEnd(); 
			break;  
		}
	}
	
	glMatrixMode( GL_PROJECTION );
	glPopMatrix( );
	glMatrixMode( GL_MODELVIEW);
	glPopMatrix( );
	
	glDepthMask(GL_TRUE);
	glEnable( GL_DEPTH_TEST );
	glEnable(GL_CULL_FACE );
	glDisable(GL_BLEND);
}


int TFPS::GetWeaponIndex(int type) {
	for(int i = 0; i < WeaponList.size(); i++) {
		if(WeaponList[i].type == type) return i;
	}
	
	return -1;
}

void TFPS::RenderMd2(TMd2* curObject) {
	curObject->EnablePlainDecal();
	curObject->SelectSingleDecalTexture();
	curObject->SetupVertexArraysForRendering(DECAL_MODE);
	curObject->Render();
	
	if(renderLevel < RENDER_LEVEL1) return;
	curObject->SetLightPos(currentLightVec.x, currentLightVec.y, currentLightVec.z);
	curObject->SetEyePos(currentEyeVec.x, currentEyeVec.y, currentEyeVec.z);
	curObject->SetupLightVectorsForRendering();
	
	//diffuse pass
	curObject->EnableDiffusePass(0.2f, 0.2f, 0.2f, 0.0f, 0.45f, 0.45f, 0.45f, 0.0f);
	curObject->SelectCubeAndBumpTexture();
	curObject->SetupVertexArraysForRendering(DIFFUSE_BUMP_MODE);
	curObject->Render();
	//specular pass
	curObject->SelectCubeAndBumpTexture();
	curObject->EnableSpecularPass();
	curObject->SetupVertexArraysForRendering(SPECULAR_BUMP_MODE);
	curObject->Render();

}

void TFPS::AddAmmo(int r1, int g1, int b1, int r2, int g2, int b2, int type) {
	TParticle *curParticle = curInfrastructure->GetParticle();
	DisplayAmmo newAmmo;
	newAmmo.type = type;
	
	if(type == EXPLOSIVE_TYPE) { //create glowing ball
		newAmmo.radius = 5.0f;
		GLuint retImage = curParticle->createGlowBall(r1, g1, b1, r2, g2, b2);
		newAmmo.rasterImage.push_back(retImage);
	}
	
	else if(type == FLAME_TYPE) {
		newAmmo.radius = 5.0f;
		GLuint retImage = curParticle->createGlowBall(r1, g1, b1, r2, g2, b2);
		newAmmo.rasterImage.push_back(retImage);
	}
	
	else if(type == EXPLOSION1) {
		newAmmo.radius = 5.0f;
		GLuint retImage = curParticle->createGlowBall(r1, g1, b1, r2, g2, b2);
		newAmmo.rasterImage.push_back(retImage);
	}
	else if(type == CANNON_SHOT_TYPE) {
		newAmmo.radius = 5.0f;
		GLuint retImage = curParticle->createGlowBall(r1, g1, b1, r2, g2, b2);
		newAmmo.rasterImage.push_back(retImage);
	}
	
	
	AmmoList.push_back(newAmmo);
}

void TFPS::shootAmmo(int owner, int type, Vector vel, Vector startLoc, Vector *rotVec = NULL, int sectorIndex = -1) {
	slist<GamerAmmo> newAmmo;
	
	IDgen++;
	
	if(type == EXPLOSIVE_TYPE) {
		curInfrastructure->PlaySound(SMASH_SOUND);
		GamerAmmo AmmoData;
		AmmoData.type = type;
		AmmoData.frame = 0;
		AmmoData.owner = owner;
		AmmoData.ID = IDgen;
		AmmoData.loc = startLoc;
		AmmoData.prevLoc = startLoc;
		AmmoData.vel = vel;
		if(rotVec != NULL) AmmoData.rotVec = *rotVec;
//		AmmoData.colObjIndex = -1; // no collision
		
		newAmmo.push_front(AmmoData);
		
		AmmoParticles.push_front(newAmmo);
		
		if(rotVec == NULL) {
			SetLight(viewerLoc, viewerLoc, weaponLightBrightness, weaponLightR, weaponLightG, weaponLightB,
					curSectorIndex, weaponLightID);
		}
		else if(rotVec != NULL && sectorIndex != -1) {
			SetLight(startLoc, startLoc, weaponLightBrightness, weaponLightR, weaponLightG, weaponLightB,
					sectorIndex, weaponLightID);
		}
	}
	
	else if(type == EXPLOSION1) { //seed with 50 particles
		GamerAmmo AmmoArray[MAX_PARTICLES];
		float factor = 0.1f;
		
		for(int i = 0; i < MAX_PARTICLES; i++) {
			AmmoArray[i].type = type;
			AmmoArray[i].frame = 0;
			AmmoArray[i].owner = owner;
			AmmoArray[i].loc = startLoc;
			AmmoArray[i].prevLoc = startLoc;
			AmmoArray[i].vel.x = float((rand()%50)-26.0f)*factor;
			AmmoArray[i].vel.y = float((rand()%50)-26.0f)*factor;
			AmmoArray[i].vel.z = float((rand()%50)-26.0f)*factor;
//			AmmoArray[i].colObjIndex = -1;
			AmmoArray[i].ID = IDgen;
			
			newAmmo.push_front(AmmoArray[i]);
		}
		
		AmmoParticles.push_front(newAmmo);
	}
	
	else if(type == FLAME_TYPE) {
		curInfrastructure->PlaySound(LIQUID_BLAST_SOUND);
		GamerAmmo AmmoArray[MAX_PARTICLES];
		float factor = 0.05f;
		Vector shootVec, orientVec;
		if(rotVec == NULL) {
			shootVec = GetViewerMoveDelta(0.0, 1.0, -1.0f, 
				180.0 -viewAngleX, 180.0 -viewAngleY, 0.0f);
			orientVec.x = viewAngleX;
			orientVec.y = viewAngleY;
			orientVec.z = 0.0;
		}
		else {
			shootVec = GetViewerMoveDelta(0.0, 1.0, -1.0f, 
				180.0 -rotVec->x, 180.0 -rotVec->y, 0.0f);
			orientVec = *rotVec;
		}
		
		shootVec.x = -shootVec.x;
		Vnormal(&shootVec);
		Vscale(&shootVec, 3.0);

		Vadd(&startLoc, &shootVec, &startLoc);
		
		for(int i = 0; i < MAX_PARTICLES; i++) {
			AmmoArray[i].type = type;
			AmmoArray[i].frame = 0;
			AmmoArray[i].owner = owner;
			AmmoArray[i].loc = startLoc;
			AmmoArray[i].prevLoc = startLoc;
			AmmoArray[i].vel.x = float((rand()%100)-26.0f)*factor;
			AmmoArray[i].vel.y = float((rand()%100)-26.0f)*factor;
			AmmoArray[i].vel.z = -float((rand()%100)-26.0f)*factor;
			
			AmmoArray[i].rotVec = orientVec;
			AmmoArray[i].startVec = startLoc;
//			AmmoArray[i].colObjIndex = -1;
			AmmoArray[i].ID = IDgen;
			
			newAmmo.push_front(AmmoArray[i]);
			
			if(rotVec == NULL) {
				SetLight(viewerLoc, viewerLoc, weaponLightBrightness, weaponLightR, weaponLightG, weaponLightB,
					curSectorIndex, weaponLightID);
			}
			else {
				SetLight(startLoc, startLoc, weaponLightBrightness, weaponLightR, weaponLightG, weaponLightB,
						sectorIndex, weaponLightID);
			}
		}
		
		AmmoParticles.push_front(newAmmo);
	}
	else if(type == CANNON_SHOT_TYPE){
		curInfrastructure->PlaySound(LUGER_SOUND);
		GamerAmmo AmmoData;
		AmmoData.type = type;
		AmmoData.frame = 0;
		AmmoData.owner = owner;
		AmmoData.ID = IDgen;
		AmmoData.loc = startLoc;
		AmmoData.prevLoc = startLoc;
		AmmoData.vel = vel;
		if(rotVec != NULL) AmmoData.rotVec = *rotVec;
		
		newAmmo.push_front(AmmoData);
		
		AmmoParticles.push_front(newAmmo);
		
		if(rotVec == NULL) {
			SetLight(viewerLoc, viewerLoc, weaponLightBrightness, weaponLightR, weaponLightG, weaponLightB,
					curSectorIndex, weaponLightID);
		}
		else if(rotVec != NULL && sectorIndex != -1) {
			SetLight(startLoc, startLoc, weaponLightBrightness, weaponLightR, weaponLightG, weaponLightB,
					sectorIndex, weaponLightID);
		}
	}
	else if(type == MOUSE_SHOT_TYPE) {
		curInfrastructure->PlaySound(CANNON_SOUND);
		GamerAmmo AmmoData;
		AmmoData.type = type;
		AmmoData.frame = 0;
		AmmoData.owner = owner;
		AmmoData.ID = IDgen;
		AmmoData.loc = startLoc;
		AmmoData.prevLoc = startLoc;
		AmmoData.vel = vel;
		if(rotVec != NULL) AmmoData.rotVec = *rotVec;
		
		newAmmo.push_front(AmmoData);
		
		AmmoParticles.push_front(newAmmo);
		
		if(rotVec == NULL) {
			SetLight(viewerLoc, viewerLoc, weaponLightBrightness, weaponLightR, weaponLightG, weaponLightB,
					curSectorIndex, weaponLightID);
		}
		else if(rotVec != NULL && sectorIndex != -1) {
			SetLight(startLoc, startLoc, weaponLightBrightness, weaponLightR, weaponLightG, weaponLightB,
					sectorIndex, weaponLightID);
		}
	}
	else if(type == MELEE_TYPE) {
		if(!meleeRotSwitch && meleeRotDelta == 0.0) {
			meleeRotSwitch = true;
			meleeRotDelta = meleeRotDelta + 10.0;
		}
		GamerAmmo AmmoData;
		AmmoData.type = type;
		AmmoData.frame = 0;
		AmmoData.owner = owner;
		AmmoData.ID = IDgen;
		AmmoData.loc = startLoc;
		AmmoData.prevLoc = startLoc;
		AmmoData.vel = vel;
		if(rotVec != NULL) AmmoData.rotVec = *rotVec;
//		AmmoData.colObjIndex = -1; // no collision
		
		newAmmo.push_front(AmmoData);
		
		AmmoParticles.push_front(newAmmo);
		
	}
}

void TFPS::simulateAmmo() {
	slist <slist<GamerAmmo> >::iterator iter;
	slist<GamerAmmo>::iterator iter2;
	slist<GamerAmmo>::iterator iter3;
	vector <int> deleteList;
	

	for(iter = AmmoParticles.begin(); iter != AmmoParticles.end(); iter++) {
		iter2 = (*iter).begin();
		
		if( (*iter2).type == EXPLOSIVE_TYPE && (*iter2).colObjIndex.empty()) {
			(*iter2).prevLoc = (*iter2).loc;
			Vadd( &(*iter2).loc, &(*iter2).vel, &(*iter2).loc);
			(*iter2).frame++;
			if( (*iter2).frame > 800) {
				int newDeleteList;
				newDeleteList = (*iter2).ID;
				deleteList.push_back(newDeleteList);
			}
		}
		else if( (*iter2).type == CANNON_SHOT_TYPE && (*iter2).colObjIndex.empty()) {
			(*iter2).prevLoc = (*iter2).loc;
			Vadd( &(*iter2).loc, &(*iter2).vel, &(*iter2).loc);
			(*iter2).frame++;
			if( (*iter2).frame > 800) {
				int newDeleteList;
				newDeleteList = (*iter2).ID;
				deleteList.push_back(newDeleteList);
			}
		}
		else if( (*iter2).type == MOUSE_SHOT_TYPE && (*iter2).colObjIndex.empty()) {
			(*iter2).prevLoc = (*iter2).loc;
			Vadd( &(*iter2).loc, &(*iter2).vel, &(*iter2).loc);
			(*iter2).vel.y = (*iter2).vel.y - 0.8;
			(*iter2).frame++;
			if( (*iter2).frame > 800) {
				int newDeleteList;
				newDeleteList = (*iter2).ID;
				deleteList.push_back(newDeleteList);
			}
		}
		
		else if( (*iter2).type == FLAME_TYPE) {
			if( (*iter2).frame > 20) {
				int newDeleteList;
				newDeleteList = (*iter2).ID;
				deleteList.push_back(newDeleteList);
			}
		}

		else if( (*iter2).type == MELEE_TYPE) {
			(*iter2).frame++;
			if( (*iter2).frame > 5) {
				int newDeleteList;
				newDeleteList = (*iter2).ID;
				deleteList.push_back(newDeleteList);
			}
		}
				
		else if( (*iter2).type == EXPLOSION1) {
			if( (*iter2).frame > 40) {
				int newDeleteList;
				newDeleteList = (*iter2).ID;
				deleteList.push_back(newDeleteList);
			}
		}
		
		
		//see if this particle hit something.. ouch!
		if( !(*iter2).colObjIndex.empty()) {
			int newDeleteList;
			newDeleteList = (*iter2).ID;
			deleteList.push_back(newDeleteList);
			
			if( (*iter2).type == EXPLOSIVE_TYPE) { //add in an explosion effect at that location
				Vector vec;
				shootAmmo(FPS_PLAYER, EXPLOSION1, vec, (*iter2).loc, NULL, -1);
			}
			else if( (*iter2).type == CANNON_SHOT_TYPE) {
				Vector vec;
				shootAmmo((*iter2).owner, EXPLOSION1, vec, (*iter2).loc, NULL, -1);
			}
			else if( (*iter2).type == MOUSE_SHOT_TYPE) {
				Vector vec;
				shootAmmo((*iter2).owner, EXPLOSION1, vec, (*iter2).loc, NULL, -1);
			}
		}
		
	}
		

	for(int i = 0; i < deleteList.size(); i++) {
		deleteAmmo(deleteList[i]);
	}


	ParticlesIntersect();
}

void TFPS::deleteAmmo(int ID) {
	slist <slist<GamerAmmo> >::iterator iter;
	slist<GamerAmmo>::iterator iter2;
	
	for(iter = AmmoParticles.begin(); iter != AmmoParticles.end(); iter++) {
		iter2 = (*iter).begin();
		if( (*iter2).ID == ID) {
			AmmoParticles.erase(iter);
			break;
		}
	}
}

void TFPS::renderAmmo() {
	slist <slist<GamerAmmo> >::iterator iter;
	slist<GamerAmmo>::iterator iter2;
	TParticle *curParticle = curInfrastructure->GetParticle();
	glDisable(GL_CULL_FACE );
	curParticle->prepareParticlePlainRender();
	

	for(iter = AmmoParticles.begin(); iter != AmmoParticles.end(); iter++) {
		iter2 = (*iter).begin();
		if( (*iter2).type == EXPLOSIVE_TYPE) {
			glBindTexture(GL_TEXTURE_2D, AmmoList[GetAmmoIndex( (*iter2).type)].rasterImage[0]  );
			curParticle->renderParticlePlain((*iter2).loc.x, (*iter2).loc.y, (*iter2).loc.z, 5.0f, 5.0f, viewAngleX,
						viewAngleY, 0.0f, this->inverseViewerMatrix);
		}
		else if( (*iter2).type == CANNON_SHOT_TYPE) {
			glBindTexture(GL_TEXTURE_2D, AmmoList[GetAmmoIndex( (*iter2).type)].rasterImage[0]  );
			curParticle->renderParticlePlain((*iter2).loc.x, (*iter2).loc.y, (*iter2).loc.z, 5.0f, 5.0f, viewAngleX,
						viewAngleY, 0.0f, this->inverseViewerMatrix);
		}
		else if( (*iter2).type == MOUSE_SHOT_TYPE) { 
			GameType addType = GetUnitInfo((*iter2).type - 10); //magic number
			TMd2 *curMd2 = LoadedMd2( (char *)(addType.md2_Filename.c_str()) );
			curMd2->RestoreMatrix();
			curMd2->PrepareTransform();
				glLoadIdentity();
				glTranslatef((*iter2).loc.x, (*iter2).loc.y, (*iter2).loc.z);
				glRotatef((float)( (*iter2).frame * 10), 0.0, 0.0, 1.0f);
				glRotatef(90.0, 0.0, 1.0f, 0.0);
				glRotatef(0.0, 1.0f, 0.0, 0.0);
				glScalef(0.4, 0.4, 0.4);
			curMd2->EndTransform();
				
			curMd2->MatrixMult(this->inverseViewerMatrix);
				
			curMd2->EnablePlainDecal();
			curMd2->SelectSingleDecalTexture();
			curMd2->SetupVertexArraysForRendering(DECAL_MODE);
			glEnable(GL_BLEND);
				glBlendFunc(GL_SRC_ALPHA,GL_ONE);
				glColor4f(1.0, 1.0, 1.0, 0.5);
				curMd2->Render();
			glDisable(GL_BLEND);
			
			curParticle->prepareParticlePlainRender();
		}
		
		else if( (*iter2).type == FLAME_TYPE) {
			GLfloat curMatrix[16][16];
	
			glMatrixMode(GL_MODELVIEW);
			glPushMatrix();
				glLoadIdentity();
//				glRotatef(viewAngleY, 0.0f, 1.0f, 0.0f);
//				glRotatef(viewAngleX, 1.0f, 0.0f, 0.0f);
				glRotatef( (*iter2).rotVec.y , 0.0f, 1.0f, 0.0f);
				glRotatef( (*iter2).rotVec.x, 1.0f, 0.0f, 0.0f);
				glGetFloatv(GL_MODELVIEW_MATRIX, &curMatrix[0][0]);
			glPopMatrix();		
			
			Vector curGrav, transGrav;
			Vset(&transGrav, 0.0, 0.0, 0.0);
			curGrav.x = 0.0f;
			curGrav.y = -3.0f;
			curGrav.z = 25.2f;
			
			transformVector(&transGrav, &curGrav, &curMatrix[0][0]);
			Vadd(&transGrav, &(*iter2).startVec, &transGrav);
			
			
			glBindTexture(GL_TEXTURE_2D, AmmoList[GetAmmoIndex( (*iter2).type)].rasterImage[0]  );
			curParticle->renderParticleList2( (*iter).begin(), (*iter).end(), transGrav, 0.05, 1.0, 1.0, 0.3,
								1.0, 1.0, 0.0, 0.1, 0.1, 0.0, 50, 13.0, 13.0,
								viewAngleX, viewAngleY, 0.0f, this->inverseViewerMatrix); 
		}
		
		else if( (*iter2).type == EXPLOSION1) {
			Vector curGrav;
			curGrav.x = 0.0f;
			curGrav.y = -0.2f;
			curGrav.z = 0.0f;
			
			glBindTexture(GL_TEXTURE_2D, AmmoList[GetAmmoIndex( (*iter2).type)].rasterImage[0]  );
			curParticle->renderParticleList( (*iter).begin(), (*iter).end(), curGrav, 0.05, 1.0, 1.0, 1.0,
								1.0, 1.0, 0.0, 0.1, 0.1, 0.0, 50, 1.0, 1.0,
								viewAngleX, viewAngleY, 0.0f, this->inverseViewerMatrix);
		}
	}

	glEnable(GL_CULL_FACE );
	curParticle->endParticleRender();	
}


void TFPS::renderStatusText() {
	if(statusText == "") return;
	statusCurFrame++;
	if(statusCurFrame > statusFrameLimit) {
		statusText = "";
		statusCurFrame = 0;
	}
	
	if(statusCurFrame > statusFrameLimit / 2) {
		float fadeVal = (float)statusFrameLimit * 0.5;
		float curFade = statusCurFrame - fadeVal;
		
		glColor4f(1.0, 1.0, 1.0, 1.0 - curFade / fadeVal);
	}

	glActiveTextureARB(GL_TEXTURE0_ARB );
	glDisable(GL_TEXTURE_CUBE_MAP_ARB );
	glActiveTextureARB(GL_TEXTURE1_ARB );
	glDisable(GL_TEXTURE_CUBE_MAP_ARB );
	glDisable(GL_REGISTER_COMBINERS_NV);
	glDisable(GL_CULL_FACE );
	glDisable( GL_DEPTH_TEST );
		
	glEnable(GL_BLEND);
	glBlendFunc( GL_SRC_ALPHA, GL_ONE);
	curInfrastructure->screenPrint(0, (int)(curInfrastructure->GetWinHeight() * 0.95), (char *)statusText.c_str(), 1, 1.0, 1.0);

	glDisable(GL_BLEND);

	glEnable(GL_CULL_FACE );
	glEnable( GL_DEPTH_TEST );
}


GLuint TFPS::GetAmmoIndex(int type) {
	for(int i = 0; i < AmmoList.size(); i++) {
		if(AmmoList[i].type == type) return i;
	}
	
	return -1;
}

void TFPS::ParticlesIntersect() {
	slist <slist<GamerAmmo> >::iterator iter;
	slist<GamerAmmo>::iterator iter2;
	bool flag = false;
	
	for(iter = AmmoParticles.begin(); iter != AmmoParticles.end(); iter++) {
		iter2 = (*iter).begin();
		if((*iter2).type == EXPLOSIVE_TYPE) {
			Vector diffVec, boundVec;
			Vsub( &(*iter2).prevLoc, &(*iter2).loc, &diffVec);
			Vcopy(&(*iter2).loc, &boundVec);
			float factor = 1.0 / (float)(PARTICLE_COLLIDE_ACCURACY);
			Vscale(&diffVec, factor);
			flag = false;
			
			for(int j = 0; j < PARTICLE_COLLIDE_ACCURACY; j++) {
				//set up the bounding box for the particle
				float radius = AmmoList[GetAmmoIndex( (*iter2).type)].radius;
				Vector minVec, maxVec;

				minVec.x = boundVec.x - radius;
				minVec.y = boundVec.y - radius;
				minVec.z = boundVec.z - radius;
				maxVec.x = boundVec.x + radius;
				maxVec.y = boundVec.y + radius;
				maxVec.z = boundVec.z + radius;
			
				dummyObj->SetDstBounds1( minVec.x, minVec.y, minVec.z );
				dummyObj->SetDstBounds2( maxVec.x, maxVec.y, maxVec.z );
				Vector *dstBnd1 = dummyObj->GetDstBounds1();
				Vector *dstBnd2 = dummyObj->GetDstBounds2();
				dummyObj->SetDstBounds3(dstBnd2->x, dstBnd1->y, dstBnd1->z);
				dummyObj->SetDstBounds4(dstBnd2->x, dstBnd1->y, dstBnd2->z);
				dummyObj->SetDstBounds5(dstBnd1->x, dstBnd1->y, dstBnd2->z);
				dummyObj->SetDstBounds6(dstBnd2->x, dstBnd2->y, dstBnd1->z);
				dummyObj->SetDstBounds7(dstBnd1->x, dstBnd2->y, dstBnd2->z);
				dummyObj->SetDstBounds8(dstBnd1->x, dstBnd2->y, dstBnd1->z);
			
				for(int i = 0; i < ObjectList.size(); i++) {
					if(OBBIntersect(dummyObj, ObjectList[i].curObject) && (*iter2).owner != i) { //particle hits something
						(*iter2).colObjIndex.push_back(i);
						flag = true;
						int wIndex = FPSGamePacket.weaponSelect;
						if(ObjectList[i].gamePacket.type == PLAYER_TYPE || ObjectList[i].gamePacket.type == GAME_PILLAR_TYPE) continue;
						if(ObjectList[i].gamePacket.team > 0) {
							ObjectList[i].gamePacket.health = ObjectList[i].gamePacket.health - FPSGamePacket.weapons[wIndex].damage;
							cout << "Object Health: " << ObjectList[i].gamePacket.health << endl;
							if(ObjectList[i].gamePacket.health < 0) { ObjectList[i].gamePacket.health = -1; cout << "Object Killed" << endl; }
						}
					}
				}
				
				if(flag) { break;}
				Vadd(&diffVec, &boundVec, &boundVec);
			}
		}
		
		else if((*iter2).type == FLAME_TYPE) { //do flame thrower damage
			int curOwner = (*iter2).owner;
			Vector minBnds, maxBnds;
			Vset(&minBnds, 9999.0, 99999.0, 99999.0);
			Vset(&maxBnds, -9999.0, -99999.0, -99999.0);
			while((iter2) != (*iter).end()) {
				if( (*iter2).loc.x < minBnds.x) minBnds.x = (*iter2).loc.x;
				if( (*iter2).loc.y < minBnds.y) minBnds.y = (*iter2).loc.y;
				if( (*iter2).loc.z < minBnds.z) minBnds.z = (*iter2).loc.z;
				
				if( (*iter2).loc.x > maxBnds.x) maxBnds.x = (*iter2).loc.x;
				if( (*iter2).loc.y > maxBnds.y) maxBnds.y = (*iter2).loc.y;
				if( (*iter2).loc.z > maxBnds.z) maxBnds.z = (*iter2).loc.z;
				
				iter2++;
			}
		
				Vector midPnt, scaleNeg, scalePos;
				Vadd(&minBnds, &maxBnds, &midPnt);
				Vscale(&midPnt, 0.5);
				float radii = 9.0;

				
				dummyObj->SetDstBounds1( midPnt.x - radii, midPnt.y - radii, midPnt.z - radii);
				dummyObj->SetDstBounds2( midPnt.x + radii, midPnt.y + radii, midPnt.z + radii);
				Vector *dstBnd1 = dummyObj->GetDstBounds1();
				Vector *dstBnd2 = dummyObj->GetDstBounds2();
				dummyObj->SetDstBounds3(dstBnd2->x, dstBnd1->y, dstBnd1->z);
				dummyObj->SetDstBounds4(dstBnd2->x, dstBnd1->y, dstBnd2->z);
				dummyObj->SetDstBounds5(dstBnd1->x, dstBnd1->y, dstBnd2->z);
				dummyObj->SetDstBounds6(dstBnd2->x, dstBnd2->y, dstBnd1->z);
				dummyObj->SetDstBounds7(dstBnd1->x, dstBnd2->y, dstBnd2->z);
				dummyObj->SetDstBounds8(dstBnd1->x, dstBnd2->y, dstBnd1->z);
				
				for(int m = 0; m < ObjectList.size(); m++) {
					if(ObjectList[m].gamePacket.type == PLAYER_TYPE || ObjectList[m].gamePacket.type == GAME_PILLAR_TYPE) continue;
					if(OBBIntersect(dummyObj, ObjectList[m].curObject)) { //particle hits something
						flag = true;
						int wIndex = FPSGamePacket.weaponSelect;
						if( curOwner == FPS_PLAYER && ObjectList[m].gamePacket.type == PLAYER_TYPE) { cout << "Skipping" << endl; continue; }
						
						if(ObjectList[m].gamePacket.team > 0) {
							ObjectList[m].gamePacket.health = ObjectList[m].gamePacket.health - FPSGamePacket.weapons[wIndex].damage;
							if(ObjectList[m].gamePacket.health < 0) { ObjectList[m].gamePacket.health = -1; cout << "Object Killed" << endl; }
						}
					}
				} 
		}
		
		else if((*iter2).type == CANNON_SHOT_TYPE) {
			Vector diffVec, boundVec;
			Vsub( &(*iter2).prevLoc, &(*iter2).loc, &diffVec);
			Vcopy(&(*iter2).loc, &boundVec);
			float factor = 1.0 / (float)(PARTICLE_COLLIDE_ACCURACY);
			Vscale(&diffVec, factor);
			flag = false;
			
			for(int j = 0; j < PARTICLE_COLLIDE_ACCURACY; j++) {
				//set up the bounding box for the particle
				float radius = AmmoList[GetAmmoIndex( (*iter2).type)].radius;
				Vector minVec, maxVec;

				minVec.x = boundVec.x - radius;
				minVec.y = boundVec.y - radius;
				minVec.z = boundVec.z - radius;
				maxVec.x = boundVec.x + radius;
				maxVec.y = boundVec.y + radius;
				maxVec.z = boundVec.z + radius;
			
				dummyObj->SetDstBounds1( minVec.x, minVec.y, minVec.z );
				dummyObj->SetDstBounds2( maxVec.x, maxVec.y, maxVec.z );
				Vector *dstBnd1 = dummyObj->GetDstBounds1();
				Vector *dstBnd2 = dummyObj->GetDstBounds2();
				dummyObj->SetDstBounds3(dstBnd2->x, dstBnd1->y, dstBnd1->z);
				dummyObj->SetDstBounds4(dstBnd2->x, dstBnd1->y, dstBnd2->z);
				dummyObj->SetDstBounds5(dstBnd1->x, dstBnd1->y, dstBnd2->z);
				dummyObj->SetDstBounds6(dstBnd2->x, dstBnd2->y, dstBnd1->z);
				dummyObj->SetDstBounds7(dstBnd1->x, dstBnd2->y, dstBnd2->z);
				dummyObj->SetDstBounds8(dstBnd1->x, dstBnd2->y, dstBnd1->z);
			
				for(int i = 0; i < ObjectList.size(); i++) {
					int gtIndex = getGameTypeIndex(ObjectList[(*iter2).owner].gamePacket.type);
					if(ObjectList[i].curObject->GetType() == PLANE_TYPE) {
						TPlane *curPlane = ObjectList[i].curObject;
						Vector planeNorm = curPlane->GetNormal();
						if(planeNorm.y >= 0.8) continue;
						
					}
					if(OBBIntersect(dummyObj, ObjectList[i].curObject) && (*iter2).owner != i) { //particle hits something
						(*iter2).colObjIndex.push_back(i);
						flag = true;
						cout << "Hitting Index: " << i << " whose team is: " << ObjectList[i].gamePacket.team << endl;
						if(ObjectList[i].gamePacket.team >= 0) {
							ObjectList[i].gamePacket.health = ObjectList[i].gamePacket.health - gameObjectTypeList[gtIndex].damage;
							cout << "Object Health: " << ObjectList[i].gamePacket.health << endl;
							if(ObjectList[i].gamePacket.health < 0) { ObjectList[i].gamePacket.health = -1; cout << "Object Killed" << endl; }
						}
					}
				}

				if(OBBIntersect(NULL, dummyObj)) { //particle hits FPS guy
					(*iter2).colObjIndex.push_back(0);
					flag = true;
				} 
								
				if(flag) { break;}
				Vadd(&diffVec, &boundVec, &boundVec);
			}
		}
		
		else if((*iter2).type == MOUSE_SHOT_TYPE) {
			Vector diffVec, boundVec;
			Vsub( &(*iter2).prevLoc, &(*iter2).loc, &diffVec);
			Vcopy(&(*iter2).loc, &boundVec);
			float factor = 1.0 / (float)(PARTICLE_COLLIDE_ACCURACY);
			Vscale(&diffVec, factor);
			flag = false;
			
			for(int j = 0; j < PARTICLE_COLLIDE_ACCURACY; j++) {
				//set up the bounding box for the particle
				float radius = 5;
				Vector minVec, maxVec;

				minVec.x = boundVec.x - radius * 1.5;
				minVec.y = boundVec.y - radius * 0.5;
				minVec.z = boundVec.z - radius * 1.5;
				maxVec.x = boundVec.x + radius * 1.5;
				maxVec.y = boundVec.y + radius * 1.5;
				maxVec.z = boundVec.z + radius * 1.5;
			
				dummyObj->SetDstBounds1( minVec.x, minVec.y, minVec.z );
				dummyObj->SetDstBounds2( maxVec.x, maxVec.y, maxVec.z );
				Vector *dstBnd1 = dummyObj->GetDstBounds1();
				Vector *dstBnd2 = dummyObj->GetDstBounds2();
				dummyObj->SetDstBounds3(dstBnd2->x, dstBnd1->y, dstBnd1->z);
				dummyObj->SetDstBounds4(dstBnd2->x, dstBnd1->y, dstBnd2->z);
				dummyObj->SetDstBounds5(dstBnd1->x, dstBnd1->y, dstBnd2->z);
				dummyObj->SetDstBounds6(dstBnd2->x, dstBnd2->y, dstBnd1->z);
				dummyObj->SetDstBounds7(dstBnd1->x, dstBnd2->y, dstBnd2->z);
				dummyObj->SetDstBounds8(dstBnd1->x, dstBnd2->y, dstBnd1->z);
			
				for(int i = 0; i < ObjectList.size(); i++) {
					int gtIndex = getGameTypeIndex(ObjectList[(*iter2).owner].gamePacket.type);
					if(OBBIntersect(dummyObj, ObjectList[i].curObject) && (*iter2).owner != i) { //particle hits something
						(*iter2).colObjIndex.push_back(i);
						flag = true;
						cout << "Hitting Index: " << i << " whose team is: " << ObjectList[i].gamePacket.team << endl;
						if(ObjectList[i].gamePacket.team >= 0 || ObjectList[i].gamePacket.type == PLAYER_TYPE) {
							ObjectList[i].gamePacket.health = ObjectList[i].gamePacket.health - gameObjectTypeList[gtIndex].damage;
							cout << "Object Health: " << ObjectList[i].gamePacket.health << endl;
							if(ObjectList[i].gamePacket.health < 0) { ObjectList[i].gamePacket.health = -1; cout << "Object Killed" << endl; }
						}
					}
				}

				if(OBBIntersect(NULL, dummyObj)) { //particle hits FPS guy
					(*iter2).colObjIndex.push_back(0);
					flag = true;
				} 
								
				if(flag) { break;}
				Vadd(&diffVec, &boundVec, &boundVec);
			}
		}
		else if((*iter2).type == MELEE_TYPE) {
			Vector midPnt = (*iter2).loc;
			float radii = 5.0;
				
			dummyObj->SetDstBounds1( midPnt.x - radii, midPnt.y - radii * 3, midPnt.z - radii);
			dummyObj->SetDstBounds2( midPnt.x + radii, midPnt.y + radii, midPnt.z + radii);
			Vector *dstBnd1 = dummyObj->GetDstBounds1();
			Vector *dstBnd2 = dummyObj->GetDstBounds2();
			dummyObj->SetDstBounds3(dstBnd2->x, dstBnd1->y, dstBnd1->z);
			dummyObj->SetDstBounds4(dstBnd2->x, dstBnd1->y, dstBnd2->z);
			dummyObj->SetDstBounds5(dstBnd1->x, dstBnd1->y, dstBnd2->z);
			dummyObj->SetDstBounds6(dstBnd2->x, dstBnd2->y, dstBnd1->z);
			dummyObj->SetDstBounds7(dstBnd1->x, dstBnd2->y, dstBnd2->z);
			dummyObj->SetDstBounds8(dstBnd1->x, dstBnd2->y, dstBnd1->z);
				
			for(int m = 0; m < ObjectList.size(); m++) {
				if(OBBIntersect(dummyObj, ObjectList[m].curObject)) { //particle hits something
					flag = true;
					int wIndex = FPSGamePacket.weaponSelect;
					if( (*iter2).owner == FPS_PLAYER && ObjectList[m].gamePacket.type == PLAYER_TYPE) { cout << "Skipping" << endl; continue; }
					
					if(ObjectList[m].gamePacket.team > 0) {
						ObjectList[m].gamePacket.health = ObjectList[m].gamePacket.health - FPSGamePacket.weapons[wIndex].damage;
						if(ObjectList[m].gamePacket.health < 0) { ObjectList[m].gamePacket.health = -1; cout << "Object Killed" << endl; }
					}
				}
			} 
			
		}
		

	}
	
}

int TFPS::getGameTypeIndex(int type) {
	for(int i = 0; i < gameObjectTypeList.size(); i++) {
		if(gameObjectTypeList[i].type == type) return i;
	}
	
	return -1;
}










                              
