/***************************************************************************
                          tconsole.h  -  description
                             -------------------
    begin                : Fri Jul 4 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TCONSOLE_H
#define TCONSOLE_H

#include "tinfrastructure.h"

const int SHOW_ALL = -1;
const int NO_STRING = -2;

/**
  *@author Chong Jiayi
  */
struct stringLine {
	string line;
	int fontset;
	bool symbolStart;
};

class TConsole {
protected:
	int x1,y1,x2,y2;
	int visibleDataCnt;
	vector <stringLine> data;
	TInfrastructure *curInfrastructure;
	bool border;
	float r, g, b, a;
	float r2, g2, b2, a2;
	bool startSymbol;
	void RenderBorder();
public: 
	TConsole(int setX1, int setY1, int setX2, int setY2, TInfrastructure *theInfrastructure);
	~TConsole();
	void AddString(string addData, int fontset, bool symbolStart);
	void Clear() { data.clear(); }
	string GetString(int index) { return data[index].line; }
	void ReplaceString(string replaceString, int index) { data[index].line = replaceString; }
	void SetVisibleLines(int cnt);
	void Render();
	void RenderLines(int from, int to);
	void SetBorder(bool flag, float red, float green, float blue, float alpha, float red2, float green2, float blue2, float alpha2);
	void SetLoc(int setX1, int setY1, int setX2, int setY2);
	void SetStartSymbol(bool flag) { startSymbol = flag; }
	int GetNumStrings() { return data.size(); }
	int AddInputChar(char *c);
};

#endif
