/***************************************************************************
                          tconsole.cpp  -  description
                             -------------------
    begin                : Fri Jul 4 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "tconsole.h"

TConsole::TConsole(int setX1, int setY1, int setX2, int setY2, TInfrastructure *theInfrastructure){
	x1 = setX1;
	y1 = setY1;
	x2 = setX2;
	y2 = setY2;
	visibleDataCnt = SHOW_ALL;
	curInfrastructure = theInfrastructure;
	border = false;
	startSymbol = false;
}

TConsole::~TConsole(){
}

void TConsole::AddString(string addData, int fontset, bool symbolStart) {
	stringLine newstringLine;
	newstringLine.fontset = fontset;
	newstringLine.line = addData;
	newstringLine.symbolStart = symbolStart;
	data.push_back(newstringLine);
}

void TConsole::SetVisibleLines(int cnt) {
	visibleDataCnt = cnt;
}


void TConsole::Render() {
	glEnable(GL_BLEND);
	glBlendFunc( GL_SRC_ALPHA, GL_ONE);

	if(visibleDataCnt == SHOW_ALL) {
		RenderLines(0, data.size() - 1);
	}
	else {
		if(data.size() > visibleDataCnt) 	RenderLines(data.size() - 1 - (visibleDataCnt - 1), data.size() - 1);
		else RenderLines(0, data.size() - 1);
	}

	if(border) RenderBorder();

	glDisable(GL_BLEND);

}

void TConsole::RenderBorder() {
	glActiveTextureARB(GL_TEXTURE0_ARB );
	glDisable(GL_TEXTURE_CUBE_MAP_ARB );
	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE1_ARB );
	glDisable(GL_TEXTURE_CUBE_MAP_ARB );
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_CULL_FACE );
	glDisable(GL_REGISTER_COMBINERS_NV);
	
	glDisable( GL_DEPTH_TEST );
	glMatrixMode( GL_PROJECTION );
		glPushMatrix( );
		glLoadIdentity( );
		glOrtho(0, curInfrastructure->GetWinWidth(), 0, curInfrastructure->GetWinHeight(), -1, 1);

	glMatrixMode( GL_MODELVIEW );
		glPushMatrix( );
		glLoadIdentity( );

	//render the border
	glBegin(GL_QUADS);
		glColor4f(r, g, b, a);
		glVertex2d(x1, y1);
		glVertex2d(x2, y1);
		glColor4f(r2, g2, b2, a2);
		glVertex2d(x2, y2);
		glVertex2d(x1, y2);
	glEnd();
	
	glMatrixMode( GL_PROJECTION );
	glPopMatrix( );
	glMatrixMode( GL_MODELVIEW );
	glPopMatrix( );
	glEnable( GL_DEPTH_TEST );
	glEnable(GL_CULL_FACE );
}

void TConsole::RenderLines(int from, int to) {
	int startX = x1, startY = y2 - 16;
	int curY = startY;
	
	for(int i = from; i <= to; i++) {
		if(data[i].symbolStart) {
			curInfrastructure->screenPrint((int)startX, (int)curY, ">", (int)data[i].fontset, 1.0, 1.0);
			string printString;
			if(data[i].line.length() > 0 && i == data.size() - 1) printString = data[i].line + "_";
			else printString = data[i].line;
			if((printString.length() * 16 + startX + 16) > x2) {
				int curLength = printString.length();
				int curPos = 0;
				int maxLength = abs((float)(x2 - x1) / 16.0f) + 6;
				while(curLength > 0) {
					string curString;
					if(curLength > maxLength) {curString = printString.substr(curPos, maxLength); curPos = curPos + maxLength; curLength = curLength - maxLength;}
					else {curString = printString.substr(curPos, curLength); curLength = 0;}
					curInfrastructure->screenPrint((int)startX + 16, (int)curY, (char *)curString.c_str(), (int)data[i].fontset, 1.0, 1.0);
					curY = curY - 16;
					if(curY < y1) break;
				}
			}
			else curInfrastructure->screenPrint((int)startX + 16, (int)curY, (char *)printString.c_str(), (int)data[i].fontset, 1.0, 1.0);
		}
		else curInfrastructure->screenPrint((int)startX, (int)curY, (char *)data[i].line.c_str(), (int)data[i].fontset, 1.0, 1.0);

		curY = curY - 16;
		if(curY < y1) break;
	}
}

void TConsole::SetBorder(bool flag, float red, float green, float blue, float alpha, float red2, float green2, float blue2, float alpha2) {
	border = flag;
	r = red;
	g = green;
	b = blue;
	a = alpha;

	r2 = red2;
	g2 = green2;
	b2 = blue2;
	a2 = alpha2;
}

void TConsole::SetLoc(int setX1, int setY1, int setX2, int setY2) {
	x1 = setX1;
	y1 = setY1;
	x2 = setX2;
	y2 = setY2;
}

int TConsole::AddInputChar(char *c) {
	string addString = c;
	if(*c != '\r' && *c != '\b') {
		data[data.size() - 1].line = data[data.size() - 1].line + addString;
		return NO_STRING;
	}
	else if(*c == '\b') {
		if(data[data.size() - 1].line.length() > 0) data[data.size() - 1].line.erase(data[data.size() - 1].line.length() - 1, 1);
		return NO_STRING;
	}
	

	AddString("", 0, true);
	return data.size() - 2;
}





