/***************************************************************************
                          tbutton.h  -  description
                             -------------------
    begin                : Mon Jul 28 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TBUTTON_H
#define TBUTTON_H

#include "twidget.h"
#include "tlabel.h"


/**
  *@author Chong Jiayi
  */

class TButton : public TWidget  {
protected:
	TLabel *title;
	TWidgetRender *curRender;
	bool loaded;
	bool state;
	int textOffsetX, textOffsetY;
	
	GLfloat red1[2], green1[2], blue1[2], curAlpha[2];
	GLfloat red2[2], green2[2], blue2[2];

public: 
	TButton(TInfrastructure *theInfrastructure);
	~TButton();

	void setTitle(char *curTitle, int fontSet);	
	void setTextColor(GLfloat r, GLfloat g, GLfloat b, GLfloat alpha);
	void setTextOffset(int offsetX, int offsetY);
	void render(int X, int Y);	
	
	void setButtonUpColor(GLfloat inred1, GLfloat ingreen1, GLfloat inblue1, 
					GLfloat inred2, GLfloat ingreen2, GLfloat inblue2, GLfloat inAlpha);
	void setButtonDownColor(GLfloat inred1, GLfloat ingreen1, GLfloat inblue1, 
					GLfloat inred2, GLfloat ingreen2, GLfloat inblue2, GLfloat inAlpha);

	int getType() { return BUTTON_TYPE; }
	void inputMouseDown(int x, int y);
	void inputMouseUp(int x, int y);
	void show(bool flag);
};

#endif
