/***************************************************************************
                          selectclient.h  -  description
                             -------------------
    begin                : Tue Aug 26 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef SELECTCLIENT_H
#define SELECTCLIENT_H

#include "trts.h"
#include "twidgetmanager.h"
#include "twidgetwindow.h"
#include "tbutton.h"
#include "tconsole.h"

const int HUMAN_SELECTED = 1;
const int MOUSE_SELECTED = 2;

/**
  *@author Chong Jiayi
  */

class selectClient {
protected:
	TInfrastructure *curInfrastructure;
	TRTS *myScene;
	TWidgetManager *myWidgetManager;
	TButton *MouseButton;
	TButton *ManButton;
	TButton *SelectedButton1;
	TButton *SelectedButton2;
	TButton *GoButton;
	TButton *LoadWords;
	
	float rotY1, rotY2;
	int changeSelect;
	int finalSelect;
	bool done;
public: 
	selectClient(TInfrastructure *infrastructure);
	~selectClient();
	
	TButton *getSelect1() { return SelectedButton1; }
	TButton *getSelect2() { return SelectedButton2; }
	void setChangeSelect(int change) { changeSelect = change; }
	void finalizeSelect() { finalSelect = changeSelect; LoadWords->setTitle("Loading...", 0); renderAll();}
	
	void initialize(char *filename);
	void processEvent(SDL_Event *curEvent);
	void resetSelect() {finalSelect = -1; LoadWords->setTitle("", 0);}
	void release();
	void renderAll();
	int getFinalSelect() { return finalSelect; }
};

#endif
