/***************************************************************************
                          rtsclient.h  -  description
                             -------------------
    begin                : Mon Aug 25 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef RTSCLIENT_H
#define RTSCLIENT_H

#include <iostream.h>
#include <stdlib.h>
#include <string>

#include "trts.h"
#include "twidgetmanager.h"
#include "twidgetwindow.h"
#include "tbutton.h"
#include "tpicbutton.h"
#include "tconsole.h"

/**
  *@author Chong Jiayi
  */

class RTSClient {
protected:
	TInfrastructure *curInfrastructure;
	TRTS *myScene;
	TConsole *myConsole;
	TWidgetManager *myWidgetManager;
	TWidgetManager *myWidgetManager2;
	float viewZDisp, viewXDisp, viewYDisp, healthRot, ammoRot;
	TButton *ResourceWords;
	TPicButton *mousewin_Pic;
	TPicButton *humanwin_Pic;
	bool showConsole;
	bool leftDown, rightDown;
	bool done;
	bool firstDrawFrame;
	int prevAmmo, prevHealth;
	int mode;
	SDL_Event event;
	LoadCallEvent callBackFunc;
	void *callBackObj;
	
	void updateDisplay();
	bool once;
	
	

public: 
	RTSClient(TInfrastructure *infrastructure);
	~RTSClient();
	
	void initialize(char *sceneFile, char *weaponFile, char *itemsFile);
	void release();
	void processEvent(SDL_Event *curEvent);
	void renderAll();
	void setCallBack(void *obj, LoadCallEvent curCall) { callBackFunc = curCall; callBackObj = obj; }
	void resetCallBack() { myScene->SetCallBack(NULL, NULL); }
	void setMode(int curMode) { mode = curMode; }
};

#endif
