/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun Dec 15 17:50:53 PST 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include <string>
#include "tinfrastructure.h"
#include "tplane.h"
#include "tmd2.h"
#include "tscene.h"
#include "tconsole.h"
#include "tlevelgen.h"
#include "tfps.h"
#include "trts.h"
#include "twidgetmanager.h"
#include "twidgetwindow.h"
#include "tbutton.h"
#include "rtsclient.h"

//#include <GL/glu.h>

//global declarations, we are testing the engine so it's ok
char win_title[] = "Troodon Engine - Chong Jiayi";
TInfrastructure Infrastructure(800, 600, 0, 0, win_title);
TPlane myPlane(&Infrastructure);
TPlane myPlane2(&Infrastructure);
TMd2 myMd2(&Infrastructure);
TMd2 myMd2_2(&Infrastructure);
TRTS myScene(&Infrastructure);
TConsole myConsole(0, 400, 800, 600, &Infrastructure);
TLevelGen myLevelGen(&myScene);
TWidgetWindow myWindow(&Infrastructure);
TButton myButton(&Infrastructure);
TWidgetManager myWidgetManager(&Infrastructure);
RTSClient rtsObject(&Infrastructure);


GLfloat angleY = 0.0f;
GLfloat viewAngleY = 0.0f;
GLfloat viewAngleX = 0.0f;
GLfloat viewZ = 0.0f;
GLfloat viewX = 0.0f;
GLfloat distanceZ = -95.0f;
float viewZDisp = 0.0f, viewXDisp = 0.0f, viewYDisp = 0.0f;
bool showConsole = false;
bool leftDown = false, rightDown = false;

void DrawGLScene();
void TestMouseUp(int x, int y);

		
int main(int argc, char *argv[])
{

	Uint8* keys = NULL; // This variable will be used in the keyboard routine
	int done = false;
	Infrastructure.CreateGL(false);

	rtsObject.initialize(argv[1], "weapons.scn");

	SDL_EnableUNICODE(1);

	

	//SDL_EnableKeyRepeat(10, 10);
  // This is the main loop for the entire program and it will run until done==TRUE

  while(!done)
  {
    // And poll for events
    SDL_Event event;
    while ( SDL_PollEvent(&event) ) {
      switch (event.type) {
        // If a quit event was recieved
        case SDL_QUIT:
          // then we're done and we'll end this program
          done = true;
          break;
      }
      
      rtsObject.processEvent(&event);
    }

    // Get the state of the keyboard keys
    keys = SDL_GetKeyState(NULL);

    // and check if ESCAPE has been pressed. If so then quit
    if(keys[SDLK_ESCAPE]) done = true;
    
    rtsObject.renderAll();

    SDL_GL_SwapBuffers( );
  }

  rtsObject.release();
  Infrastructure.KillGLWindow();
//  myScene.SaveSceneFile("test2.scn");
  return EXIT_SUCCESS;
}


