/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun Dec 15 17:50:53 PST 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include <string>
#include "tinfrastructure.h"
#include "tplane.h"
#include "tmd2.h"
#include "tscene.h"
#include "tconsole.h"
#include "tlevelgen.h"
#include "tfps.h"
//#include <GL/glu.h>

//global declarations, we are testing the engine so it's ok
char win_title[] = "Troodon Engine Room Generator - Chong Jiayi";
TInfrastructure Infrastructure(800, 600, 0, 0, win_title);
TPlane myPlane(&Infrastructure);
TPlane myPlane2(&Infrastructure);
TMd2 myMd2(&Infrastructure);
TMd2 myMd2_2(&Infrastructure);
TFPS myScene(&Infrastructure);
TConsole myConsole(0, 400, 800, 600, &Infrastructure);
TLevelGen myLevelGen(&myScene);
GLfloat angleY = 0.0f;
GLfloat viewAngleY = 0.0f;
GLfloat viewAngleX = 0.0f;
GLfloat viewZ = 0.0f;
GLfloat viewX = 0.0f;
GLfloat distanceZ = -95.0f;
float viewZDisp = 0.0f, viewXDisp = 0.0f, viewYDisp = 0.0f;
bool showConsole = false;
bool leftDown = false, rightDown = false;

void DrawGLScene();
		
int main(int argc, char *argv[])
{

	Uint8* keys = NULL; // This variable will be used in the keyboard routine
	int done = false;
	bool fullScreen = false;
	if(argc > 2) {
		if(*argv[2] != '0') fullScreen = true;
	}
	else {
		cout << " <inputfile>  <fullscreen> " << endl;
		return 0;
	}
	
	Infrastructure.CreateGL(fullScreen);

	myLevelGen.LoadTextureList("texturelist.des");
	myLevelGen.LoadRoomGen(argv[1]);
	myLevelGen.GenerateLevel("tmp1234.des");

	myScene.LoadSceneFile("tmp1234.des");
	myScene.LoadWeaponsFromFile("weapons.scn");
	myConsole.AddString("Welcome to the Troodon Engine", 0, false);
	myConsole.AddString("Current Build: 001", 1, false);
	myConsole.AddString("", 0, true);
	myConsole.SetBorder(true, 0.5, 0.5, 0.5, 0.5, 0.0, 0.0, 0.0, 0.5);
	myConsole.SetVisibleLines(6);

	SDL_EnableUNICODE(1);

	for(int i = 0; i < myScene.GetObjectNum(); i++) {
	TObject *curObject = myScene.GetObject(i);
		if(curObject->GetType() == MD2_TYPE) {
			TMd2 *curMd2 = (TMd2 *)curObject;
			curMd2->SetCurrentAnimation(0, 5);
		}
	}
	
	SDL_WarpMouse(0, 0);
	myScene.MoveViewerDelta(0.0, 0.0, 0.0, 0.0, 0.0, 0.0f);
	myScene.setKeyBind(SDLK_a, SDLK_d, SDLK_w, SDLK_s, SDLK_SPACE);
	myScene.setMovement(0.7, 0.7, 1.7, 0.7, 0.7);

  // This is the main loop for the entire program and it will run until done==TRUE
  while(!done)
  {
    // Draw the scene
    DrawGLScene();
    // And poll for events
    SDL_Event event;
    while ( SDL_PollEvent(&event) ) {
      switch (event.type) {
        // If a quit event was recieved
        case SDL_QUIT:
          // then we're done and we'll end this progr           /*if(event.motion.xrel > 0) viewAngleY = viewAngleY - 0.7;

          done = true;
          break;

        case SDL_MOUSEMOTION:
	   myScene.mouseInput(event.motion.xrel, event.motion.yrel, leftDown, rightDown);

           break;
	   
	 case SDL_MOUSEBUTTONDOWN:           /*if(event.motion.xrel > 0) viewAngleY = viewAngleY - 0.7;
           else viewAngleY = viewAngleY + 0.7;*/

	 	if(event.button.button == SDL_BUTTON_LEFT) leftDown = true;
	 	if(event.button.button == SDL_BUTTON_RIGHT) rightDown = true;
	       myScene.mouseInput(event.motion.xrel, event.motion.yrel, leftDown, rightDown);
	 break;

	 case SDL_MOUSEBUTTONUP:
	 	if(event.button.button == SDL_BUTTON_LEFT) leftDown = false;
	 	if(event.button.button == SDL_BUTTON_RIGHT) rightDown = false;
	       myScene.mouseInput(event.motion.xrel, event.motion.yrel, leftDown, rightDown);
	 break;
	 	 
        case SDL_KEYDOWN:
			if(showConsole == false) {
          switch( event.key.keysym.sym ) {
				case SDLK_BACKQUOTE:
					showConsole = !showConsole;
				break;
				
				default:
					myScene.userInput(event.key.keysym.sym);
				break;
			 }
		}
		else {
          switch( event.key.keysym.sym ) {
				case SDLK_BACKQUOTE:
				showConsole = !showConsole;
				break;

				case SDLK_LSHIFT:
				break;

				case SDLK_RSHIFT:
				break;

				default:
				char inputChar[2];
				inputChar[0] = event.key.keysym.unicode;
				inputChar[1] = '\0';
				int retval = myConsole.AddInputChar(inputChar);

				if(retval != NO_STRING) {
					if(myConsole.GetString(retval) == "quit") {done = true;}
					else if(myConsole.GetString(retval) == "set renderlevel 0") {myScene.SetRenderLevel(RENDER_LEVEL0);}
					else if(myConsole.GetString(retval) == "set renderlevel 1") {myScene.SetRenderLevel(RENDER_LEVEL1);}
					else if(myConsole.GetString(retval) == "set renderlevel 2") {myScene.SetRenderLevel(RENDER_LEVEL2);}
					else if(myConsole.GetString(retval).length() > 5 ) {
						if(myConsole.GetString(retval).substr(0, 4) == "save") {
							myLevelGen.GenerateLevel((char *)myConsole.GetString(retval).substr(5, myConsole.GetString(retval).length()).c_str() );
							myConsole.AddString("File Saved", 1, false);	myConsole.AddString("", 0, true);
						}
						else {myConsole.AddString("Invalid Command", 1, false);	myConsole.AddString("", 0, true); }
					}
					
					else {myConsole.AddString("Invalid Command", 1, false);	myConsole.AddString("", 0, true);}
				}
		
				break;
			  }
		}
		
          break;
        case SDL_KEYUP:
          switch( event.key.keysym.sym ) {
				
				default:
					myScene.userKeyUp(event.key.keysym.sym);
				break;
	  }
	
        break;

        default:
          break;

        
      }
    }

    // Get the state of the keyboard keys
    keys = SDL_GetKeyState(NULL);

    // and check if ESCAPE has been pressed. If so then quit
    if(keys[SDLK_ESCAPE]) done = true;

    SDL_GL_SwapBuffers( );
  }

  Infrastructure.KillGLWindow();
  return EXIT_SUCCESS;
}


void SceneRender() {
	Vector lightVec, eyeVec;
	lightVec.x = 0.0f;
	lightVec.y = 0.0f;
	lightVec.z = -4.0f;

	eyeVec.x = -30.0f;
	eyeVec.y = 0.0f;
	eyeVec.z = 600.0f;
	

	for(int i = 0; i < myScene.GetObjectNum(); i++) {
		TObject *curObject = myScene.GetObject(i);
		if(curObject->GetType() == MD2_TYPE) {
			TMd2 *curMd2 = (TMd2 *)curObject;
//			curMd2->SetCurrentAnimation(1);
			curMd2->PlayAnimation();
		}
	}

	viewX = viewX + viewXDisp;
	viewZ = viewZ + viewZDisp;


	myScene.PrepareSceneForCulling();       

	myScene.RestoreSceneObjectsTransform();
	myScene.ApplyMd2PhysicsTransform();
	myScene.RecalcSectorPos();
	myScene.ApplyUserInput();
	myScene.TryMoveFPSViewerPhysics();

	myScene.ApplyViewerTransform();
	myScene.DoLightingCalc();
	myScene.PortalCull();
	myScene.FrustrumCull();
	myScene.RenderAll();
	myScene.RenderFPSWeapon();
	myScene.simulateAmmo();
	myScene.renderAmmo();
	

	if(showConsole) {
		glColor4f(1.0, 1.0, 1.0, 1.0);
		myConsole.Render();
	}
}

void DrawGLScene() {
	/* Clear the color and depth buffers. */
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);

	SceneRender();
}
