/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun Dec 15 17:50:53 PST 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include <string>
#include "tinfrastructure.h"
#include "tplane.h"
#include "tmd2.h"
#include "tscene.h"
#include "tconsole.h"
#include "tlevelgen.h"
#include "tfps.h"
#include "trts.h"
#include "twidgetmanager.h"
#include "twidgetwindow.h"
#include "tbutton.h"
#include "selectclient.h"
#include "rtsclient.h"
#include "fpsclient.h"
#include "mainscreen.h"
#include "networkscreen.h"

//#include <GL/glu.h>

const int SELECTION_MODE = 0;
const int FPS_PLAY_MODE = 1;
const int RTS_PLAY_MODE = 2;
const int MAIN_SELECTION_MODE = 3;
const int JUST_HOST_MODE = 100;

static void clientJoinCallBack(void *data);

//global declarations, we are testing the engine so it's ok
char win_title[] = "Mice and Men alpha build";
TInfrastructure Infrastructure(800, 600, 0, 0, win_title);
TPlane myPlane(&Infrastructure);
TPlane myPlane2(&Infrastructure);
TMd2 myMd2(&Infrastructure);
TMd2 myMd2_2(&Infrastructure);
TRTS myScene(&Infrastructure);
TConsole myConsole(0, 400, 800, 600, &Infrastructure);
TLevelGen myLevelGen(&myScene);
TWidgetWindow myWindow(&Infrastructure);
TButton myButton(&Infrastructure);
TWidgetManager myWidgetManager(&Infrastructure);
MainScreen mainObject(&Infrastructure);
selectClient selectObject(&Infrastructure);
networkScreen networkObject(&Infrastructure);
FPSClient *fpsObject = NULL;
RTSClient *rtsObject = NULL;
TNetwork *curNetworkManager = NULL;
int debugMode = false;

GLfloat angleY = 0.0f;
GLfloat viewAngleY = 0.0f;
GLfloat viewAngleX = 0.0f;
GLfloat viewZ = 0.0f;
GLfloat viewX = 0.0f;
GLfloat distanceZ = -95.0f;
float viewZDisp = 0.0f, viewXDisp = 0.0f, viewYDisp = 0.0f;
bool showConsole = false;
bool leftDown = false, rightDown = false;
int mode = MAIN_SELECTION_MODE; //SELECTION_MODE;

void DrawGLScene();
void TestMouseUp(int x, int y);
static void LoadPrintInfo(void *obj, char *text);
		
int main(int argc, char *argv[])
{

	Uint8* keys = NULL; // This variable will be used in the keyboard routine
	int done = false;
	if(argc > 2) {
		if(*argv[2] == '1')
			Infrastructure.CreateGL(true);
		else if(*argv[2] == '2') { debugMode = true; Infrastructure.CreateGL(false); }
		else if(*argv[2] == '3') { debugMode = 2; Infrastructure.CreateGL(false); }
		else { mode = JUST_HOST_MODE; }
	}
	else	Infrastructure.CreateGL(false);
	Infrastructure.LoadSoundFileList("./sounds.des");
	Infrastructure.LoadConfigKeys("./config.cfg");
	Infrastructure.PlayMusic(TUNE2_MUSIC);

	if(mode != JUST_HOST_MODE) {
//		selectObject.initialize("selectscreen.scn");
		mainObject.initialize("mainselectscreen.scn");
		networkObject.initialize("");
	}
	
	curNetworkManager = Infrastructure.getNetwork();
	if(mode == JUST_HOST_MODE) {
		curNetworkManager->disConnect();
		curNetworkManager->allowConnect(NULL, NULL);
	}

	SDL_EnableUNICODE(1);

	

	//SDL_EnableKeyRepeat(10, 10);
  // This is the main loop for the entire program and it will run until done==TRUE

  while(!done)
  {
    // And poll for events
    SDL_Event event;
    while ( SDL_PollEvent(&event) ) {
    
    switch(mode) {
	case MAIN_SELECTION_MODE:
		mainObject.processEvent(&event);
	break;
	
    	case SELECTION_MODE:
//		selectObject.processEvent(&event);
	break;
	
	case FPS_PLAY_MODE:
		fpsObject->processEvent(&event);
	break;
	
	case RTS_PLAY_MODE:
		rtsObject->processEvent(&event);
	break;
	
	case NETWORK_HOST_MODE:
		networkObject.processEvent(&event);
	break;
	
	case NETWORK_JOIN_MODE:
		networkObject.processEvent(&event);
	break;
    }
      
      switch (event.type) {
        // If a quit event was recieved
        case SDL_QUIT:
          // then we're done and we'll end this program
          done = true;
          break;
      }
      
//      rtsObject.processEvent(&event);
    }
    
    // Get the state of the keyboard keys
    keys = SDL_GetKeyState(NULL);

    // and check if ESCAPE has been pressed. If so then quit
    if(keys[SDLK_ESCAPE]) {
    	curNetworkManager->stopNetwork();
	
    	switch(mode) {
		case SELECTION_MODE:
			mode = MAIN_SELECTION_MODE;
		break;
		
		case FPS_PLAY_MODE:
			fpsObject->release();
			delete fpsObject;
			fpsObject = NULL;
			mode = MAIN_SELECTION_MODE;
			keys[SDLK_ESCAPE] = false;
		break;
		
		case RTS_PLAY_MODE:
			rtsObject->release();
			delete rtsObject;
			rtsObject = NULL;
			mode = MAIN_SELECTION_MODE;
			keys[SDLK_ESCAPE] = false;
		break;
	}
    } 
	//do rendering
	switch(mode) {
		case MAIN_SELECTION_MODE:
			mainObject.renderAll();
		break;
		
		case SELECTION_MODE:
//			selectObject.renderAll();
		break;
	
		case FPS_PLAY_MODE:
			fpsObject->renderAll();
		break;
	
		case RTS_PLAY_MODE:
			rtsObject->renderAll();
		break;
		
		case NETWORK_HOST_MODE:
			networkObject.renderAll();
		break;
		
		case NETWORK_JOIN_MODE:
			networkObject.renderAll();
		break;
    }    

    if(mode != JUST_HOST_MODE) SDL_GL_SwapBuffers( );
    
	if(mode == SELECTION_MODE) {
		networkObject.makeActive(false);
	
		if(selectObject.getFinalSelect() == HUMAN_SELECTED) { // load the fps client
			mode = networkObject.getMode();
			networkObject.setFaction(FPS_PLAY_MODE);
			networkObject.syncSettings();
			selectObject.resetSelect();
		}
		else if(selectObject.getFinalSelect() == MOUSE_SELECTED) {
			mode = networkObject.getMode();
			networkObject.setFaction(RTS_PLAY_MODE);
			networkObject.syncSettings();
			selectObject.resetSelect();
		}
	}
	
	else if(mode == MAIN_SELECTION_MODE) {
		int gotoMode = mainObject.getSelect();
		switch(gotoMode) {
			case HOST_MODE_SELECTED:
				mode = NETWORK_HOST_MODE;
				networkObject.setMode(NETWORK_HOST_MODE);
				if(debugMode == 2) {
					 networkObject.setFaction(FPS_PLAY_MODE);
				}
				else networkObject.setFaction(RTS_PLAY_MODE);
				networkObject.syncSettings();
				curNetworkManager->disConnect();
				curNetworkManager->allowConnect(&clientJoinCallBack, (void *)&networkObject);
				networkObject.addTextPlayers("Mouse Host");
			break;
			
			case JOIN_MODE_SELECTED:
				mode = NETWORK_JOIN_MODE;
				networkObject.setFaction(FPS_PLAY_MODE);
				networkObject.syncSettings();
				networkObject.setMode(NETWORK_JOIN_MODE);
				curNetworkManager->startNetwork(NULL, NULL);
				networkObject.addTextPlayers("Mouse Host");
				networkObject.addTextPlayers("Human Client");
			break;
			
			case CONFIG_MODE_SELECTED:
			break;
			
			case EXIT_MODE_SELECTED:
				done = true;
			break;
		}
	}
	else if(mode == NETWORK_HOST_MODE) {
		networkObject.makeActive(true);
		int destMode = networkObject.getMode();
		switch(destMode) {
			case MAIN_SELECTION_MODE:
				mode = MAIN_SELECTION_MODE;
				networkObject.resetSelection();
			break;
			
			case FPS_PLAY_MODE:
				curNetworkManager->startNetwork(NULL, NULL);
				networkObject.makeActive(false);
				mode = FPS_PLAY_MODE;
				fpsObject = new FPSClient(&Infrastructure);
				if(!debugMode) rtsObject->setMode(SERVER_FPS_MODE);
				fpsObject->setCallBack((void *)&networkObject, &LoadPrintInfo);
				fpsObject->initialize(argv[1], "weapons.scn", "items.des"); 
				networkObject.resetSelection();
				fpsObject->resetCallBack();
				networkObject.clearText();
				networkObject.addText("Mice and Men MultiPlayer");
			break;
			
			case RTS_PLAY_MODE:
				curNetworkManager->startNetwork(NULL, NULL);
				networkObject.makeActive(false);
				mode = RTS_PLAY_MODE;
				rtsObject = new RTSClient(&Infrastructure);
				if(!debugMode) rtsObject->setMode(SERVER_RTS_MODE);
				rtsObject->setCallBack((void *)&networkObject, &LoadPrintInfo);
				rtsObject->initialize(argv[1], "weapons.scn", "items.des"); 
				networkObject.resetSelection();
				rtsObject->resetCallBack();
				networkObject.clearText();
				networkObject.addText("Mice and Men MultiPlayer");
			break;
			
			case SELECTION_MODE:
				networkObject.makeActive(false);
				mode = SELECTION_MODE;
				networkObject.setMode(NETWORK_HOST_MODE);
			break;
			
			default:
			break;
		}
	}
	else if(mode == NETWORK_JOIN_MODE) {
		networkObject.makeActive(true);
		int destMode = networkObject.getMode();
		switch(destMode) {
			case MAIN_SELECTION_MODE:
				mode = MAIN_SELECTION_MODE;
				networkObject.resetSelection();
			break;
			
			case FPS_PLAY_MODE:
				curNetworkManager->startNetwork(NULL, NULL);
				networkObject.makeActive(false);
				mode = FPS_PLAY_MODE;
				fpsObject = new FPSClient(&Infrastructure);
				if(!debugMode) fpsObject->setMode(CLIENT_FPS_MODE);
				fpsObject->setCallBack((void *)&networkObject, &LoadPrintInfo);
				fpsObject->initialize(argv[1], "weapons.scn", "items.des"); 
				networkObject.resetSelection();
				fpsObject->resetCallBack();
				networkObject.clearText();
				networkObject.addText("Mice and Men MultiPlayer");
				SDL_WarpMouse(Infrastructure.GetWinWidth() * 0.5, Infrastructure.GetWinHeight() * 0.5);
			break;
			
			case RTS_PLAY_MODE:
			break;
			
			case SELECTION_MODE:
				networkObject.makeActive(false);
				mode = SELECTION_MODE;
				networkObject.setMode(NETWORK_JOIN_MODE);
			break;
			
			default:
			break;
		}
	}
	else if(mode == JUST_HOST_MODE) {
		
	}

  }

  selectObject.release();
  mainObject.release();
  Infrastructure.SaveConfigKeys("./config.cfg");
  Infrastructure.KillGLWindow();
//  myScene.SaveSceneFile("test2.scn");
  return EXIT_SUCCESS;
}

static void LoadPrintInfo(void *obj, char *text) {
	networkScreen *curObj = (networkScreen *)obj;
	string addInfo = text;
	curObj->addText(addInfo);
	curObj->renderAll();
	SDL_GL_SwapBuffers( );
}


static void clientJoinCallBack(void *data) {
	networkObject.addTextPlayers("Human Client");
}
