/***************************************************************************
                          fpsclient.cpp  -  description
                             -------------------
    begin                : Sun Aug 24 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "fpsclient.h"
const int MENU_BUTTON_WIDTH = 256;
const int MENU_BUTTON_HEIGHT = 128;


void HealthWordPress(void *obj, int x, int y);

FPSClient::FPSClient(TInfrastructure *infrastructure){
	curInfrastructure = infrastructure;
	myScene = NULL;
	myConsole = NULL;
	myWidgetManager = NULL;
	myWidgetManager2 = NULL;
	HealthWords = NULL;
	AmmoWords = NULL;
	HealthMd2 = NULL;
	AmmoMd2 = NULL;
	showConsole = false;
	leftDown = false;
	rightDown = false;
	done = false;
	once = false;
	healthRot = 0.0;
	ammoRot = 0.0;
	
	callBackFunc = NULL;
	callBackObj = NULL;
	
	mode = NORMAL_MODE;
}

FPSClient::~FPSClient(){
}

void FPSClient::initialize(char *sceneFile, char *weaponFile, char *itemsFile) {
	myScene = new TRTS(curInfrastructure);
	myConsole = new TConsole(0, 0.6 * curInfrastructure->GetWinHeight(), curInfrastructure->GetWinWidth(), curInfrastructure->GetWinHeight(), curInfrastructure);
	myScene->SetCallBack(callBackObj, callBackFunc);	
	
	myScene->LoadSceneFile(sceneFile);
	myScene->LoadWeaponsFromFile(weaponFile);
	myScene->LoadUnitInfoFile("units.des");
	myScene->LoadItemsFile(itemsFile);
//	myScene->SetPortalScissor(true);
	
	myConsole->AddString("Welcome to the Troodon Engine", 0, false);
	myConsole->AddString("Current Build: 001", 1, false);
	myConsole->AddString("", 0, true);
	myConsole->SetBorder(true, 0.5, 0.5, 0.5, 0.5, 0.0, 0.0, 0.0, 0.5);
	myConsole->SetVisibleLines(6);
	
	myWidgetManager = new TWidgetManager(curInfrastructure);
	myWidgetManager2 = new TWidgetManager(curInfrastructure);
	HealthWords = new TButton(curInfrastructure);
	AmmoWords = new TButton(curInfrastructure);
	HealthMd2 = new TMd2(curInfrastructure);
	AmmoMd2 = new TMd2(curInfrastructure);
	
	HealthWords->setDimensions(10, 10, 150, 70);
	HealthWords->setButtonUpColor(0.0, 0.0, 0.0, 1.0, 1.0, 0.1, 1.0);
	HealthWords->setButtonDownColor(0.0, 0.0, 0.0, 1.0, 0.0, 0.1, 1.0);
	HealthWords->setTextColor(1.0, 1.0, 1.0, 1.0);
	HealthWords->setTitle("Health:", 0);
	HealthWords->setTextOffset(15, 25);
	HealthWords->setMouseUpFunction(&HealthWordPress);

	AmmoWords->setDimensions(curInfrastructure->GetWinWidth() - 150, 10, 140, 70);
	AmmoWords->setButtonUpColor(0.0, 0.0, 0.0, 1.0, 1.0, 0.1, 1.0);
	AmmoWords->setButtonDownColor(0.0, 0.0, 0.0, 1.0, 0.0, 0.1, 1.0);
	AmmoWords->setTextColor(1.0, 1.0, 1.0, 1.0);
	AmmoWords->setTitle("Ammo:", 0);
	AmmoWords->setTextOffset(15, 25);
	AmmoWords->setMouseUpFunction(&HealthWordPress);
	
	HealthMd2->LoadGeom("./ClientResource/health.md2");
	HealthMd2->LoadTexture("./ClientResource/health_skin.tga", "./ClientResource/health_skin_bump.tga", 1, 5.0);
	HealthMd2->SetCurrentAnimation(0, 1);
	HealthMd2->PlayAnimation();
		
	AmmoMd2->LoadGeom("./ClientResource/ammo.md2");
	AmmoMd2->LoadTexture("./ClientResource/ammo_skin.tga", "./ClientResource/ammo_skin_bump.tga", 1, 5.0);
	AmmoMd2->SetCurrentAnimation(0, 1);
	AmmoMd2->PlayAnimation();
	
	myWidgetManager->AttachWidget(HealthWords);
	myWidgetManager->AttachWidget(AmmoWords);
	

	mousewin_Pic = new TPicButton(curInfrastructure);
	humanwin_Pic = new TPicButton(curInfrastructure);
	
	mousewin_Pic->setTexture("./ClientResource/mouse_wins.tga");
	mousewin_Pic->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	mousewin_Pic->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	mousewin_Pic->setTitle("", 0);
	mousewin_Pic->setDimensions(curInfrastructure->GetWinWidth() * 0.5 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.85 - MENU_BUTTON_HEIGHT,
						MENU_BUTTON_WIDTH * 2.0, MENU_BUTTON_HEIGHT * 1.5);

	humanwin_Pic->setTexture("./ClientResource/human_wins.tga");
	humanwin_Pic->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	humanwin_Pic->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	humanwin_Pic->setTitle("", 0);
	humanwin_Pic->setDimensions(curInfrastructure->GetWinWidth() * 0.5 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.85 - MENU_BUTTON_HEIGHT,
						MENU_BUTTON_WIDTH * 2.0, MENU_BUTTON_HEIGHT * 1.5);
		
	curInfrastructure->loadSkyBox("./SkyBox/desdusklf.tga" , "./SkyBox/desduskrt.tga" , "./SkyBox/desduskft.tga" , 
						"./SkyBox/desduskbk.tga" , "./SkyBox/desduskup.tga" , "./SkyBox/desduskdn.tga" ); 
	
	SDL_EnableUNICODE(1);

	for(int i = 0; i < myScene->GetObjectNum(); i++) {
		TObject *curObject = myScene->GetObject(i);
		if(curObject->GetType() == MD2_TYPE) {
			TMd2 *curMd2 = (TMd2 *)curObject;
			curMd2->SetCurrentAnimation(0, 5);
		}
	}

	myScene->MoveViewerDelta(0.0, 0.0, 0.0, 0.0, 0.0, 0.0f);
	myScene->setKeyBind(SDLK_a, SDLK_d, SDLK_w, SDLK_s, SDLK_SPACE);
	GameConfigKeys curConfig = curInfrastructure->GetConfigKeys();
	myScene->setMovement(curConfig.moveXVel, curConfig.moveYVel, curConfig.moveJVel, curConfig.moveXrot, curConfig.moveYrot);
	myScene->SetRenderLevel(curConfig.renderLevel);
	myScene->MoveFPSViewerDelta(0.0, 20.0, 0.0, 
				0.0, 0.0, 0.0);
	
	SDL_WM_GrabInput(SDL_GRAB_ON);
	SDL_WarpMouse(curInfrastructure->GetWinWidth() * 0.5, curInfrastructure->GetWinHeight() * 0.5);
	SDL_ShowCursor(SDL_DISABLE);
	
	prevHealth = myScene->GetGamerHealth();
	prevAmmo = myScene->GetGamerAmmo();
	
	if(mode == SERVER_RTS_MODE || mode == SERVER_FPS_MODE || mode == CLIENT_RTS_MODE || mode == CLIENT_FPS_MODE) {
		myScene->setMultiPlayerMode(mode);
		myScene->prepareMultiplayerMode();
	}
	
	if(mode == CLIENT_FPS_MODE) myScene->clientFPSkeyUp(0);
	
	firstDrawFrame = true;	
}

void FPSClient::release() {
	myScene->endMultiplayerMode();
	if(myScene != NULL) delete myScene;
	if(myConsole != NULL) delete myConsole;
	if(myWidgetManager != NULL) delete myWidgetManager;
	if(myWidgetManager2 != NULL) delete myWidgetManager2;
	if(HealthWords != NULL) delete HealthWords;
	if(AmmoWords != NULL) delete AmmoWords;
	if(HealthMd2 != NULL) delete HealthMd2;
	if(AmmoMd2 != NULL) delete AmmoMd2;
	SDL_ShowCursor(SDL_ENABLE);
}

void FPSClient::renderAll() {
	if(mode == CLIENT_RTS_MODE || mode == CLIENT_FPS_MODE) myScene->syncToNetwork();

	if(myScene->getGameEnd()) {
		if((myScene->getGameEnd() == 1) && !once) {
			myWidgetManager2->AttachWidget(mousewin_Pic);
			mousewin_Pic->show(true);
		}
		else if((myScene->getGameEnd() == 2) && ! once) {
			myWidgetManager2->AttachWidget(humanwin_Pic);
			humanwin_Pic->show(true);
		}
		
		once = true;
		
		myScene->renderEndGameSequence();
		myWidgetManager2->renderWidgets();
		return;
	}
	
	myScene->PrepareSceneForPortalCulling();
	myScene->RestoreSceneObjectsTransform();
	myScene->ApplyMd2PhysicsTransform();
	myScene->RecalcSectorPos();
	
	myScene->ApplyUserInput();
	myScene->TryMoveFPSViewerPhysics();
	
	myScene->TryToShootFPSAmmo();
	myScene->simulateAmmo();

	myScene->ApplyViewerTransform();
	myScene->DoLightingCalc();
	myScene->PortalCull();
	myScene->FrustrumCull();

	for(int i = 0; i < myScene->GetObjectNum(); i++) {
		if(!myScene->GetObjectVisible(i) || firstDrawFrame) { firstDrawFrame = false; continue;}		TObject *curObject = myScene->GetObject(i);
		if(curObject->GetType() == MD2_TYPE) {
			TMd2 *curMd2 = (TMd2 *)curObject;
			curMd2->PlayAnimation();
		}
	}
	
	myScene->AnimateItems();
	myScene->RenderAll();
	myScene->GlowRender();
	myScene->RenderFPSWeapon();
	myScene->RenderSkyBox(1400.0);
	myScene->renderAmmo();
	myScene->RenderFPSLensFlare();
	
	myScene->incrementFrame();
	

	if(showConsole) {
		glColor4f(1.0, 1.0, 1.0, 1.0);
		myConsole->Render();
	}

	updateDisplay();
	if(mode == CLIENT_FPS_MODE) myScene->sendClientFPSinput();
}

void FPSClient::processEvent(SDL_Event *curEvent) {
      switch (curEvent->type) {
        // If a quit event was recieved
        case SDL_QUIT:
          // then we're done and we'll end this program
          done = true;
          break;

        case SDL_MOUSEMOTION:
	   myScene->mouseInput(curEvent->motion.xrel, curEvent->motion.yrel, leftDown, rightDown);
           if(mode == CLIENT_FPS_MODE) myScene->clientFPSmouseInput(curEvent->motion.xrel, curEvent->motion.yrel, curInfrastructure->GetWinWidth(), curInfrastructure->GetWinHeight(), leftDown, rightDown);
	   if(curEvent->motion.x <= 0 || curEvent->motion.x >= (curInfrastructure->GetWinWidth() - 1) || curEvent->motion.y <= 0 || curEvent->motion.y >= (curInfrastructure->GetWinHeight() - 1)) 
	   	SDL_WarpMouse(curInfrastructure->GetWinWidth() * 0.5, curInfrastructure->GetWinHeight() * 0.5);
	 break;
	   
	 case SDL_MOUSEBUTTONDOWN:
	 	if(curEvent->button.button == SDL_BUTTON_LEFT) leftDown = true;
	 	if(curEvent->button.button == SDL_BUTTON_RIGHT) rightDown = true;
	       if(mode == CLIENT_FPS_MODE) {
	       		myScene->clientFPSmouseInput(curEvent->motion.xrel, curEvent->motion.yrel, curInfrastructure->GetWinWidth(), curInfrastructure->GetWinHeight(), leftDown, rightDown);
			myScene->mouseInput(curEvent->motion.xrel, curEvent->motion.yrel, leftDown, rightDown);
		}
	       else myScene->mouseInput(curEvent->motion.xrel, curEvent->motion.yrel, leftDown, rightDown);
	 break;

	 case SDL_MOUSEBUTTONUP:
	 	if(curEvent->button.button == SDL_BUTTON_LEFT) leftDown = false;
	 	if(curEvent->button.button == SDL_BUTTON_RIGHT) rightDown = false;
	       if(mode == CLIENT_FPS_MODE) {
	       	myScene->clientFPSmouseInput(curEvent->motion.xrel, curEvent->motion.yrel, curInfrastructure->GetWinWidth(), curInfrastructure->GetWinHeight(), leftDown, rightDown);
		myScene->mouseInput(curEvent->motion.xrel, curEvent->motion.yrel, leftDown, rightDown);
	       }
	       else myScene->mouseInput(curEvent->motion.xrel, curEvent->motion.yrel, leftDown, rightDown);
	 break;
	 	 
        case SDL_KEYDOWN:
	if(showConsole == false) {
          switch( curEvent->key.keysym.sym ) {
				
				case SDLK_BACKQUOTE:
					showConsole = !showConsole;
				break;
				
				default:
					if(mode == CLIENT_FPS_MODE) myScene->clientFPSkeyDown(curEvent->key.keysym.sym);
					myScene->userInput(curEvent->key.keysym.sym);
				break;
			 }
		}
	else {
          switch( curEvent->key.keysym.sym ) {
				case SDLK_BACKQUOTE:
				showConsole = !showConsole;
				break;

				case SDLK_LSHIFT:
				break;

				case SDLK_RSHIFT:
				break;

				default:
				char inputChar[2];
				inputChar[0] = curEvent->key.keysym.unicode;
				inputChar[1] = '\0';
				int retval = myConsole->AddInputChar(inputChar);

				if(retval != NO_STRING) {
					if(myConsole->GetString(retval) == "quit") {done = true;}
					else if(myConsole->GetString(retval) == "set renderlevel 0") {myScene->SetRenderLevel(RENDER_LEVEL0);}
					else if(myConsole->GetString(retval) == "set renderlevel 1") {myScene->SetRenderLevel(RENDER_LEVEL1);}
					else if(myConsole->GetString(retval) == "set renderlevel 2") {myScene->SetRenderLevel(RENDER_LEVEL2);}
					else if(myConsole->GetString(retval) == "set renderlevel 3") {myScene->SetRenderLevel(RENDER_LEVEL3);}
					else if(myConsole->GetString(retval) == "blur 0") {myScene->SetBlurSwitch(false);}
					else if(myConsole->GetString(retval) == "blur 1") {myScene->SetBlurSwitch(true);}
					else {myConsole->AddString("Invalid Command", 1, false); myConsole->AddString("", 0, true);}
				}
		
				break;
			  }
		}
		
          break;
        case SDL_KEYUP:
          switch( curEvent->key.keysym.sym ) {
				
				default:
					if(mode == CLIENT_FPS_MODE) myScene->clientFPSkeyUp(curEvent->key.keysym.sym);
					myScene->userKeyUp(curEvent->key.keysym.sym);
				break;
	  }
	
        break;

        default:
          break;

        
      }
}

void FPSClient::updateDisplay() {
	char printBuffer[500];
	
	sprintf(printBuffer, "Health: %d\n", myScene->GetGamerHealth());
	HealthWords->setTitle(printBuffer, 0);
	sprintf(printBuffer, "Ammo: %d\n", myScene->GetGamerAmmo());
	AmmoWords->setTitle(printBuffer, 0);

	//render the Md2 status objects
	HealthMd2->PrepareTransform();
		glTranslatef(-3.4, -2.3, -5.0);
		glScalef(0.025, 0.025, 0.025);
		glRotatef(-healthRot, 0.0, 1.0, 0.0);
	HealthMd2->EndTransform();
	
	AmmoMd2->PrepareTransform();
		glTranslatef(3.4, -2.3, -5.0);
		glScalef(0.065, 0.065, 0.065);
		glRotatef(-ammoRot, 0.0, 1.0, 0.0);
		glRotatef(90, 0.0, 0.0, 1.0);
	AmmoMd2->EndTransform();
	
	
	if(myScene->GetGamerHealth() != prevHealth) {
		prevHealth = myScene->GetGamerHealth();
		healthRot = healthRot + 10.0;
		HealthWords->setButtonUpColor(1.0, 0.0, 0.0, 1.0, 0.0, 0.1, 1.0);
	}
	else {
		HealthWords->setButtonUpColor(0.0, 0.0, 0.0, 1.0, 1.0, 0.1, 1.0);
	}
	
	healthRot = healthRot + 1.0;
	if(healthRot > 360.0) healthRot = healthRot - 360.0;
	
	if(myScene->GetGamerAmmo() != prevAmmo) {
		prevAmmo = myScene->GetGamerAmmo();
		ammoRot = ammoRot + 10.0;
	}
	
	ammoRot = ammoRot + 1.0;
	if(ammoRot > 360.0) ammoRot = ammoRot - 360.0;
	
	myScene->RenderMd2(HealthMd2);
	myScene->RenderMd2(AmmoMd2);
	//render the widgets	
	myWidgetManager->renderWidgets();
	myScene->renderStatusText();
}


void HealthWordPress(void *obj, int x, int y) {

}


