/***************************************************************************
                          tobject.h  -  generic object that other classes should derive to create 3D objects
                             -------------------
    begin                : Tue Dec 17 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TOBJECT_H
#define TOBJECT_H

#include "tinfrastructure.h"
#include "vectorutils.h"
#include <stdio.h>

/**
  *@author Chong Jiayi
  */

const static int DECAL_MODE = 0;
const static int DIFFUSE_BUMP_MODE = 1;
const static int SPECULAR_BUMP_MODE = 2;
	
class TObject {

protected:
	//these data structures are all composed coordinates packed in triplets(basically
	//in the form of triangles)
	Vertex *vertices;
	OrthoNormalBasis *orthobasis;
	TInfrastructure *infrastructure;
	TextureInfo *texInfo;
	Connective *vertexConnect;
	int triangleNum;
	Vector eyePos;
	Vector lightPos;
	GLfloat transformMatrix[16];
	GLfloat inverseTransformMatrix[16];
	void setVertexPos(int index, GLfloat x, GLfloat y, GLfloat z);
	void setTextureCoords(int index, GLfloat s, GLfloat t);
	void setNormalCoords(int index, GLfloat x, GLfloat y, GLfloat z);
	void EnableNVRegCombinersDiffuse(GLfloat aRed, GLfloat aGreen, GLfloat aBlue, GLfloat aAlpha, GLfloat dRed, GLfloat dGreen, GLfloat dBlue, GLfloat dAlpha);
	void EnableNVRegCombinersSpecular();
	void ShadowPass(Connective *curConnective, Vertex *curVertex, Connective *theConnectives, Vector lightVec, bool flag);
	bool ShareEdge(Vertex *edge11, Vertex * edge12, Vertex *edge21, Vertex *edge22);
	bool SameTriangle(Vector *v11, Vector *v12, Vector *v13, Vector *v21, Vector *v22, Vector *v23);
	int curRenderMode;
	
public:
	//constructors/destructors of inherited objects should have these specifications
/*	virtual TObject(TInfrastructure * curInfrastructure) =0;
	virtual ~TObject() =0;      */
	void Initialize(TInfrastructure *curInfrastructure);
	void Cleanup();   
	
	void Render();
	void LoadTexture(char *decal_filename, char *bump_filename, int mipmaps, float scale);
	void CalculateOrthoBasis();
	void CalculateSphericalOrthoBasis();
	void CalculatePlanes();
	void SetConnectives();
	void SelectSingleDecalTexture();
	void SelectCubeAndBumpTexture();
	void SetupVertexArraysForRendering(int mode);
	void PrepareTransform();
	void EndTransform();
	void EnablePlainDecal();
	void EnableShadowedDecal();
	void EnableStencilDecal(GLfloat r, GLfloat g, GLfloat b);
	void EnableDiffusePass(GLfloat aRed, GLfloat aGreen, GLfloat aBlue, GLfloat aAlpha, GLfloat dRed, GLfloat dGreen, GLfloat dBlue, GLfloat dAlpha);
	void EnableSpecularPass();
	void SetLightPos(GLfloat x, GLfloat y, GLfloat z);
	void SetEyePos(GLfloat x, GLfloat y, GLfloat z);
	void SetupLightVectorsForRendering();
	void CastShadowDepthPass();
	virtual bool Loadable() =0;
	virtual void LoadGeom(char *filename) =0;
};

#endif
