/* File: widgetcalls.cpp
 * Author: Ryan Barrett
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Defines the functions that use Widget UI in main.cpp. These should really be
 * inside main.cpp, but it was already too long.
 */


/* GetMouse
 * --------
 * Returns the current position of the mouse cursor.
 */
void GetMouse(int &x, int &y)
{
  x = gMouseX;
  y = gMouseY;
}


/* ShowMenu
 * --------
 * Opens a Widget UI menu.
 */
void ShowMenu(int x, int y)	// defaults: x = 100, y = 100
{
  //CWItem *added;

  // open menu
  gMenu = new CWScrolledWindow("Tic Tac Toe", x, y, 200, 200);

  gMenu->AddItem("New Game", WNewGameMenu);
  if (gGame.HumanTurn())
	gMenu->AddItem("Move", WMoveMenu);
  gMenu->AddItem("Options", WOptionsMenu);
  gMenu->AddItem("Quit", WQuit);

  for (int i = 0; i < 10; i++)
	gMenu->AddItem("", NULL);
  gMenu->AddItem("<Nelson Muntz voice>", NULL);
  gMenu->AddItem("Ha ha, made you scroll!", NULL);
}


// -----------------------------------------------------------------------------
// CALLBACKS
// -----------------------------------------------------------------------------

void WNewGameMenu(CWItem *item)
{
  gChildMenu = gMenu->OpenChild(item);
  gChildMenu->AddItem("Human X, Human O", WNewGame);
  gChildMenu->AddItem("Human X, Computer O", WNewGame);
  gChildMenu->AddItem("Computer X, Human O", WNewGame);
  gChildMenu->AddItem("Computer X, Computer O", WNewGame);
}


void WNewGame(CWItem *item)
{
  if (item->GetCaption() == "Human X, Human O")
	gGame.NewGame(false, false);
  else if (item->GetCaption() == "Human X, Computer O")
	gGame.NewGame(false, true);
  else if (item->GetCaption() == "Computer X, Human O")
	gGame.NewGame(true, false);
  else if (item->GetCaption() == "Computer X, Computer O")
	gGame.NewGame(true, true);

  DEL(gMenu);
}


void WMoveMenu(CWItem *item)
{
  gChildMenu = gMenu->OpenChild(item);
  gChildMenu->AddItem("Top",	WMoveMenu2, reinterpret_cast<void *>(2));
  gChildMenu->AddItem("Middle",	WMoveMenu2, reinterpret_cast<void *>(1));
  gChildMenu->AddItem("Bottom",	WMoveMenu2, reinterpret_cast<void *>(0));
}


CWItem *gWSelItem = NULL;

void WMoveMenu2(CWItem *item)
{
  gWSelItem = item;
  gChildMenu = gChildMenu->OpenChild(item);
  gChildMenu->AddItem("Left",	WMove, reinterpret_cast<void *>(0));
  gChildMenu->AddItem("Middle",	WMove, reinterpret_cast<void *>(1));
  gChildMenu->AddItem("Right",	WMove, reinterpret_cast<void *>(2));
}


void WMove(CWItem *item)
{
  /*
  const string &vert = item->GetCaption(), &horiz = gWSelItem->GetCaption();

  // find row
  if (vert == "Bottom")
	row = 0;
  else if (vert == "Middle")
	row = 1;
  else if (vert == "Top")
	row = 2;

  // find column
  if (horiz == "Left")
	row = 0;
  else if (horiz == "Middle")
	row = 1;
  else if (horiz == "Right")
	row = 2;
  */

  int row = reinterpret_cast<int>(gWSelItem->GetUserData()),
	  col = reinterpret_cast<int>(item->GetUserData());

  // make move
  gGame.Move(row, col);

  DEL(gMenu);
}
	



void WOptionsMenu(CWItem *item)
{
  gChildMenu = gMenu->OpenChild(item);
  gChildMenu->AddCheckbox("Waves",			WOptionSet, gWaves, &gWaves);
  gChildMenu->AddCheckbox("Draw Normals", 	WOptionSet, gDrawNormals, &gDrawNormals);
  gChildMenu->AddCheckbox("Draw Pieces", 	WOptionSet, gDrawObjects, &gDrawObjects);
  gChildMenu->AddCheckbox("Draw Water", 	WOptionSet, gDrawWater, &gDrawWater);
  gChildMenu->AddCheckbox("Rain",			WOptionSet, gDrawRain, &gDrawRain);
  gChildMenu->AddCheckbox("Print FPS",		WOptionSet, gPrintFPS, &gPrintFPS);
  gChildMenu->AddCheckbox("Sharp Edges", 	WOptionSet, gSharpEdges, &gSharpEdges);
  gChildMenu->AddCheckbox("Reflection", 	WOptionSet, gEnvMap, &gEnvMap);
  gChildMenu->AddCheckbox("Refraction", 	WOptionSet, gRefract, &gRefract);
  gChildMenu->AddCheckbox("Use Fresnel Term", 	WOptionSet, gFresnel, &gFresnel);
  gChildMenu->AddCheckbox("Texture Water", 	WOptionSet, gTexture, &gTexture);
  gChildMenu->AddCheckbox("Blend Water", 	WOptionSet, gTransparent, &gTransparent);
  gChildMenu->AddCheckbox("Wireframe",		WOptionSet, gWireframe, &gWireframe);
  gChildMenu->AddCheckbox("Sound",			WOptionSet, gSound, &gSound);
}


void WOptionSet(CWItem *item)
{
  bool *optionPtr = reinterpret_cast<bool *>(item->GetUserData());
//  CWCheckbox *checkbox = dynamic_cast<CWCheckbox *>(item);
  // changed because there's a bug in vc++ dynamic_cast
  CWCheckbox *checkbox = (CWCheckbox *)(item);

  *optionPtr = checkbox->IsChecked();

  // if it's refraction, check if it's allowed to be turned on
  if (checkbox->GetCaption() == "Refraction") {
	UpdateView();
	if (!gRefract && checkbox->IsChecked())
	  checkbox->Select();
  }
}


void WQuit(CWItem *item)
{
  exit(0);
}


