/* File: wscrolledwindow.h
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 *	CS248 Fall 2001
 *	HW3 - Video Game
 *
 *  Declares the CWScrolledWindow class, which is a version of CWWindow with
 *	scrollbars. (CWScrolledWindow = Widget Scrolled Window.) A CWScrolledWindow
 *	acts just like a CWWindow except it has scrollbars and does not dynamically
 *	resize when items are added.
 *
 *	Here is the class hierarchy:
 *
 *
 *							CWidget
 *						  /	  |		-
 *						/	  |		  -
 *				CWWindow	CWItem		CWScrollBar
 *				  /			 /	-
 *				/			/	  -
 *	CWScrolledWindow  CWTextBox	CWCheckBox
 *
 *
 *	NOTE: CWTextbox has been suspended since the game doesn't need it.
 *
 */

#ifndef _WSCROLLEDWINDOW_H
#define _WSCROLLEDWINDOW_H

#include "wwindow.h"
#include "wscrollbar.h"



// -----------------------------------------------------------------------------
// CWSCROLLEDWINDOW CLASS
// -----------------------------------------------------------------------------
class CWScrolledWindow : public CWWindow
{
public:
	// ctor
	CWScrolledWindow(const string &caption, int x, int y, int width, int height);

	// dtor
	virtual ~CWScrolledWindow();

	/* Add*
	 * ----
	 * Overridden from CWWindow so adding items does not change the dimensions.
	 * See CWWindow for more information on the Add* functions.
	 */
	virtual CWItem *AddItem(
		const string &caption,
		void (*callback)(CWItem *item),
		void *userData = NULL);

	virtual CWCheckbox *AddCheckbox(
		const string &caption,
		void (*callback)(CWItem *item),
		bool checked,
		void *userData = NULL);

	/* Draw
	 * ----
	 * Overridden from CWWindow to draw the scroll bars.
	 */
	virtual void Draw();

	/* IsMouseOver
	 * -----------
	 * Overridden from CWidget. Returns true if the mouse is over the window
	 * *or* either of the scrollbars, false otherwise. This was ovverridden
	 * to take the scrollbars into account.
	 */
	bool IsMouseOver() const;

protected:
	// allows CWWindow to create a child scrolled window
	friend class CWWindow;

	// ctor (used if this is a child window)
	CWScrolledWindow(CWItem *parent, int width, int height);

	// methods
	void	PostAdd();
	void	RepositionItems();
	void	PositionScrollbars();
	virtual CWidget *WidgetUnderMouse();	// overridden from CWWindow

	// members
	CWScrollbar mHoriz, mVert;
	int			mTotalWidth, mTotalHeight;	// space taken up by all items

//	Inherited from CWWindow:
//
//	CWItem		**mItems;
//	int			mNumItems, mAlloc;
//	CWWindow	*mChild;			// non-NULL if this window has a child
//	CWItem		*mParent;			// non-NULL if this is a child window


private:
	// disallow empty constructor
	CWScrolledWindow();

	// disallow a CWScrolledWindow to have a child
	// grr...I guess I'll allow it for now
/*	virtual CWScrolledWindow	*OpenChild(CWItem *parent, int width, int height)
	{
		rassert(false); return NULL;
	}
	virtual	CWWindow			*OpenChild(CWItem *parent)
	{
		rassert(false); return NULL;
	}
	void				CloseChild()
	{
		rassert(false);
	}
*/
};

#endif	// _WSCROLLEDWINDOW_H

