/* File: wscrollbar.h
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 *	CS248 Fall 2001
 *	HW3 - Video Game
 *
 *  Declares the CWScrollbar class, which is a scrollbar in the Widget UI.
 *	(CWScrollbar = Widget Scrollbar.) It is used by CWScrolledWindow.
 *
 *	NOTE: you should not instantiate CWScrollbar! CWScrolledWindow does this
 *	automatically. The client should never deal with CWScrollbar, which is why
 *	everything is protected.
 *
 *	Here is the class hierarchy:
 *
 *
 *							CWidget
 *						  /	  |		-
 *						/	  |		  -
 *				CWWindow	CWItem		CWScrollBar
 *				  /			 /	-
 *				/			/	  -
 *	CWScrolledWindow  CWTextBox	CWCheckBox
 *
 *
 *	NOTE: CWTextbox has been suspended since the game doesn't need it.
 *
 */

#ifndef _WSCROLLBAR_H
#define _WSCROLLBAR_H


#include "widget.h"


// -----------------------------------------------------------------------------
// CWSCROLLBAR CLASS
// -----------------------------------------------------------------------------
class CWScrollbar : public CWidget
{
public:
	// dtor
	~CWScrollbar();


protected:
	// allows CWScrolledWindow to instantiate CWScrollbar
	friend class CWScrolledWindow;
	// allows CWidget to turn off dragging when mouse button is released
	friend class CWidget;

	// EDirection - used to determine which direction the scrollbar is
	enum EDirection { eHorizontal, eVertical };



	// ctor
	CWScrollbar(EDirection dir);

	// protected methods
	virtual void Draw();
	virtual void Select();
	virtual void MouseDown();
	void DragThumb();
	inline int ThumbX();
	inline int ThumbY();

	// members
	EDirection			mDir;	// direction
	float				mVal;	// the thumb position (0 to 1, 0 is left or up)
	CWScrolledWindow	*mParent;

	// if the user is dragging a scrollbar, points to the scrollbar being
	// dragged. otherwise NULL.
	static CWScrollbar	*sDragging;

	// constants
	static const int	kScrollbarWidth;
	static const int	kThumbLen;
	static const float	kThumbJump;


//	Inherited from CWidget:
//
//	string		mCaption;
//	int			mx, my, mWidth, mHeight;

private:
	// disallow empty constructor
	CWScrollbar();
};


#endif	// _WSCROLLBAR_H

