/* File: witem.h
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 *	CS248 Fall 2001
 *	HW3 - Video Game
 *
 *  Declares the CWItem class, which is an item in the Widget UI. (CWItem =
 *	Widget Item.) It is most like a menu item - it can be clicked on and
 *	displays a caption. CWItem derives directly from CWidget.
 *
 *	NOTE: you should not instantiate CWItem! (If my countermeasures work, you
 *	can't.) Use CWWindow::AddItem instead.
 *
 *	Here is the class hierarchy:
 *
 *
 *							CWidget
 *						  /	  |		-
 *						/	  |		  -
 *				CWWindow	CWItem		CWScrollBar
 *				  /			 /	-
 *				/			/	  -
 *	CWScrolledWindow  CWTextBox	CWCheckBox
 *
 *
 *	NOTE: CWTextbox has been suspended since the game doesn't need it.
 *
 */


#ifndef _WITEM_H
#define _WITEM_H

#include "widget.h"



// -----------------------------------------------------------------------------
// FORWARD DECLARATIONS
// -----------------------------------------------------------------------------
class CWWindow;


// -----------------------------------------------------------------------------
// CWITEM CLASS
// -----------------------------------------------------------------------------
class CWItem : public CWidget
{
public:
	// dtor
	virtual ~CWItem();

	/* Select
	 * ------
	 * Called when the item is clicked on or otherwise selected.
	 */
	virtual void Select();

	/* GetCaption
	 * ----------
	 * Returns the item's caption.
	 */
	const string &GetCaption() const	{ return mCaption; }

	/* GetCaption
	 * ----------
	 * Returns the item's user data.
	 */
    void *GetUserData() const { return mUserData; }

	/* CompareItems
	 * ------------
	 * Compares the captions of the two items. Returns <0 if i1's caption is
	 * before i2's caption (alphabetically), >0 if i2's caption is before i1's,
	 * and 0 if they are equal.
	 *
	 * (This is used with qsort() in stdlib.)
	 */
	static int CompareItems(const void *i1, const void *i2);

protected:
	// allows the window classes to instantiate CWItem
	friend class CWWindow;
	friend class CWScrolledWindow;
	// allows static CWidget methods to access the item's parent
	friend class CWidget;

	// ctor (protected so that clients cannot instantiate CWItem)
	typedef void (*ItemFn)(CWItem *);
	CWItem(const string &caption, ItemFn callback, CWWindow *parent,
		void *userData);

	virtual		void Draw()		{ Draw(0); }
	virtual		void Draw(int capOffset);
	virtual		bool IsMouseOver() const;
	void		GetVisible(int &vleft, int &vright, int &vtop, int &vbottom) const;

	// members
	CWWindow	*mParent;
	ItemFn		mCallback;	// callback
	void		*mUserData;   // User data

//	Inherited from CWidget:
//
//	int			mx, my, mWidth, mHeight;
//	string		mCaption;


private:
	// disallow empty constructor
	CWItem();
};

#endif	// _WITEM_H
