/* File: WItem.cpp
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 *	CS248 Fall 2001
 *	HW3 - Video Game
 *
 *  Defines the CWItem class, which is the item class for the Widget UI. For
 *	more information, see witem.h.
 *
 */

#include <GL/glut.h>
#include <assert.h>
#include "witem.h"
#include "wwindow.h"


// ----------------------------------------------------------------------------
// public methods
// ----------------------------------------------------------------------------

// ctor
// Sets a callback that is called when the item is selected. When the callback
// is called, a pointer to the parent of the selected item is passed as the
// argument.
//
// NOTE: the callback can be NULL, in which case, nothing happens when the item
// is selected.
CWItem::CWItem(const string &caption, ItemFn callback, CWWindow *parent,
			   void *userData) : CWidget(caption)
{
	assert(parent);

	mCallback = callback;
	mParent = parent;
	mUserData = userData;
	mWidth = StringWidth(caption) + kItemMargin;
	mHeight = kFontHeight + kFontHeightMargin + kItemMargin;
}


// dtor
CWItem::~CWItem()
{}


// Select
void CWItem::Select()
{
	// call callback
	if (mCallback)
		mCallback(this);
}


// CompareItems
int CWItem::CompareItems(const void *i1, const void *i2)
{
	string &s1 = (*((CWItem **)i1))->mCaption,
		   &s2 = (*((CWItem **)i2))->mCaption;

	//return s1.compare(s2, CS_ignore);
	if (s1 == s2)
	  return 0;
	return (s1 < s2) ? -1 : 1;
}


// ----------------------------------------------------------------------------
// protected helper methods
// ----------------------------------------------------------------------------

/* Draw
 * ----
 * Draws the item with the caption offset horizontally by capOffset.
 */
void CWItem::Draw(int capOffset)
{
	int vleft, vright, vtop, vbottom;
	int cx = mx + capOffset;

	// get visible part of the item
	GetVisible(vleft, vright, vtop, vbottom);

	// check to make sure that some part of the item is visible
	if (vleft >= vright || vtop + 1 >= vbottom)
		return;

	if (IsMouseOver())
	{
		// draw highlighted background
		SetColor(kSelectColor);
		DrawRect(vleft, vtop, vright - vleft, vbottom - vtop, true);
	}


	// draw caption
	DrawString(cx + kItemMargin, my + mHeight, mCaption);
}


/* IsMouseOver
 * -----------
 * Overridden from CWidget so that it takes into account the *visible* part of
 * the item only.
 */

bool CWItem::IsMouseOver() const
{
	int x, y, vleft, vright, vtop, vbottom;

	GetVisible(vleft, vright, vtop, vbottom);
	assert(sMouseCallback);
	sMouseCallback(x, y);

	return (x >= vleft && x <= vright && y >= vtop && y < vbottom);
}


/* GetVisible
 * ----------
 * Returns the visible part of the item.
 */
void CWItem::GetVisible(int &vleft, int &vright, int &vtop, int &vbottom) const
{
	vleft	= MAX(mx, mParent->mx);
	vtop	= MAX(my, mParent->my + kFontHeight / 2 + kFontHeightMargin);
	vright	= MIN(mx + mWidth, mParent->mx + mParent->mWidth);
	vbottom	= MIN(my + mHeight, mParent->my + mParent->mHeight);
}



