/* File: wcheckbox.h
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 *	CS248 Fall 2001
 *	HW3 - Video Game
 *
 *  Declares the CWCheckbox class, which is a checkbox in the Widget UI.
 *	(CWCheckbox = Widget Checkbox.) It works like a standard checkbox in any
 *	graphical interface - it can be checked and unchecked. CWCheckbox derives
 *	from CWItem.
 *
 *	NOTE: you should not instantiate CWCheckbox! (If my countermeasures work,
 *	you can't.) Use CWWindow::AddCheckbox instead.
 *
 *	Here is the class hierarchy:
 *
 *
 *							CWidget
 *						  /	  |		-
 *						/	  |		  -
 *				CWWindow	CWItem		CWScrollBar
 *				  /			 /	-
 *				/			/	  -
 *	CWScrolledWindow  CWTextBox	CWCheckBox
 *
 *
 *	NOTE: CWTextbox has been suspended since the game doesn't need it.
 *
 */

#ifndef _WCHECKBOX_H
#define _WCHECKBOX_H


#include "witem.h"


// -----------------------------------------------------------------------------
// CWCHECKBOX CLASS
// -----------------------------------------------------------------------------
class CWCheckbox : public CWItem
{
public:
	// dtor
	virtual ~CWCheckbox();

	/* IsChecked
	 * ---------
	 * Returns true if the checkbox is checked, false otherwise.
	 */
	bool IsChecked() const	{ return mChecked; }

	/* Select
	 * ------
	 * Changes the checkbox from checked to unchecked or vice versa.
	 */
	virtual void Select();

protected:
	// allows CWWindow to instantiate CWItem
	friend class CWWindow;

	// ctor (used by CWWindow::AddCheckbox)
	CWCheckbox(const string &caption, ItemFn callback, bool checked,
		CWWindow *parent, void *userData);

	// protected member functions
	virtual void Draw();
	void DrawActualCheckbox();

	// members
	bool mChecked;

//	Inherited from CWItem:
//
//	CWWindow *mParent;
//	ItemFn mCallback;
//	void *mUserdata
//
//	int			mx, my, mWidth, mHeight;
//	string		mCaption;

	// constants (checkbox drawing stuff)
	static const int		kCheckboxSize;
	static const int		kCheckboxMargin;
	static const glColor	kHighlight;
	static const glColor	kHighlightLess;
	static const glColor	kShadow;
	static const glColor	kMidLight;
	static const glColor	kMid;
	static const glColor	kMidDark;
	static const glColor	kPressedLight;
	static const glColor	kPressed;
	static const glColor	kPressedDark;

private:
	// disallow empty constructor
	CWCheckbox();
};


#endif	// _WCHECKBOX_H
