/* File: widget.cpp
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 *	CS248 Fall 2001
 *	HW3 - Video Game
 *
 *  Defines the CWCheckbox class, which is the item class for the Widget UI.
 *	For more information, see wcheckbox.h.
 *
 */

#include <GL/glut.h>
#include "wcheckbox.h"


// ----------------------------------------------------------------------------
// initialize constants	(stuff for drawing the checkbox)
// ----------------------------------------------------------------------------
const int		CWCheckbox::kCheckboxSize	= 12;
const int		CWCheckbox::kCheckboxMargin	= 6;
const glColor	CWCheckbox::kHighlight		= { 0, 196, 196, 196 };
const glColor	CWCheckbox::kHighlightLess	= { 0, 148, 148, 196 };
const glColor	CWCheckbox::kShadow			= { 0,  26,  26, 196 };
const glColor	CWCheckbox::kMidLight		= { 0, 154, 154, 196 };
const glColor	CWCheckbox::kMid			= { 0, 128, 128, 196 };
const glColor	CWCheckbox::kMidDark		= { 0, 104, 104, 196 };
const glColor	CWCheckbox::kPressedLight	= { 0, 128, 128, 196 };
const glColor	CWCheckbox::kPressed		= { 0, 104, 104, 196 };
const glColor	CWCheckbox::kPressedDark	= { 0,  80,  80, 196 };




// ----------------------------------------------------------------------------
// public methods
// ----------------------------------------------------------------------------

// ctor
// Sets a callback that is called when the item is selected. When the callback
// is called, a pointer to the parent of the selected item is passed as the
// argument.
//
// NOTE: the callback can be NULL, in which case, nothing happens when the item
// is selected.
CWCheckbox::CWCheckbox(const string &caption, ItemFn callback, bool checked,
	CWWindow *parent, void *userData) : CWItem(caption, callback, parent, userData)
{
	mChecked = checked;

	mWidth += kCheckboxSize + kCheckboxMargin * 2;
}


// dtor
CWCheckbox::~CWCheckbox()
{}


// Select
void CWCheckbox::Select()
{
	mChecked = !mChecked;
	CWItem::Select();	// call CWItem::Select on *this* checkbox
}


/* Draw
 * ----
 * Overrides the virtual definition in CWItem.
 */
void CWCheckbox::Draw()
{
	int vleft, vright, vtop, vbottom;

	CWItem::Draw(kCheckboxSize + 2 * kCheckboxMargin);	// offset the caption

	// get visible part of the item
	GetVisible(vleft, vright, vtop, vbottom);

	// draw actual checkbox
	DrawActualCheckbox();
}


/* DrawActualCheckbox
 * ------------------
 * Draws the actual checkbox part of the item.
 */
void CWCheckbox::DrawActualCheckbox()
{
	int cx, cy;
	glVec2 corners[4];
	glColor colors[4];
	bool pressed;

	// set coordinates
	cx = mx + kCheckboxMargin;
	cy = my + kCheckboxMargin;

	// top left
	corners[0][0] = cx;
	corners[0][1] = cy;
	// top right
	corners[1][0] = cx + kCheckboxSize;
	corners[1][1] = cy;
	// bottom right
	corners[2][0] = cx + kCheckboxSize;
	corners[2][1] = cy + kCheckboxSize;
	// bottom left
	corners[3][0] = cx;
	corners[3][1] = cy + kCheckboxSize;


	// true if mouse button is down over this checkbox
	pressed = ((CWidget::pressed == (CWidget *)this) && IsMouseOver());

	// draw back
	if (pressed)
	{
		memcpy(colors[0], kPressedDark, sizeof(glColor));
		memcpy(colors[1], kPressed, sizeof(glColor));
		memcpy(colors[2], kPressedLight, sizeof(glColor));
		memcpy(colors[3], kPressed, sizeof(glColor));
	}
	else	// not pressed
	{
		memcpy(colors[0], kMidDark, sizeof(glColor));
		memcpy(colors[1], kMid, sizeof(glColor));
		memcpy(colors[2], kMidLight, sizeof(glColor));
		memcpy(colors[3], kMid, sizeof(glColor));
	}
	glBegin(GL_QUADS);
	glColor4ubv(colors[0]);		glVertex2i(cx, cy);
	glColor4ubv(colors[1]);		glVertex2i(cx + kCheckboxSize, cy);
	glColor4ubv(colors[2]);		glVertex2i(cx + kCheckboxSize, cy + kCheckboxSize);
	glColor4ubv(colors[3]);		glVertex2i(cx, cy + kCheckboxSize);
	glEnd();


	// draw sides
	glColor high, less;
	memcpy(high, kHighlight, sizeof(glColor));
	memcpy(less, kHighlightLess, sizeof(glColor));

	glBegin(GL_LINE_STRIP);

	if (mChecked || pressed)	// down
	{
	  glColor4ubv(less);	glVertex2i(corners[1][0], corners[1][1]);
	  glColor4ubv(high);	glVertex2i(corners[2][0], corners[2][1]);
	  glColor4ubv(less);	glVertex2i(corners[3][0], corners[3][1]);
	  glColor4ubv(kShadow);
	  glVertex2i(corners[0][0], corners[0][1]);
	  glVertex2i(corners[1][0], corners[1][1]);
	}
	else	// up
	{
	  glColor4ubv(less);	glVertex2i(corners[3][0], corners[3][1]);
	  glColor4ubv(high);	glVertex2i(corners[0][0], corners[0][1]);
	  glColor4ubv(less);	glVertex2i(corners[1][0], corners[1][1]);
	  glColor4ubv(kShadow);
	  glVertex2i(corners[2][0], corners[2][1]);
	  glVertex2i(corners[3][0], corners[3][1]);
	}

	glEnd();
}



