/* File: vector3.h
 * Author: Ryan Barrett (rbarrett@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * My own vector class. Normally I wouldn't rewrite stuff that I know has been
 * written hundreds of times before, and probably much better than I'm going to
 * do. But this is probably the best way to make sure I understand the 3D math
 * I need to know.
 */

#ifndef _VECTOR3_H
#define _VECTOR3_H


// ----------------------------------------------------------------------------
// CLASS DECLARATION
// ----------------------------------------------------------------------------

class CVector3
{
public:

	// Constructors
	CVector3() {}
	CVector3(const CVector3 &v)	{ *this = v; }
	CVector3(float x, float y, float z) : x(x), y(y), z(z) {}

	// Destructor
	//virtual ~CVector3() {}
	~CVector3() {}

	// Returns the length of the vector
	inline float	Length() const;

	// Returns the length squared
	inline float	Length2() const;

	// vector math
	inline CVector3 &operator =		(const CVector3 &v);
	inline CVector3 operator -		() const;
	inline CVector3 operator +		(const CVector3 &v) const;
	inline CVector3 operator -		(const CVector3 &v) const;
	inline CVector3 &operator +=	(const CVector3 &v);
	inline CVector3 &operator -=	(const CVector3 &v);

	// scalar math
	inline CVector3	operator *		(const float f) const;
	inline CVector3 operator /		(const float f) const;
	inline CVector3 &operator *=	(const float f);
	inline CVector3 &operator /=	(const float f);

	friend inline CVector3 operator *	(const float f, const CVector3 &v);

	// Operators for comparing equality
	inline bool operator==			(const CVector3 &v) const;
	inline bool operator!=			(const CVector3 &v) const;

	// Dot and cross products
	inline float Dot				(const CVector3 &v) const;
	inline CVector3 Cross			(const CVector3 &v) const;

	// Normalizes the vector's length to 1
	inline void Normalize();

public:

	// I like having these public.
	float x, y, z;
};


// include implementation
#include "vector3.cpp"


#endif	// _VECTOR3_H


