/* File: vector3.cpp
 * Author: Ryan Barrett (rbarrett@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Implements the CVector3 class. For more information, see vector3.h.
 */

// does *not* include vector3.h because vector3.h includes this file!
#include <math.h>	// for sqrt



// ----------------------------------------------------------------------------
// INLINE METHOD DEFINITIONS
// ----------------------------------------------------------------------------

// Length
inline float CVector3::Length() const
{
	return static_cast<float>(sqrt(static_cast<float>(Length2())));
}

inline float CVector3::Length2() const
{
	return static_cast<float>(x * x + y * y + z * z);
}


// Vector math
inline CVector3 & CVector3::operator = (const CVector3 &v)
{
	x = v.x;
	y = v.y;
	z = v.z;
	return *this;
}

inline CVector3 CVector3::operator - () const
{
	return CVector3(-x, -y, -z);
}

inline CVector3 CVector3::operator + (const CVector3 &v) const
{
	return CVector3(x + v.x, y + v.y, z + v.z);
}

inline CVector3 CVector3::operator - (const CVector3 &v) const
{
	return CVector3(x - v.x, y - v.y, z - v.z);
}

inline CVector3 &CVector3::operator += (const CVector3 &v)
{
	x += v.x;
	y += v.y;
	z += v.z;
	return *this;
}

inline CVector3 &CVector3::operator -= (const CVector3 &v)
{
	x -= v.x;
	y -= v.y;
	z -= v.z;
	return *this;
}


// Comparison
inline bool CVector3::operator== (const CVector3 &v) const
{
	return (x == v.x && y == v.y && z == v.z);
}

inline bool CVector3::operator!= (const CVector3 &v) const
{
	return (!operator==(v));
}


// Scalar math
inline CVector3 CVector3::operator * (const float f) const
{
	return CVector3(x * f, y * f, z * f);
}

inline CVector3 CVector3::operator / (const float f) const
{
	return CVector3(x / f, y / f, z / f);
}

inline CVector3 &CVector3::operator *= (const float f)
{
	x *= f;
	y *= f;
	z *= f;

	return *this;
}

inline CVector3 &CVector3::operator /= (const float f)
{
	x /= f;
	y /= f;
	x /= f;

	return *this;
}

// declared as friend
inline CVector3 operator * (const float f, const CVector3 &v)
{
	return CVector3(f * v.x, f * v.y, f * v.z);
}





inline float CVector3::Dot(const CVector3 &v) const
{
  return x * v.x + y * v.y + z * v.z;
}


inline CVector3 CVector3::Cross(const CVector3 &v) const
{
  return CVector3(y * v.z - z * v.y,
				  z * v.x - x * v.z,
				  x * v.y - y * v.x);
}


inline void CVector3::Normalize()
{
  float invlen = 1.0f / sqrt(x * x + y * y + z * z);

  x *= invlen;
  y *= invlen;
  z *= invlen;
}
