/* File: tictactoe.h
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Declares the CTicTacToe class. It runs the game logic for tic-tac-toe. It
 * keeps track of whose turn it is, checks for the victory condition, etc. It
 * also encapsulates the tic-tac-toe AI. The AI is built on a neural net, built
 * ground-up from historic tic-tac-toe championship games. It uses iterative
 * pruning and constantly refines its search tree during the game.
 *
 * (Just kidding.)
 * 
 * Its methods are:
 *  void		NewGame(bool xIsAI, oIsAI);
 *  void		Draw();
 *  void		Update(int msecs);
 *  void		Move(int col, int row);
 *  bool		HumanTurn();
 */

#ifndef _TICTACTOE_H
#define _TICTACTOE_H

#include "board.h"


// -----------------------------------------------------------------------------
// FORWARD DECLARATIONS
// -----------------------------------------------------------------------------
//class slSample;

// -----------------------------------------------------------------------------
// CTICTACTOE CLASS
// -----------------------------------------------------------------------------
class CTicTacToe
{
public:

  // ctor
  CTicTacToe();

  // dtor
  ~CTicTacToe() {}

  /* NewGame
   * -------
   * Starts a new game with either none, one, or both of the players as AI.
   */
  void NewGame(bool xIsAI, bool oIsAI);

  /* Draw
   * ----
   * Draws the tic-tac-toe board. Simply a wrapper for CBoard::Draw.
   */
  void Draw() { board.Draw(); }

  /* Update
   * ------
   * Updates the game. Simply a wrapper for CBoard::Update.
   */
  void Update(int msecs) { board.Update(msecs); }

  /* Move
   * ----
   * Makes a move at the given row and column.
   */
  void Move(int row, int col);

  /* HumanTurn
   * ---------
   * Returns true if the game is waiting for a human to play.
   */
  bool HumanTurn() const;


protected:
  // constants
  static const int kVocMoveNum, kVocNoMoveNum, kVocWinNum, kVocLoseNum;

  // to make playerT local
  typedef CBoard::playerT playerT;
  static const playerT X;
  static const playerT O;

  // CPiece is a friend so that it can call CheckGameOver
  friend class CPiece;

  // helper methods
  void PieceLanded();
  void CheckGameOver();
  void Win(playerT player);
  void CatsGame();
  void AIMove(playerT player);

  // members
  CBoard board;
  playerT curPlayer;	// whose turn it is
  bool xIsAI, oIsAI;	// whether one or both players are AI
  bool playing;			// is the game in progress, or is it over?

  // voices
//  slSample **kVocMove, **kVocNoMove, **kVocWin, **kVocLose;
};



#endif	// _TICTACTOE_H
