/* File: tictactoe.cpp
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Defines the CTicTacToe class. For more information, see tictactoe.h.
 */

#include <assert.h>
//#include <plib/sl.h>	// for sound, using the SL library from PLIB
#include <iostream>
#include <stdlib.h>		// for rand()
#include "settings.h"
#include "board.h"
#include "piece.h"
#include "tictactoe.h"


#define PIECES board.pieces



// -----------------------------------------------------------------------------
// INITIALIZE CONSTANTS
// -----------------------------------------------------------------------------
const CTicTacToe::playerT CTicTacToe::X	= CBoard::X;
const CTicTacToe::playerT CTicTacToe::O	= CBoard::O;
const int CTicTacToe::kVocMoveNum		= 0; //CSettings::GetInt("Voices", "MoveNum");
const int CTicTacToe::kVocNoMoveNum		= 0; //CSettings::GetInt("Voices", "NoMoveNum");
const int CTicTacToe::kVocWinNum		= 0; //CSettings::GetInt("Voices", "WinNum");
const int CTicTacToe::kVocLoseNum		= 0; //CSettings::GetInt("Voices", "LoseNum");


// -----------------------------------------------------------------------------
// GLOBAL VARIABLES
// -----------------------------------------------------------------------------
//extern slScheduler		gSL;
extern bool				gSound;


// -----------------------------------------------------------------------------
// PUBLIC METHODS
// -----------------------------------------------------------------------------

CTicTacToe::CTicTacToe() : playing(false)
{
  /*
  // create voice arrays
  kVocMove = new slSample *[kVocMoveNum];
  kVocNoMove = new slSample *[kVocNoMoveNum];
  kVocWin = new slSample *[kVocWinNum];
  kVocLose = new slSample *[kVocLoseNum];

  // fill with voice samples
  kVocMove[0] = new slSample(const_cast<char *>
						 (CSettings::Get<string>("Voices", "Move0").c_str()), &gSL);
  kVocMove[1] = new slSample(const_cast<char *>
						 (CSettings::Get<string>("Voices", "Move1").c_str()), &gSL);
  kVocMove[2] = new slSample(const_cast<char *>
						 (CSettings::Get<string>("Voices", "Move2").c_str()), &gSL);
  kVocMove[3] = new slSample(const_cast<char *>
						 (CSettings::Get<string>("Voices", "Move3").c_str()), &gSL);
  kVocMove[4] = new slSample(const_cast<char *>
						 (CSettings::Get<string>("Voices", "Move4").c_str()), &gSL);

  kVocNoMove[0] = new slSample(const_cast<char *>
						(CSettings::Get<string>("Voices", "NoMove0").c_str()), &gSL);
  kVocNoMove[1] = new slSample(const_cast<char *>
						(CSettings::Get<string>("Voices", "NoMove1").c_str()), &gSL);

  kVocWin[0] = new slSample(const_cast<char *>
						(CSettings::Get<string>("Voices", "Win0").c_str()), &gSL);
  kVocWin[1] = new slSample(const_cast<char *>
						(CSettings::Get<string>("Voices", "Win1").c_str()), &gSL);
  kVocWin[2] = new slSample(const_cast<char *>
						(CSettings::Get<string>("Voices", "Win2").c_str()), &gSL);

  kVocLose[0] = new slSample(const_cast<char *>
						(CSettings::Get<string>("Voices", "Lose0").c_str()), &gSL);
  kVocLose[1] = new slSample(const_cast<char *>
						(CSettings::Get<string>("Voices", "Lose1").c_str()), &gSL);

  for (int i = 0; i < kVocMoveNum; i++) {
	kVocMove[i]->autoMatch(&gSL);
	//kVocMove[i]->setRate(41000);
  }
  for (int i = 0; i < kVocNoMoveNum; i++) {
	kVocNoMove[i]->autoMatch(&gSL);
	//kVocNoMove[i]->setRate(41000);
  }
  for (int i = 0; i < kVocWinNum; i++) {
	kVocWin[i]->autoMatch(&gSL);
	//kVocWin[i]->setRate(41000);
  }
  for (int i = 0; i < kVocLoseNum; i++) {
	kVocLose[i]->autoMatch(&gSL);
	//kVocLose[i]->setRate(41000);
  }
  */
}


void CTicTacToe::NewGame(bool xIsAI, bool oIsAI)
{
  this->xIsAI = xIsAI;
  this->oIsAI = oIsAI;
  playing = true;
  board.Clear();

  curPlayer = CBoard::X;	// X always starts
  if (xIsAI)
	AIMove(curPlayer);
}


void CTicTacToe::Move(int row, int col)
{
  if (!playing && gSound)	// not playing, can't move!
	//gSL.playSample(kVocNoMove[rand() % kVocNoMoveNum]);
	;

  else if (!board.CanMove(row, col) && gSound)
	//gSL.playSample(kVocNoMove[rand() % kVocNoMoveNum]);
	;

  else {
	board.Move(row, col, curPlayer);
	curPlayer = (curPlayer == X) ? O : X;
  }
}


bool CTicTacToe::HumanTurn() const
{
  return (playing && ((curPlayer == X && !xIsAI) || (curPlayer == O && !oIsAI)));
}


// -----------------------------------------------------------------------------
// PROTECTED METHODS
// -----------------------------------------------------------------------------

/* PieceLanded
 * -----------
 * Called by a piece when it hits the water. This checks the victory condition
 * and makes a move if it's the computer's turn.
 */
void CTicTacToe::PieceLanded()
{
  CheckGameOver();

  if (playing && ((xIsAI && curPlayer == X) || (oIsAI && curPlayer == O)))
	AIMove(curPlayer);
}


/* CheckGameOver
 * -------------
 * Checks to see if the game is over. If a player won, a sound is played.
 * If it's a cat's game, a different sound is played. (whee.)
 */
void CTicTacToe::CheckGameOver()
{
  static const int kBoardSize = CBoard::kBoardSize;
  int c, r;
  bool catsgame = true;

  // first, check for cat's game
  for (r = 0; r < kBoardSize; r++)
	for (c = 0; c < kBoardSize; c++)
	  if (!PIECES[r][c])
		catsgame = false;

  if (catsgame) {
	CatsGame();
	return;
  }

  // check rows
  for (r = 0; r < kBoardSize; r++) {

	for (c = 0; c < kBoardSize; c++) {
	  if (!PIECES[r][c] ||
		  c > 0 && PIECES[r][c]->IsX() != PIECES[r][c - 1]->IsX())
		  break;
	}

	if (c == kBoardSize)
	  Win((PIECES[r][0]->IsX()) ? X : O);
  }


  // check columns
  for (c = 0; c < kBoardSize; c++) {

	for (r = 0; r < kBoardSize; r++) {
	  if (!PIECES[r][c] ||
		  r > 0 && PIECES[r][c]->IsX() != PIECES[r - 1][c]->IsX())
		break;
	}

	if (r == kBoardSize)
	  Win((PIECES[0][c]->IsX()) ? X : O);
  }


  // check forward diagonal
  int k;
  for (k = 0; k < kBoardSize; k++) {
	if (!PIECES[k][k] ||
		k > 0 && PIECES[k][k]->IsX() != PIECES[k - 1][k - 1]->IsX())
	  break;
  }

  if (k == kBoardSize)
	Win((PIECES[0][0]->IsX()) ? X : O);


  // check backward diagonal
  for (r = 0, c = kBoardSize - 1; r < kBoardSize; r++, c--) {
	if (!PIECES[r][c] ||
		r > 0 && PIECES[r][c]->IsX() != PIECES[r - 1][c + 1]->IsX())
	  break;
  }

  if (r == kBoardSize)
	Win((PIECES[kBoardSize - 1][0]->IsX()) ? X : O);


  // no winner, do nothing
}


/* Win
 * ---
 * Plays a sound and lets the winning player know that they won.
 */
void CTicTacToe::Win(playerT player)
{
  //cout << ((player == CBoard::X) ? "X" : "O") << " wins!" << endl;

  if (gSound) {
	if ((player == CBoard::X && !xIsAI) || (player == CBoard::O && !oIsAI))
	  //gSL.playSample(kVocWin[rand() % kVocWinNum]);
	  ;
	else
	  //gSL.playSample(kVocLose[rand() % kVocLoseNum]);
	  ;
  }

  playing = false;
}


/* CatsGame
 * --------
 * Plays a sound and lets the players know that no one won.
 */
void CTicTacToe::CatsGame()
{
  //cout << "Cat's game!" << endl;

  //gSL.playSample(kVocLose[rand() % kVocLoseNum]);
  playing = false;
}


/* AIMove
 * ------
 * The AI method. Makes the best move for the given player.
 *
 * For those of you who like trivia, I translated this pretty much straight from
 * a tic-tac-toe game i wrote in QBasic in middle school.
 */

// helpers
#define MOVE_AND_RETURN(r, c) { Move(r, c); return; }

// ok, for now, here's the translation: 1 is X and 2 is O
inline bool eq(const CPiece * const piece, int pnum)
{
  if (!piece)
	return (pnum == 0);

  CBoard::playerT player = (pnum == 1) ? CBoard::X : CBoard::O;

  return ((piece->IsX() && player == CBoard::X) ||
		  (piece->IsO() && player == CBoard::O));
}

void CTicTacToe::AIMove(playerT player)
{
  int pnum = (player == X) ? 1 : 2;
  int i, j;
  int t1;
  int t2;
  int t3;

  if (pnum == 1) {
	t1 = 1;
	t2 = 3;
	t3 = 1;
  } else {		// pnum == 2
	t1 = 2;
	t2 = 0;
	t3 = -1;
  }

  for (i = t1; i != t2; i += t3) {
	for (j = 0; j < 3; j++) { 
	  if (!PIECES[j][0] && eq(PIECES[j][1], i) && eq(PIECES[j][2], i))
		MOVE_AND_RETURN(j, 0)
	  if (eq(PIECES[j][0], i) && !PIECES[j][1] && eq(PIECES[j][2], i))
		MOVE_AND_RETURN(j, 1)
	  if (eq(PIECES[j][0], i) && eq(PIECES[j][1], i) && !PIECES[j][2])
		MOVE_AND_RETURN(j, 2)
	  if (!PIECES[0][j] && eq(PIECES[1][j], i) && eq(PIECES[2][j], i))
		MOVE_AND_RETURN(0, j)
	  if (eq(PIECES[0][j], i) && !PIECES[1][j] && eq(PIECES[2][j], i))
		MOVE_AND_RETURN(1, j)
	  if (eq(PIECES[0][j], i) && eq(PIECES[1][j], i) && !PIECES[2][j])
		MOVE_AND_RETURN(2, j)
	  }
	if (!PIECES[0][0] && eq(PIECES[1][1], i) && eq(PIECES[2][2], i))
	  MOVE_AND_RETURN(0, 0)
	if (eq(PIECES[0][0], i) && !PIECES[1][1] && eq(PIECES[2][2], i))
	  MOVE_AND_RETURN(1, 1)
	if (eq(PIECES[0][0], i) && eq(PIECES[1][1], i) && !PIECES[2][2])
	  MOVE_AND_RETURN(2, 2)
	if (!PIECES[0][2] && eq(PIECES[1][1], i) && eq(PIECES[2][0], i))
	  MOVE_AND_RETURN(0, 2)
	if (eq(PIECES[0][2], i) && !PIECES[1][1] && eq(PIECES[2][0], i))
	  MOVE_AND_RETURN(1, 1)
	if (eq(PIECES[0][2], i) && eq(PIECES[1][1], i) && !PIECES[2][0])
	  MOVE_AND_RETURN(2, 0)
  }
  for (i = t1; i != t2; i += t3) {
	if (eq(PIECES[0][1], i) && eq(PIECES[1][0], i) && !PIECES[0][0])
	  MOVE_AND_RETURN(0, 0)
	if (eq(PIECES[0][1], i) && eq(PIECES[1][2], i) && !PIECES[0][2])
	  MOVE_AND_RETURN(0, 2)
	if (eq(PIECES[2][1], i) && eq(PIECES[1][0], i) && !PIECES[2][0])
	  MOVE_AND_RETURN(2, 0)
	if (eq(PIECES[2][1], i) && eq(PIECES[1][2], i) && !PIECES[2][2])
	  MOVE_AND_RETURN(2, 2)
  }
  if (!PIECES[1][1])
	MOVE_AND_RETURN(1, 1)
  if (eq(PIECES[0][0], pnum) && !PIECES[2][2])
	MOVE_AND_RETURN(0, 0)
  if (eq(PIECES[2][0], pnum) && !PIECES[0][2])
	MOVE_AND_RETURN(0, 2)
  if (eq(PIECES[0][2], pnum) && !PIECES[2][0])
	MOVE_AND_RETURN(2, 0)
  if (eq(PIECES[2][2], pnum) && !PIECES[0][0])
	MOVE_AND_RETURN(2, 2)
  if (eq(PIECES[1][1], pnum)) {
	for (i = 0; i < 3; i++) {
	  if (!PIECES[i][0] && !PIECES[2 - i][2])
		MOVE_AND_RETURN(i, 0)
	  if (!PIECES[i][2] && !PIECES[2 - i][0])
		MOVE_AND_RETURN(i, 2)
	}
  }

  for (i = 0; i < 3; i++) {
	if (!PIECES[i][0] && !PIECES[i][1] && eq(PIECES[i][2], pnum))
	  MOVE_AND_RETURN(i, 0)
	if (!PIECES[i][2] && !PIECES[i][1] && eq(PIECES[i][0], pnum))
	  MOVE_AND_RETURN(i, 2)
	if (!PIECES[0][i] && !PIECES[1][i] && eq(PIECES[2][i], pnum))
	  MOVE_AND_RETURN(0, i)
	if (!PIECES[2][i] && !PIECES[1][i] && eq(PIECES[0][i], pnum))
	  MOVE_AND_RETURN(2, i)
	if (!PIECES[i][0] && eq(PIECES[i][1], pnum) && !PIECES[i][2])
	  MOVE_AND_RETURN(i, 0)
	if (!PIECES[i][2] && eq(PIECES[i][1], pnum) && !PIECES[i][0])
	  MOVE_AND_RETURN(i, 2)
	if (!PIECES[0][i] && eq(PIECES[1][i], pnum) && !PIECES[2][i])
	  MOVE_AND_RETURN(2, i)
	if (!PIECES[2][i] && eq(PIECES[1][i], pnum) && !PIECES[0][i])
	  MOVE_AND_RETURN(0, i)
  }

  int crow, ccol;

  do {
	crow = rand() % 3;
	ccol = rand() % 3;
  } while (PIECES[crow][ccol]);
  MOVE_AND_RETURN(crow, ccol);
}
