/* File: texture.h
 * Author: Ryan Barrett (rbarrett@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * A simple, small texture class for use with OpenGL. The texture can be given
 * as a set of pixels in memory or loaded from a file.
 *
 * NOTE: Right now, only 24-bit textures (RGB) in .RAW files are supported.
 */

#ifndef _TEXTURE_H
#define _TEXTURE_H

#include <GL/glut.h>


// ----------------------------------------------------------------------------
// CTEXTURE CLASS
// ----------------------------------------------------------------------------

class CTexture
{
public:
	/* Ctor
	 * ----
	 * Loads the texture from a file, or creates it from an section of memory.
	 */
	CTexture(const char *rawfile);
	CTexture(const int size, const unsigned char *pixels);

	/* Dtor
	 * ----
	 * Releases the texture.
	 */
	~CTexture();

	/* Bind
	 * ----
	 * Selects the texture for use.
	 */
	void	Bind() const;

	// Accessors
	int		GetSize() const		{ return mSize; }

protected:
	// members
	unsigned int	mTexture;
	int		mSize;

	// protected member functions
	void SetTexture(const int size, const unsigned char *pixels);

	// disallow empty ctor
	CTexture();
};


#endif	// _TEXTURE_H
