/* File: settings.h
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Declares the CSettings class. CSettings is a static class - it cannot be
 * instantiated. CSettings stores the settings for everything in the game.
 *
 * Its methods are:
 *  template <typename T> T	Get(string section, string key);
 *  void					Save();
 */

#ifndef _SETTINGS_H
#define _SETTINGS_H

#include "stlini.h"
#include <string>
#include <sstream>

using namespace std;


// -----------------------------------------------------------------------------
// CSETTINGS CLASS
// -----------------------------------------------------------------------------
class CSettings
{
public:
  /* Get
   * ---
   * Returns the setting associated with the given name. If there is no setting
   * associated with the name, Get throws an assertion. Also, if the setting
   * stored with the name has a different type than the return type, Get
   * throws an assertion.
   *
   * NOTE: you probably shouldn't instantiate this with any type besides string,
   * int, float, etc.
   *
   * MORE IMPORTANT NOTE: for the windoze port, since vc++ is incompetent with
   * templated code, I'm declaring multiple methods instead.
   */
  static string	GetString	(const string &section, const string &key);
  static int	GetInt		(const string &section, const string &key);
  static float	GetFloat	(const string &section, const string &key);

  /* Save
   * ----
   * Saves the current settings to the filename in kFilename.
   */
  static void Save() { SaveIni(sFile, kFilename.c_str()); }


private:
  // constants
  static const string	kFilename;

  // static members
  static INIFile		sFile;
  static bool			sLoaded;

  // helper methods
  static void Load();
};


// -----------------------------------------------------------------------------
// TEMPLATIZED METHODS
// -----------------------------------------------------------------------------


#endif	// SETTINGS_H
