/* File: settings.cpp
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Defines the CSettings class. For more information, see settings.h.
 */

#include <assert.h>
#include "settings.h"	// stl stuff (including string) is #included in stlini.h


// -----------------------------------------------------------------------------
// INITIALIZE STATIC MEMBERS
// -----------------------------------------------------------------------------
// moved to main.cpp as a hack to get around vc++'s init order...
//
//const string	CSettings::kFilename("tictactoe.ini");
//INIFile			CSettings::sFile;
//bool			CSettings::sLoaded = false;



// -----------------------------------------------------------------------------
// PUBLIC METHODS
// -----------------------------------------------------------------------------
string CSettings::GetString(const string &section, const string &key)
{
  Load();

  // get setting
  string setting(GetIniSetting(sFile, section.c_str(), key.c_str(), ""));
  assert(setting != "");

  return setting;
}


int CSettings::GetInt(const string &section, const string &key)
{
  const string setting(GetString(section, key));

  // convert to int
  int val;
  stringstream s;
  s << setting;
  s >> val;
  return val;
}



float CSettings::GetFloat(const string &section, const string &key)
{
  const string setting(GetString(section, key));

  // convert to int
  float val;
  stringstream s;
  s << setting;
  s >> val;
  return val;
}



// -----------------------------------------------------------------------------
// PRIVATE METHODS
// -----------------------------------------------------------------------------
void CSettings::Load()
{
  if (!sLoaded) {
	sFile = LoadIni(kFilename.c_str());
	// had to do it this way because vc++ messes up initialization order
//	sFile = LoadIni("tictactoe.ini");
	sLoaded = true;
  }
}

