/* File: refract.cpp
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Defines the CWater::RefractColor method. For more information, see water.h.
 */

#include "texture.h"


// -----------------------------------------------------------------------------
// GLOBALS
// -----------------------------------------------------------------------------
extern CVector3	gViewPos;



/* RefractCoords
 * -------------
 * Sets up the refracted texture coordinates of the ground for drawing the water
 * surface.
 */
void CWater::RefractCoords(int row, int col) const
{
  static const float dist = CSettings::GetFloat("Floor", "Height");
  static const float factor = CSettings::GetFloat("Water", "RefractFactor");
  static const float waterSize = CSettings::GetFloat("Water", "FineVerts") *
								 CSettings::GetFloat("Water", "FineSquare") / 2;
  const CVector3& normal = normals[row][col];

  // get point of incidence
  const float x = ColToX(col), y = RowToY(row);

  // find negative incident vector (note that it's NOT normalized!)
  CVector3 nincident(gViewPos);
  nincident.x -= x;
  nincident.y -= y;
  nincident.z -= heights[cur][row][col];
  nincident.Normalize();

  // *APPROXIMATION* of Snell's Law is -N * fac + I, or - (N * fac + - I)
  // (where N is normal, fac is refraction factor, and I is incident ray)
  CVector3 refracted(- (normal * factor + nincident));
  refracted.Normalize();

  // get truly correct depth here
  // TODO: is this necessary?
  const float depth = dist + heights[cur][row][col];

  // find texture coords by parametrically extending refracted ray until it
  // intersects the given depth.
  const float t = depth / refracted.z;
  const float u = (x + refracted.x * t) / waterSize;
  const float v = (y + refracted.x * t) / waterSize;

  // set refracted texture coordinates
  glTexCoord2f(u, v);
}

