/* File: raindrop.h
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Declares the CRaindrop class. CRaindrop is the class for a raindrop.
 *
 * Its methods are:
 *  void		Draw();
 *  void		Update(int msecs);
 *  CVector3&	GetPos();
 *  void		SetPos(CVector3& pos);
 */

#ifndef _RAINDROP_H
#define _RAINDROP_H


#include "vector3.h"


// -----------------------------------------------------------------------------
// FORWARD DECLARATIONS
// -----------------------------------------------------------------------------


// -----------------------------------------------------------------------------
// CRAINDROP CLASS
// -----------------------------------------------------------------------------
class CRaindrop
{
public:
  // ctor
  CRaindrop()	{ Init(); }

  // dtor
  ~CRaindrop()	{}

  /* Draw
   * ----
   * Draws the raindrop at its current position.
   */
  void Draw() const;

  /* Update
   * ------
   * Updates the position, behavior, etc. of the raindrop after a given delta time.
   * In this case, the piece will fall (move down) some, based on its velocity. If
   * it hits the water, it will cause a ripple.
   */
  void Update(int msecs);

  /* GetPos, SetPos
   * --------------
   * Accessors for the piece's position.
   */
  const CVector3& GetPos() const				{ return pos; }
  const void SetPos(const CVector3& pos)		{ this->pos = pos; }


protected:
  // constants
  static float	kMinHeight, kMaxHeight;
  static float	kSize;
  static CVector3	kVelocity;	// in units per second

  // helper methods
  void Init();

  // members
  CVector3 pos;
  CVector3 velocity;
};


#endif	// _RAINDROP_H


