/* File: raindrop.cpp
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Defines the CRaindrop class. For more information, see raindrop.h.
 */

#include <GL/glut.h>
//#include <plib/sl.h>	// for sound
#include <assert.h>
#include <math.h>
#include "settings.h"
#include "vector3.h"
#include "water.h"
#include "texture.h"
#include "raindrop.h"


// -----------------------------------------------------------------------------
// GLOBAL VARIABLES
// -----------------------------------------------------------------------------
extern CWater		gWater;


// -----------------------------------------------------------------------------
// INITIALIZE STATIC MEMBERS
// -----------------------------------------------------------------------------
float		CRaindrop::kMinHeight	= 0; //CSettings::GetFloat("Rain", "MinHeight");
float		CRaindrop::kMaxHeight	= 0; //CSettings::GetFloat("Rain", "MaxHeight");
float		CRaindrop::kSize		= 0; //CSettings::GetFloat("Rain", "Size");
CVector3	CRaindrop::kVelocity; //(CSettings::GetFloat("Rain", "VelocityX"),
								  // CSettings::GetFloat("Rain", "VelocityY"),
								  // CSettings::GetFloat("Rain", "VelocityZ"));


// -----------------------------------------------------------------------------
// PUBLIC METHODS
// -----------------------------------------------------------------------------
void CRaindrop::Update(int msecs)
{
  float secs = static_cast<float>(msecs) / 1000;

  // kVelocity stores velocity per second
  pos += velocity * secs;

  // did it hit the water?
  if (pos.z <= CWater::kHeight)
	gWater.Touch(pos.x, pos.y, true);

  if (pos.z - velocity.z * kSize <= CWater::kHeight)
	Init();
}


void CRaindrop::Draw() const
{
  static const CTexture tex(CSettings::GetString("Rain", "TexFile").c_str());
  static const float kWidth = CSettings::GetFloat("Rain", "Width");
  //float diff = velocity.x * kSize * CSettings::Get<float>("Rain", "Width");

  CVector3 tail(pos);
  tail -= velocity * kSize;

  tex.Bind();

  glBegin(GL_LINE_STRIP);
  glColor3f(1.0, 1.0, 1.0);
  glLineWidth(kWidth);
  glVertex3f(pos.x, pos.y, pos.z);
  glVertex3f(tail.x, tail.y, tail.z);
  tail -= velocity * kSize;
  glLineWidth(kWidth / 2);
  glVertex3f(tail.x, tail.y, tail.z);
  glEnd();

  /*
  glBegin(GL_TRIANGLE_STRIP);
  glColor3f(1.0, 1.0, 1.0);
  glVertex3f(pos.x, pos.y, pos.z);
  glVertex3f(tail.x, tail.y, tail.z);
  glVertex3f(pos.x + diff, pos.y + diff, tail.z);
  glVertex3f(tail.x, tail.y, tail.z);
  glVertex3f(pos.x - diff, pos.y - diff, tail.z);
  glEnd();
  */
}


// -----------------------------------------------------------------------------
// PRIVATE METHODS
// -----------------------------------------------------------------------------

// returns a random float in the range [0.0, 1.0).
inline float RandPercent() { return static_cast<float>(rand()) / RAND_MAX; }

/* Init
 * ----
 * Initializes a raindrop to a random position and velocity.
 */
void CRaindrop::Init()
{
  static const float kWaterSize =
	CSettings::GetFloat("Water", "FineVerts") *
	CSettings::GetFloat("Water", "FineSquare");

  // init static "constants" (damn vc++ can't do init order right)
  if (kMinHeight == 0) {
	kMinHeight	= CSettings::GetFloat("Rain", "MinHeight");
	kMaxHeight	= CSettings::GetFloat("Rain", "MaxHeight");
	kSize			= CSettings::GetFloat("Rain", "Size");
	kVelocity.x	= CSettings::GetFloat("Rain", "VelocityX");
	kVelocity.y	= CSettings::GetFloat("Rain", "VelocityY");
	kVelocity.z	= CSettings::GetFloat("Rain", "VelocityZ");
  }


  // set velocity (perturb a little from the default...
  velocity.x = kVelocity.x * (RandPercent() / 2 + .75);
  velocity.y = kVelocity.y * (RandPercent() / 2 + .75);
  velocity.z = kVelocity.z * (RandPercent() / 2 + .75);


  // set position...
  // get random z
  pos.z =  RandPercent() * (kMaxHeight - kMinHeight)
	+ kMinHeight;

  // get random x and y and offset by velocity.x/y
  pos.x = RandPercent() * kWaterSize - kWaterSize / 2;
  pos.x -= velocity.x * pos.z / -velocity.z;

  pos.y = RandPercent() * kWaterSize - kWaterSize / 2;
  pos.y -= velocity.y * pos.z / -velocity.z;
}
