/* File: piece.h
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Declares the CPiece class. CPiece is the class for a tic-tac-toe piece. It
 * is an *abstract* class - its implementing subclasses are CPieceX and CPieceO.
 *
 * Its methods are:
 *  void		Draw();
 *  void		Update(int msecs);
 *  bool		IsX();
 *  bool		IsO();
 *  CVector3&	GetPos();
 *  void		SetPos(CVector3& pos);
 *
 * This file also declares the CPieceX and CPieceO classes. The only differences
 * they have (right now) are their code for IsX, IsO, and Draw.
 */

#ifndef _PIECE_H
#define _PIECE_H

#include "vector3.h"

// -----------------------------------------------------------------------------
// FORWARD DECLARATIONS
// -----------------------------------------------------------------------------
class CBoard;


// -----------------------------------------------------------------------------
// CPIECE CLASS
// -----------------------------------------------------------------------------
class CPiece
{
public:
  // ctor
  CPiece(const CVector3& pos);

  // dtor
  virtual ~CPiece() {}

  /* Draw
   * ----
   * Draws the piece at its current position. (Declared pure virtual...all derived
   * classes *must* implement this!)
   */
  virtual void Draw() const = 0;

  /* Update
   * ------
   * Updates the position, behavior, etc. of the piece after a given delta time.
   * In this case, the piece will fall (move down) some, based on its current
   * velocity and whether it's in the air or the water.
   */
  void Update(int msecs);

  /* IsX, IsO
   * --------
   * Return true if the piece is an X or an O, respectively.
   */
  virtual bool IsX() const = 0;
  virtual bool IsO() const = 0;

  /* GetPos, SetPos
   * --------------
   * Accessors for the piece's position.
   */
  const CVector3& GetPos() const				{ return pos; }
  const void SetPos(const CVector3& pos)		{ this->pos = pos; }


protected:
  // constants
  static const float kInitVelocity;		// units per second
  static const float kWaterVelocity;
  static const float kAirAccel;			// units per second^2

  static const float kSize;		// initialized in piece.cpp
  static const float kDepth;	// ditto

  // helper methods
  /* CreateDispList
   * --------------
   * Creates a display list for the piece and stores it in sDisplist. Your derived
   * class doesn't have to use display list, but unless it's animated or has
   * procedural geometry, it probably should.
   *
   * NOTE: I'm tightening the requirement. You have to use display lists. Deal. :P
   */
  //virtual void CreateDispList() = 0;

  static inline void SharpHelper(float x, float y, float nx, float ny);
  void Orient() const;

  // members
  CVector3		pos;		// position of the *center* of the piece
  CVector3		normal;		// "up" direction for the piece, used for orientation
  float			velocity;
  bool			falling, playedSplash;
};


// -----------------------------------------------------------------------------
// CPIECEX CLASS
// -----------------------------------------------------------------------------
class CPieceX : public CPiece  // public inheritance models is-a!
{
public:
  // ctor
  CPieceX(const CVector3& pos);

  // dtor
  ~CPieceX() {}

  /* Draw
   * ----
   * Draws a capital, block X - 24 vertices (12 top, 12 bottom).
   */
  void Draw() const;

  // IsX, IsO
  bool IsX() const { return true; }
  bool IsO() const { return false; }

protected:
  // constants
  static const float kColor[4];

  // static members
  static unsigned int	sDLSharp, sDLSmooth;	// display lists for faster rendering

  // static methods
  static void CreateDispList();
  static void DrawTop();
  static void DrawSidesSharp();
  static void DrawSidesSmooth();
};


// -----------------------------------------------------------------------------
// CPIECEO CLASS
// -----------------------------------------------------------------------------
class CPieceO : public CPiece  // public inheritance models is-a!
{
public:
  // ctor
  CPieceO(const CVector3& pos);

  // dtor
  ~CPieceO() {}

  /* Draw
   * ----
   * Draws a capital, block O.
   */
  void Draw() const;

  // IsX, IsO
  bool IsX() const { return false; }
  bool IsO() const { return true; }

protected:
  // constants
  static const float kColor[4];

  // static members
  static unsigned int	sDispList;		// display list for faster rendering

  // static methods
  static unsigned int CreateDispList();
};



// ----------------------------------------------------------------------------
// INLINE METHOD DEFINITIONS
// ----------------------------------------------------------------------------


#endif	// _PIECE_H
