/* File: fresnel.cpp
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Defines the CWater::FresnelTerm method. For more information, see water.h.
 */



// -----------------------------------------------------------------------------
// GLOBALS
// -----------------------------------------------------------------------------
extern CVector3	gViewPos;



/* FresnelTerm
 * -----------
 * Calculates and sets the Fresnel term for the vertex at the given position in
 * the heightfield. This is dependent on the angle of incidence, so it uses the
 * viewing position stored in gViewPos.
 *
 * The equation I'm using right now is:
 *			(g-c)^2		 (c(g+c)-1)^2)
 *   F = .5	------- (1 + ------------- )
 *			(g+c)^2		 (c(g-c)+1)^2)
 *							 _	 _		  _					 _
 *   where c = cos theta_h = L * H		( L is light vector, H is halfway vector)
 *
 *					  n_i
 *	   and g = sqrt( {---}^2 + c^2 + 1)
 *					  n_t
 *
 * (sigh.....)
 *
 * BUT! After much thinking, which is sometimes better than diving into assembly
 * (especially Intel assembly...yuck), I think I could use this approximation:
 *						   _   _		  _			   _
 *	f = (cos theta_i)^k = (N * V)^k		( N is normal, V is viewpoint vector)
 *
 * Much better...
 */
void CWater::FresnelTerm(int row, int col) const
{
  //static const float index = CSettings::Get<float>("Water", "RefractFactor") *
  //						   CSettings::Get<float>("Water", "RefractFactor");
  static float color[4] = { 1.0, 1.0, 1.0, 0.0 };

  // get point of incidence
  const float x = ColToX(col), y = RowToY(row);

  // get normal vector
  const CVector3& normal = normals[row][col];

  // get viewpoint vector (from point of incidence to light)
  CVector3 incident(gViewPos);
  //incident.x += x;
  //incident.y += y;
  incident.z -= heights[cur][row][col];
  incident.Normalize();

  // get dot product
  color[3] = normal.Dot(incident);

  // try fourth power for now
  //color[3] = color[3] * color[3];
  //color[3] = color[3] * color[3];

  color[3] = 1 - color[3];
  glColor4fv(color);
}
