/* File: piece.cpp
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Defines the CPiece class. For more information, see piece.h.
 */

#include <GL/glut.h>
#include "settings.h"
#include "texture.h"
#include "board.h"
#include "floor.h"


// -----------------------------------------------------------------------------
// INITIALIZE STATIC MEMBERS
// -----------------------------------------------------------------------------
int		CFloor::kHeight = 0; //CSettings::GetInt("Floor", "Height");


// -----------------------------------------------------------------------------
// PUBLIC METHODS
// -----------------------------------------------------------------------------

void CFloor::Draw() const
{
  const CTexture floor(CSettings::GetString("Floor", "TexFile").c_str());
  static const float vert = CSettings::GetFloat("Water", "FineVerts") *
							CSettings::GetFloat("Water", "FineSquare");
  static float x[4]		= { 0.085, 0.0, 0.0, 0.0 };
  static float y[4]		= { 0.0, 0.085, 0.0, 0.0 };
  //static float color[4]	= { 1.0, 1.0, 1.0, 1.0 };

  glDisable(GL_BLEND);
  glEnable(GL_TEXTURE_2D);

  // generate texture coordinates (so it will repeat)
  //glEnable(GL_TEXTURE_GEN_S);
  //glEnable(GL_TEXTURE_GEN_T);
  glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);

  glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
  glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
  glTexGenfv(GL_S, GL_OBJECT_PLANE, x);
  glTexGenfv(GL_T, GL_OBJECT_PLANE, y);


  floor.Bind();

  glBegin(GL_QUADS);

  // draw floor
  glNormal3f(0.0, 0.0, 1.0);
  //glTexCoord2f(0.0, 0.0);
  glVertex3f(-vert, -vert, kHeight);
  //glTexCoord2f(1.0, 0.0);
  glVertex3f(vert, -vert, kHeight);
  //glTexCoord2f(1.0, 1.0);
  glVertex3f(vert, vert, kHeight);
  //glTexCoord2f(0.0, 1.0);
  glVertex3f(-vert, vert, kHeight);

  glEnd();
}
