/* File: envmap.cpp
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Defines the Texture method. For more information, see water.h.
 */

#include "texture.h"


/* EnvMap
 * -------
 * Sets up a spherical environment map.
 */
void Env(bool on)
{
	static CTexture tex("blueenv.raw");

	if (!on) {
	  glDisable(GL_TEXTURE_2D);
	  return;
	}

	tex.Bind();

	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);

	glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);

	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);
}

