/* File: board.h
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Declares the CBoard class. CBoard is the class for a tic-tac-toe board. It
 * runs the game logic and holds the board as an array of CPieces.
 *
 * Its methods are:
 *  void		Draw();
 *  void		Update(int msecs);
 *  bool		CanMove(int col, int row);
 *  void		Move(int col, int row, playerT player);
 */

#ifndef _BOARD_H
#define _BOARD_H

// -----------------------------------------------------------------------------
// FORWARD DECLARATIONS
// -----------------------------------------------------------------------------
class CVector3;
class CPiece;



// -----------------------------------------------------------------------------
// CBOARD CLASS
// -----------------------------------------------------------------------------
class CBoard
{
public:
  // declared solely for expressiveness
  typedef enum { X, O } playerT;

  // constants
  static const int		kBoardSize;
  static const int		kStartZ;
  static const float	kSquareSize;

  // ctor
  CBoard();

  // dtor
  ~CBoard();

  /* Draw
   * ----
   * Draws the board.
   */
  void Draw() const;

  /* Update
   * ------
   * Updates the position, behavior, etc. of the entire board after a given delta
   * time. This includes the positions of all of the pieces.
   */
  void Update(int msecs);

  /* CanMove
   * -------
   * Returns true if a player can place a piece at a given position (i.e. there
   * isn't already a piece there).
   */
  bool CanMove(int row, int col) const;

  /* Move
   * ----
   * Makes the current player's move at the given position.
   */
  void Move(int row, int col, playerT player);

  /* Clear
   * -----
   * Removes all of the pieces from the board.
   */
  void Clear();

protected:
  // CTicTacToe is a friend so that the AI can examine the board
  friend class CTicTacToe;

  // helper methods
  inline bool IsValid(int col, int row) const;

  // the board. the first array index is the row, the second is the column.
  // so the piece at row r, column c is pieces[r][c].
  //
  // NOTE: this is an array of pointers because a piece could be either a CPieceX
  // or a CPieceO, so I don't want to call the constructor until I know which one.
  CPiece ***pieces;
};


// -----------------------------------------------------------------------------
// INLINE METHODS
// -----------------------------------------------------------------------------

/* IsValid
 * -------
 * Returns true if (row, col) is a valid board position, false otherwise.
 */
inline bool CBoard::IsValid(int row, int col) const
{
  return (row >= 0 && row < kBoardSize && col >= 0 && col < kBoardSize);
}


#endif	 // _BOARD_H
