/* File: board.cpp
 * Author: Ryan Barrett (rbarret@stanford.edu)
 * --------------------
 * CS248 Fall 2001
 * HW3 - Video Game
 *
 * Defines the CBoard class. For more information, see board.h.
 */

#include <GL/glut.h>
#include <assert.h>
#include "vector3.h"
#include "piece.h"
#include "board.h"
#include "tictactoe.h"
#include "water.h"




// -----------------------------------------------------------------------------
// GLOBAL VARIABLES
// -----------------------------------------------------------------------------
extern CWater gWater;



// -----------------------------------------------------------------------------
// INITIALIZE STATIC MEMBERS
// -----------------------------------------------------------------------------
const int	CBoard::kBoardSize		= 3;
const int	CBoard::kStartZ			= 10;
const float	CBoard::kSquareSize		= 2;


// -----------------------------------------------------------------------------
// PUBLIC METHODS
// -----------------------------------------------------------------------------

CBoard::CBoard()
{
	// allocate board
  pieces = new CPiece **[kBoardSize];
  assert(pieces);

  for (int r = 0; r < kBoardSize; r++) {
	pieces[r] = new CPiece *[kBoardSize];
	assert(pieces[r]);
  }

	// initialize pieces
  for (int row = 0; row < kBoardSize; row++)
	for (int col = 0; col < kBoardSize; col++)
	  pieces[row][col] = 0;
}


CBoard::~CBoard()
{
  Clear();

  // deallocate board
  for (int r = 0; r < kBoardSize; r++)
	delete[] pieces[r];

  delete[] pieces;
}


void CBoard::Draw() const
{
  static const float x[4] = { 0.5, 0.0, 0.0, 0.0 };
  static const float y[4] = { 0.0, 0.5, 0.0, 0.0 };

  glEnable(GL_TEXTURE_2D);
  glEnable(GL_LIGHTING);
  glDisable(GL_BLEND);
  glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
  glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
  glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
  glTexGenfv(GL_S, GL_OBJECT_PLANE, x);
  glTexGenfv(GL_T, GL_OBJECT_PLANE, y);
  glEnable(GL_TEXTURE_GEN_S);
  glEnable(GL_TEXTURE_GEN_T);
  glColor3f(1.0, 1.0, 1.0);

  for (int row = 0; row < kBoardSize; row++)
	for (int col = 0; col < kBoardSize; col++)
	  if (pieces[row][col])
		pieces[row][col]->Draw();
}


void CBoard::Update(int msecs)
{
  // update pieces
  for (int row = 0; row < kBoardSize; row++)
	for (int col = 0; col < kBoardSize; col++)
	  if (pieces[row][col])
		pieces[row][col]->Update(msecs);
}


bool CBoard::CanMove(int row, int col) const
{
  assert(IsValid(row, col));

  return (pieces[row][col] == 0);
}


void CBoard::Move(int row, int col, playerT player)
{
  assert(IsValid(row, col));
  assert(CanMove(row, col));

  // create new piece
  CVector3 pos((col - (kBoardSize - 1) / 2) * kSquareSize,  // starting x coord
			   (row - (kBoardSize - 1) / 2) * kSquareSize,  // starting y coord
			   kStartZ);

  if (player == X) {
	pieces[row][col] = new CPieceX(pos);
	player = CBoard::O;
  } else {
	pieces[row][col] = new CPieceO(pos);
	player = CBoard::X;
  }

  assert(pieces[row][col] != 0);
}


void CBoard::Clear()
{
  for (int row = 0; row < kBoardSize; row++) {
	for (int col = 0; col < kBoardSize; col++) {
	  delete pieces[row][col];	// ok because calling delete on NULL is a noop
	  pieces[row][col] = 0;
	}
  }
}


// -----------------------------------------------------------------------------
// HELPER METHODS
// -----------------------------------------------------------------------------

