#include <stdio.h>
#include <stdlib.h>
#include "SoundObject.h"


SoundObject::SoundObject()
{
	waveFile = NULL;
}

SoundObject::~SoundObject()
{
	if (waveFile!=NULL)
		FSOUND_Sample_Free(waveFile);
}


bool SoundObject::loadWave(const char * path,const char *name)
{
	char fileName[256];
	strcpy(fileName,path);
	strcat(fileName,name);
	return (loadWave (fileName));
}

bool SoundObject::loadWave (const char* filename)
{	
	if (waveFile == NULL)
		waveFile = FSOUND_Sample_Load (FSOUND_UNMANAGED, filename, FSOUND_NORMAL, 0);
	else{
		FSOUND_Sample_Free(waveFile);
		waveFile = FSOUND_Sample_Load (FSOUND_UNMANAGED, filename, FSOUND_NORMAL, 0);
	}
	strcpy (typeName, filename);
	return (waveFile != NULL);
}

FSOUND_SAMPLE* SoundObject::getAudio()
{
	return waveFile;
}

const char* SoundObject::getTypeName(){
	return typeName;
}
