#include "server.h"
#include "ClientState.h"
#include "GameState.h"

#include "ServerModelList.h"

#if defined WIN32 || defined WIN64
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#define sleep(x)    Sleep(1000 * (x))
#endif



ClientState* clientStates[MAX_CLIENTS];

unsigned char buff[MAXPACKETLEN];
int cursor; //packetlen = cursor;


static void deleteClient(int token);
static int insertClient(NLsocket sockfd);

static int writePacket(NLsocket sockfd, unsigned char *packet, int packetlen);

void printErrorExit(void)
{
    NLenum err = nlGetError();
    
    if(err == NL_SOCKET_ERROR)
    {
        //printf("System error: %s\n", nlGetSystemErrorStr(nlGetSystemError()));
    }
    else
    {
        //printf("Network library error: %s\n", nlGetErrorStr(err));
    }
    nlShutdown();
    exit(1);
}

int main(int argc, char **argv)
{
    NLsocket    serversock;
	GameState	*gameState;
	int i,j;
	unsigned long mcurtime, moldtime,moldSpawnTime,lastCycleTime;


	NLsocket    activesocks[MAX_CLIENTS+1];
	
    printf("Server Release 9.2\n");
	printf("(c) 2001. Satyam Vaghani, Sujith Surendran, Sriram Viji.\nWelcome to the multiplayer experience.\n");


	//initialization
	printf("\nLoading Gamestate. Start counting till infinity.\n");
	printf("Pre-caching weapon positions and player spawn points. Wait...\n"); 
	gameState = new GameState(0.25f, 1.0f/* 0.10f, 0.05f */);
	//Load weapon positions

	printf("\nMaking room for Client states. Wait...\n");
	for (i = 0; i < MAX_CLIENTS; i++)
		clientStates[i]  = NULL;
	printf("Client states ready.\n");

	lastCycleTime=moldSpawnTime=moldtime = 0;


	printf("\nInitializing the network.\n");

    if(!nlInit())
        printErrorExit();
	nlSelectNetwork(NL_IP);
	nlEnable(NL_BLOCKING_IO);
	nlEnable(NL_TCP_NO_DELAY);
    
	printf("Network ready\n");
    
	printf("\nSTARTING SERVER. Take a deep breath...\n");

	// create the server socket
    serversock = nlOpen(SERVERPORT, NL_RELIABLE);
    
    if(serversock == NL_INVALID)
        printErrorExit();
    
    if(!nlListen(serversock))
    {
        nlClose(serversock);
        printErrorExit();
    }

    
	NLint group;
    group = nlGroupCreate();
	if (nlGroupAddSocket(group, serversock) != NL_TRUE)
		printErrorExit();

	printf("SERVER STARTED SUCCESSFULLY. Exhale slowly\n");
	printf("SERVER: Ready to roll....gimme some clients\n");

	NLint numactive;
	NLsocket newsock;
	unsigned char command, tmpchar;
	char sessiontoken;
    
	while(1)
    {
		if ( (numactive = nlPollGroup(group, NL_READ_STATUS, activesocks, MAX_CLIENTS+1, 0)) != NL_INVALID){
		

			for (int i = 0; i < numactive; i++)
				if (activesocks[i] == serversock)
				{
					//accept new connection if ok
					newsock = nlAcceptConnection(serversock);
					if (newsock == NL_INVALID)
						printErrorExit();

					if ( nlGroupAddSocket(group, newsock) != NL_TRUE)
							nlClose(newsock);
					//printf("adding a new socket to poll group\n");
						//add to listener group but it is not in the game yet. HELLO s.v.p
				}
				else
				{
					//houston! we got incoming
					nlRead(activesocks[i], &command, 1);
					//printf("MAIN COMMAND: %d\n", command);
					switch (command)
					{
					case HELLO:
						{
							tmpchar = BYE;
							sessiontoken = insertClient(activesocks[i]);
							printf("New SESSION token %d\n", sessiontoken);
							if (sessiontoken < 0)
							{
								nlWrite(activesocks[i], &tmpchar, 1);
								nlGroupDeleteSocket(group, activesocks[i]);
								nlClose(activesocks[i]);
								break;
							}
							//echo back hello with a session ID
							nlWrite(activesocks[i], &command, 1);
							nlWrite(activesocks[i], &sessiontoken, 1);

							//Transfer game state to new player adds the new player to list,new player will be known to others on nxt update
							gameState->playerCount++;
							clientStates[sessiontoken]->dirtyFlag=true;
							//One of 5 types of players
							clientStates[sessiontoken]->modelTypeIndex=(5.0*rand()/(RAND_MAX*1.0));
							clientStates[sessiontoken]->playerModel.setPosition(gameState->startPosition);
							clientStates[sessiontoken]->playerModel.setOrientation(gameState->startOrientation);
							clientStates[sessiontoken]->motionState=NOTMOVING;
							int len=gameState->makeStateForNewPlayer(activesocks[i],sessiontoken);
							
							//printf("NEW client got complete gamestate in %d bytes\n", len);

							if(writePacket(activesocks[i],buff,len)<len){

								nlGroupDeleteSocket(group, activesocks[i]);
								nlClose(activesocks[i]);
								deleteClient(sessiontoken);
								
								tmpchar = DELETE_PLAYER;
								gameState->playerCount--;

							}
							
						}						

						break;
					case BYE:

						nlRead(activesocks[i], &sessiontoken, 1);
						nlGroupDeleteSocket(group, activesocks[i]);
						nlClose(activesocks[i]);
						deleteClient(sessiontoken);
						
						printf("Received a bye from client. token %d\n", sessiontoken);
						
						gameState->playerCount--;
						tmpchar = DELETE_PLAYER;
						for (j = 0; j < MAX_CLIENTS; j++)
							if (clientStates[j])
							{
								nlWrite(clientStates[j]->sockfd, &tmpchar, 1);
								nlWrite(clientStates[j]->sockfd, &sessiontoken, 1);
							}

						break;
					case PLAYERUPDATE:
						//printf("received a player update from client token %d", sessiontoken);
						nlRead(activesocks[i], &sessiontoken, 1);
						nlRead(activesocks[i], &buff, PLAYERUPDATELENGTH);
						clientStates[sessiontoken]->updateClient(buff,PLAYERUPDATELENGTH);
						
						break;

					case PICKUPOBJECTREQUEST:
						{
							nlRead(activesocks[i], &sessiontoken, 1);
							nlRead(activesocks[i],&buff,1);
							ServerModelList *staticModelList=gameState->getStaticModelList();
							ServerModel *model=staticModelList->getModel(buff[0]);
							if(model!=NULL){
								if (model->isActive()){
									model->setActive(false);
									
									buff[0]=OBJECTPICKED;
									buff[1]=sessiontoken;
									buff[2]=model->getID();
									for (j=0; j < MAX_CLIENTS; j++){
										if (clientStates[j]){
											nlWrite(clientStates[j]->sockfd, &buff, OBJECTPICKEDLENGTH+1);
										}

									}

								}
							}
						}
						//See if object can be picked up

						break;

					case STARTMATRIX:
					case ENDMATRIX:
						//forward the command
						nlRead(activesocks[i], &sessiontoken, 1);
						for (j=0; j < MAX_CLIENTS; j++)
							if (clientStates[j]){
								nlWrite(clientStates[j]->sockfd, &command, 1);
								nlWrite(clientStates[j]->sockfd, &sessiontoken, 1);
							}
						break;

					case PROJECTILECREATED:
						buff[0]=PROJECTILECREATED;
						nlRead(activesocks[i],&buff[1],PROJECTILECREATEDLENGTH);
						for (j=0; j < MAX_CLIENTS; j++){
							if (clientStates[j]){
								nlWrite(clientStates[j]->sockfd, &buff, PROJECTILECREATEDLENGTH+1);
							}

						}
						gameState->projectileCreated();
						printf("Projhectile created message sent\n");
						break;
					case REMOVEPROJECTILE:
						buff[0]=REMOVEPROJECTILE;
						nlRead(activesocks[i],&buff[1],REMOVEPROJECTILELENGTH);
						for (j=0; j < MAX_CLIENTS; j++){
							if (clientStates[j]){
								nlWrite(clientStates[j]->sockfd, &buff, REMOVEPROJECTILELENGTH+1);
							}

						}
						gameState->projectileRemoved();
						printf("Projectile removed message sent\n");
						break;
						
					case PROJECTILEUPDATE:
						buff[0]=PROJECTILEUPDATE;
						nlRead(activesocks[i],&buff[1],PROJECTILEUPDATELENGTH);
						for (j=0; j < MAX_CLIENTS; j++){
							if (clientStates[j]){
								nlWrite(clientStates[j]->sockfd, &buff, PROJECTILEUPDATELENGTH+1);
							}

						} 
						gameState->projectileUpdated();
						printf("Projectile update message sent\n");
						break;
					case DAMAGE:
						buff[0]=DAMAGE;
						nlRead(activesocks[i],&buff[1],2);
						if(clientStates[buff[1]]){
							nlWrite(clientStates[buff[1]]->sockfd, &buff,3);
							printf ("%d %d %d\n", buff[0], buff[1], buff[2]);
						}
						break;
					default:
						printf("some client misbehaved. we are in default handler\n");
						//didnt understand the client. better shut him up
						nlGroupDeleteSocket(group, activesocks[i]);
						nlClose(activesocks[i]);
						gameState->playerCount--;
						for (j = 0; j < MAX_CLIENTS; j++){
							if((clientStates[j]!=NULL)&&(clientStates[j]->sockfd==activesocks[i])){
								sessiontoken=j;
								break;
							}
						}

						//printf("session token for misbehaving client = %d\n", sessiontoken);

						tmpchar = DELETE_PLAYER;
						for (j = 0; j < MAX_CLIENTS; j++)
							if (clientStates[j])
							{
								nlWrite(clientStates[j]->sockfd, &tmpchar, 1);
								nlWrite(clientStates[j]->sockfd, &sessiontoken, 1);
							}

						break;
					}
					
				}
			}

			lastCycleTime=mcurtime;

		#ifdef WIN32
			struct timeb tmptime;
			ftime(&tmptime);
			mcurtime = tmptime.time*1000 + tmptime.millitm;
		#else
			struct timeval tmptime;
			struct timezone tz;
			gettimeofday(&tmptime, &tz);
			mcurtime = tmptime.tv_sec*1000 + tmptime.tv_usec/1000;
		#endif
			float incr=(mcurtime-lastCycleTime)/1000;
			ServerModelList *projectileList=gameState->getProjectileList();
			projectileList->updatePosition(incr);

			for (int m = 0; m < MAX_CLIENTS; m++){
				if (clientStates[m]){
						
						float aTime=clientStates[m]->playerModel.getAnimationTime();
						aTime+=incr;
						clientStates[m]->playerModel.setAnimationTime(aTime);
				}
			}

			
		if (mcurtime - moldtime > MINSERVERUPDATETIMEPERIOD && gameState->playerCount>0 && gameState->updateState())
		{



		

			//printf("sending game updates...\n");
			moldtime = mcurtime;
			
			//optimized for ze best performance. watch, as the server code fries L1/L2/L3	
			//writeout the new game config to all clients
			for (int k = 0; k < MAX_CLIENTS; k++)
				if (clientStates[k]){
						
						
								
						if (writePacket(clientStates[k]->sockfd, buff, cursor) != cursor)
						{
							//printf("gameupdate didnt happen. removing client %d\n", k);

							nlGroupDeleteSocket(group, clientStates[k]->sockfd);
							nlClose(clientStates[k]->sockfd);
							deleteClient(k);
								
							tmpchar = DELETE_PLAYER;
							gameState->playerCount--;
							sessiontoken=k;
							for (j = 0; j < MAX_CLIENTS; j++)
								if (clientStates[j])
								{
									nlWrite(clientStates[j]->sockfd, &tmpchar, 1);
									nlWrite(clientStates[j]->sockfd, &sessiontoken, 1);
								}

						}
				}
		}

		
		if ((mcurtime - moldSpawnTime) > MINRESPAWNTIMEPERIOD)
		{
			
			moldSpawnTime = mcurtime;
			ServerModelList *staticModelList=gameState->getStaticModelList();
			buff[0]=OBJECTSPAWNED;
			int count=0;
			for( int k=0;k<staticModelList->getLength();k++){
				ServerModel *model=staticModelList->getModel(k);
				if(!model->isActive()){
					if((mcurtime-model->getTimeStamp())>MINRESPAWNTIMEPERIOD){
						model->setActive(true);
						buff[count+2]=model->getID();
						count++;
					}
				}
				
				//else{
				//	model->setActive(false);
				//	model->setTimeStamp(mcurtime);
				//}
				
				
			}
			buff[1]=count;
			if(count>0){
				for (j = 0; j < MAX_CLIENTS; j++){
					if (clientStates[j]){
							nlWrite(clientStates[j]->sockfd, &buff, (count+2));
					}
				}
			} 
			
		}
		
		
	}

	//we'll never reach here
    nlShutdown();
    return 0;
}

static int insertClient(NLsocket sockfd)
{
	for (int i = 0; i < MAX_CLIENTS; i++)
		if (! clientStates[i])
		{
			clientStates[i] = new ClientState(sockfd);
			return i;
		}
	return -1;

}

static void deleteClient(int token)
{
	if (clientStates[token])
	{
		delete clientStates[token];
		clientStates[token] = NULL;
	}
}

static int writePacket(NLsocket sockfd, unsigned char *packet, int packetlen)
{
	int n = 0, totalwr = 0;
	
	while ( (n = nlWrite(sockfd, (void *)(packet+totalwr), packetlen - totalwr)) > 0)
	{
		totalwr += n;
		if (totalwr == packetlen)
			return totalwr;
	}
	if ( n < 0)
		return -1;
	return totalwr;
}

