#include "GameState.h"


#include "BSPDataModel.h"
#include "mapent.h"
#include "globals.h"

#define writeShortMod(x, y, z)     {*((NLushort *)((NLbyte *)&x[y])) = nlSwaps(z);}
extern unsigned char buff[MAXPACKETLEN];
extern int cursor;
static char randomType[65]={16,16,14,11,5,15,6,12,7,16,5,16,16,6,7,5,16,14,15,6,12,7,11,5,16,12,15,6,7,5,6,13,7,14,16,16,5,6,7,5,15,6,7,13,5,6,15,11,7,14,5,6,7,5,16,13,6,7,14,5,6,12,16,7};
GameState::GameState( float pLight, float pFog)
{
	lightFX = false;
	lightTSLFX = 0;
	lightFXtime = 0;
	pLightFX = pLight;

	fogFX = false;
	pFogFX = pFog;
	fogFXtime = 0;
	fogTSLFX = 0;
	fogcolor[0] = 0.7f;
	fogcolor[1] = 0.7f;
	fogcolor[2] = 0.7f;
	density = 0.005f;
	playerCount=0;
	initStaticModelList();
}

inline void GameState::getTime()
{
	register unsigned long oldtime = curtime;
#ifdef WIN32
	struct timeb tmptime;
	ftime(&tmptime);
	curtime = tmptime.time*1000 + tmptime.millitm;
#else
	struct timeval tmptime;
	struct timezone tz;
	gettimeofday(&tmptime, &tz);
	curtime = tmptime.tv_sec*1000 + tmptime.tv_usec/1000;
#endif
	delta = curtime - oldtime;
}

bool GameState::updateState()
{


	buff[0] = GAMEUPDATE;
	cursor = 3;

	getTime();
	//printf("current time: %ul\n", curtime);
	//printf("delta: %ul\n", delta);

	//do the lighting calculations first
	if (lightTSLFX > LIGHTCURFEW)
	{
		if (rand()/RAND_MAX < pLightFX)
		{
			lightTSLFX = 0;
			lightFX = true;
			lightFXtime = 0;
			//send light command
			writeByte(buff, cursor, LIGHTOFF); 
			
		}

	}
	else
	{
		lightTSLFX += delta;
		if (lightFX)
		{
			lightFXtime += delta;
			if (lightFXtime > LIGHTFXDUR)
			{
				writeByte(buff, cursor, LIGHTON);
				lightFX = false;
			}
		}
	}

	//do the fog calculations
	if (fogTSLFX > FOGCURFEW)
	{
		if (rand()/RAND_MAX < pFogFX)
		{
			fogTSLFX = 0;
			fogFX = true;
			lightFXtime = 0;
			//send fog command
			writeByte(buff, cursor, FOGON);
			writeFloat(buff, cursor, fogcolor[0]);
			writeFloat(buff, cursor, fogcolor[1]);
			writeFloat(buff, cursor, fogcolor[2]);
			writeFloat(buff, cursor, density);

		}
	}
	else
	{
		fogTSLFX += delta;
		if (fogFX)
		{
			fogFXtime += delta;
			if (fogFXtime > FOGFXDUR)
			{
				writeByte(buff, cursor, FOGOFF);
				fogFX = false;
			}
		}
		
	}


	//Player updates
	unsigned char charTemp;
	for(int i=0;i<MAX_CLIENTS;i++){
		
		if((clientStates[i]!=NULL)&&(clientStates[i]->dirtyFlag)){
			//Send an update that player x has changed state
			writeByte(buff,cursor,PLAYERHASCHANGED);

	

	//PlayerID
			charTemp=i;	
			writeByte(buff,cursor,charTemp);

			//MotionState
			charTemp=clientStates[i]->motionState;
			writeByte(buff,cursor,charTemp);
			
			//ModelType
			charTemp=clientStates[i]->modelTypeIndex;
			writeByte(buff,cursor,charTemp);

			//Position
			vec3 vec;
			vec=clientStates[i]->playerModel.getPosition();

			writeFloat(buff,cursor,vec[0]);
			writeFloat(buff,cursor,vec[1]);
			writeFloat(buff,cursor,vec[2]);

			//Orientation
			vec=clientStates[i]->playerModel.getOrientation();
			writeFloat(buff,cursor,vec[0]);
			writeFloat(buff,cursor,vec[1]);
			writeFloat(buff,cursor,vec[2]);

		
			
			//Animation

			writeByte(buff,cursor,clientStates[i]->playerModel.getAction());
			writeByte(buff,cursor,clientStates[i]->playerModel.getPreviousAction());
			writeFloat(buff,cursor,clientStates[i]->playerModel.getAnimationTime());
			//Done writing reset dirty flag

			clientStates[i]->dirtyFlag=false;
		}
	}

	//now that we are done with the updates,
	//fill in the right buff length in all the packet buffers

	writeShortMod(buff, 1, cursor);

	//packets are ready for delivery. wait for main loop to send them
	return true;
}

void GameState::initStaticModelList(){

	int i;

	BSPDataModel *bspDM=new BSPDataModel();
	if ( bspDM->load(SERVERWORLDPATH, SERVERWORLDFILE) < 0)
	{
		printf("Duh! Show me a map so that I can read spawn info! Bye for now.\n");
		exit(0);
	}
	vec3_t org;
	int cluster;
	int g_mapent_numinst=getNumInstances();
    for (i=0; i < g_mapent_numinst; i++){
	
		getOriginForEntityInstance(org,i);
		cluster=bspDM->find_cluster(org);
		setClusterForEntityInstance(i,cluster);

			
		ServerModel *model=new ServerModel();
		model->setID(i);
		model->setModelTypeIndex(randomType[i]);

		model->setActive(true);
					 
		model->setPosition(vec3(org[0],org[1],org[2]));
		staticModelList.addModel(model);
	
		

	}


	/* Find the first spawn point in the entities list */
   
    const char *cname;
    
    
	vec3_t posit;
	
    for (i = 0; i < bspDM->getNumEntities(); i++)
    {
		cname = bspDM->entity_value(i, "classname");
		if (!strcmp(cname, "info_player_deathmatch"))
		{
			//startOrientation[2]= bspDM->entity_float(i, "angle");
			startOrientation[2]= 0;
			startOrientation[0]=0;
			startOrientation[1]=0;
			bspDM->entity_vec3(i, "origin", posit);
			startPosition[0]=posit[0];startPosition[1]=posit[1];startPosition[2]=posit[2]+30;
			
			
			break;
		}
    }
    

	delete bspDM;
	
	
}

int GameState::makeStateForNewPlayer(NLsocket sock,unsigned char sessionToken){
	cursor=0;
	unsigned char i;
	
	writeByte(buff,cursor,GAMEWEAPONSTATE);
	unsigned char charTemp=staticModelList.getLength();

	//Number of models
	writeByte(buff,cursor,charTemp);
	for(i=0;i<staticModelList.getLength();i++){
		//ModelID
		writeByte(buff,cursor,staticModelList.getModel(i)->getID());

		//ModelType
		writeByte(buff,cursor,staticModelList.getModel(i)->getModelTypeIndex());
		
		//Activeflag
		if(staticModelList.getModel(i)->isActive()){
			writeByte(buff,cursor,1);
		}
		else{
			writeByte(buff,cursor,0);
		}
		

		//Position
		vec3 vec;
		vec=staticModelList.getModel(i)->getPosition();

		writeFloat(buff,cursor,vec[0]);
		writeFloat(buff,cursor,vec[1]);
		writeFloat(buff,cursor,vec[2]);

		//Orientation
		vec=staticModelList.getModel(i)->getOrientation();
		writeFloat(buff,cursor,vec[0]);
		writeFloat(buff,cursor,vec[1]);
		writeFloat(buff,cursor,vec[2]);

		//Velocity
		vec=staticModelList.getModel(i)->getVelocity();
		writeFloat(buff,cursor,vec[0]);
		writeFloat(buff,cursor,vec[1]);
		writeFloat(buff,cursor,vec[2]);

		//Acceleration
		vec=staticModelList.getModel(i)->getAcceleration();
		writeFloat(buff,cursor,vec[0]);
		writeFloat(buff,cursor,vec[1]);
		writeFloat(buff,cursor,vec[2]);
		
		

	}
	int activePlayers=0;
	for(i=0;i<MAX_CLIENTS;i++){
		if(clientStates[i]){
			activePlayers++;
		}
	}
	charTemp=activePlayers;
	//PlayerUpdate command
	writeByte(buff,cursor,GAMEPLAYERSTATE );
	writeByte(buff,cursor,charTemp);
	for(i=0;i<MAX_CLIENTS;i++){
		if(clientStates[i]){
			
			//PlayerID
			charTemp=i;
			writeByte(buff,cursor,charTemp);

			//MotionState
			charTemp=clientStates[i]->motionState;
			writeByte(buff,cursor,charTemp);
			
			//ModelType
			charTemp=clientStates[i]->modelTypeIndex;
			writeByte(buff,cursor,charTemp);

			//Position
			vec3 vec;
			vec=clientStates[i]->playerModel.getPosition();

			writeFloat(buff,cursor,vec[0]);
			writeFloat(buff,cursor,vec[1]);
			writeFloat(buff,cursor,vec[2]);

			//Orientation
			vec=clientStates[i]->playerModel.getOrientation();
			writeFloat(buff,cursor,vec[0]);
			writeFloat(buff,cursor,vec[1]);
			writeFloat(buff,cursor,vec[2]);

		

			//Animation
			writeByte(buff,cursor,clientStates[i]->playerModel.getAction());
			writeByte(buff,cursor,clientStates[i]->playerModel.getPreviousAction());
			writeFloat(buff,cursor,clientStates[i]->playerModel.getAnimationTime());

		}
	}

//Projectile state
	writeByte(buff,cursor,GAMEPROJECTILESTATE);
	charTemp=projectileList.getLength();

	//Number of models
	writeByte(buff,cursor,charTemp);
	for(i=0;i<projectileList.getLength();i++){

		writeByte(buff,cursor,projectileList.getModel(i)->getOwner());
		//ModelID
		writeByte(buff,cursor,projectileList.getModel(i)->getID());

		//ModelType
		writeByte(buff,cursor,projectileList.getModel(i)->getModelTypeIndex());
		
		

		//Position
		vec3 vec;
		vec=projectileList.getModel(i)->getPosition();

		writeFloat(buff,cursor,vec[0]);
		writeFloat(buff,cursor,vec[1]);
		writeFloat(buff,cursor,vec[2]);

		//Orientation
		vec=projectileList.getModel(i)->getOrientation();
		writeFloat(buff,cursor,vec[0]);
		writeFloat(buff,cursor,vec[1]);
		writeFloat(buff,cursor,vec[2]);

		//Velocity
		vec=projectileList.getModel(i)->getVelocity();
		writeFloat(buff,cursor,vec[0]);
		writeFloat(buff,cursor,vec[1]);
		writeFloat(buff,cursor,vec[2]);

		//Acceleration
		vec=projectileList.getModel(i)->getAcceleration();
		writeFloat(buff,cursor,vec[0]);
		writeFloat(buff,cursor,vec[1]);
		writeFloat(buff,cursor,vec[2]);
		
		

	}



	return cursor;
}

void GameState::projectileCreated(){

			cursor=1;
			unsigned char id,owner,mType;
			readByte(buff,cursor,owner);
			readByte(buff,cursor,id);
			readByte(buff,cursor,mType);

			ServerModel *projectile=new ServerModel();
			projectile->setModelTypeIndex(mType);
			projectile->setOwner(owner);
			projectile->setID(id);
			
			float vec[3];
						//Position

			

			readFloat(buff,cursor,vec[0]);
			readFloat(buff,cursor,vec[1]);
			readFloat(buff,cursor,vec[2]);
			
			projectile->setPosition(vec3(vec[0],vec[1],vec[2]));
			//Orientation
			
			readFloat(buff,cursor,vec[0]);
			readFloat(buff,cursor,vec[1]);
			readFloat(buff,cursor,vec[2]);
			
			projectile->setOrientation(vec3(vec[0],vec[1],vec[2]));

			//Velocity

			readFloat(buff,cursor,vec[0]);
			readFloat(buff,cursor,vec[1]);
			readFloat(buff,cursor,vec[2]);

			projectile->setVelocity(vec3(vec[0],vec[1],vec[2]));

			//Acceleration

			readFloat(buff,cursor,vec[0]);
			readFloat(buff,cursor,vec[1]);
			readFloat(buff,cursor,vec[2]);

			projectile->setAcceleration(vec3(vec[0],vec[1],vec[2]));
			projectileList.addModel(projectile);
			printf("A projectile was created on Server\n");


}

void GameState::projectileUpdated(){

			cursor=1;
			unsigned char id,owner,mType;
			readByte(buff,cursor,owner);
			readByte(buff,cursor,id);
			readByte(buff,cursor,mType);

			ServerModel *projectile=projectileList.getModel(owner,id);
			if(projectile==NULL){
				return;
			}
			projectile->setOwner(owner);
			projectile->setID(id);
			
			float vec[3];
						//Position

			

			readFloat(buff,cursor,vec[0]);
			readFloat(buff,cursor,vec[1]);
			readFloat(buff,cursor,vec[2]);
			
			projectile->setPosition(vec3(vec[0],vec[1],vec[2]));
			//Orientation
			
			readFloat(buff,cursor,vec[0]);
			readFloat(buff,cursor,vec[1]);
			readFloat(buff,cursor,vec[2]);
			
			projectile->setOrientation(vec3(vec[0],vec[1],vec[2]));

			//Velocity

			readFloat(buff,cursor,vec[0]);
			readFloat(buff,cursor,vec[1]);
			readFloat(buff,cursor,vec[2]);

			projectile->setVelocity(vec3(vec[0],vec[1],vec[2]));

			//Acceleration

			readFloat(buff,cursor,vec[0]);
			readFloat(buff,cursor,vec[1]);
			readFloat(buff,cursor,vec[2]);

			projectile->setAcceleration(vec3(vec[0],vec[1],vec[2]));
			printf("Updating projectile\n");
}

void GameState::projectileRemoved(){
	
	cursor=1;
	unsigned char id,owner;
	readByte(buff,cursor,owner);
	readByte(buff,cursor,id);
	projectileList.removeModel(owner,id);
	
	
}

ServerModelList *GameState::getStaticModelList(){
	return &staticModelList;
}

ServerModelList *GameState::getProjectileList(){
	return &projectileList;
}