/*
  Sample program for the HawkNL cross platform network library
  Copyright (C) 2000 Phil Frisbie, Jr. (phil@hawksoft.com)
*/
/*
  Test the asynchronous calls nlGetNameFromAddrAsync and nlGetAddrFromNameAsync
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "nl.h"

#if defined WIN32 || defined WIN64
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#define sleep(x)    Sleep((DWORD)(1000 * (x)))
#endif


static void printErrorExit(void)
{
    NLenum err = nlGetError();

    if(err == NL_SOCKET_ERROR)
    {
        printf("System error: %s\n", nlGetSystemErrorStr(nlGetSystemError()));
    }
    else
    {
        printf("HawkNL error: %s\n", nlGetErrorStr(err));
    }
    nlShutdown();
    exit(EXIT_FAILURE);
}

int main(int argc, char **argv)
{
    NLbyte      name1[NL_MAX_STRING_LENGTH] = "www.hawksoft.com:80";
    NLbyte      name2[NL_MAX_STRING_LENGTH] = "www.flipcode.com";
    NLbyte      name3[NL_MAX_STRING_LENGTH] = "www.amd.com";
    NLbyte      name4[NL_MAX_STRING_LENGTH] = "www.3dfx.com";
    NLbyte      name5[NL_MAX_STRING_LENGTH] = "192.156.136.22";
    NLaddress   addr1, addr2, addr3, addr4, addr5;
    NLbyte      ip1[] = "1.2.3.4";
    NLbyte      ip2[] = "192.156.136.22:80";
    NLbyte      ip3[] = "204.71.200.74";
    NLbyte      ip4[] = "216.200.197.161";
    NLbyte      ip5[] = "204.254.182.130";
    NLbyte      string[NL_MAX_STRING_LENGTH];

    if(nlInit() == NL_FALSE)
        printErrorExit();

    printf("nlGetString(NL_VERSION) = %s\n\n", nlGetString(NL_VERSION));

    if(nlSelectNetwork(NL_IP) == NL_FALSE)
        printErrorExit();

    printf("Resolve address from name, start:\n");
    nlGetAddrFromNameAsync(name1, &addr1);
    nlGetAddrFromNameAsync(name2, &addr2);
    nlGetAddrFromNameAsync(name3, &addr3);
    nlGetAddrFromNameAsync(name4, &addr4);
    nlGetAddrFromNameAsync(name5, &addr5);

    while(1 == 1)
    {
        int count = 0;
        static int sec = 0;

        printf("%d second(s)\n", sec);
        if(addr1.valid == NL_TRUE)
        {
            printf("%s resolves to %s\n", name1, nlAddrToString(&addr1, string));
            count++;
        }
        if(addr2.valid == NL_TRUE)
        {
            printf("%s resolves to %s\n", name2, nlAddrToString(&addr2, string));
            count++;
        }
        if(addr3.valid == NL_TRUE)
        {
            printf("%s resolves to %s\n", name3, nlAddrToString(&addr3, string));
            count++;
        }
        if(addr4.valid == NL_TRUE)
        {
            printf("%s resolves to %s\n", name4, nlAddrToString(&addr4, string));
            count++;
        }
        if(addr5.valid == NL_TRUE)
        {
            printf("%s resolves to %s\n", name5, nlAddrToString(&addr5, string));
            count++;
        }
        if(count == 5)
        {
            /* we are done */
            break;
        }
        printf("\n");
        sleep(1);
        sec++;
    }
    printf("Done\n\n");
    printf("Resolve name from address, start:\n");
    nlStringToAddr(ip1, &addr1);
    nlStringToAddr(ip2, &addr2);
    nlStringToAddr(ip3, &addr3);
    nlStringToAddr(ip4, &addr4);
    nlStringToAddr(ip5, &addr5);
    nlGetNameFromAddrAsync(&addr1, name1);
    nlGetNameFromAddrAsync(&addr2, name2);
    nlGetNameFromAddrAsync(&addr3, name3);
    nlGetNameFromAddrAsync(&addr4, name4);
    nlGetNameFromAddrAsync(&addr5, name5);

    while(1 == 1)
    {
        int count = 0;
        static int sec = 0;

        printf("%d second(s)\n", sec);
        if(strlen(name1) > 0)
        {
            printf("%s resolves to %s\n", ip1, name1);
            count++;
        }
        if(strlen(name2) > 0)
        {
            printf("%s resolves to %s\n", ip2, name2);
            count++;
        }
        if(strlen(name3) > 0)
        {
            printf("%s resolves to %s\n", ip3, name3);
            count++;
        }
        if(strlen(name4) > 0)
        {
            printf("%s resolves to %s\n", ip4, name4);
            count++;
        }
        if(strlen(name5) > 0)
        {
            printf("%s resolves to %s\n", ip5, name5);
            count++;
        }
        if(count == 5)
        {
            /* we are done */
            break;
        }
        printf("\n");
        sleep(1);
        sec++;
    }
    printf("Done\n");
    nlShutdown();
    return 0;
}

